/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.listeners;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.CrimsonArmorAbilityStack;
import com.fix3dll.skyblockaddons.core.EssenceType;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.ItemDiff;
import com.fix3dll.skyblockaddons.core.PlayerStat;
import com.fix3dll.skyblockaddons.core.SkillType;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.core.SlayerArmorProgress;
import com.fix3dll.skyblockaddons.core.ThunderBottle;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureGuiData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.state.BlitAbsoluteRenderState;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import com.fix3dll.skyblockaddons.core.updater.Updater;
import com.fix3dll.skyblockaddons.events.RenderEvents;
import com.fix3dll.skyblockaddons.features.BaitManager;
import com.fix3dll.skyblockaddons.features.EndstoneProtectorManager;
import com.fix3dll.skyblockaddons.features.FetchurManager;
import com.fix3dll.skyblockaddons.features.PetManager;
import com.fix3dll.skyblockaddons.features.TrevorTrapperTracker;
import com.fix3dll.skyblockaddons.features.deployable.Deployable;
import com.fix3dll.skyblockaddons.features.deployable.DeployableManager;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonTracker;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonType;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonsSince;
import com.fix3dll.skyblockaddons.features.dungeonmap.DungeonMapManager;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonClass;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonMilestone;
import com.fix3dll.skyblockaddons.features.healingcircle.HealingCircleManager;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerBoss;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerDrop;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTracker;
import com.fix3dll.skyblockaddons.features.spooky.CandyType;
import com.fix3dll.skyblockaddons.features.spooky.SpookyEventManager;
import com.fix3dll.skyblockaddons.features.tablist.TabListParser;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonLocation;
import com.fix3dll.skyblockaddons.gui.screens.EnchantmentSettingsGui;
import com.fix3dll.skyblockaddons.gui.screens.IslandWarpGui;
import com.fix3dll.skyblockaddons.gui.screens.LocationEditGui;
import com.fix3dll.skyblockaddons.gui.screens.SettingsGui;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsGui;
import com.fix3dll.skyblockaddons.utils.ActionBarParser;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.SkyblockColor;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.impl.client.rendering.hud.HudElementRegistryImpl;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_12079;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1549;
import net.minecraft.class_1560;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderListener {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    public static final class_2960 SBA_RENDER_LAYER = SkyblockAddons.resourceLocation("hud_layer");
    private static final class_1799 BONE_ITEM = new class_1799((class_1935)class_1802.field_8606);
    private static final class_2960 ARMOR = class_2960.method_60656((String)"hud/armor_full");
    private static final class_2960 BARS = SkyblockAddons.resourceLocation("bars_v2.png");
    private static final class_2960 DEFENCE_VANILLA = SkyblockAddons.resourceLocation("defence.png");
    private static final class_2960 TICKER_SYMBOL = SkyblockAddons.resourceLocation("ticker.png");
    private static final class_2960 ENDERMAN_ICON = SkyblockAddons.resourceLocation("icons/enderman.png");
    private static final class_2960 ENDERMAN_GROUP_ICON = SkyblockAddons.resourceLocation("icons/endermangroup.png");
    private static final class_2960 SIRIUS_ICON = SkyblockAddons.resourceLocation("icons/sirius.png");
    private static final class_2960 SUMMONING_EYE_ICON = SkyblockAddons.resourceLocation("icons/summoningeye.png");
    private static final class_2960 ZEALOTS_PER_EYE_ICON = SkyblockAddons.resourceLocation("icons/zealotspereye.png");
    private static final class_2960 SLASH_ICON = SkyblockAddons.resourceLocation("icons/slash.png");
    private static final class_2960 IRON_GOLEM_ICON = SkyblockAddons.resourceLocation("icons/irongolem.png");
    private static final class_2960 FARM_ICON = SkyblockAddons.resourceLocation("icons/farm.png");
    private static final class_2960 RIFTSTALKER_BLOODFIEND = SkyblockAddons.resourceLocation("vampire.png");
    private static final class_2960 MORT_ICON = SkyblockAddons.resourceLocation("icons/mort.png");
    private static final class_1799 WATER_BUCKET = class_1802.field_8705.method_7854();
    private static final class_1799 CHEST = class_2246.field_10034.method_8389().method_7854();
    private static final SlayerArmorProgress[] DUMMY_PROGRESSES = new SlayerArmorProgress[]{new SlayerArmorProgress(new class_1799((class_1935)class_1802.field_8285)), new SlayerArmorProgress(new class_1799((class_1935)class_1802.field_8218)), new SlayerArmorProgress(new class_1799((class_1935)class_1802.field_8058)), new SlayerArmorProgress(new class_1799((class_1935)class_1802.field_8267))};
    private static final ObjectArrayList<ItemDiff> DUMMY_PICKUP_LOG = ObjectArrayList.of((Object[])new ItemDiff[]{new ItemDiff(String.valueOf(ColorCode.DARK_PURPLE) + "Forceful Ember Chestplate", 1, new class_1799((class_1935)class_1802.field_8873)), new ItemDiff("Oak Boat", -1, new class_1799((class_1935)class_1802.field_8533)), new ItemDiff(String.valueOf(ColorCode.BLUE) + "Aspect of the End", 1, new class_1799((class_1935)class_1802.field_8802))});
    private static final Pattern DUNGEON_STAR_PATTERN = Pattern.compile("(?i)(?:(?:\u00a7[a-f0-9])?\u272a)+(?:\u00a7r)?(?:\u00a7[a-f0-9]?[\u278a-\u2792])?");
    private static final int DEPLOYABLE_GUI_SIZE = 27;
    private static class_1642 revenant;
    private static class_1628 tarantula;
    private static class_1549 caveSpider;
    private static class_1493 sven;
    private static class_1560 enderman;
    private static class_1545 inferno;
    private static class_745 riftstalker;
    private boolean predictHealth;
    private boolean predictMana;
    private boolean updateMessageDisplayed;
    private ScheduledTask updateMessageDisplayTask;
    private Feature subtitleFeature;
    private Feature titleFeature;
    private ScheduledTask subtitleResetTask;
    private ScheduledTask titleResetTask;
    private int arrowsLeft = -1;
    private String arrowsType;
    private String cannotReachMobName;
    private long skillFadeOutTime = -1L;
    private SkillType skill;
    private String skillText;
    private EnumUtils.GUIType guiToOpen;
    private int guiPageToOpen = 1;
    private EnumUtils.GuiTab guiTabToOpen = EnumUtils.GuiTab.MAIN;
    private Feature guiFeatureToOpen;
    private float maxRiftHealth = 0.0f;
    private PetManager.Pet pet = null;
    private class_1799 petSkull = null;

    public RenderListener() {
        HudElementRegistryImpl.attachElementAfter((class_2960)VanillaHudElements.INFO_BAR, (class_2960)SBA_RENDER_LAYER, this::onRenderHud);
        RenderEvents.LEVEL_LAST.register(this::onRenderWorld);
    }

    public void onRenderHud(class_332 graphics, class_9779 renderTickCounter) {
        if (main.getUtils().isOnSkyblock()) {
            this.renderOverlays(graphics);
            this.renderWarnings(graphics);
        } else {
            this.renderTimersOnly(graphics);
        }
        this.drawUpdateMessage(graphics);
        this.setGui();
    }

    private void renderTimersOnly(class_332 graphics) {
        if (!(RenderListener.MC.field_1755 instanceof LocationEditGui)) {
            Matrix3x2fStack poseStack;
            float scale;
            if (Feature.DARK_AUCTION_TIMER.isEnabled(FeatureSetting.DARK_AUCTION_TIMER_IN_OTHER_GAMES)) {
                scale = Feature.DARK_AUCTION_TIMER.getGuiScale();
                poseStack = graphics.method_51448();
                poseStack.pushMatrix();
                poseStack.scale(scale);
                this.drawText(graphics, Feature.DARK_AUCTION_TIMER, scale, null);
                poseStack.popMatrix();
            }
            if (Feature.FARM_EVENT_TIMER.isEnabled(FeatureSetting.FARM_EVENT_TIMER_IN_OTHER_GAMES)) {
                scale = Feature.FARM_EVENT_TIMER.getGuiScale();
                poseStack = graphics.method_51448();
                poseStack.pushMatrix();
                poseStack.scale(scale);
                this.drawText(graphics, Feature.FARM_EVENT_TIMER, scale, null);
                poseStack.popMatrix();
            }
        }
    }

    private void renderWarnings(class_332 graphics) {
        if (RenderListener.MC.field_1687 == null || RenderListener.MC.field_1724 == null || !main.getUtils().isOnSkyblock()) {
            return;
        }
        int scaledWidth = MC.method_22683().method_4486();
        int scaledHeight = MC.method_22683().method_4502();
        if (this.titleFeature != null) {
            String translationKey;
            switch (this.titleFeature) {
                case FULL_INVENTORY_WARNING: {
                    String string = "messages.fullInventory";
                    break;
                }
                case SUMMONING_EYE_ALERT: {
                    String string = "messages.summoningEyeFound";
                    break;
                }
                case SPECIAL_ZEALOT_ALERT: {
                    String string = "messages.specialZealotFound";
                    break;
                }
                case LEGENDARY_SEA_CREATURE_WARNING: {
                    String string = "messages.legendarySeaCreatureWarning";
                    break;
                }
                case BOSS_APPROACH_ALERT: {
                    String string = "messages.bossApproaching";
                    break;
                }
                case FETCHUR_TODAY: {
                    String string = "messages.fetchurWarning";
                    break;
                }
                case BROOD_MOTHER_ALERT: {
                    String string = "messages.broodMotherWarning";
                    break;
                }
                case BAL_BOSS_ALERT: {
                    String string = "messages.balBossWarning";
                    break;
                }
                default: {
                    String string = translationKey = null;
                }
            }
            if (translationKey != null) {
                float scale;
                String text = Translations.getMessage(translationKey, new Object[0]);
                int stringWidth = RenderListener.MC.field_1772.method_1727(text);
                if ((float)stringWidth * (scale = 4.0f) > (float)scaledWidth * 0.9f) {
                    scale = (float)scaledWidth * 0.9f / (float)stringWidth;
                }
                Matrix3x2fStack poseStack = graphics.method_51448();
                poseStack.pushMatrix();
                poseStack.translate((float)(scaledWidth / 2), (float)(scaledHeight / 2));
                poseStack.pushMatrix();
                poseStack.scale(scale);
                DrawUtils.drawText(graphics, text, (float)(-RenderListener.MC.field_1772.method_1727(text)) / 2.0f, -20.0f, this.titleFeature.getColor());
                poseStack.popMatrix();
                poseStack.popMatrix();
            }
        }
        if (this.subtitleFeature != null) {
            String text;
            switch (this.subtitleFeature) {
                case MINION_STOP_WARNING: {
                    String string = Translations.getMessage("messages.minionCannotReach", this.cannotReachMobName);
                    break;
                }
                case MINION_FULL_WARNING: {
                    String string = Translations.getMessage("messages.minionIsFull", new Object[0]);
                    break;
                }
                case NO_ARROWS_LEFT_ALERT: {
                    String string;
                    if (this.arrowsType != null) {
                        if (this.arrowsLeft != -1) {
                            string = Translations.getMessage("messages.onlyFewArrowsLeft", this.arrowsLeft, this.arrowsType);
                            break;
                        }
                        string = Translations.getMessage("messages.noArrowsLeft", this.arrowsType);
                        break;
                    }
                    string = null;
                    break;
                }
                default: {
                    String string = text = null;
                }
            }
            if (text != null) {
                float scale;
                int stringWidth = RenderListener.MC.field_1772.method_1727(text);
                if ((float)stringWidth * (scale = 2.0f) > (float)scaledWidth * 0.9f) {
                    scale = (float)scaledWidth * 0.9f / (float)stringWidth;
                }
                Matrix3x2fStack poseStack = graphics.method_51448();
                poseStack.pushMatrix();
                poseStack.translate((float)(scaledWidth / 2), (float)(scaledHeight / 2));
                poseStack.pushMatrix();
                poseStack.scale(scale);
                DrawUtils.drawText(graphics, text, (float)(-RenderListener.MC.field_1772.method_1727(text)) / 2.0f, -23.0f, this.subtitleFeature.getColor());
                poseStack.popMatrix();
                poseStack.popMatrix();
            }
        }
    }

    private void renderOverlays(class_332 graphics) {
        if (!(RenderListener.MC.field_1755 instanceof LocationEditGui)) {
            for (Feature feature : Feature.getGuiFeatures()) {
                if (!feature.isEnabled() || feature == Feature.SKELETON_BAR && !main.getInventoryUtils().isWearingSkeletonHelmet() || feature == Feature.HEALTH_UPDATES && main.getPlayerListener().getActionBarParser().getHealthUpdate() == null) continue;
                this.drawFeature(graphics, feature, feature.getGuiScale(), null);
            }
        }
    }

    public void drawFeature(class_332 graphics, Feature feature, float scale, ButtonLocation buttonLocation) {
        FeatureGuiData guiFeatureData = feature.getFeatureGuiData();
        if (guiFeatureData != null && guiFeatureData.getDrawType() != null) {
            Matrix3x2fStack poseStack = graphics.method_51448();
            poseStack.pushMatrix();
            poseStack.scale(scale);
            switch (guiFeatureData.getDrawType()) {
                case SKELETON_BAR: {
                    main.getRenderListener().drawSkeletonBar(graphics, scale, buttonLocation);
                    break;
                }
                case BAR: {
                    main.getRenderListener().drawBar(graphics, feature, scale, buttonLocation);
                    break;
                }
                case TEXT: {
                    main.getRenderListener().drawText(graphics, feature, scale, buttonLocation);
                    break;
                }
                case PICKUP_LOG: {
                    main.getRenderListener().drawItemPickupLog(graphics, scale, buttonLocation);
                    break;
                }
                case DEFENCE_ICON: {
                    main.getRenderListener().drawIcon(graphics, scale, buttonLocation);
                    break;
                }
                case SLAYER_ARMOR_PROGRESS: {
                    main.getRenderListener().drawSlayerArmorProgress(graphics, scale, buttonLocation);
                    break;
                }
                case DEPLOYABLE_DISPLAY: {
                    main.getRenderListener().drawDeployableStatus(graphics, scale, buttonLocation);
                    break;
                }
                case TICKER: {
                    main.getRenderListener().drawScorpionFoilTicker(graphics, scale, buttonLocation);
                    break;
                }
                case BAIT_LIST_DISPLAY: {
                    main.getRenderListener().drawBaitList(graphics, scale, buttonLocation);
                    break;
                }
                case DUNGEONS_MAP: {
                    DungeonMapManager.drawDungeonsMap(graphics, scale, buttonLocation);
                    break;
                }
                case SLAYER_TRACKERS: {
                    main.getRenderListener().drawSlayerTrackers(graphics, feature, scale, buttonLocation);
                    break;
                }
                case DRAGON_STATS_TRACKER: {
                    main.getRenderListener().drawDragonTrackers(graphics, scale, buttonLocation);
                    break;
                }
                case PROXIMITY_INDICATOR: {
                    TrevorTrapperTracker.drawTrackerLocationIndicator(graphics, scale, buttonLocation);
                    break;
                }
                case PET_DISPLAY: {
                    this.drawPetDisplay(graphics, scale, buttonLocation);
                }
            }
            poseStack.popMatrix();
        }
    }

    public void drawBar(class_332 graphics, Feature feature, float scale, ButtonLocation buttonLocation) {
        float fill;
        boolean hasAbsorption = false;
        float widthScale = 1.0f;
        switch (feature) {
            case MANA_BAR: {
                fill = PlayerStat.MANA.getValue() / PlayerStat.MAX_MANA.getValue();
                break;
            }
            case DRILL_FUEL_BAR: {
                fill = PlayerStat.FUEL.getValue() / PlayerStat.MAX_FUEL.getValue();
                break;
            }
            case SKILL_PROGRESS_BAR: {
                if (buttonLocation == null) {
                    ActionBarParser parser = main.getPlayerListener().getActionBarParser();
                    if (parser.getPercent() == 0.0f || parser.getPercent() == 100.0f) {
                        return;
                    }
                    fill = parser.getPercent() / 100.0f;
                    break;
                }
                fill = 0.4f;
                break;
            }
            case HEALTH_BAR: {
                if (Feature.HEALTH_BAR.isEnabled(FeatureSetting.HIDE_HEALTH_BAR_ON_RIFT) && main.getUtils().isOnRift()) {
                    return;
                }
                fill = PlayerStat.HEALTH.getValue() / PlayerStat.MAX_HEALTH.getValue();
                break;
            }
            case PRESSURE_BAR: {
                float pressure;
                float f = pressure = buttonLocation != null ? 50.0f : PlayerStat.PRESSURE.getValue();
                if (pressure == -1.0f) {
                    return;
                }
                fill = pressure / 100.0f;
                break;
            }
            default: {
                return;
            }
        }
        if (fill > 1.0f) {
            fill = 1.0f;
        }
        float x = feature.getActualX();
        float y = feature.getActualY();
        float scaleX = feature.getFeatureData().getSizesX();
        float scaleY = feature.getFeatureData().getSizesY();
        graphics.method_51448().scale(scaleX, scaleY);
        x = this.transformX(x, 71, scale * scaleX, false);
        y = this.transformY(y, 5, scale * scaleY);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + 71.0f, y, y + 5.0f, scale, scaleX, scaleY);
        }
        SkyblockColor color = ColorUtils.getDummySkyblockColor(feature.getColor(), feature.isChroma());
        switch (feature) {
            case SKILL_PROGRESS_BAR: {
                int remainingTime;
                if (buttonLocation != null || (remainingTime = (int)(this.skillFadeOutTime - System.currentTimeMillis())) >= 0) break;
                if (remainingTime < -2000) {
                    return;
                }
                int textAlpha = Math.round(255.0f - (float)(-remainingTime) / 2000.0f * 255.0f);
                color = ColorUtils.getDummySkyblockColor(feature.getColor(textAlpha), feature.isChroma());
                break;
            }
            case DRILL_FUEL_BAR: {
                if (RenderListener.MC.field_1724 == null) {
                    return;
                }
                if (buttonLocation != null || ItemUtils.isDrill(RenderListener.MC.field_1724.method_6047())) break;
                return;
            }
            case HEALTH_BAR: {
                if (feature.isEnabled(FeatureSetting.CHANGE_BAR_COLOR_WITH_POTIONS) && RenderListener.MC.field_1724 != null) {
                    if (RenderListener.MC.field_1724.method_6059(class_1294.field_5899)) {
                        color = ColorUtils.getDummySkyblockColor(ColorCode.DARK_GREEN.getColor(), feature.isChroma());
                    } else if (RenderListener.MC.field_1724.method_6059(class_1294.field_5920)) {
                        color = ColorUtils.getDummySkyblockColor(ColorCode.DARK_GRAY.getColor(), feature.isChroma());
                    } else if (RenderListener.MC.field_1724.method_6059(class_1294.field_5898) && PlayerStat.HEALTH.getValue() > PlayerStat.MAX_HEALTH.getValue()) {
                        fill = PlayerStat.MAX_HEALTH.getValue() / PlayerStat.HEALTH.getValue();
                        hasAbsorption = true;
                    }
                }
                if (!main.getUtils().isOnRift()) break;
                float maxCurrentHealth = PlayerStat.MAX_RIFT_HEALTH.getValue();
                fill = PlayerStat.HEALTH.getValue() / maxCurrentHealth;
                if (maxCurrentHealth > this.maxRiftHealth) {
                    this.maxRiftHealth = maxCurrentHealth;
                } else {
                    widthScale = maxCurrentHealth / this.maxRiftHealth;
                }
                if (!Float.isNaN(widthScale)) break;
                widthScale = 1.0f;
                break;
            }
            case PRESSURE_BAR: {
                float pressure;
                if (!Feature.PRESSURE_BAR.isEnabled(FeatureSetting.PRESSURE_BAR_ALERT) || !((pressure = PlayerStat.PRESSURE.getValue()) >= 90.0f) || main.getScheduler().getTotalTicks() % 40L < 20L) break;
                color = ColorUtils.getDummySkyblockColor(ColorCode.RED.getColor(), feature.isChroma());
            }
        }
        this.drawMultiLayeredBar(graphics, color, x, y, fill, hasAbsorption, widthScale);
    }

    private void drawMultiLayeredBar(class_332 graphics, SkyblockColor skyblockColor, float x, float y, float fill, boolean hasAbsorption, float widthScale) {
        RenderPipeline renderPipeline;
        int barHeight = 5;
        float barWidth = 71.0f * widthScale;
        float barFill = barWidth * fill;
        int color = skyblockColor.getColor() == ColorCode.BLACK.getColor() ? class_9848.method_61318((float)((float)class_9848.method_61320((int)skyblockColor.getColor()) / 255.0f), (float)0.25f, (float)0.25f, (float)0.25f) : class_9848.method_61330((int)230, (int)skyblockColor.getColor());
        if (skyblockColor.drawMulticolorUsingShader()) {
            color = class_9848.method_61318((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            renderPipeline = DrawUtils.CHROMA_TEXT;
        } else {
            renderPipeline = class_10799.field_56883;
        }
        int emptyBarColor = color;
        class_11231 textureSetup = RenderListener.textureSetup(BARS);
        graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(renderPipeline, RenderListener.textureSetup(BARS), (Matrix3x2f)graphics.method_51448(), x, y, 1.0f, 1.0f, barWidth, barHeight, 80.0f, 50.0f, emptyBarColor, graphics.field_44659.method_70863()));
        if (skyblockColor.drawMulticolorUsingShader()) {
            color = class_9848.method_61317((float)1.0f);
        }
        if (fill != 0.0f) {
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x, y, 1.0f, 7.0f, barFill, barHeight, 80.0f, 50.0f, color, graphics.field_44659.method_70863()));
        }
        if (hasAbsorption) {
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x + barFill, y, 1.0f + barFill, 7.0f, barWidth - barFill, barHeight, 80.0f, 50.0f, ColorCode.GOLD.getColor(), graphics.field_44659.method_70863()));
        }
        if (fill > 0.0f && fill < 1.0f) {
            float padding = 0.01f;
            float oneSide = 2.0f - padding;
            float startX = Math.max(0.0f, barFill - oneSide);
            float startTexX = Math.max(padding, oneSide - barFill);
            float endTexX = Math.min(2.0f * oneSide - startTexX, barWidth - barFill + oneSide);
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x + startX, y, 1.0f + startTexX, 24.0f, endTexX, barHeight, 80.0f, 50.0f, color, graphics.field_44659.method_70863()));
        }
        graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x, y, 1.0f, 13.0f, barWidth, barHeight, 80.0f, 50.0f, color, graphics.field_44659.method_70863()));
    }

    private void drawUpdateMessage(class_332 graphics) {
        Updater updater = main.getUpdater();
        if (updater.hasUpdate() && !this.updateMessageDisplayed) {
            String message = updater.getMessageToRender();
            if (message != null && Feature.AUTO_UPDATE.getValue() == EnumUtils.AutoUpdateMode.UPDATE_OFF) {
                String[] textList = main.getUtils().wrapSplitText(message, 36);
                int halfWidth = MC.method_22683().method_4486() / 2;
                graphics.method_25294(halfWidth - 110, 20, halfWidth + 110, 53 + textList.length * 10, ColorUtils.getDefaultBlue(140));
                String title = SkyblockAddons.METADATA.getName();
                Matrix3x2fStack poseStack = graphics.method_51448();
                poseStack.pushMatrix();
                float scale = 1.5f;
                poseStack.scale(scale);
                graphics.method_27534(RenderListener.MC.field_1772, (class_2561)class_2561.method_43470((String)title), (int)((float)halfWidth / scale), (int)(30.0f / scale), ColorCode.WHITE.getColor());
                poseStack.popMatrix();
                int y = 45;
                for (String line : textList) {
                    graphics.method_27534(RenderListener.MC.field_1772, (class_2561)class_2561.method_43470((String)line), halfWidth, y, ColorCode.WHITE.getColor());
                    y += 10;
                }
            }
            if (!main.getUpdater().hasSentUpdateMessage()) {
                main.getUpdater().sendUpdateMessage();
            }
            if (this.updateMessageDisplayTask == null) {
                this.updateMessageDisplayTask = main.getScheduler().scheduleTask(scheduledTask -> {
                    main.getRenderListener().setUpdateMessageDisplayed(true);
                    this.updateMessageDisplayTask = null;
                }, 200);
            }
        }
    }

    public void drawSkeletonBar(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        int bones;
        float x = Feature.SKELETON_BAR.getActualX();
        float y = Feature.SKELETON_BAR.getActualY();
        if (!(RenderListener.MC.field_1755 instanceof LocationEditGui) && RenderListener.MC.field_1687 != null && RenderListener.MC.field_1724 != null) {
            List bonesEntityList = RenderListener.MC.field_1687.method_8390(class_1542.class, RenderListener.MC.field_1724.method_5829().method_1014(8.0), itemEntity -> {
                class_1531 vehicle;
                class_1297 patt0$temp;
                return itemEntity.method_5765() && (patt0$temp = itemEntity.method_5854()) instanceof class_1531 && (vehicle = (class_1531)patt0$temp).method_5767();
            });
            bones = bonesEntityList.size();
        } else {
            bones = 3;
        }
        if (bones > 3) {
            bones = 3;
        }
        int height = 16;
        int width = 48;
        x = this.transformX(x, width, scale, false);
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        for (int boneCounter = 0; boneCounter < bones; ++boneCounter) {
            this.renderItem(graphics, BONE_ITEM, x + (float)(boneCounter * 16), y);
        }
    }

    public void drawScorpionFoilTicker(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        if (buttonLocation != null || main.getPlayerListener().getTickers() != -1) {
            float x = Feature.TICKER_CHARGES_DISPLAY.getActualX();
            float y = Feature.TICKER_CHARGES_DISPLAY.getActualY();
            int height = 9;
            int width = 42;
            x = this.transformX(x, width, scale, false);
            y = this.transformY(y, height, scale);
            if (buttonLocation != null) {
                buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
            }
            class_11231 textureSetup = RenderListener.textureSetup(TICKER_SYMBOL);
            int maxTickers = buttonLocation == null ? main.getPlayerListener().getMaxTickers() : 4;
            for (int tickers = 0; tickers < maxTickers; ++tickers) {
                float uOffset = tickers < (buttonLocation == null ? main.getPlayerListener().getTickers() : 3) ? 0.0f : 9.0f;
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, textureSetup, (Matrix3x2f)graphics.method_51448(), x + (float)(tickers * 11), y, uOffset, 0.0f, 9.0f, 9.0f, 18.0f, 9.0f, -1, graphics.field_44659.method_70863()));
            }
        }
    }

    public void drawIcon(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        if (main.getUtils().isOnRift()) {
            return;
        }
        float x = Feature.DEFENCE_ICON.getActualX();
        float y = Feature.DEFENCE_ICON.getActualY();
        x = this.transformX(x, 9, scale, false);
        y = this.transformY(y, 9, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + 9.0f, y, y + 9.0f, scale);
        }
        if (Feature.DEFENCE_ICON.isEnabled(FeatureSetting.USE_VANILLA_TEXTURE)) {
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(DEFENCE_VANILLA), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 9.0f, 9.0f, 9.0f, 9.0f, -1, graphics.field_44659.method_70863()));
        } else {
            graphics.method_52706(class_10799.field_56883, ARMOR, (int)x, (int)y, 9, 9);
        }
    }

    public void drawText(class_332 graphics, Feature feature, float scale, ButtonLocation buttonLocation) {
        Object text;
        boolean onRift = main.getUtils().isOnRift();
        int color = feature.getColor();
        switch (feature) {
            case MANA_TEXT: {
                text = TextUtils.formatNumber(Float.valueOf(PlayerStat.MANA.getValue())) + "/" + TextUtils.formatNumber(Float.valueOf(PlayerStat.MAX_MANA.getValue())) + (feature.isEnabled(FeatureSetting.MANA_TEXT_ICON) ? "\u270e" : "");
                break;
            }
            case OVERFLOW_MANA: {
                if (PlayerStat.OVERFLOW_MANA.getValue() == 0.0f && buttonLocation == null) {
                    return;
                }
                text = TextUtils.formatNumber(Float.valueOf(PlayerStat.OVERFLOW_MANA.getValue())) + "\u02ac";
                break;
            }
            case HEALTH_TEXT: {
                if (feature.isEnabled(FeatureSetting.HIDE_HEALTH_TEXT_ON_RIFT) && onRift) {
                    return;
                }
                boolean shouldHeart = feature.isEnabled(FeatureSetting.HEART_INSTEAD_HEALTH_ON_RIFT) && onRift;
                text = TextUtils.formatNumber(Float.valueOf(PlayerStat.HEALTH.getValue() / (shouldHeart ? 2.0f : 1.0f))) + "/";
                text = main.getUtils().isOnRift() ? (String)text + TextUtils.formatNumber(Float.valueOf(PlayerStat.MAX_RIFT_HEALTH.getValue() / (shouldHeart ? 2.0f : 1.0f))) : (String)text + TextUtils.formatNumber(Float.valueOf(PlayerStat.MAX_HEALTH.getValue()));
                if (!feature.isEnabled(FeatureSetting.HEALTH_TEXT_ICON)) break;
                text = (String)text + "\u2764";
                break;
            }
            case CRIMSON_ARMOR_ABILITY_STACKS: {
                text = buttonLocation != null ? "Hydra Strike \u2051 1" : this.getCrimsonArmorAbilityStacks();
                if (text != null) break;
                return;
            }
            case DEFENCE_TEXT: {
                if (onRift) {
                    return;
                }
                text = TextUtils.formatNumber(Float.valueOf(PlayerStat.DEFENCE.getValue())) + (feature.isEnabled(FeatureSetting.DEFENCE_TEXT_ICON) ? "\u2748" : "");
                break;
            }
            case OTHER_DEFENCE_STATS: {
                text = main.getPlayerListener().getActionBarParser().getOtherDefense();
                if (text != null && !((String)text).isEmpty()) break;
                if (buttonLocation != null) {
                    text = "|||  T3!";
                    break;
                }
                return;
            }
            case EFFECTIVE_HEALTH_TEXT: {
                if (onRift) {
                    return;
                }
                text = TextUtils.formatNumber(Math.round(PlayerStat.HEALTH.getValue() * (1.0f + PlayerStat.DEFENCE.getValue() / 100.0f))) + (feature.isEnabled(FeatureSetting.EFFECTIVE_HEALTH_TEXT_ICON) ? "\u2764" : "");
                break;
            }
            case DRILL_FUEL_TEXT: {
                boolean heldDrill;
                boolean bl = heldDrill = RenderListener.MC.field_1724 != null && ItemUtils.isDrill(RenderListener.MC.field_1724.method_6047());
                if (heldDrill || buttonLocation != null) {
                    float fuel = heldDrill ? PlayerStat.FUEL.getValue() : 3000.0f;
                    float maxFuel = heldDrill ? PlayerStat.MAX_FUEL.getValue() : 3000.0f;
                    text = TextUtils.formatNumber(Float.valueOf(fuel)) + "/";
                    if (feature.isEnabled(FeatureSetting.ABBREVIATE_DRILL_FUEL_DENOMINATOR)) {
                        text = (String)text + TextUtils.abbreviate(Float.valueOf(maxFuel));
                        break;
                    }
                    text = (String)text + TextUtils.formatNumber(Float.valueOf(maxFuel));
                    break;
                }
                return;
            }
            case DEFENCE_PERCENTAGE: {
                if (onRift) {
                    return;
                }
                double doubleDefence = PlayerStat.DEFENCE.getValue();
                double percentage = doubleDefence / (doubleDefence + 100.0) * 100.0;
                BigDecimal bigDecimal = new BigDecimal(percentage).setScale(1, RoundingMode.HALF_UP);
                text = String.valueOf(bigDecimal) + "%";
                break;
            }
            case SPEED_PERCENTAGE: {
                if (RenderListener.MC.field_1724 != null) {
                    int walkSpeed = (int)(RenderListener.MC.field_1724.method_31549().method_7253() * 1000.0f);
                    text = walkSpeed + "%";
                    break;
                }
                text = "123%";
                break;
            }
            case HEALTH_UPDATES: {
                if (feature.isEnabled(FeatureSetting.HIDE_HEALTH_UPDATES_ON_RIFT) && main.getUtils().isOnRift()) {
                    return;
                }
                Float healthUpdate = main.getPlayerListener().getActionBarParser().getHealthUpdate();
                if (buttonLocation == null) {
                    if (healthUpdate != null) {
                        color = healthUpdate.floatValue() > 0.0f ? ColorCode.GREEN.getColor() : ColorCode.RED.getColor();
                        text = (healthUpdate.floatValue() > 0.0f ? "+" : "-") + TextUtils.formatNumber(Float.valueOf(Math.abs(healthUpdate.floatValue())));
                        break;
                    }
                    return;
                }
                text = "+123";
                color = ColorCode.GREEN.getColor();
                break;
            }
            case DARK_AUCTION_TIMER: {
                if (Feature.DARK_AUCTION_TIMER.isEnabled(FeatureSetting.SHOW_ONLY_WHEN_SCORPIUS_IS_MAYOR) && !"Scorpius".equals(main.getUtils().getMayor())) {
                    return;
                }
                ZonedDateTime nowDA = SkyblockAddons.getHypixelZonedDateTime();
                ZonedDateTime nextDarkAuction = nowDA.withMinute(55).withSecond(0);
                if (nowDA.getMinute() >= 55) {
                    nextDarkAuction = nextDarkAuction.plusHours(1L);
                }
                Duration diffDA = Duration.between(nowDA, nextDarkAuction);
                text = String.format("%02d:%02d", diffDA.toMinutes(), diffDA.getSeconds() % 60L);
                break;
            }
            case FARM_EVENT_TIMER: {
                Duration diffFE;
                long minutesFE;
                ZonedDateTime nowFE = SkyblockAddons.getHypixelZonedDateTime();
                ZonedDateTime nextFarmEvent = nowFE.withMinute(15).withSecond(0);
                if (nowFE.getMinute() >= 15) {
                    nextFarmEvent = nextFarmEvent.plusHours(1L);
                }
                if ((minutesFE = (diffFE = Duration.between(nowFE, nextFarmEvent)).toMinutes()) < 40L) {
                    text = String.format("%02d:%02d", minutesFE, diffFE.getSeconds() % 60L);
                    break;
                }
                text = String.format("Active: %02d:%02d", minutesFE - 40L, diffFE.getSeconds() % 60L);
                break;
            }
            case SKILL_DISPLAY: {
                int remainingTime;
                if (buttonLocation == null) {
                    text = this.skillText;
                    if (text == null) {
                        return;
                    }
                } else {
                    StringBuilder previewBuilder = new StringBuilder();
                    if (feature.isEnabled(FeatureSetting.SHOW_SKILL_XP_GAINED)) {
                        previewBuilder.append("+123 ");
                    }
                    if (feature.isEnabled(FeatureSetting.SHOW_SKILL_PERCENTAGE_INSTEAD_OF_XP)) {
                        previewBuilder.append("40% ");
                    } else {
                        previewBuilder.append("(2000/5000) ");
                    }
                    if (feature.isEnabled(FeatureSetting.SKILL_ACTIONS_LEFT_UNTIL_NEXT_LEVEL)) {
                        previewBuilder.append(" - ").append(Translations.getMessage("messages.actionsLeft", 3000)).append(" ");
                    }
                    previewBuilder.setLength(previewBuilder.length() - 1);
                    text = previewBuilder.toString();
                }
                if (buttonLocation != null || (remainingTime = (int)(this.skillFadeOutTime - System.currentTimeMillis())) >= 0) break;
                if (remainingTime < -1968) {
                    return;
                }
                int textAlpha = Math.round(255.0f - (float)(-remainingTime) / 2000.0f * 255.0f);
                color = feature.getColor(textAlpha);
                break;
            }
            case ZEALOT_COUNTER: {
                if (feature.isEnabled(FeatureSetting.COUNTER_ZEALOT_SPAWN_AREAS_ONLY) && !LocationUtils.isOnZealotSpawnLocation() && buttonLocation == null) {
                    return;
                }
                text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getKills());
                break;
            }
            case SHOW_TOTAL_ZEALOT_COUNT: {
                if (feature.isEnabled(FeatureSetting.TOTAL_ZEALOT_SPAWN_AREAS_ONLY) && !LocationUtils.isOnZealotSpawnLocation() && buttonLocation == null) {
                    return;
                }
                if (main.getPersistentValuesManager().getPersistentValues().getTotalKills() <= 0) {
                    text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getKills());
                    break;
                }
                text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getTotalKills() + main.getPersistentValuesManager().getPersistentValues().getKills());
                break;
            }
            case SHOW_SUMMONING_EYE_COUNT: {
                if (feature.isEnabled(FeatureSetting.EYE_ZEALOT_SPAWN_AREAS_ONLY) && !LocationUtils.isOnZealotSpawnLocation() && buttonLocation == null) {
                    return;
                }
                text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getSummoningEyeCount());
                break;
            }
            case SHOW_AVERAGE_ZEALOTS_PER_EYE: {
                if (feature.isEnabled(FeatureSetting.AVERAGE_ZEALOT_SPAWN_AREAS_ONLY) && !LocationUtils.isOnZealotSpawnLocation() && buttonLocation == null) {
                    return;
                }
                int summoningEyeCount = main.getPersistentValuesManager().getPersistentValues().getSummoningEyeCount();
                if (summoningEyeCount > 0) {
                    text = TextUtils.formatNumber(Math.round((double)main.getPersistentValuesManager().getPersistentValues().getTotalKills() / (double)main.getPersistentValuesManager().getPersistentValues().getSummoningEyeCount()));
                    break;
                }
                text = "0";
                break;
            }
            case BIRCH_PARK_RAINMAKER_TIMER: {
                long rainmakerTime = main.getPlayerListener().getRainmakerTimeEnd();
                if (!LocationUtils.isOn("Birch Park") && buttonLocation == null) {
                    return;
                }
                String parsedRainTime = TabListParser.getParsedRainTime();
                if (parsedRainTime != null) {
                    text = parsedRainTime;
                    break;
                }
                if (rainmakerTime != -1L) {
                    int totalSeconds = (int)(rainmakerTime - System.currentTimeMillis()) / 1000;
                    if (totalSeconds <= 0) {
                        return;
                    }
                    StringBuilder timerBuilder = new StringBuilder();
                    int hours = totalSeconds / 3600;
                    int minutes = totalSeconds / 60 % 60;
                    int seconds = totalSeconds % 60;
                    if (hours > 0) {
                        timerBuilder.append(hours).append(":");
                    }
                    if (minutes < 10 && hours > 0) {
                        timerBuilder.append("0");
                    }
                    timerBuilder.append(minutes).append(":");
                    if (seconds < 10) {
                        timerBuilder.append("0");
                    }
                    timerBuilder.append(seconds);
                    text = timerBuilder.toString();
                    break;
                }
                if (buttonLocation == null) {
                    return;
                }
                text = "1:23";
                break;
            }
            case ENDSTONE_PROTECTOR_DISPLAY: {
                if (!(LocationUtils.isOn(Island.THE_END) && EndstoneProtectorManager.getMinibossStage() != null && EndstoneProtectorManager.isCanDetectSkull() || buttonLocation != null)) {
                    return;
                }
                EndstoneProtectorManager.Stage stage = EndstoneProtectorManager.getMinibossStage();
                if (buttonLocation != null && stage == null) {
                    stage = EndstoneProtectorManager.Stage.STAGE_3;
                }
                int stageNum = Math.min(stage.ordinal(), 5);
                text = Translations.getMessage("messages.stage", String.valueOf(stageNum));
                break;
            }
            case SHOW_DUNGEON_MILESTONE: {
                if (buttonLocation == null && !main.getUtils().isInDungeon()) {
                    return;
                }
                DungeonMilestone dungeonMilestone = main.getDungeonManager().getDungeonMilestone();
                if (dungeonMilestone == null) {
                    if (buttonLocation != null) {
                        dungeonMilestone = new DungeonMilestone(DungeonClass.HEALER);
                    } else {
                        return;
                    }
                }
                text = "Milestone " + dungeonMilestone.getLevel();
                break;
            }
            case DUNGEONS_COLLECTED_ESSENCES_DISPLAY: {
                if (buttonLocation == null && !main.getUtils().isInDungeon()) {
                    return;
                }
                text = "";
                break;
            }
            case DUNGEON_DEATH_COUNTER: {
                if (buttonLocation == null && !main.getUtils().isInDungeon()) {
                    return;
                }
                text = Integer.toString(main.getDungeonManager().getDeathCount());
                break;
            }
            case ROCK_PET_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.SHOW_ONLY_HOLDING_MINING_TOOL) && !main.getPlayerListener().isHoldingMiningTool()) {
                    return;
                }
                text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getOresMined());
                break;
            }
            case DOLPHIN_PET_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.SHOW_ONLY_HOLDING_FISHING_ROD) && !main.getPlayerListener().isHoldingRod()) {
                    return;
                }
                text = TextUtils.formatNumber(main.getPersistentValuesManager().getPersistentValues().getSeaCreaturesKilled());
                break;
            }
            case DUNGEONS_SECRETS_DISPLAY: {
                if (buttonLocation == null && !main.getUtils().isInDungeon()) {
                    return;
                }
                text = "Secrets";
                break;
            }
            case SPIRIT_SCEPTRE_DISPLAY: {
                if (RenderListener.MC.field_1724 == null) {
                    return;
                }
                if (buttonLocation != null) {
                    text = "\u00a76Hyperion";
                    break;
                }
                class_1799 holdingItem = RenderListener.MC.field_1724.method_6047();
                String skyblockItemID = ItemUtils.getSkyblockItemID(holdingItem);
                if (holdingItem == class_1799.field_8037 || skyblockItemID == null) {
                    return;
                }
                if (DamageDisplayItem.getByID(skyblockItemID) != null) {
                    text = DUNGEON_STAR_PATTERN.matcher(TextUtils.getFormattedText(holdingItem.method_65130())).replaceFirst("");
                    break;
                }
                return;
            }
            case CANDY_POINTS_COUNTER: {
                if (buttonLocation == null && !SpookyEventManager.isActive()) {
                    return;
                }
                text = "Test";
                break;
            }
            case FETCHUR_TODAY: {
                FetchurManager.FetchurItem fetchurItem = FetchurManager.getInstance().getCurrentFetchurItem();
                if (!FetchurManager.getInstance().hasFetchedToday() || buttonLocation != null) {
                    if (feature.isEnabled(FeatureSetting.SHOW_FETCHUR_ITEM_NAME)) {
                        text = Translations.getMessage("messages.fetchurItem", fetchurItem.itemStack().method_7947() + "x " + fetchurItem.itemText());
                        break;
                    }
                    text = Translations.getMessage("messages.fetchurItem", "");
                    break;
                }
                text = "";
                break;
            }
            case FIRE_FREEZE_TIMER: {
                if (buttonLocation == null && !main.getUtils().isInDungeon()) {
                    return;
                }
                if (buttonLocation != null) {
                    text = "Fire Freeze in 5,00";
                    break;
                }
                if (feature.isEnabled(FeatureSetting.FIRE_FREEZE_WHEN_HOLDING) && !main.getPlayerListener().isHoldingFireFreeze()) {
                    return;
                }
                long fireFreezeTimer = main.getPlayerListener().getFireFreezeTimer();
                if (fireFreezeTimer == 0L) {
                    return;
                }
                double countdown = (double)(fireFreezeTimer - System.currentTimeMillis()) / 1000.0;
                if (countdown > 0.0) {
                    text = String.format("Fire Freeze in %.2f", countdown);
                    break;
                }
                if (feature.isEnabled(FeatureSetting.FIRE_FREEZE_SOUND)) {
                    main.getUtils().playLoudSound(class_3417.field_14792, 1.0);
                }
                main.getPlayerListener().setFireFreezeTimer(0L);
                return;
            }
            case THUNDER_BOTTLE_DISPLAY: {
                String capacity;
                ThunderBottle displayBottle = ThunderBottle.getDisplayBottle();
                if (buttonLocation == null && displayBottle == null) {
                    return;
                }
                if (displayBottle != null) {
                    if (displayBottle.isFull()) {
                        text = "\u00a7aFull!";
                        break;
                    }
                    capacity = feature.isEnabled(FeatureSetting.ABBREVIATE_THUNDER_DISPLAYS_DENOMINATOR) ? TextUtils.abbreviate(displayBottle.getCapacity()) : TextUtils.formatNumber(displayBottle.getCapacity());
                    text = TextUtils.formatNumber(displayBottle.getCharge()) + "/" + capacity;
                    break;
                }
                capacity = feature.isEnabled(FeatureSetting.ABBREVIATE_THUNDER_DISPLAYS_DENOMINATOR) ? TextUtils.abbreviate(50000) : TextUtils.formatNumber(50000);
                text = TextUtils.formatNumber(42440) + "/" + capacity;
                break;
            }
            case PRESSURE_TEXT: {
                float pressure;
                float f = pressure = buttonLocation != null ? 50.0f : PlayerStat.PRESSURE.getValue();
                if (pressure == -1.0f) {
                    return;
                }
                boolean icon = feature.isEnabled(FeatureSetting.PRESSURE_TEXT_ICON);
                boolean lastRemembered = main.getPlayerListener().getActionBarParser().isUseLastRememberedPressure();
                text = (icon ? "\u274d" : "") + (lastRemembered ? "~" : "") + TextUtils.formatNumber(Float.valueOf(pressure)) + "%";
                break;
            }
            default: {
                return;
            }
        }
        float x = feature.getActualX();
        float y = feature.getActualY();
        int height = 7;
        int width = RenderListener.MC.field_1772.method_1727((String)text);
        switch (feature) {
            case ZEALOT_COUNTER: 
            case SHOW_TOTAL_ZEALOT_COUNT: 
            case SHOW_SUMMONING_EYE_COUNT: 
            case SHOW_AVERAGE_ZEALOTS_PER_EYE: {
                width = RenderListener.MC.field_1772.method_1727((String)text) + 18;
                height += 9;
                break;
            }
            case ENDSTONE_PROTECTOR_DISPLAY: {
                width += 38 + RenderListener.MC.field_1772.method_1727(String.valueOf(EndstoneProtectorManager.getZealotCount()));
                height += 9;
                break;
            }
            case SHOW_DUNGEON_MILESTONE: {
                width += 18;
                height += 10;
                break;
            }
            case DUNGEONS_SECRETS_DISPLAY: {
                width += 18;
                height += 12;
                break;
            }
            case FETCHUR_TODAY: {
                if (!feature.isDisabled(FeatureSetting.SHOW_FETCHUR_ITEM_NAME)) break;
                width += 18;
                height += 9;
                break;
            }
            case DUNGEONS_COLLECTED_ESSENCES_DISPLAY: {
                int maxNumberWidth = RenderListener.MC.field_1772.method_1727("99");
                width = 20 + maxNumberWidth + 5 + 18 + 2 + maxNumberWidth;
                height = 18 * (int)Math.ceil((float)EssenceType.values().length / 2.0f);
                break;
            }
            case SPIRIT_SCEPTRE_DISPLAY: {
                width += 18 + RenderListener.MC.field_1772.method_1727("12345");
                height += 20;
                break;
            }
            case CANDY_POINTS_COUNTER: {
                width = 0;
                Map<CandyType, Integer> candyCounts = SpookyEventManager.getCandyCounts();
                if (!SpookyEventManager.isActive()) {
                    if (buttonLocation == null) {
                        return;
                    }
                    candyCounts = SpookyEventManager.getDummyCandyCounts();
                }
                int green = candyCounts.get((Object)CandyType.GREEN);
                int purple = candyCounts.get((Object)CandyType.PURPLE);
                if (buttonLocation != null || green > 0) {
                    width += 17 + RenderListener.MC.field_1772.method_1727(TextUtils.formatNumber(green));
                }
                if (buttonLocation != null || purple > 0) {
                    if (green > 0) {
                        ++width;
                    }
                    width += 17 + RenderListener.MC.field_1772.method_1727(TextUtils.formatNumber(purple)) + 1;
                }
                height = 24;
                break;
            }
            case DARK_AUCTION_TIMER: 
            case FARM_EVENT_TIMER: 
            case SKILL_DISPLAY: 
            case BIRCH_PARK_RAINMAKER_TIMER: 
            case DUNGEON_DEATH_COUNTER: 
            case ROCK_PET_TRACKER: 
            case DOLPHIN_PET_TRACKER: 
            case FIRE_FREEZE_TIMER: 
            case THUNDER_BOTTLE_DISPLAY: {
                width += 18;
                height += 9;
            }
        }
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        switch (feature) {
            case DARK_AUCTION_TIMER: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(SIRIUS_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case FARM_EVENT_TIMER: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(FARM_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case ZEALOT_COUNTER: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(ENDERMAN_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case SHOW_TOTAL_ZEALOT_COUNT: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(ENDERMAN_GROUP_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case SHOW_SUMMONING_EYE_COUNT: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(SUMMONING_EYE_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case SHOW_AVERAGE_ZEALOTS_PER_EYE: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(ZEALOTS_PER_EYE_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(SLASH_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case SKILL_DISPLAY: {
                if ((this.skill == null || this.skill.getItem() == null) && buttonLocation == null) {
                    return;
                }
                this.renderItem(graphics, buttonLocation == null ? this.skill.getItem() : SkillType.FARMING.getItem(), x, y);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case BIRCH_PARK_RAINMAKER_TIMER: {
                this.renderItem(graphics, WATER_BUCKET, x, y);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case ENDSTONE_PROTECTOR_DISPLAY: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(IRON_GOLEM_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(ENDERMAN_GROUP_ICON), (Matrix3x2f)graphics.method_51448(), x += (float)(18 + RenderListener.MC.field_1772.method_1727((String)text) + 2), y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                int count = EndstoneProtectorManager.getZealotCount();
                DrawUtils.drawText(graphics, TextUtils.formatNumber(count), x + 16.0f + 2.0f, y + 4.0f, color);
                break;
            }
            case SHOW_DUNGEON_MILESTONE: {
                Number amount;
                DungeonMilestone dungeonMilestone = main.getDungeonManager().getDungeonMilestone();
                if (buttonLocation != null) {
                    dungeonMilestone = new DungeonMilestone(DungeonClass.HEALER);
                }
                this.renderItem(graphics, dungeonMilestone.getDungeonClass().getItem(), x, y);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y, color);
                try {
                    amount = TextUtils.NUMBER_FORMAT.parse(dungeonMilestone.getValue());
                }
                catch (ParseException e) {
                    amount = -1;
                }
                String formattedAmount = TextUtils.formatNumber(amount);
                DrawUtils.drawText(graphics, formattedAmount, x + 18.0f + (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f - (float)RenderListener.MC.field_1772.method_1727(formattedAmount) / 2.0f, y + 9.0f, color);
                break;
            }
            case DUNGEONS_COLLECTED_ESSENCES_DISPLAY: {
                this.drawCollectedEssences(graphics, x, y, buttonLocation != null, true);
                break;
            }
            case DUNGEON_DEATH_COUNTER: {
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(MORT_ICON), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case ROCK_PET_TRACKER: {
                this.renderItem(graphics, ItemUtils.getTexturedHead("DUMMY_ROCK"), x, y);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case DOLPHIN_PET_TRACKER: {
                this.renderItem(graphics, ItemUtils.getTexturedHead("DUMMY_DOLPHIN"), x, y);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case DUNGEONS_SECRETS_DISPLAY: {
                int secrets = main.getDungeonManager().getSecrets();
                int maxSecrets = main.getDungeonManager().getMaxSecrets();
                DrawUtils.drawText(graphics, (String)text, x + 16.0f + 2.0f, y, color);
                if (secrets == -1 && buttonLocation != null) {
                    secrets = 5;
                    maxSecrets = 10;
                }
                if (secrets == -1 | maxSecrets == 0) {
                    String none = Translations.getMessage("messages.none", new Object[0]);
                    DrawUtils.drawText(graphics, none, x + 16.0f + 2.0f + (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f - (float)RenderListener.MC.field_1772.method_1727(none) / 2.0f, y + 10.0f, color);
                } else {
                    float g;
                    float r;
                    float percent;
                    if (secrets > maxSecrets) {
                        maxSecrets = secrets;
                    }
                    if ((percent = (float)secrets / (float)maxSecrets) < 0.0f) {
                        percent = 0.0f;
                    } else if (percent > 1.0f) {
                        percent = 1.0f;
                    }
                    if ((double)percent <= 0.5) {
                        r = 1.0f;
                        g = percent * 2.0f * 0.66f + 0.33f;
                    } else {
                        r = (1.0f - percent) * 0.66f + 0.33f;
                        g = 1.0f;
                    }
                    int secretsColor = class_9848.method_61318((float)1.0f, (float)Math.min(1.0f, r), (float)g, (float)0.33f);
                    float secretsWidth = RenderListener.MC.field_1772.method_1727(String.valueOf(secrets));
                    float slashWidth = RenderListener.MC.field_1772.method_1727("/");
                    float maxSecretsWidth = RenderListener.MC.field_1772.method_1727(String.valueOf(maxSecrets));
                    float totalWidth = secretsWidth + slashWidth + maxSecretsWidth;
                    DrawUtils.drawText(graphics, "/", x + 16.0f + 2.0f + (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f - totalWidth / 2.0f + secretsWidth, y + 11.0f, color);
                    DrawUtils.drawText(graphics, String.valueOf(secrets), x + 16.0f + 2.0f + (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f - totalWidth / 2.0f, y + 11.0f, secretsColor);
                    DrawUtils.drawText(graphics, String.valueOf(maxSecrets), x + 16.0f + 2.0f + (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f - totalWidth / 2.0f + secretsWidth + slashWidth, y + 11.0f, secretsColor);
                }
                this.renderItem(graphics, CHEST, x, y);
                break;
            }
            case SPIRIT_SCEPTRE_DISPLAY: {
                int hitEnemies = main.getPlayerListener().getSpiritSceptreHitEnemies();
                float dealtDamage = main.getPlayerListener().getSpiritSceptreDealtDamage();
                DrawUtils.drawText(graphics, (String)text, x + 16.0f + 2.0f, y, color);
                if (hitEnemies == 1) {
                    DrawUtils.drawText(graphics, String.format("%d enemy hit", hitEnemies), x + 16.0f + 2.0f, y + 9.0f, color);
                } else {
                    DrawUtils.drawText(graphics, String.format("%d enemies hit", hitEnemies), x + 16.0f + 2.0f, y + 9.0f, color);
                }
                DrawUtils.drawText(graphics, String.format("%,d damage dealt", Math.round(dealtDamage)), x + 16.0f + 2.0f, y + 18.0f, color);
                if (buttonLocation != null) {
                    this.renderItem(graphics, DamageDisplayItem.HYPERION.itemStack, x, y);
                    break;
                }
                class_1799 displayItem = DamageDisplayItem.getByID(ItemUtils.getSkyblockItemID(RenderListener.MC.field_1724.method_6047()));
                if (displayItem == null) break;
                this.renderItem(graphics, displayItem, x, y);
                break;
            }
            case CANDY_POINTS_COUNTER: {
                Map<CandyType, Integer> candyCounts = SpookyEventManager.getCandyCounts();
                if (!SpookyEventManager.isActive()) {
                    candyCounts = SpookyEventManager.getDummyCandyCounts();
                }
                int green = candyCounts.get((Object)CandyType.GREEN);
                int purple = candyCounts.get((Object)CandyType.PURPLE);
                int points = SpookyEventManager.getPoints();
                if (!SpookyEventManager.isActive()) {
                    points = 5678;
                }
                float currentX = x;
                if (buttonLocation != null || green > 0) {
                    this.renderItem(graphics, ItemUtils.getTexturedHead("GREEN_CANDY"), currentX, y);
                    DrawUtils.drawText(graphics, TextUtils.formatNumber(green), currentX += 17.0f, y + 4.0f, color);
                }
                if (buttonLocation != null || purple > 0) {
                    if (buttonLocation != null || green > 0) {
                        currentX += (float)(RenderListener.MC.field_1772.method_1727(TextUtils.formatNumber(green)) + 1);
                    }
                    this.renderItem(graphics, ItemUtils.getTexturedHead("PURPLE_CANDY"), currentX, y);
                    DrawUtils.drawText(graphics, TextUtils.formatNumber(purple), currentX += 17.0f, y + 4.0f, color);
                }
                text = TextUtils.formatNumber(points) + " Points";
                DrawUtils.drawText(graphics, (String)text, x + (float)width / 2.0f - (float)RenderListener.MC.field_1772.method_1727((String)text) / 2.0f, y + 16.0f, color);
                break;
            }
            case FETCHUR_TODAY: {
                boolean showDwarven = feature.isDisabled(FeatureSetting.SHOW_FETCHUR_ONLY_IN_DWARVENS) || LocationUtils.isOn(Island.DWARVEN_MINES);
                boolean showInventory = feature.isDisabled(FeatureSetting.SHOW_FETCHUR_INVENTORY_OPEN_ONLY) || RenderListener.MC.field_1755 != null;
                FetchurManager.FetchurItem fetchurItem = FetchurManager.getInstance().getCurrentFetchurItem();
                if (fetchurItem == null || buttonLocation == null && (FetchurManager.getInstance().hasFetchedToday() || !showDwarven || !showInventory)) break;
                if (feature.isDisabled(FeatureSetting.SHOW_FETCHUR_ITEM_NAME)) {
                    DrawUtils.drawText(graphics, (String)text, x + 1.0f, y + 4.0f, color);
                    float offsetX = RenderListener.MC.field_1772.method_1727((String)text);
                    RenderListener.renderItemAndOverlay(graphics, fetchurItem.itemStack(), String.valueOf(fetchurItem.itemStack().method_7947()), x + offsetX, y);
                    break;
                }
                DrawUtils.drawText(graphics, (String)text, x, y, color);
                break;
            }
            case HEALTH_TEXT: {
                if (RenderListener.MC.field_1724 != null && RenderListener.MC.field_1724.method_6059(class_1294.field_5898) && PlayerStat.HEALTH.getValue() > PlayerStat.MAX_HEALTH.getValue()) {
                    String formattedHealth = TextUtils.formatNumber(Float.valueOf(PlayerStat.HEALTH.getValue()));
                    int formattedHealthWidth = RenderListener.MC.field_1772.method_1727(formattedHealth);
                    color = ColorUtils.getDummySkyblockColor(ColorCode.GOLD.getColor(), feature.isChroma()).getColor();
                    DrawUtils.drawText(graphics, formattedHealth, x, y, color);
                    color = feature.getColor();
                    DrawUtils.drawText(graphics, "/" + TextUtils.formatNumber(Float.valueOf(PlayerStat.MAX_HEALTH.getValue())) + (feature.isEnabled(FeatureSetting.HEALTH_TEXT_ICON) ? "\u2764" : ""), x + (float)formattedHealthWidth, y, color);
                    break;
                }
                DrawUtils.drawText(graphics, (String)text, x, y, color);
                break;
            }
            case FIRE_FREEZE_TIMER: {
                this.renderItem(graphics, class_2246.field_10182.method_8389().method_7854(), x, y - 3.0f);
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case THUNDER_BOTTLE_DISPLAY: {
                ThunderBottle displayBottle = ThunderBottle.getDisplayBottle();
                if (displayBottle != null) {
                    this.renderItem(graphics, displayBottle.getItemStack(), x, y);
                } else {
                    this.renderItem(graphics, ItemUtils.getTexturedHead("DUMMY_THUNDER_BOTTLE"), x, y);
                }
                DrawUtils.drawText(graphics, (String)text, x + 18.0f, y + 4.0f, color);
                break;
            }
            case PRESSURE_TEXT: {
                float pressure;
                if (Feature.PRESSURE_TEXT.isEnabled(FeatureSetting.PRESSURE_TEXT_ALERT) && (pressure = PlayerStat.PRESSURE.getValue()) >= 90.0f && main.getScheduler().getTotalTicks() % 40L >= 20L) {
                    color = ColorCode.RED.getColor();
                }
                DrawUtils.drawText(graphics, (String)text, x, y, color);
                break;
            }
            default: {
                DrawUtils.drawText(graphics, (String)text, x, y, color);
            }
        }
    }

    private String getCrimsonArmorAbilityStacks() {
        class_746 player = RenderListener.MC.field_1724;
        if (player == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        block0: for (CrimsonArmorAbilityStack crimsonArmorAbilityStack : CrimsonArmorAbilityStack.values()) {
            for (class_1304 equipmentSlot : class_1661.field_56551.values()) {
                class_1799 itemStack = player.method_6118(equipmentSlot);
                if (itemStack == class_1799.field_8037) continue;
                for (String line : ItemUtils.getItemLore(itemStack)) {
                    String abilityName;
                    if (!line.contains("\u00a76Tiered Bonus: ") || !line.contains(abilityName = crimsonArmorAbilityStack.getAbilityName())) continue;
                    String symbol = crimsonArmorAbilityStack.getSymbol();
                    int stack = crimsonArmorAbilityStack.getCurrentValue();
                    builder.append(abilityName).append(" ").append(symbol).append(" ").append(stack);
                    continue block0;
                }
            }
        }
        return builder.isEmpty() ? null : builder.toString();
    }

    public void drawCollectedEssences(class_332 graphics, float x, float y, boolean usePlaceholders, boolean hideZeroes) {
        int maxNumberWidth;
        InventoryType inventoryType = main.getInventoryUtils().getInventoryType();
        float currentX = x;
        if (inventoryType == InventoryType.SALVAGING) {
            Set<Map.Entry<EssenceType, Integer>> entrySet = main.getDungeonManager().getSalvagedEssences().entrySet();
            if (entrySet.isEmpty()) {
                return;
            }
            String highestAmountStr = ((Integer)Collections.max(entrySet, Map.Entry.comparingByValue()).getValue()).toString();
            maxNumberWidth = RenderListener.MC.field_1772.method_1727(highestAmountStr);
        } else {
            maxNumberWidth = RenderListener.MC.field_1772.method_1727("99");
        }
        int color = Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.getColor();
        int count = 0;
        for (EssenceType essenceType : EssenceType.values()) {
            int value = inventoryType == InventoryType.SALVAGING ? main.getDungeonManager().getSalvagedEssences().getOrDefault((Object)essenceType, 0).intValue() : main.getDungeonManager().getCollectedEssences().getOrDefault((Object)essenceType, 0).intValue();
            if (usePlaceholders) {
                value = 99;
            } else if (value <= 0 && hideZeroes) continue;
            int column = count % 2;
            int row = count / 2;
            if (column == 0) {
                currentX = x;
            } else if (column == 1) {
                currentX = x + 18.0f + 2.0f + (float)maxNumberWidth + 5.0f;
            }
            float currentY = y + (float)(row * 18);
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(essenceType.getResourceLocation()), (Matrix3x2f)graphics.method_51448(), currentX, currentY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, -1, graphics.field_44659.method_70863()));
            DrawUtils.drawText(graphics, TextUtils.formatNumber(value), currentX + 18.0f + 2.0f, currentY + 5.0f, color);
            ++count;
        }
    }

    public void drawBaitList(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        if (!main.getPlayerListener().isHoldingRod() && buttonLocation == null) {
            return;
        }
        Object baits = BaitManager.getInstance().getBaitsInInventory();
        if (buttonLocation != null) {
            baits = BaitManager.DUMMY_BAITS;
        }
        int longestLineWidth = 0;
        for (Map.Entry entry : baits.entrySet()) {
            longestLineWidth = Math.max(longestLineWidth, RenderListener.MC.field_1772.method_1727(TextUtils.formatNumber((Number)entry.getValue())));
        }
        Feature feature = Feature.BAIT_LIST;
        float x = feature.getActualX();
        float y = feature.getActualY();
        int spacing = 1;
        int iconSize = 16;
        int width = iconSize + spacing + longestLineWidth;
        int height = iconSize * baits.size();
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        for (Map.Entry entry : baits.entrySet()) {
            if ((Integer)entry.getValue() == 0) continue;
            this.renderItem(graphics, (class_1799)entry.getKey(), x, y);
            int color = feature.getColor();
            DrawUtils.drawText(graphics, TextUtils.formatNumber((Number)entry.getValue()), x + (float)iconSize + (float)spacing, y + (float)iconSize / 2.0f - 4.0f, color);
            y += (float)iconSize;
        }
    }

    public void drawSlayerTrackers(class_332 graphics, Feature feature, float scale, ButtonLocation buttonLocation) {
        SlayerBoss slayerBoss;
        boolean textMode;
        boolean colorByRarity;
        EnumUtils.SlayerQuest quest = main.getUtils().getSlayerQuest();
        switch (feature) {
            case REVENANT_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_CRYPTS) && (quest != EnumUtils.SlayerQuest.REVENANT_HORROR || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.REVENANT_HORROR))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.REVENANT_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.REVENANT_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.REVENANT;
                break;
            }
            case TARANTULA_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_SPIDERS_DEN) && (quest != EnumUtils.SlayerQuest.TARANTULA_BROODFATHER || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.TARANTULA_BROODFATHER))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.TARANTULA_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.TARANTULA_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.TARANTULA;
                break;
            }
            case SVEN_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_CASTLE) && (quest != EnumUtils.SlayerQuest.SVEN_PACKMASTER || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.SVEN_PACKMASTER))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.SVEN_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.SVEN_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.SVEN;
                break;
            }
            case VOIDGLOOM_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_END) && (quest != EnumUtils.SlayerQuest.VOIDGLOOM_SERAPH || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.VOIDGLOOM_SERAPH))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.VOIDGLOOM_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.VOIDGLOOM_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.VOIDGLOOM;
                break;
            }
            case INFERNO_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_CRIMSON) && (quest != EnumUtils.SlayerQuest.INFERNO_DEMONLORD || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.INFERNO_DEMONLORD))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.INFERNO_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.INFERNO_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.INFERNO;
                break;
            }
            case RIFTSTALKER_SLAYER_TRACKER: {
                if (buttonLocation == null && feature.isEnabled(FeatureSetting.HIDE_WHEN_NOT_IN_RIFT) && (quest != EnumUtils.SlayerQuest.RIFTSTALKER_BLOODFIEND || !LocationUtils.isOnSlayerLocation(EnumUtils.SlayerQuest.RIFTSTALKER_BLOODFIEND))) {
                    return;
                }
                colorByRarity = feature.isEnabled(FeatureSetting.RIFTSTALKER_TRACKER_COLOR_BY_RARITY);
                textMode = feature.isEnabled(FeatureSetting.RIFTSTALKER_TRACKER_TEXT_MODE);
                slayerBoss = SlayerBoss.RIFTSTALKER;
                break;
            }
            default: {
                return;
            }
        }
        float actualX = feature.getActualX();
        float actualY = feature.getActualY();
        int color = feature.getColor();
        if (textMode) {
            int lineHeight = 8;
            int spacer = 3;
            int lines = 0;
            int spacers = 0;
            int longestLineWidth = RenderListener.MC.field_1772.method_1727(slayerBoss.getDisplayName());
            ++lines;
            ++spacers;
            int longestSlayerDropLineWidth = RenderListener.MC.field_1772.method_1727(Translations.getMessage("slayerTracker.bossesKilled", new Object[0]));
            int longestCount = RenderListener.MC.field_1772.method_1727(String.valueOf(SlayerTracker.getInstance().getSlayerKills(slayerBoss)));
            ++lines;
            ++spacers;
            for (SlayerDrop drop : slayerBoss.getDrops()) {
                longestSlayerDropLineWidth = Math.max(longestSlayerDropLineWidth, RenderListener.MC.field_1772.method_1727(drop.getDisplayName()));
                longestCount = Math.max(longestCount, RenderListener.MC.field_1772.method_1727(String.valueOf(SlayerTracker.getInstance().getDropCount(drop))));
                ++lines;
            }
            int width = Math.max(longestLineWidth, longestSlayerDropLineWidth + 8 + longestCount);
            int height = lines * 8 + spacer * spacers;
            float x = this.transformX(actualX, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
            float y = this.transformY(actualY, height, scale);
            if (buttonLocation != null) {
                buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
            }
            DrawUtils.drawText(graphics, slayerBoss.getDisplayName(), x, y, color);
            DrawUtils.drawText(graphics, Translations.getMessage("slayerTracker.bossesKilled", new Object[0]), x, y += (float)(lineHeight + spacer), color);
            String string = String.valueOf(SlayerTracker.getInstance().getSlayerKills(slayerBoss));
            DrawUtils.drawText(graphics, string, x + (float)width - (float)RenderListener.MC.field_1772.method_1727(string), y, color);
            y += (float)(lineHeight + spacer);
            for (SlayerDrop slayerDrop : slayerBoss.getDrops()) {
                int currentColor = colorByRarity ? slayerDrop.getRarity().getColorCode().getColor() : color;
                DrawUtils.drawText(graphics, slayerDrop.getDisplayName(), x, y, currentColor, colorByRarity);
                String string2 = String.valueOf(SlayerTracker.getInstance().getDropCount(slayerDrop));
                DrawUtils.drawText(graphics, string2, x + (float)width - (float)RenderListener.MC.field_1772.method_1727(string2), y, currentColor);
                y += (float)lineHeight;
            }
        } else {
            int width;
            int entityRenderY;
            int textCenterX = switch (feature) {
                case Feature.REVENANT_SLAYER_TRACKER -> {
                    entityRenderY = 30;
                    yield 15;
                }
                case Feature.TARANTULA_SLAYER_TRACKER -> {
                    entityRenderY = 36;
                    yield 28;
                }
                case Feature.SVEN_SLAYER_TRACKER -> {
                    entityRenderY = 25;
                    yield 20;
                }
                case Feature.VOIDGLOOM_SLAYER_TRACKER -> {
                    entityRenderY = 24;
                    yield 20;
                }
                case Feature.INFERNO_SLAYER_TRACKER -> {
                    entityRenderY = 35;
                    yield 20;
                }
                case Feature.RIFTSTALKER_SLAYER_TRACKER -> {
                    entityRenderY = 40;
                    yield 15;
                }
                default -> {
                    entityRenderY = 36;
                    yield 15;
                }
            };
            int iconWidth = 16;
            int entityWidth = textCenterX * 2;
            int entityIconSpacingHorizontal = 2;
            int iconTextOffset = -2;
            int row = 0;
            int column = 0;
            int maxItemsPerRow = (int)Math.ceil((double)slayerBoss.getDrops().size() / 3.0);
            int[] maxTextWidths = new int[maxItemsPerRow];
            for (SlayerDrop slayerDrop : slayerBoss.getDrops()) {
                width = RenderListener.MC.field_1772.method_1727(TextUtils.abbreviate(SlayerTracker.getInstance().getDropCount(slayerDrop)));
                maxTextWidths[column] = Math.max(maxTextWidths[column], width);
                if (++column != maxItemsPerRow) continue;
                column = 0;
                ++row;
            }
            int totalColumnWidth = 0;
            for (int i : maxTextWidths) {
                totalColumnWidth += i;
            }
            int n = 4;
            width = entityWidth + entityIconSpacingHorizontal + maxItemsPerRow * iconWidth + totalColumnWidth + iconTextOffset;
            int height = (iconWidth + n) * 3 - n;
            float x = this.transformX(actualX, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
            float y = this.transformY(actualY, height, scale);
            if (buttonLocation != null) {
                buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
            }
            switch (feature) {
                case REVENANT_SLAYER_TRACKER: {
                    if (revenant == null) {
                        revenant = new class_1642(class_1299.field_6051, (class_1937)RenderListener.MC.field_1687);
                        revenant.method_5673(class_1304.field_6173, ItemUtils.createItemStack(class_1802.field_8527, true));
                        revenant.method_5673(class_1304.field_6166, ItemUtils.createItemStack(class_1802.field_8285, false));
                        revenant.method_5673(class_1304.field_6172, ItemUtils.createItemStack(class_1802.field_8218, true));
                        revenant.method_5673(class_1304.field_6174, ItemUtils.createItemStack(class_1802.field_8058, true));
                        revenant.method_5673(class_1304.field_6169, ItemUtils.getTexturedHead("REAPER_MASK"));
                    }
                    RenderListener.revenant.field_6012 = (int)main.getScheduler().getTotalTicks();
                    this.drawEntity(graphics, (class_1309)revenant, x, y, entityWidth, height, -15.0f, scale);
                    break;
                }
                case TARANTULA_SLAYER_TRACKER: {
                    if (tarantula == null) {
                        tarantula = new class_1628(class_1299.field_6079, (class_1937)RenderListener.MC.field_1687);
                        caveSpider = new class_1549(class_1299.field_6084, (class_1937)RenderListener.MC.field_1687);
                    }
                    this.drawEntity(graphics, (class_1309)tarantula, x + 3.0f, y, entityWidth, height, -30.0f, scale);
                    this.drawEntity(graphics, (class_1309)caveSpider, x, y - 10.0f, entityWidth, height, -30.0f, scale);
                    break;
                }
                case SVEN_SLAYER_TRACKER: {
                    if (sven == null) {
                        sven = new class_1493(class_1299.field_6055, (class_1937)RenderListener.MC.field_1687);
                        sven.method_29514(Integer.MAX_VALUE);
                    }
                    this.drawEntity(graphics, (class_1309)sven, x, y - 2.0f, entityWidth, height, -35.0f, scale, 1.2f);
                    break;
                }
                case VOIDGLOOM_SLAYER_TRACKER: {
                    if (enderman == null) {
                        enderman = new class_1560(class_1299.field_6091, (class_1937)RenderListener.MC.field_1687);
                        enderman.method_7032(class_2246.field_10327.method_9564());
                    }
                    RenderListener.enderman.field_6012 = (int)main.getScheduler().getTotalTicks();
                    this.drawEntity(graphics, (class_1309)enderman, x, y, entityWidth, height, -30.0f, scale, 0.7f);
                    break;
                }
                case INFERNO_SLAYER_TRACKER: {
                    if (inferno == null) {
                        inferno = new class_1545(class_1299.field_6099, (class_1937)RenderListener.MC.field_1687);
                        inferno.method_6993(true);
                    }
                    RenderListener.inferno.field_6012 = (int)main.getScheduler().getTotalTicks();
                    this.drawEntity(graphics, (class_1309)inferno, x, y, entityWidth, height, -15.0f, scale);
                    break;
                }
                case RIFTSTALKER_SLAYER_TRACKER: {
                    if (riftstalker == null) {
                        riftstalker = new class_745(this, RenderListener.MC.field_1687, new GameProfile(UUID.randomUUID(), "Riftstalker")){

                            public class_8685 method_52814() {
                                class_12079.class_10726 bodySkin = new class_12079.class_10726(RIFTSTALKER_BLOODFIEND, RIFTSTALKER_BLOODFIEND);
                                return new class_8685((class_12079.class_12081)bodySkin, null, null, class_7920.field_41123, true);
                            }
                        };
                        riftstalker.method_5880(false);
                    }
                    this.drawEntity(graphics, (class_1309)riftstalker, x, y, entityWidth, height, -15.0f, scale);
                }
            }
            row = 0;
            column = 0;
            float currentX = x + (float)entityIconSpacingHorizontal + (float)entityWidth;
            for (SlayerDrop slayerDrop : slayerBoss.getDrops()) {
                if (column > 0) {
                    currentX += (float)(iconWidth + maxTextWidths[column - 1]);
                }
                float currentY = y + (float)(row * (iconWidth + n));
                this.renderItem(graphics, slayerDrop.getItemStack(), currentX, currentY);
                int currentColor = colorByRarity ? slayerDrop.getRarity().getColorCode().getColor() : color;
                DrawUtils.drawText(graphics, TextUtils.abbreviate(SlayerTracker.getInstance().getDropCount(slayerDrop)), currentX + (float)iconWidth + (float)iconTextOffset, currentY + 8.0f, currentColor, colorByRarity);
                if (++column != maxItemsPerRow) continue;
                currentX = x + (float)entityIconSpacingHorizontal + (float)entityWidth;
                column = 0;
                ++row;
            }
            String text = TextUtils.abbreviate(SlayerTracker.getInstance().getSlayerKills(slayerBoss)) + " Kills";
            DrawUtils.drawText(graphics, text, x + (float)textCenterX - (float)RenderListener.MC.field_1772.method_1727(text) / 2.0f, y + (float)entityRenderY, color);
        }
    }

    public void drawDragonTrackers(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        int height;
        int width;
        Feature feature = Feature.DRAGON_STATS_TRACKER;
        if (feature.isEnabled(FeatureSetting.DRAGONS_NEST_ONLY) && !LocationUtils.isOn("Dragon's Nest") && buttonLocation == null) {
            return;
        }
        List<DragonType> recentDragons = DragonTracker.getInstance().getRecentDragons();
        if (recentDragons.isEmpty() && buttonLocation != null) {
            recentDragons = DragonTracker.getDummyDragons();
        }
        boolean colorByRarity = feature.isEnabled(FeatureSetting.DRAGON_TRACKER_COLOR_BY_RARITY);
        boolean textMode = feature.isEnabled(FeatureSetting.DRAGON_TRACKER_TEXT_MODE);
        int spacerHeight = 3;
        String never = Translations.getMessage("dragonTracker.never", new Object[0]);
        if (textMode) {
            int lines = 0;
            int spacers = 0;
            int longestLineWidth = RenderListener.MC.field_1772.method_1727(Translations.getMessage("dragonTracker.recentDragons", new Object[0]));
            ++lines;
            ++spacers;
            ++spacers;
            longestLineWidth = Math.max(longestLineWidth, RenderListener.MC.field_1772.method_1727(Translations.getMessage("dragonTracker.dragonsSince", new Object[0])));
            ++lines;
            ++spacers;
            for (DragonType dragon : recentDragons) {
                longestLineWidth = Math.max(longestLineWidth, RenderListener.MC.field_1772.method_1727(dragon.getDisplayName()));
                ++lines;
            }
            int longestCount = 0;
            int longestDragonsSinceLineWidth = 0;
            for (DragonsSince dragonsSince : DragonsSince.values()) {
                longestDragonsSinceLineWidth = Math.max(longestDragonsSinceLineWidth, RenderListener.MC.field_1772.method_1727(dragonsSince.getDisplayName()));
                int dragonsSinceValue = DragonTracker.getInstance().getDragsSince(dragonsSince);
                longestCount = Math.max(longestCount, RenderListener.MC.field_1772.method_1727(dragonsSinceValue == 0 ? never : String.valueOf(dragonsSinceValue)));
                ++lines;
            }
            width = Math.max(longestLineWidth, longestDragonsSinceLineWidth + 8 + longestCount);
            height = lines * 8 + spacerHeight * spacers;
        } else {
            width = 100;
            height = 100;
        }
        float x = Feature.DRAGON_STATS_TRACKER.getActualX();
        float y = Feature.DRAGON_STATS_TRACKER.getActualY();
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        int color = feature.getColor();
        if (textMode) {
            DrawUtils.drawText(graphics, Translations.getMessage("dragonTracker.recentDragons", new Object[0]), x, y, color);
            y += (float)(8 + spacerHeight);
            for (DragonType dragon : recentDragons) {
                int currentColor = colorByRarity ? dragon.getColor().getColor() : color;
                DrawUtils.drawText(graphics, dragon.getDisplayName(), x, y, currentColor, colorByRarity);
                y += 8.0f;
            }
            color = feature.getColor();
            DrawUtils.drawText(graphics, Translations.getMessage("dragonTracker.dragonsSince", new Object[0]), x, y += (float)spacerHeight, color);
            y += (float)(8 + spacerHeight);
            for (DragonsSince dragonsSince : DragonsSince.values()) {
                int currentColor = colorByRarity ? dragonsSince.getItemRarity().getColorCode().getColor() : color;
                DrawUtils.drawText(graphics, dragonsSince.getDisplayName(), x, y, currentColor, colorByRarity);
                int dragonsSinceValue = DragonTracker.getInstance().getDragsSince(dragonsSince);
                String text = dragonsSinceValue == 0 ? never : String.valueOf(dragonsSinceValue);
                DrawUtils.drawText(graphics, text, x + (float)width - (float)RenderListener.MC.field_1772.method_1727(text), y, color);
                y += 8.0f;
            }
        }
    }

    public void drawSlayerArmorProgress(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        float x = Feature.SLAYER_ARMOR_PROGRESS.getActualX();
        float y = Feature.SLAYER_ARMOR_PROGRESS.getActualY();
        Feature feature = Feature.SLAYER_ARMOR_PROGRESS;
        int longest = -1;
        SlayerArmorProgress[] progresses = main.getInventoryUtils().getSlayerArmorProgresses();
        if (buttonLocation != null) {
            progresses = DUMMY_PROGRESSES;
        }
        for (SlayerArmorProgress progress : progresses) {
            int textWidth;
            if (progress == null || (textWidth = RenderListener.MC.field_1772.method_1727(progress.getPercent() + "% (" + progress.getDefence() + ")")) <= longest) continue;
            longest = textWidth;
        }
        if (longest == -1) {
            return;
        }
        int height = 60;
        int width = 18 + longest;
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        boolean downwards = Feature.SLAYER_ARMOR_PROGRESS.getAnchorPoint().isOnTop();
        int color = feature.getColor();
        int drawnCount = 0;
        for (int armorPiece = 3; armorPiece >= 0; --armorPiece) {
            SlayerArmorProgress progress = progresses[downwards ? armorPiece : 3 - armorPiece];
            if (progress == null) continue;
            float fixedY = downwards ? y + (float)(drawnCount * 15) : y + 45.0f - (float)(drawnCount * 15);
            this.renderItem(graphics, progress.getItemStack(), x, fixedY);
            float currentX = x + 19.0f;
            DrawUtils.drawText(graphics, progress.getPercent() + "% (", currentX, fixedY + 5.0f, color);
            DrawUtils.drawText(graphics, progress.getDefence(), currentX += (float)RenderListener.MC.field_1772.method_1727(progress.getPercent() + "% ("), fixedY + 5.0f, -1);
            DrawUtils.drawText(graphics, ")", currentX += (float)RenderListener.MC.field_1772.method_1727(progress.getDefence()), fixedY + 5.0f, color);
            ++drawnCount;
        }
    }

    private void drawPetDisplay(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        if (main.getUtils().isOnRift()) {
            return;
        }
        Feature feature = Feature.PET_DISPLAY;
        PetManager.Pet newPet = main.getPetCacheManager().getCurrentPet();
        if (newPet == null) {
            return;
        }
        if (this.pet != newPet) {
            this.pet = newPet;
            this.petSkull = newPet.getItemStack();
        }
        String text = this.pet.getDisplayName();
        float x = feature.getActualX();
        float y = feature.getActualY();
        Objects.requireNonNull(RenderListener.MC.field_1772);
        int height = 7 + 9;
        int width = RenderListener.MC.field_1772.method_1727(text) + 18;
        EnumUtils.PetItemStyle style = (EnumUtils.PetItemStyle)feature.getAsEnum(FeatureSetting.PET_ITEM_STYLE);
        int line = 1;
        if (style != EnumUtils.PetItemStyle.NONE && this.pet.getPetInfo().getHeldItemId() != null) {
            height *= 2;
            width += 18;
            ++line;
        }
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        int color = feature.getColor();
        DrawUtils.drawText(graphics, text, x + (float)(18 * line), y + 4.0f, color);
        switch (style) {
            case DISPLAY_NAME: {
                if (this.pet.getPetInfo().getHeldItemId() == null) break;
                String petDisplayName = PetManager.getInstance().getPetItemDisplayNameFromId(this.pet.getPetInfo().getHeldItemId());
                DrawUtils.drawText(graphics, "Held Item: " + petDisplayName, x + (float)(18 * line), y + 16.0f, color);
                break;
            }
            case SHOW_ITEM: {
                if (this.pet.getPetInfo().getHeldItemId() == null) break;
                PetManager petManager = PetManager.getInstance();
                String petHeldItemId = this.pet.getPetInfo().getHeldItemId();
                class_1799 petItemStack = petManager.getPetItemFromId(petHeldItemId);
                SkyblockRarity petItemRarity = petManager.getPetItemRarityFromId(petHeldItemId);
                Object displayText = "Held Item:";
                if (petHeldItemId.endsWith(petItemRarity.getLoreName())) {
                    displayText = (String)displayText + " " + petItemRarity.getColorCode().toString() + petItemRarity.getLoreName();
                }
                DrawUtils.drawText(graphics, (String)displayText, x + (float)(18 * line), y + 16.0f, color);
                this.renderItem(graphics, petItemStack, x + (float)(18 * line) + (float)RenderListener.MC.field_1772.method_1727((String)displayText), y + 10.0f);
            }
        }
        this.renderItem(graphics, this.petSkull, x, y, line);
    }

    private void renderItem(class_332 graphics, class_1799 item, float x, float y) {
        this.renderItem(graphics, item, x, y, 1.0f);
    }

    private void renderItem(class_332 graphics, class_1799 item, float x, float y, float scale) {
        if (item == null || item.method_7960()) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        if (scale != 1.0f) {
            poseStack.scale(scale);
        }
        poseStack.translate(x / scale, y / scale);
        graphics.method_51427(item, 0, 0);
        poseStack.popMatrix();
    }

    public static void renderItemAndOverlay(class_332 graphics, class_1799 item, String name, float x, float y) {
        if (item == null || item.method_7960()) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        graphics.method_51427(item, 0, 0);
        graphics.method_51432(RenderListener.MC.field_1772, item, 0, 0, name);
        poseStack.popMatrix();
    }

    public void drawItemPickupLog(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        Feature feature = Feature.ITEM_PICKUP_LOG;
        float x = feature.getActualX();
        float y = feature.getActualY();
        boolean downwards = feature.getAnchorPoint().isOnTop();
        boolean renderItemStack = feature.isEnabled(FeatureSetting.RENDER_ITEM_ON_LOG);
        int heightSpacer = renderItemStack ? 6 : 1;
        Objects.requireNonNull(RenderListener.MC.field_1772);
        int lineHeight = 9 + heightSpacer;
        int height = lineHeight * DUMMY_PICKUP_LOG.size();
        int width = RenderListener.MC.field_1772.method_1727("+ 1x Forceful Ember Chestplate");
        if (renderItemStack) {
            width += 18;
        }
        x = this.transformX(x, width, scale, false);
        y = this.transformY(y, height, scale);
        if (renderItemStack) {
            x += 9.0f;
            y += (float)(heightSpacer / 2 * DUMMY_PICKUP_LOG.size());
        }
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
        }
        int i = 0;
        Collection<ItemDiff> log = main.getInventoryUtils().getItemPickupLog();
        if (buttonLocation != null) {
            log = DUMMY_PICKUP_LOG;
        }
        for (ItemDiff itemDiff : log) {
            float stringY = downwards ? y + (float)(i * lineHeight) + (float)(heightSpacer / 2) : y + (float)height - (float)(i * lineHeight) - 9.0f - (float)(heightSpacer / 2);
            String countText = String.format("%s %sx", itemDiff.getAmount() > 0 ? "\u00a7a+" : "\u00a7c-", Math.abs(itemDiff.getAmount()));
            DrawUtils.drawText(graphics, countText, x, stringY, -1);
            DrawUtils.drawText(graphics, "\u00a7r" + itemDiff.getDisplayName(), x + (float)RenderListener.MC.field_1772.method_1727(countText) + (float)(renderItemStack ? 20 : 4), stringY, -1);
            if (renderItemStack) {
                this.renderItem(graphics, itemDiff.getItemStack(), x + (float)RenderListener.MC.field_1772.method_1727(countText) + 2.0f, stringY - (float)(heightSpacer / 2) - 1.0f);
            }
            ++i;
        }
    }

    public void drawDeployableStatus(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        DeployableManager.DeployableEntry activeDeployable = DeployableManager.getInstance().getActiveDeployable();
        if (buttonLocation != null && activeDeployable == null) {
            activeDeployable = DeployableManager.DUMMY_DEPLOYABLE_ENTRY;
        }
        if (activeDeployable != null) {
            Deployable deployable = activeDeployable.getDeployable();
            int seconds = activeDeployable.getSeconds();
            EnumUtils.DeployableDisplayStyle displayStyle = (EnumUtils.DeployableDisplayStyle)Feature.DEPLOYABLE_STATUS_DISPLAY.getAsEnum(FeatureSetting.DEPLOYABLE_DISPLAY_STYLE);
            if (displayStyle == EnumUtils.DeployableDisplayStyle.DETAILED) {
                this.drawDetailedDeployableStatus(graphics, scale, buttonLocation, deployable, seconds);
            } else {
                this.drawCompactDeployableStatus(graphics, scale, buttonLocation, deployable, seconds);
            }
        }
    }

    private void drawCompactDeployableStatus(class_332 graphics, float scale, ButtonLocation buttonLocation, Deployable deployable, int seconds) {
        class_1531 armorStand;
        Feature feature = Feature.DEPLOYABLE_STATUS_DISPLAY;
        float x = feature.getActualX();
        float y = feature.getActualY();
        String secondsString = String.format("\u00a7e%ss", seconds);
        int spacing = 1;
        int width = 27 + spacing + RenderListener.MC.field_1772.method_1727(secondsString);
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, 27, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + 27.0f, scale);
        }
        class_1531 entity = null;
        DeployableManager.DeployableEntry activeDeployable = DeployableManager.getInstance().getActiveDeployable();
        if (activeDeployable != null) {
            UUID uuidOfActiveDep = activeDeployable.getUuid();
            if (uuidOfActiveDep != null) {
                entity = Utils.getEntityFromUUID(uuidOfActiveDep);
            }
        } else if (buttonLocation != null) {
            entity = DeployableManager.DUMMY_ARMOR_STAND;
        }
        if (entity instanceof class_1531 && !this.isUnarmored((class_1309)(armorStand = entity))) {
            this.drawDeployableArmorStand(graphics, armorStand, x, y, scale);
        } else {
            graphics.method_25290(class_10799.field_56883, deployable.getResourceLocation(), (int)x, (int)y, 0.0f, 0.0f, 27, 27, 27, 27);
        }
        DrawUtils.drawText(graphics, secondsString, x + (float)spacing + 27.0f, y + 13.5f - 4.0f, ColorCode.WHITE.getColor());
    }

    private void drawDetailedDeployableStatus(class_332 graphics, float scale, ButtonLocation buttonLocation, Deployable deployable, int seconds) {
        class_1531 armorStand;
        int trophyFishChance;
        int bonusAttackSpeed;
        int ferocity;
        int trueDefense;
        double mending;
        double vitality;
        int strength;
        Feature feature = Feature.DEPLOYABLE_STATUS_DISPLAY;
        float x = feature.getActualX();
        float y = feature.getActualY();
        LinkedList<Object> display = new LinkedList<Object>();
        int passIndex = 0;
        if (deployable.getHealthRegen() > 0.0) {
            float maxHealth = PlayerStat.MAX_HEALTH.getValue();
            float healthRegen = (float)((double)maxHealth * deployable.getHealthRegen());
            if (main.getUtils().getSlayerQuest() == EnumUtils.SlayerQuest.TARANTULA_BROODFATHER && main.getUtils().getSlayerQuestLevel() >= 2) {
                healthRegen *= 0.5f;
            }
            display.add(String.format("\u00a7c+%s \u2764/s", TextUtils.formatNumber(Float.valueOf(healthRegen))));
            ++passIndex;
        }
        if (deployable.getManaRegen() > 0.0) {
            float maxMana = PlayerStat.MAX_MANA.getValue();
            float manaRegen = (float)((double)maxMana * deployable.getManaRegen() / 50.0);
            display.add(String.format("\u00a7b+%s \u270e/s", TextUtils.formatNumber(Float.valueOf(manaRegen))));
            ++passIndex;
        }
        if ((strength = deployable.getStrength()) > 0) {
            display.add("\u00a7c+" + strength + " \u2741 ");
        }
        if ((vitality = deployable.getVitality()) > 0.0) {
            display.add("\u00a74+" + TextUtils.formatNumber(vitality) + " \u2668 ");
        }
        if ((mending = deployable.getMending()) > 0.0) {
            display.add("\u00a7a+" + TextUtils.formatNumber(mending) + " \u2604 ");
        }
        if ((trueDefense = deployable.getTrueDefense()) > 0) {
            display.add("\u00a7f+" + trueDefense + " \u2742 ");
        }
        if ((ferocity = deployable.getFerocity()) > 0) {
            display.add("\u00a7c+" + ferocity + " \u2afd ");
        }
        if ((bonusAttackSpeed = deployable.getBonusAttackSpeed()) > 0) {
            display.add("\u00a7e+" + bonusAttackSpeed + "% \u2694 ");
        }
        if ((trophyFishChance = deployable.getTrophyFishChance()) > 0) {
            display.add("\u00a76+" + trophyFishChance + " \u2654 ");
        }
        if (feature.isEnabled(FeatureSetting.EXPAND_DEPLOYABLE_STATUS) && display.size() > 3) {
            int i;
            LinkedList displayCopy = new LinkedList(display);
            display.clear();
            for (i = 0; i < passIndex; ++i) {
                display.add((String)displayCopy.get(i));
            }
            for (i = passIndex; i < displayCopy.size() - 1; i += 2) {
                if (i - 1 >= displayCopy.size()) continue;
                display.add((String)displayCopy.get(i) + (String)displayCopy.get(i + 1));
            }
            if ((displayCopy.size() - passIndex) % 2 != 0) {
                display.add((String)displayCopy.getLast());
            }
        }
        Optional<String> longestLine = display.stream().max(Comparator.comparingInt(String::length));
        int spacingBetweenLines = 1;
        Objects.requireNonNull(RenderListener.MC.field_1772);
        int iconAndSecondsHeight = 27 + 9;
        Objects.requireNonNull(RenderListener.MC.field_1772);
        int effectsHeight = (9 + spacingBetweenLines) * display.size();
        int width = 29 + longestLine.map(arg_0 -> ((class_327)RenderListener.MC.field_1772).method_1727(arg_0)).orElseGet(() -> display.isEmpty() ? 0 : RenderListener.MC.field_1772.method_1727((String)display.getFirst()));
        int height = Math.max(effectsHeight, iconAndSecondsHeight);
        x = this.transformX(x, width, scale, feature.isEnabled(FeatureSetting.X_ALLIGNMENT));
        y = this.transformY(y, height, scale);
        float startY = Math.round(y + (float)iconAndSecondsHeight / 2.0f - (float)effectsHeight / 2.0f);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y - (float)spacingBetweenLines, y + (float)height, scale);
        }
        if (effectsHeight > iconAndSecondsHeight) {
            int add = Math.abs(effectsHeight - iconAndSecondsHeight) / 2;
            y += (float)add;
            startY += (float)add;
        }
        class_1531 entity = null;
        DeployableManager.DeployableEntry activeDeployable = DeployableManager.getInstance().getActiveDeployable();
        if (activeDeployable != null) {
            UUID uuidOfActiveDep = activeDeployable.getUuid();
            if (uuidOfActiveDep != null) {
                entity = Utils.getEntityFromUUID(uuidOfActiveDep);
            }
        } else if (buttonLocation != null) {
            entity = DeployableManager.DUMMY_ARMOR_STAND;
        }
        if (entity instanceof class_1531 && !this.isUnarmored((class_1309)(armorStand = entity))) {
            this.drawDeployableArmorStand(graphics, armorStand, x, y, scale);
        } else {
            graphics.method_25290(class_10799.field_56883, deployable.getResourceLocation(), (int)x, (int)y, 0.0f, 0.0f, 27, 27, 27, 27);
        }
        String secondsString = String.format("\u00a7e%ss", seconds);
        DrawUtils.drawText(graphics, secondsString, Math.round(x + 13.5f - (float)RenderListener.MC.field_1772.method_1727(secondsString) / 2.0f), y + 27.0f, ColorCode.WHITE.getColor());
        float displayTextX = x + 27.0f + 2.0f;
        for (int i = 0; i < display.size(); ++i) {
            String string = (String)display.get(i);
            Objects.requireNonNull(RenderListener.MC.field_1772);
            DrawUtils.drawText(graphics, string, displayTextX, startY + (float)(i * (9 + spacingBetweenLines)), ColorCode.WHITE.getColor());
        }
    }

    private boolean isUnarmored(class_1309 livingEntity) {
        for (class_1304 slot : class_1304.values()) {
            class_1799 slotItem;
            if (!slot.method_46643() || (slotItem = livingEntity.method_6118(slot)) == class_1799.field_8037) continue;
            return false;
        }
        return true;
    }

    public void setGui() {
        if (this.guiToOpen == EnumUtils.GUIType.MAIN) {
            MC.method_1507((class_437)new SkyblockAddonsGui(this.guiPageToOpen, this.guiTabToOpen));
        } else if (this.guiToOpen == EnumUtils.GUIType.EDIT_LOCATIONS) {
            MC.method_1507((class_437)new LocationEditGui(this.guiPageToOpen, this.guiTabToOpen));
        } else if (this.guiToOpen == EnumUtils.GUIType.SETTINGS) {
            if (this.guiFeatureToOpen == Feature.ENCHANTMENT_LORE_PARSING) {
                MC.method_1507((class_437)new EnchantmentSettingsGui(1, this.guiPageToOpen, this.guiTabToOpen));
            } else {
                MC.method_1507((class_437)new SettingsGui(this.guiFeatureToOpen, 1, this.guiPageToOpen, this.guiTabToOpen, null));
            }
        } else if (this.guiToOpen == EnumUtils.GUIType.WARP) {
            MC.method_1507((class_437)new IslandWarpGui());
        }
        this.guiToOpen = null;
    }

    public void setGuiToOpen(EnumUtils.GUIType guiToOpen, int page, EnumUtils.GuiTab tab) {
        this.guiToOpen = guiToOpen;
        this.guiPageToOpen = page;
        this.guiTabToOpen = tab;
    }

    public void setGuiToOpen(EnumUtils.GUIType guiToOpen, int page, EnumUtils.GuiTab tab, Feature feature) {
        this.setGuiToOpen(guiToOpen, page, tab);
        this.guiFeatureToOpen = feature;
    }

    public float transformX(float x, int width, float scale, boolean xAllignment) {
        double minecraftScale = MC.method_22683().method_4495();
        if (!xAllignment) {
            x -= (float)width / 2.0f * scale;
        }
        x = (float)((double)Math.round((double)x * minecraftScale) / minecraftScale);
        return x / scale;
    }

    public float transformY(float y, int height, float scale) {
        double minecraftScale = MC.method_22683().method_4495();
        y -= (float)height / 2.0f * scale;
        y = (float)((double)Math.round((double)y * minecraftScale) / minecraftScale);
        return y / scale;
    }

    public void onRenderWorld(class_4597.class_4598 source, class_4587 poseStack) {
        HealingCircleManager.renderHealingCircleOverlays(source, poseStack);
    }

    private void drawDeployableArmorStand(class_332 graphics, class_1531 deployableArmorStand, float x, float y, float scale) {
        float yaw;
        Vector3f translation = new Vector3f(0.0f, 1.5f + 0.0625f * deployableArmorStand.method_55693(), 0.0f);
        Quaternionf rotation = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf rotation4 = class_7833.field_40714.rotationDegrees(-22.0f);
        rotation.mul((Quaternionfc)rotation4);
        float prevRenderYawOffset = deployableArmorStand.field_6283;
        float prevPrevRenderYawOffset = deployableArmorStand.field_6220;
        deployableArmorStand.field_6283 = yaw = (float)(System.currentTimeMillis() % 1750L) / 1750.0f * 360.0f;
        deployableArmorStand.field_6220 = yaw;
        float scaledWH = 27.0f * scale;
        class_490.method_48472((class_332)graphics, (int)Math.round(x *= scale), (int)Math.round(y *= scale), (int)Math.round(x + scaledWH), (int)Math.round(y + scaledWH), (float)(25.0f / deployableArmorStand.method_55693() * scale), (Vector3f)translation, (Quaternionf)rotation, null, (class_1309)deployableArmorStand);
        deployableArmorStand.field_6283 = prevRenderYawOffset;
        deployableArmorStand.field_6220 = prevPrevRenderYawOffset;
    }

    private void drawEntity(class_332 graphics, class_1309 entity, float x, float y, float width, float height, float yaw, float scale) {
        this.drawEntity(graphics, entity, x, y, width, height, yaw, scale, 1.0f);
    }

    private void drawEntity(class_332 graphics, class_1309 entity, float x, float y, float width, float height, float yaw, float scale, float entityScale) {
        Vector3f translation = new Vector3f(0.0f, entity.method_17682() / 2.0f + 0.0625f * entity.method_55693(), 0.0f);
        Quaternionf overrideCameraAngel = class_7833.field_40715.rotationDegrees(-180.0f);
        Quaternionf rotation = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf rotation2 = class_7833.field_40716.rotationDegrees(180.0f);
        Quaternionf rotation3 = class_7833.field_40714.rotationDegrees(15.0f);
        rotation.mul((Quaternionfc)rotation2);
        rotation.mul((Quaternionfc)rotation3);
        float oYRot = entity.method_36454();
        float oBodyRot = entity.field_6283;
        float oyHeadRotO = entity.field_6259;
        float oyHeadRot = entity.field_6241;
        entity.method_36456(yaw);
        entity.field_6283 = yaw;
        entity.field_6241 = yaw;
        entity.field_6259 = yaw;
        class_490.method_48472((class_332)graphics, (int)Math.round(x *= scale), (int)Math.round(y *= scale), (int)Math.round(x + (width *= scale)), (int)Math.round(y + (height *= scale)), (float)(25.0f / entity.method_55693() * entityScale * scale), (Vector3f)translation, (Quaternionf)rotation, (Quaternionf)overrideCameraAngel, (class_1309)entity);
        entity.method_36456(oYRot);
        entity.field_6283 = oBodyRot;
        entity.field_6241 = oyHeadRotO;
        entity.field_6259 = oyHeadRot;
    }

    public void setTitleFeature(Feature feature) {
        this.titleFeature = feature;
        if (feature != null) {
            if (this.titleResetTask != null) {
                this.titleResetTask.cancel();
            }
            this.titleResetTask = main.getScheduler().scheduleTask(scheduledTask -> main.getRenderListener().setTitleFeature(null), Feature.WARNING_TIME.numberValue().intValue() * 20, 0, true, false);
        }
    }

    public void setSubtitleFeature(Feature feature) {
        this.subtitleFeature = feature;
        if (feature != null) {
            if (this.subtitleResetTask != null) {
                this.subtitleResetTask.cancel();
            }
            this.subtitleResetTask = main.getScheduler().scheduleTask(scheduledTask -> main.getRenderListener().setSubtitleFeature(null), Feature.WARNING_TIME.numberValue().intValue() * 20, 0, true, false);
        }
    }

    public static class_11231 textureSetup(class_2960 location) {
        GpuTextureView gpuTextureView = MC.method_1531().method_4619(location).method_71659();
        return class_11231.method_70900((GpuTextureView)gpuTextureView);
    }

    @Generated
    public boolean isPredictHealth() {
        return this.predictHealth;
    }

    @Generated
    public void setPredictHealth(boolean predictHealth) {
        this.predictHealth = predictHealth;
    }

    @Generated
    public boolean isPredictMana() {
        return this.predictMana;
    }

    @Generated
    public void setPredictMana(boolean predictMana) {
        this.predictMana = predictMana;
    }

    @Generated
    public void setUpdateMessageDisplayed(boolean updateMessageDisplayed) {
        this.updateMessageDisplayed = updateMessageDisplayed;
    }

    @Generated
    public Feature getTitleFeature() {
        return this.titleFeature;
    }

    @Generated
    public ScheduledTask getSubtitleResetTask() {
        return this.subtitleResetTask;
    }

    @Generated
    public ScheduledTask getTitleResetTask() {
        return this.titleResetTask;
    }

    @Generated
    public void setArrowsLeft(int arrowsLeft) {
        this.arrowsLeft = arrowsLeft;
    }

    @Generated
    public void setArrowsType(String arrowsType) {
        this.arrowsType = arrowsType;
    }

    @Generated
    public void setCannotReachMobName(String cannotReachMobName) {
        this.cannotReachMobName = cannotReachMobName;
    }

    @Generated
    public void setSkillFadeOutTime(long skillFadeOutTime) {
        this.skillFadeOutTime = skillFadeOutTime;
    }

    @Generated
    public void setSkill(SkillType skill) {
        this.skill = skill;
    }

    @Generated
    public void setSkillText(String skillText) {
        this.skillText = skillText;
    }

    @Generated
    public void setGuiToOpen(EnumUtils.GUIType guiToOpen) {
        this.guiToOpen = guiToOpen;
    }

    @Generated
    public void setMaxRiftHealth(float maxRiftHealth) {
        this.maxRiftHealth = maxRiftHealth;
    }

    private static enum DamageDisplayItem {
        HYPERION(ItemUtils.createItemStack(class_1802.field_8371, "\u00a76Hyperion", "HYPERION", false)),
        VALKYRIE(ItemUtils.createItemStack(class_1802.field_8371, "\u00a76Valkyrie", "VALKYRIE", false)),
        ASTRAEA(ItemUtils.createItemStack(class_1802.field_8371, "\u00a76Astraea", "ASTRAEA", false)),
        SCYLLA(ItemUtils.createItemStack(class_1802.field_8371, "\u00a76Scylla", "SCYLLA", false)),
        BAT_WAND(new class_1799((class_1935)class_2246.field_10226, 1)),
        STARRED_BAT_WAND(new class_1799((class_1935)class_2246.field_10226, 1)),
        MIDAS_STAFF(ItemUtils.createItemStack(class_1802.field_8322, "\u00a76Midas Staff", "MIDAS_STAFF", false));

        private final class_1799 itemStack;

        private DamageDisplayItem(class_1799 itemStack) {
            this.itemStack = itemStack;
        }

        public static class_1799 getByID(String id) {
            for (DamageDisplayItem displayItem : DamageDisplayItem.values()) {
                if (!displayItem.name().equals(id)) continue;
                return displayItem.itemStack;
            }
            return null;
        }
    }
}

