/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.CrimsonArmorAbilityStack;
import com.fix3dll.skyblockaddons.core.PlayerStat;
import com.fix3dll.skyblockaddons.core.SkillType;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.SkillXpManager;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class ActionBarParser {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final Pattern COLLECTIONS_CHAT_PATTERN = Pattern.compile("\\+(?<gained>[0-9,.]+) (?<skillName>[A-Za-z]+) (?<progress>\\((((?<current>[0-9.,kM]+)/(?<total>[0-9.,kM]+))|((?<percent>[0-9.,]+)%))\\))");
    private static final Pattern SKILL_GAIN_PATTERN_S = Pattern.compile("\\+(?<gained>[0-9,.]+) (?<skillName>[A-Za-z]+) (?<progress>\\((((?<current>[0-9.,]+)/(?<total>[0-9.,]+))|((?<percent>[0-9.,]+)%))\\))");
    private static final Pattern MANA_PATTERN_S = Pattern.compile("(?<num>[0-9,.]+)/(?<den>[0-9,.]+)\u270e(| Mana| (?<overflow>-?[0-9,.]+)\u02ac)");
    private static final Pattern DEFENSE_PATTERN_S = Pattern.compile("(?<defense>[0-9,.]+)\u2748 Defense(?<other>( (?<align>\\|\\|\\|))?( {2}(?<tether>T[0-9,.]+!?))?.*)?");
    private static final Pattern HEALTH_PATTERN_S = Pattern.compile("(?<health>[0-9,.]+)/(?<maxHealth>[0-9,.]+)\u2764(?<wand>\\+(?<wandHeal>[0-9,.]+)[\u2586\u2585\u2584\u2583\u2582\u2581])?(?: {2}(?<tether>T[0-9,.]+!?))?");
    private int tickers = -1;
    private int maxTickers = 0;
    private float lastSecondHealth = -1.0f;
    private Float healthUpdate;
    private long lastHealthUpdate;
    private float currentSkillXP;
    private int totalSkillXP;
    private float percent;
    private boolean healthLock;
    private String otherDefense;
    private String lastParsedSkillSection = "";
    private String lastSkillProgressString;
    private SkillType lastSkillType;
    private boolean useLastRememberedPressure;
    private final LinkedList<String> stringsToRemove = new LinkedList();

    public String parseActionBar(String actionBar) {
        String[] splitMessage = actionBar.split(" {3,}");
        LinkedList<String> unusedSections = new LinkedList<String>();
        this.stringsToRemove.clear();
        main.getRenderListener().setPredictMana(true);
        main.getRenderListener().setPredictHealth(true);
        this.tickers = -1;
        if (actionBar.contains("\u2764") && !actionBar.contains("\u2748") && splitMessage.length == 2) {
            PlayerStat.DEFENCE.setValue(0.0f);
        }
        if (!actionBar.contains("\u274d")) {
            if (class_310.method_1551().field_1724.method_5869()) {
                this.useLastRememberedPressure = true;
            } else {
                PlayerStat.PRESSURE.setValue(-1.0f);
                this.useLastRememberedPressure = false;
            }
        } else {
            this.useLastRememberedPressure = false;
        }
        for (String section : splitMessage) {
            try {
                String sectionReturn = this.parseSection(section);
                if (sectionReturn != null) {
                    unusedSections.add(sectionReturn);
                    continue;
                }
                this.stringsToRemove.add(section);
            }
            catch (Exception ex) {
                unusedSections.add(section);
            }
        }
        return String.join((CharSequence)StringUtils.repeat((String)" ", (int)5), unusedSections);
    }

    private String parseSection(String section) {
        String stripColoring = TextUtils.stripColor(section);
        try {
            String convertMag = TextUtils.convertMagnitudes(stripColoring);
            if (section.contains("\u02ac")) {
                convertMag = convertMag.split(" ")[0];
            }
            String numbersOnly = TextUtils.getNumbersOnly(convertMag).trim();
            String[] splitStats = numbersOnly.split("/");
            if (section.contains("\u2764")) {
                if ((section = this.parseCrimsonArmorAbilityStack(section)).endsWith("\u0ca0") && section.contains("Glare Damage")) {
                    section = section.split(Pattern.quote("\u00a76 "))[0];
                }
                return this.parseHealth(section);
            }
            if (section.contains("\u274d")) {
                return this.parsePressure(section);
            }
            if (section.contains("\u2748")) {
                return this.parseDefense(section);
            }
            if (section.endsWith("\u00a7f\u2742 True Defense")) {
                return this.parseTrueDefence(section);
            }
            if (section.contains("\u270e")) {
                if (section.contains("\u24c4") || section.contains("\u24e9")) {
                    String tickerSection;
                    String[] split = ActionBarParser.splitManaAndTicker(section);
                    String manaSection = this.parseMana(split[0]);
                    if (manaSection == null) {
                        this.stringsToRemove.add(split[0]);
                        section = section.replace(split[0], "");
                    }
                    if ((tickerSection = this.parseTickers(split[1])) == null) {
                        this.stringsToRemove.add(split[1]);
                        section = section.replace(split[1], "");
                    }
                    return section.isEmpty() ? null : section;
                }
                return this.parseMana(section);
            }
            if (section.contains("(")) {
                return this.parseSkill(convertMag);
            }
            if (section.contains("\u24c4") || section.contains("\u24e9")) {
                return this.parseTickers(section);
            }
            if (section.contains("Drill")) {
                return this.parseDrill(section, splitStats);
            }
        }
        catch (ParseException e) {
            LOGGER.error("The section \"{}\" will be skipped due to an error during number parsing.", (Object)section);
            LOGGER.error("Failed to parse number at offset " + e.getErrorOffset() + " in string \"" + e.getMessage() + "\".", (Throwable)e);
            return section;
        }
        return section;
    }

    private String parseTrueDefence(String section) {
        return Feature.HIDE_TRUE_DEFENSE.isEnabled() ? null : section;
    }

    private String parseCrimsonArmorAbilityStack(String section) {
        for (CrimsonArmorAbilityStack crimsonArmorAbilityStack : CrimsonArmorAbilityStack.values()) {
            crimsonArmorAbilityStack.setCurrentValue(0);
        }
        int runs = 0;
        block1: while (section.contains("  ") && ++runs != 5) {
            if (section.endsWith("\u00a7r")) {
                section = section.substring(0, section.length() - 2);
            }
            for (CrimsonArmorAbilityStack crimsonArmorAbilityStack : CrimsonArmorAbilityStack.values()) {
                String stackSymbol = crimsonArmorAbilityStack.getSymbol();
                if (!section.endsWith(stackSymbol)) continue;
                String[] split = section.split("\u00a76");
                String stack = split[split.length - 1];
                String remove = "\u00a76" + stack;
                if (stack.contains("\u00a7l")) {
                    stack = stack.substring(2);
                    if (Feature.CRIMSON_ARMOR_ABILITY_STACKS.isEnabled()) {
                        String realRemove = remove + "\u00a7r";
                        this.stringsToRemove.add(realRemove);
                    }
                } else if (Feature.CRIMSON_ARMOR_ABILITY_STACKS.isEnabled()) {
                    this.stringsToRemove.add(remove);
                }
                stack = stack.substring(0, stack.length() - 1);
                section = section.substring(0, section.length() - remove.length());
                section = section.trim();
                crimsonArmorAbilityStack.setCurrentValue(Integer.parseInt(stack));
                continue block1;
            }
        }
        return section;
    }

    private String parseHealth(String healthSection) {
        boolean separateDisplay = Feature.HEALTH_BAR.isEnabled() || Feature.HEALTH_TEXT.isEnabled();
        String returnString = healthSection;
        String stripped = TextUtils.stripColor(healthSection);
        Matcher m = HEALTH_PATTERN_S.matcher(stripped);
        if ((Feature.EFFECTIVE_HEALTH_TEXT.isEnabled() || separateDisplay) && m.matches()) {
            boolean postSetLock;
            float newHealth = this.parseFloat(m.group("health"));
            float maxHealth = this.parseFloat(m.group("maxHealth"));
            if (separateDisplay) {
                if (m.group("wand") != null) {
                    returnString = "";
                    this.stringsToRemove.add(stripped.substring(0, m.start("wand")));
                } else {
                    this.stringsToRemove.add(healthSection);
                    returnString = "";
                }
            }
            this.healthLock = false;
            boolean bl = postSetLock = PlayerStat.MAX_HEALTH.getValue() != maxHealth || (double)(Math.abs(PlayerStat.HEALTH.getValue() - newHealth) / maxHealth) > 0.05;
            if (!this.healthLock) {
                PlayerStat.HEALTH.setValue(newHealth);
            }
            PlayerStat.MAX_HEALTH.setValue(maxHealth);
            this.healthLock = postSetLock;
            String mastiffTether = m.group("tether");
            if (!StringUtils.isEmpty((CharSequence)mastiffTether)) {
                this.otherDefense = TextUtils.getFormattedString(healthSection, mastiffTether);
            }
        }
        return returnString;
    }

    private String parseMana(String manaSection) {
        Matcher m = MANA_PATTERN_S.matcher(TextUtils.stripColor(manaSection).trim());
        if (m.matches()) {
            PlayerStat.MANA.setValue(this.parseFloat(m.group("num")));
            PlayerStat.MAX_MANA.setValue(this.parseFloat(m.group("den")));
            float overflowMana = 0.0f;
            if (m.group("overflow") != null) {
                overflowMana = this.parseFloat(m.group("overflow"));
            }
            PlayerStat.OVERFLOW_MANA.setValue(overflowMana);
            main.getRenderListener().setPredictMana(false);
            if (Feature.MANA_BAR.isEnabled() || Feature.MANA_TEXT.isEnabled()) {
                return null;
            }
        }
        return manaSection;
    }

    private String parsePressure(String pressureSection) {
        int left = pressureSection.indexOf(10061);
        int right = pressureSection.indexOf(37, left);
        if (left == -1 || right == -1 || right <= left + 1) {
            LOGGER.warn("Invalid pressure section: {}", (Object)pressureSection);
        }
        try {
            PlayerStat.PRESSURE.setValue(this.parseFloat(pressureSection.substring(left + 1, right)));
        }
        catch (IndexOutOfBoundsException ex) {
            LOGGER.error("Invalid pressure section: {}", (Object)pressureSection, (Object)ex);
        }
        if (Feature.PRESSURE_BAR.isEnabled() || Feature.PRESSURE_TEXT.isEnabled()) {
            return null;
        }
        return pressureSection;
    }

    private String parseDefense(String defenseSection) {
        String stripped = TextUtils.stripColor(defenseSection);
        Matcher m = DEFENSE_PATTERN_S.matcher(stripped);
        if (m.matches()) {
            float defense = this.parseFloat(m.group("defense"));
            PlayerStat.DEFENCE.setValue(defense);
            this.otherDefense = TextUtils.getFormattedString(defenseSection, m.group("other").trim());
            if (Feature.DEFENCE_TEXT.isEnabled() || Feature.DEFENCE_PERCENTAGE.isEnabled()) {
                return null;
            }
        }
        return defenseSection;
    }

    private String parseSkill(String skillSection) throws ParseException {
        if (Feature.SKILL_DISPLAY.isEnabled() || Feature.SKILL_PROGRESS_BAR.isEnabled()) {
            Matcher matcher = SKILL_GAIN_PATTERN_S.matcher(TextUtils.stripColor(skillSection));
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            StringBuilder skillTextBuilder = new StringBuilder();
            SkillType skillType = null;
            nf.setMaximumFractionDigits(2);
            if (this.lastParsedSkillSection.equals(skillSection)) {
                skillTextBuilder.append(this.lastSkillProgressString);
                skillType = this.lastSkillType;
            } else if (matcher.matches()) {
                if (Feature.SKILL_DISPLAY.isEnabled(FeatureSetting.SHOW_SKILL_XP_GAINED)) {
                    skillTextBuilder.append("+").append(matcher.group("gained"));
                }
                skillType = SkillType.getFromString(matcher.group("skillName"));
                boolean skillPercent = matcher.group("percent") != null;
                boolean parseCurrAndTotal = true;
                if (skillPercent) {
                    this.percent = nf.parse(matcher.group("percent")).floatValue();
                    int skillLevel = SkillXpManager.getSkillLevel(skillType);
                    if (skillLevel != -1) {
                        this.totalSkillXP = SkillXpManager.getSkillXpForNextLevel(skillType, skillLevel);
                        this.currentSkillXP = (float)this.totalSkillXP * this.percent / 100.0f;
                    } else {
                        parseCurrAndTotal = false;
                    }
                } else {
                    this.currentSkillXP = nf.parse(matcher.group("current")).floatValue();
                    this.totalSkillXP = nf.parse(matcher.group("total")).intValue();
                    this.percent = this.totalSkillXP == 0 ? 100.0f : 100.0f * this.currentSkillXP / (float)this.totalSkillXP;
                }
                this.percent = Math.min(100.0f, this.percent);
                if (!parseCurrAndTotal || Feature.SKILL_DISPLAY.isEnabled(FeatureSetting.SHOW_SKILL_PERCENTAGE_INSTEAD_OF_XP)) {
                    skillTextBuilder.append(" (").append(String.format("%.2f", Float.valueOf(this.percent))).append("%)");
                } else {
                    skillTextBuilder.append(" (").append(nf.format(this.currentSkillXP));
                    if (this.totalSkillXP != 0) {
                        skillTextBuilder.append("/");
                        if (Feature.SKILL_DISPLAY.isEnabled(FeatureSetting.ABBREVIATE_SKILL_XP_DENOMINATOR)) {
                            skillTextBuilder.append(TextUtils.abbreviate(this.totalSkillXP));
                        } else {
                            skillTextBuilder.append(nf.format(this.totalSkillXP));
                        }
                    }
                    skillTextBuilder.append(")");
                }
                if (parseCurrAndTotal && Feature.SKILL_DISPLAY.isEnabled(FeatureSetting.SKILL_ACTIONS_LEFT_UNTIL_NEXT_LEVEL)) {
                    float gained = nf.parse(matcher.group("gained")).floatValue();
                    if (this.percent != 100.0f) {
                        skillTextBuilder.append(" - ");
                        if (gained != 0.0f) {
                            skillTextBuilder.append(Translations.getMessage("messages.actionsLeft", TextUtils.formatNumber((int)Math.ceil(((float)this.totalSkillXP - this.currentSkillXP) / gained))));
                        } else {
                            skillTextBuilder.append(Translations.getMessage("messages.actionsLeft", "\u221e"));
                        }
                    }
                }
                this.lastParsedSkillSection = skillSection;
                this.lastSkillProgressString = skillTextBuilder.toString();
                this.lastSkillType = skillType;
            }
            if (!skillTextBuilder.isEmpty()) {
                main.getRenderListener().setSkillText(skillTextBuilder.toString());
                main.getRenderListener().setSkill(skillType);
                main.getRenderListener().setSkillFadeOutTime(System.currentTimeMillis() + 4000L);
                if (Feature.SKILL_DISPLAY.isEnabled()) {
                    return null;
                }
            }
        }
        return skillSection;
    }

    private String parseTickers(String tickerSection) {
        this.tickers = 0;
        this.maxTickers = 0;
        boolean hitUnusables = false;
        for (char character : tickerSection.toCharArray()) {
            if (!(hitUnusables || character != '7' && character != '2' && character != '6')) {
                hitUnusables = true;
                continue;
            }
            if (character != '\u24c4' && character != '\u24e9') continue;
            if (!hitUnusables) {
                ++this.tickers;
            }
            ++this.maxTickers;
        }
        if (Feature.TICKER_CHARGES_DISPLAY.isEnabled()) {
            return null;
        }
        return tickerSection;
    }

    private String parseDrill(String drillSection, String[] splitStats) {
        int fuel = Math.max(0, Integer.parseInt(splitStats[0]));
        int maxFuel = Math.max(1, Integer.parseInt(splitStats[1]));
        PlayerStat.FUEL.setValue(fuel);
        PlayerStat.MAX_FUEL.setValue(maxFuel);
        if (Feature.DRILL_FUEL_BAR.isEnabled() || Feature.DRILL_FUEL_TEXT.isEnabled()) {
            return null;
        }
        return drillSection;
    }

    private float parseFloat(String string) {
        try {
            return TextUtils.NUMBER_FORMAT.parse(string).floatValue();
        }
        catch (ParseException e) {
            return -1.0f;
        }
    }

    public static String[] splitManaAndTicker(String inputString) {
        String searchWord = "Mana";
        int manaStartIndex = inputString.indexOf("Mana");
        if (manaStartIndex == -1) {
            return new String[]{inputString, ""};
        }
        int manaEndIndex = manaStartIndex + "Mana".length();
        String partBeforeAndMana = inputString.substring(0, manaEndIndex);
        String partAfter = inputString.substring(manaEndIndex);
        return new String[]{partBeforeAndMana, partAfter};
    }

    @Generated
    public int getTickers() {
        return this.tickers;
    }

    @Generated
    public int getMaxTickers() {
        return this.maxTickers;
    }

    @Generated
    public float getLastSecondHealth() {
        return this.lastSecondHealth;
    }

    @Generated
    public Float getHealthUpdate() {
        return this.healthUpdate;
    }

    @Generated
    public long getLastHealthUpdate() {
        return this.lastHealthUpdate;
    }

    @Generated
    public float getCurrentSkillXP() {
        return this.currentSkillXP;
    }

    @Generated
    public int getTotalSkillXP() {
        return this.totalSkillXP;
    }

    @Generated
    public float getPercent() {
        return this.percent;
    }

    @Generated
    public boolean isHealthLock() {
        return this.healthLock;
    }

    @Generated
    public String getOtherDefense() {
        return this.otherDefense;
    }

    @Generated
    public String getLastParsedSkillSection() {
        return this.lastParsedSkillSection;
    }

    @Generated
    public String getLastSkillProgressString() {
        return this.lastSkillProgressString;
    }

    @Generated
    public SkillType getLastSkillType() {
        return this.lastSkillType;
    }

    @Generated
    public boolean isUseLastRememberedPressure() {
        return this.useLastRememberedPressure;
    }

    @Generated
    public LinkedList<String> getStringsToRemove() {
        return this.stringsToRemove;
    }

    @Generated
    public void setLastSecondHealth(float lastSecondHealth) {
        this.lastSecondHealth = lastSecondHealth;
    }

    @Generated
    public void setHealthUpdate(Float healthUpdate) {
        this.healthUpdate = healthUpdate;
    }

    @Generated
    public void setLastHealthUpdate(long lastHealthUpdate) {
        this.lastHealthUpdate = lastHealthUpdate;
    }
}

