/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.utils.SkyblockColor;
import java.nio.FloatBuffer;
import net.minecraft.class_9848;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class ColorUtils {
    private static final SkyblockColor SKYBLOCK_COLOR = new SkyblockColor();

    public static boolean areAllFeaturesChroma() {
        for (Feature loopFeature : Feature.values()) {
            if (!loopFeature.isGuiFeature() || loopFeature.getFeatureGuiData().getDefaultColor() == null || loopFeature.isChroma()) continue;
            return false;
        }
        return true;
    }

    public static int getDefaultBlue(int alpha) {
        return class_9848.method_61324((int)alpha, (int)160, (int)225, (int)229);
    }

    public static int setColorAlpha(int color, float alpha) {
        return class_9848.method_61330((int)ColorUtils.getAlphaIntFromFloat(alpha), (int)color);
    }

    public static float getAlpha() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            buffer.clear();
            GL11.glGetFloatv((int)2816, (FloatBuffer)buffer);
            if (buffer.limit() < 4) {
                float f = 1.0f;
                return f;
            }
            float f = buffer.get(3);
            return f;
        }
    }

    public static int getAlphaIntFromFloat(float alpha) {
        return (int)(alpha * 255.0f);
    }

    public static float[] getNormalizedRGBA(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
    }

    public static SkyblockColor getDummySkyblockColor(int color) {
        return ColorUtils.getDummySkyblockColor(SkyblockColor.ColorAnimation.NONE, color);
    }

    public static SkyblockColor getDummySkyblockColor(int r, int g, int b, int a) {
        return ColorUtils.getDummySkyblockColor(SkyblockColor.ColorAnimation.NONE, class_9848.method_61324((int)a, (int)r, (int)g, (int)b));
    }

    public static SkyblockColor getDummySkyblockColor(int r, int g, int b, float a) {
        return ColorUtils.getDummySkyblockColor(r, g, b, ColorUtils.getAlphaIntFromFloat(a));
    }

    public static SkyblockColor getDummySkyblockColor(SkyblockColor.ColorAnimation colorAnimation) {
        return ColorUtils.getDummySkyblockColor(colorAnimation, -1);
    }

    public static SkyblockColor getDummySkyblockColor(int color, boolean chroma) {
        return ColorUtils.getDummySkyblockColor(chroma ? SkyblockColor.ColorAnimation.CHROMA : SkyblockColor.ColorAnimation.NONE, color);
    }

    public static SkyblockColor getDummySkyblockColor(SkyblockColor.ColorAnimation colorAnimation, int color) {
        return SKYBLOCK_COLOR.setColorAnimation(colorAnimation).setColor(color);
    }
}

