/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.ItemDiff;
import com.fix3dll.skyblockaddons.core.SlayerArmorProgress;
import com.fix3dll.skyblockaddons.core.ThunderBottle;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonTracker;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1304;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1707;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3858;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class InventoryUtils {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    public static final HashSet<String> BAT_PERSON_SET_IDS = new HashSet<String>(Arrays.asList("BAT_PERSON_BOOTS", "BAT_PERSON_LEGGINGS", "BAT_PERSON_CHESTPLATE", "BAT_PERSON_HELMET"));
    private static final Pattern SLAYER_ARMOR_STACK_PATTERN = Pattern.compile("Next Upgrade: \\+([0-9]+\u2748) \\(([0-9,]+)/([0-9,]+)\\)");
    private List<class_1799> previousInventory;
    private final Multimap<String, ItemDiff> itemPickupLog = ArrayListMultimap.create();
    private boolean inventoryWarningShown;
    private boolean wearingSkeletonHelmet;
    private boolean usingToxicArrowPoison;
    private boolean usingTwilightArrowPoison;
    private final SlayerArmorProgress[] slayerArmorProgresses = new SlayerArmorProgress[4];
    private InventoryType inventoryType;
    String inventoryKey;
    private int inventoryPageNum;
    private String inventorySubtype;
    private String inventoryMayorName;
    private ScheduledTask repeatWarningTask = null;
    private boolean inQuiverMode = false;

    private List<class_1799> copyInventory(class_2371<class_1799> inventory) {
        ArrayList<class_1799> copy = new ArrayList<class_1799>(inventory.size());
        for (class_1799 item : inventory) {
            copy.add(item.method_7972());
        }
        return copy;
    }

    public void calculateInventoryDifference(class_2371<class_1799> currentInventory) {
        List<class_1799> newInventory = this.copyInventory(currentInventory);
        if (this.previousInventory != null) {
            DiffHashMap previousInventoryMap = new DiffHashMap();
            DiffHashMap newInventoryMap = new DiffHashMap();
            for (int i = 0; i < newInventory.size(); ++i) {
                if (i == 8) continue;
                class_1799 previousItem = null;
                class_1799 newItem = null;
                try {
                    previousItem = this.previousInventory.get(i);
                    newItem = newInventory.get(i);
                    if (previousItem != null) {
                        previousInventoryMap.updateWithItem(previousItem);
                    }
                    if (newItem == null || newItem.method_65130() == null) continue;
                    String legacyDisplayName = TextUtils.getFormattedText(newItem.method_65130());
                    if ((legacyDisplayName = TextUtils.stripResets(legacyDisplayName)).contains(" " + String.valueOf(ColorCode.DARK_GRAY) + "x")) {
                        String newName = legacyDisplayName.substring(0, legacyDisplayName.lastIndexOf(" "));
                        newItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)newName));
                    }
                    newInventoryMap.updateWithItem(newItem);
                    continue;
                }
                catch (RuntimeException exception) {
                    class_128 crashReport = class_128.method_560((Throwable)exception, (String)"Comparing current inventory to previous inventory");
                    class_129 inventoryDetails = crashReport.method_562("Inventory Details");
                    inventoryDetails.method_578("Previous", (Object)("Size: " + this.previousInventory.size()));
                    inventoryDetails.method_578("New", (Object)("Size: " + newInventory.size()));
                    class_129 itemDetails = crashReport.method_562("Item Details");
                    itemDetails.method_578("Previous Item", (Object)("Item: " + (previousItem != null ? previousItem.toString() : "null") + "\nDisplay Name: " + String.valueOf(previousItem != null ? previousItem.method_65130() : "null") + "\nIndex: " + i + "\nMap Value: " + (previousItem != null ? (previousInventoryMap.get(previousItem.method_65130()) != null ? ((Pair)previousInventoryMap.get(previousItem.method_65130())).toString() : "null") : "null")));
                    itemDetails.method_578("New Item", (Object)("Item: " + (newItem != null ? newItem.toString() : "null") + "\nDisplay Name: " + String.valueOf(newItem != null ? newItem.method_65130() : "null") + "\nIndex: " + i + "\nMap Value: " + (newItem != null ? (previousInventoryMap.get(newItem.method_65130()) != null ? ((Pair)previousInventoryMap.get(newItem.method_65130())).toString() : "null") : "null")));
                    throw new class_148(crashReport);
                }
            }
            LinkedList<ItemDiff> inventoryDifference = new LinkedList<ItemDiff>();
            HashSet keySet = new HashSet(previousInventoryMap.keySet());
            keySet.addAll(newInventoryMap.keySet());
            keySet.forEach(key -> {
                int diff;
                int previousAmount = 0;
                if (previousInventoryMap.containsKey(key)) {
                    previousAmount = (Integer)((Pair)previousInventoryMap.get(key)).getLeft();
                }
                int newAmount = 0;
                if (newInventoryMap.containsKey(key)) {
                    newAmount = (Integer)((Pair)newInventoryMap.get(key)).getLeft();
                }
                if ((diff = newAmount - previousAmount) != 0) {
                    inventoryDifference.add(new ItemDiff((String)key, diff, (class_1799)newInventoryMap.getOrDefault(key, (Pair)previousInventoryMap.get(key)).getRight()));
                }
            });
            if (Feature.DRAGON_STATS_TRACKER.isEnabled()) {
                DragonTracker.getInstance().checkInventoryDifferenceForDrops(inventoryDifference);
            }
            if (Feature.ITEM_PICKUP_LOG.isEnabled()) {
                for (ItemDiff diff : inventoryDifference) {
                    Collection itemDiffs = this.itemPickupLog.get((Object)diff.getDisplayName());
                    if (itemDiffs.size() <= 0) {
                        this.itemPickupLog.put((Object)diff.getDisplayName(), (Object)diff);
                        continue;
                    }
                    boolean added = false;
                    for (ItemDiff loopDiff : itemDiffs) {
                        if ((diff.getAmount() >= 0 || loopDiff.getAmount() >= 0) && (diff.getAmount() <= 0 || loopDiff.getAmount() <= 0)) continue;
                        loopDiff.add(diff.getAmount());
                        added = true;
                    }
                    if (added) continue;
                    this.itemPickupLog.put((Object)diff.getDisplayName(), (Object)diff);
                }
            }
        }
        this.previousInventory = newInventory;
    }

    public void resetPreviousInventory() {
        this.previousInventory = null;
    }

    public void cleanUpPickupLog() {
        this.itemPickupLog.entries().removeIf(entry -> ((ItemDiff)entry.getValue()).getLifetime() > 5000L);
    }

    public void checkIfInventoryIsFull(class_310 mc, class_746 p) {
        Feature feature = Feature.FULL_INVENTORY_WARNING;
        if (main.getUtils().isOnSkyblock() && feature.isEnabled()) {
            for (int i = 0; i < p.method_31548().method_67533().size(); ++i) {
                class_1799 idxItem = (class_1799)p.method_31548().method_67533().get(i);
                if (idxItem == class_1799.field_8037 && i != 8) {
                    if (this.inventoryWarningShown && this.repeatWarningTask != null) {
                        this.repeatWarningTask.cancel();
                        this.repeatWarningTask = null;
                    }
                    this.inventoryWarningShown = false;
                    return;
                }
                if (idxItem == class_1799.field_8037 || i != 8 || idxItem.method_7909() != class_1802.field_8153) continue;
                this.inQuiverMode = true;
                return;
            }
            this.inQuiverMode = false;
            if (mc.field_1755 == null && main.getPlayerListener().didntRecentlyJoinWorld()) {
                if (!this.inventoryWarningShown) {
                    this.showFullInventoryWarning();
                    this.inventoryWarningShown = true;
                }
                if (feature.isEnabled(FeatureSetting.REPEATING_FULL_INVENTORY_WARNING) && this.repeatWarningTask == null) {
                    this.repeatWarningTask = main.getScheduler().scheduleTask(scheduledTask -> {
                        if (feature.isDisabled(FeatureSetting.REPEATING_FULL_INVENTORY_WARNING) || mc.field_1687 == null || mc.field_1724 == null || !main.getUtils().isOnSkyblock()) {
                            scheduledTask.cancel();
                            this.repeatWarningTask = null;
                            return;
                        }
                        if (this.inQuiverMode) {
                            return;
                        }
                        this.showFullInventoryWarning();
                    }, 200, 200, true, false);
                }
            }
        }
    }

    public void showFullInventoryWarning() {
        main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
        main.getRenderListener().setTitleFeature(Feature.FULL_INVENTORY_WARNING);
    }

    public void checkIfWearingSkeletonHelmet(class_746 p) {
        if (Feature.SKELETON_BAR.isEnabled()) {
            class_1799 item = p.method_6118(class_1304.field_6169);
            if (item != class_1799.field_8037 && "SKELETON_HELMET".equals(ItemUtils.getSkyblockItemID(item))) {
                this.wearingSkeletonHelmet = true;
                return;
            }
            this.wearingSkeletonHelmet = false;
        }
    }

    public void checkIfUsingArrowPoison(class_746 p) {
        if (Feature.TURN_BOW_COLOR_WHEN_USING_ARROW_POISON.isEnabled()) {
            for (class_1799 item : p.method_31548().method_67533()) {
                if (item == null) continue;
                String itemID = ItemUtils.getSkyblockItemID(item);
                if ("TOXIC_ARROW_POISON".equals(itemID)) {
                    this.usingToxicArrowPoison = true;
                    this.usingTwilightArrowPoison = false;
                    return;
                }
                if (!"TWILIGHT_ARROW_POISON".equals(itemID)) continue;
                this.usingToxicArrowPoison = false;
                this.usingTwilightArrowPoison = true;
                return;
            }
            this.usingToxicArrowPoison = false;
            this.usingTwilightArrowPoison = false;
        }
    }

    public int getSlotDifference(class_1703 containerMenu) {
        class_1703 class_17032 = containerMenu;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1707.class, class_1722.class, class_3858.class, class_1704.class}, (Object)class_17032, n)) {
            case 0 -> {
                class_1707 chestMenu = (class_1707)class_17032;
                yield 9 - chestMenu.method_7629().method_5439();
            }
            case 1 -> {
                class_1722 hopperMenu = (class_1722)class_17032;
                yield 4;
            }
            case 2 -> {
                class_3858 furnaceMenu = (class_3858)class_17032;
                yield 6;
            }
            case 3 -> {
                class_1704 beaconMenu = (class_1704)class_17032;
                yield 8;
            }
            default -> 0;
        };
    }

    public void checkIfThunderBottle(class_746 p) {
        if (Feature.THUNDER_BOTTLE_DISPLAY.isEnabled()) {
            ThunderBottle displayBottle = ThunderBottle.getDisplayBottle();
            if (displayBottle != null && p.method_31548().method_67533().get(displayBottle.getSlot()) == class_1799.field_8037) {
                displayBottle.setItemStack(null);
                displayBottle.setSlot(-1);
                displayBottle.setCharge(0);
            }
            ThunderBottle.updateThunderBottles((class_2371<class_1799>)p.method_31548().method_67533());
        }
    }

    public void checkIfWearingSlayerArmor(class_746 p) {
        if (Feature.SLAYER_ARMOR_PROGRESS.isDisabled()) {
            return;
        }
        for (class_1304 slot : class_1661.field_56551.values()) {
            String itemID;
            int i = slot.method_5927();
            if (i > 36) {
                i -= 36;
            }
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            class_1799 itemStack = p.method_6118(slot);
            String string = itemID = itemStack != class_1799.field_8037 ? ItemUtils.getSkyblockItemID(itemStack) : null;
            if (itemID != null && (itemID.startsWith("REVENANT") || itemID.startsWith("TARANTULA") || itemID.startsWith("FINAL_DESTINATION") || itemID.startsWith("REAPER"))) {
                String percent = null;
                String defence = null;
                List<String> lore = ItemUtils.getItemLore(itemStack);
                for (String loreLine : lore) {
                    Matcher matcher = SLAYER_ARMOR_STACK_PATTERN.matcher(TextUtils.stripColor(loreLine));
                    if (!matcher.matches()) continue;
                    try {
                        float percentage = Float.parseFloat(matcher.group(2).replace(",", "")) / (float)Integer.parseInt(matcher.group(3).replace(",", "")) * 100.0f;
                        BigDecimal bigDecimal = new BigDecimal(percentage).setScale(0, RoundingMode.HALF_UP);
                        percent = bigDecimal.toString();
                        defence = String.valueOf(ColorCode.GREEN) + matcher.group(1);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                if (percent == null || defence == null) continue;
                SlayerArmorProgress currentProgress = this.slayerArmorProgresses[i];
                if (currentProgress == null || itemStack != currentProgress.getItemStack()) {
                    this.slayerArmorProgresses[i] = new SlayerArmorProgress(itemStack, percent, defence);
                    continue;
                }
                currentProgress.setPercent(percent);
                currentProgress.setDefence(defence);
                continue;
            }
            this.slayerArmorProgresses[i] = null;
        }
    }

    public static boolean isWearingFullSet(class_1657 player, Set<String> armorSetIds) {
        boolean flag = true;
        for (class_1304 slot : class_1661.field_56551.values()) {
            String itemID;
            if (slot.method_5925() != class_1304.class_1305.field_6178 || (itemID = ItemUtils.getSkyblockItemID(player.method_6118(slot))) != null && armorSetIds.contains(itemID)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public Collection<ItemDiff> getItemPickupLog() {
        return this.itemPickupLog.values();
    }

    public InventoryType updateInventoryType(class_2561 title) {
        if (title.getString().isBlank()) {
            this.inventoryType = null;
            return null;
        }
        String chestName = TextUtils.stripColor(title.getString());
        this.inventoryType = null;
        for (InventoryType inventoryTypeItr : InventoryType.values()) {
            Matcher m = inventoryTypeItr.getInventoryPattern().matcher(chestName);
            if (!m.matches()) continue;
            if (m.groupCount() > 0) {
                if (inventoryTypeItr == InventoryType.MAYOR) {
                    try {
                        this.inventoryMayorName = m.group("mayor").trim();
                        this.inventoryType = InventoryType.MAYOR;
                        break;
                    }
                    catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
                        LOGGER.warn("Could not detect mayor in Mayor Menu");
                        this.inventoryMayorName = null;
                    }
                }
                try {
                    this.inventoryPageNum = Integer.parseInt(m.group("page"));
                }
                catch (Exception e) {
                    this.inventoryPageNum = 0;
                }
                try {
                    this.inventorySubtype = m.group("type");
                }
                catch (Exception e) {
                    this.inventorySubtype = null;
                }
            } else {
                this.inventoryPageNum = 0;
                this.inventorySubtype = null;
            }
            this.inventoryType = inventoryTypeItr;
            break;
        }
        this.inventoryKey = this.getInventoryKey(this.inventoryType, this.inventoryPageNum);
        return this.inventoryType;
    }

    private String getInventoryKey(InventoryType inventoryType, int inventoryPageNum) {
        if (inventoryType == null) {
            return null;
        }
        return inventoryType.getInventoryName() + inventoryPageNum;
    }

    @Generated
    public void setInventoryWarningShown(boolean inventoryWarningShown) {
        this.inventoryWarningShown = inventoryWarningShown;
    }

    @Generated
    public boolean isWearingSkeletonHelmet() {
        return this.wearingSkeletonHelmet;
    }

    @Generated
    public boolean isUsingToxicArrowPoison() {
        return this.usingToxicArrowPoison;
    }

    @Generated
    public boolean isUsingTwilightArrowPoison() {
        return this.usingTwilightArrowPoison;
    }

    @Generated
    public SlayerArmorProgress[] getSlayerArmorProgresses() {
        return this.slayerArmorProgresses;
    }

    @Generated
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    @Generated
    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    @Generated
    public String getInventoryKey() {
        return this.inventoryKey;
    }

    @Generated
    public int getInventoryPageNum() {
        return this.inventoryPageNum;
    }

    @Generated
    public void setInventoryPageNum(int inventoryPageNum) {
        this.inventoryPageNum = inventoryPageNum;
    }

    @Generated
    public String getInventorySubtype() {
        return this.inventorySubtype;
    }

    @Generated
    public String getInventoryMayorName() {
        return this.inventoryMayorName;
    }

    private static class DiffHashMap
    extends HashMap<String, Pair<Integer, class_1799>> {
        private DiffHashMap() {
        }

        public void updateWithItem(class_1799 itemStack) {
            if (itemStack.method_65130() == null) {
                return;
            }
            String skyblockId = ItemUtils.getSkyblockItemID(itemStack);
            String displayName = TextUtils.getFormattedText(itemStack.method_65130());
            displayName = TextUtils.stripResets(displayName);
            if ("ENCHANTED_BOOK".equals(skyblockId)) {
                List<String> lore = ItemUtils.getItemLore(itemStack);
                if (!lore.isEmpty()) {
                    displayName = lore.getFirst();
                }
            } else {
                if (main.getUtils().isInDungeon() && itemStack.method_7909() == class_1802.field_8298 && StringUtils.isBlank((CharSequence)displayName)) {
                    return;
                }
                if (ItemUtils.isQuiverArrow(itemStack)) {
                    return;
                }
                if ("INFINITE_SUPERBOOM_TNT".equals(skyblockId) || "LESSER_ORB_OF_HEALING".equals(skyblockId)) {
                    return;
                }
            }
            int amount = this.containsKey(displayName) ? (Integer)((Pair)this.get(displayName)).getLeft() + itemStack.method_7947() : itemStack.method_7947();
            this.put(displayName, new Pair<Integer, class_1799>(amount, itemStack));
        }
    }
}

