/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import java.util.HashMap;
import java.util.Set;
import lombok.Generated;

public class LocationUtils {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static HashMap<String, Set<String>> slayerLocations;
    private static final Set<String> zealotSpawnLocations;
    private static final Set<String> glaciteTunnelsLocations;

    public static boolean isOnZealotSpawnLocation() {
        return zealotSpawnLocations.contains(main.getUtils().getLocation());
    }

    public static boolean isOnSlayerLocation(EnumUtils.SlayerQuest slayerQuest) {
        return slayerLocations.get(slayerQuest.name()).contains(main.getUtils().getLocation());
    }

    public static boolean isOnGlaciteTunnelsLocation() {
        return glaciteTunnelsLocations.contains(main.getUtils().getLocation());
    }

    public static boolean isOn(Island island) {
        return main.getUtils().isOnSkyblock() && main.getUtils().getMap() == island;
    }

    public static boolean isOn(Island ... islands) {
        if (islands == null || islands.length == 0) {
            throw new IllegalArgumentException("\"islands\" cannot be null or empty");
        }
        Island currentIsland = main.getUtils().getMap();
        for (Island island : islands) {
            if (currentIsland != island) continue;
            return true;
        }
        return false;
    }

    public static boolean isOn(String ... locations) {
        if (locations == null || locations.length == 0) {
            throw new IllegalArgumentException("\"locations\" cannot be null or empty");
        }
        String currentLocation = main.getUtils().getLocation();
        for (String location : locations) {
            if (!currentLocation.equals(location)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public static void setSlayerLocations(HashMap<String, Set<String>> slayerLocations) {
        LocationUtils.slayerLocations = slayerLocations;
    }

    static {
        zealotSpawnLocations = Set.of("Dragon's Nest", "Zealot Bruiser Hideout");
        glaciteTunnelsLocations = Set.of("Dwarven Base Camp", "Fossil Research Center", "Glacite Tunnels", "Great Glacite Lake");
    }
}

