/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ReflectionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> scanPackage(String pkg, ClassLoader loader, Class<?> superType) throws IOException, URISyntaxException {
        String prefix = pkg.replace('.', '/') + "/";
        ArrayList out = new ArrayList();
        Enumeration<URL> roots = loader.getResources(prefix);
        block22: while (roots.hasMoreElements()) {
            URL url = roots.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    Path dir = Paths.get(url.toURI());
                    Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
                    try {
                        stream.filter(p -> p.toString().endsWith(".class")).forEach(p -> ReflectionUtils.add(out, pkg, dir.relativize((Path)p).toString(), loader, superType));
                        continue block22;
                    }
                    finally {
                        if (stream == null) continue block22;
                        stream.close();
                        continue block22;
                    }
                }
                case "jar": {
                    FileSystem fs;
                    String u = url.toURI().toString();
                    URI jarUri = URI.create(u.substring(0, u.indexOf(33)));
                    boolean created = false;
                    try {
                        fs = FileSystems.getFileSystem(jarUri);
                    }
                    catch (FileSystemNotFoundException ex) {
                        fs = FileSystems.newFileSystem(jarUri, Map.of());
                        created = true;
                    }
                    try {
                        Path dir = fs.getPath("/" + prefix, new String[0]);
                        if (Files.exists(dir, new LinkOption[0])) {
                            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                                stream.filter(p -> p.toString().endsWith(".class")).forEach(p -> ReflectionUtils.add(out, pkg, dir.relativize((Path)p).toString(), loader, superType));
                            }
                        }
                        if (!created) break;
                    }
                    catch (Throwable throwable) {
                        if (created) {
                            fs.close();
                        }
                        throw throwable;
                    }
                    fs.close();
                    break;
                }
            }
        }
        return out;
    }

    private static void add(List<Class<?>> sink, String rootPkg, String relPath, ClassLoader cl, Class<?> superType) {
        String name = (rootPkg + "." + relPath).replace(File.separatorChar, '.').replace('/', '.').replaceAll("\\.class$", "");
        try {
            Class<?> cls = Class.forName(name, false, cl);
            if (superType == null || superType.isAssignableFrom(cls)) {
                sink.add(cls);
            }
        }
        catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }
}

