/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_5250;
import net.minecraft.class_8646;

public class ScoreboardManager {
    public static final Pattern SIDEBAR_EMOJI_PATTERN = Pattern.compile("[\ud83d\udd2b\ud83c\udf6b\ud83d\udca3\ud83d\udc7d\ud83d\udd2e\ud83d\udc0d\ud83d\udc7e\ud83c\udf20\ud83c\udf6d\u26bd\ud83c\udfc0\ud83d\udc79\ud83c\udf81\ud83c\udf89\ud83c\udf82]+");
    private static String scoreboardTitle;
    private static String strippedScoreboardTitle;
    private static List<String> scoreboardLines;
    private static List<String> strippedScoreboardLines;
    private static long lastFoundScoreboard;

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.method_1542()) {
            ScoreboardManager.clear();
            return;
        }
        class_269 scoreboard = mc.field_1687.method_8428();
        class_266 sidebarObjective = scoreboard.method_1189(class_8646.field_45157);
        if (sidebarObjective == null) {
            ScoreboardManager.clear();
            return;
        }
        lastFoundScoreboard = System.currentTimeMillis();
        scoreboardTitle = TextUtils.getFormattedText(sidebarObjective.method_1114(), true);
        strippedScoreboardTitle = TextUtils.stripColor(sidebarObjective.method_1114().getString());
        List<String> lines = scoreboard.method_1184(sidebarObjective).stream().filter(scoreboardEntry -> !scoreboardEntry.method_55385()).sorted(class_329.field_47550).limit(15L).map(scoreboardEntry -> {
            String owner = scoreboardEntry.comp_2127();
            class_2561 name = scoreboardEntry.method_55387();
            class_268 team = scoreboard.method_1164(owner);
            class_5250 decoratedName = class_268.method_1142((class_270)team, (class_2561)name);
            return TextUtils.getFormattedText((class_2561)decoratedName, true).replace(owner, "").trim();
        }).toList();
        scoreboardLines = new ArrayList<String>();
        strippedScoreboardLines = new ArrayList<String>();
        for (String line : lines) {
            String cleansedScoreboardLine = SIDEBAR_EMOJI_PATTERN.matcher(line).replaceAll("");
            String strippedCleansedScoreboardLine = TextUtils.stripColor(cleansedScoreboardLine);
            scoreboardLines.add(cleansedScoreboardLine);
            strippedScoreboardLines.add(strippedCleansedScoreboardLine);
        }
    }

    private static void clear() {
        strippedScoreboardTitle = null;
        scoreboardTitle = null;
        strippedScoreboardLines = null;
        scoreboardLines = null;
    }

    public static boolean hasScoreboard() {
        return scoreboardTitle != null;
    }

    public static int getNumberOfLines() {
        return scoreboardLines.size();
    }

    @Generated
    public static String getScoreboardTitle() {
        return scoreboardTitle;
    }

    @Generated
    public static String getStrippedScoreboardTitle() {
        return strippedScoreboardTitle;
    }

    @Generated
    public static List<String> getScoreboardLines() {
        return scoreboardLines;
    }

    @Generated
    public static List<String> getStrippedScoreboardLines() {
        return strippedScoreboardLines;
    }

    @Generated
    public static long getLastFoundScoreboard() {
        return lastFoundScoreboard;
    }

    static {
        lastFoundScoreboard = -1L;
    }
}

