/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data;

import com.fix3dll.skyblockaddons.utils.data.DataConstants;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import java.net.URI;
import org.apache.http.concurrent.FutureCallback;
import org.apache.logging.log4j.Logger;

public abstract class DataFetchCallback<T>
implements FutureCallback<T> {
    private final Logger logger;
    private final String urlString;
    private final boolean isEssential;
    private Exception firstFail = null;

    public DataFetchCallback(Logger logger, URI url) {
        this(logger, url, false);
    }

    public DataFetchCallback(Logger logger, URI url, boolean isEssential) {
        this.logger = logger;
        this.urlString = url.toString();
        this.isEssential = isEssential;
    }

    public void completed(T result) {
        this.logger.debug("Successfully fetched {}", (Object)this.urlString);
    }

    public void failed(Exception ex) {
        this.logger.error("Failed to fetch \"{}\" data from the server. The local copy will be used instead.\n{}", (Object)DataUtils.getFileNameFromUrlString(this.urlString), (Object)ex.getMessage());
        if (DataUtils.failedUris.contains(this.urlString) && this.firstFail != null) {
            String fallbackAddress = this.urlString.replace(DataConstants.CDN_BASE_URL, DataConstants.FALLBACK_CDN_BASE_URL);
            DataUtils.handleOnlineFileLoadException(this.urlString, this.firstFail, this.isEssential);
            DataUtils.handleOnlineFileLoadException(fallbackAddress, ex, this.isEssential);
        } else if (!this.urlString.contains(DataConstants.CDN_BASE_URL)) {
            DataUtils.handleOnlineFileLoadException(this.urlString, ex, this.isEssential);
        }
        if (this.firstFail == null) {
            this.firstFail = ex;
        }
    }

    public void cancelled() {
        this.logger.info("Cancelled fetching {}", (Object)this.urlString);
    }
}

