/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.Language;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.seacreatures.SeaCreature;
import com.fix3dll.skyblockaddons.core.seacreatures.SeaCreatureManager;
import com.fix3dll.skyblockaddons.events.ClientEvents;
import com.fix3dll.skyblockaddons.exceptions.DataLoadingException;
import com.fix3dll.skyblockaddons.features.PetManager;
import com.fix3dll.skyblockaddons.features.SkillXpManager;
import com.fix3dll.skyblockaddons.features.cooldowns.CooldownManager;
import com.fix3dll.skyblockaddons.features.enchants.EnchantManager;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataConstants;
import com.fix3dll.skyblockaddons.utils.data.RemoteFileRequest;
import com.fix3dll.skyblockaddons.utils.data.RequestRetryHandler;
import com.fix3dll.skyblockaddons.utils.data.UncaughtFetchExceptionHandler;
import com.fix3dll.skyblockaddons.utils.data.requests.CompactorItemsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.ContainersRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.CooldownsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.EnchantmentsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.LocalizationsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.LocationsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.MayorRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.OnlineDataRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.PetItemsRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.SeaCreaturesRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.SkillXpRequest;
import com.fix3dll.skyblockaddons.utils.data.requests.SlayerLocationsRequest;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.CompactorItem;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.ContainerData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.EnchantmentsData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.LegacyIdItemMapData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.LocationData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.OnlineData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.PetItem;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.TexturedHead;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1802;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionMetrics;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.Logger;

public class DataUtils {
    private static final Gson GSON = SkyblockAddons.getGson();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(120000).setConnectionRequestTimeout(120000).setSocketTimeout(30000).build();
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private static final CloseableHttpClient httpClient = HttpClientBuilder.create().setUserAgent(Utils.USER_AGENT).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)new RequestRetryHandler()).build();
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("SBA DataUtils Thread %d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtFetchExceptionHandler()).build();
    private static final ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
    private static final FutureRequestExecutionService futureRequestExecutionService = new FutureRequestExecutionService((HttpClient)httpClient, executorService);
    private static final FutureRequestExecutionMetrics executionServiceMetrics = futureRequestExecutionService.metrics();
    private static final ArrayList<RemoteFileRequest<?>> remoteRequests = new ArrayList();
    private static final TreeMap<String, Throwable> failedRequests = new TreeMap();
    static boolean fallbackCDNUsed = false;
    static final HashSet<String> failedUris = new HashSet();
    private static boolean failureMessageShown = false;
    public static final boolean USE_ONLINE_DATA = !FabricLoader.getInstance().isDevelopmentEnvironment() || Boolean.getBoolean("sba.data.online");
    private static String path;
    private static LocalizationsRequest localizedStringsRequest;

    public static void readLocalAndFetchOnline() {
        DataUtils.readLocalFileData();
        DataUtils.loadOnlineData(new MayorRequest());
        if (USE_ONLINE_DATA) {
            DataUtils.fetchFromOnline();
        } else {
            SkyblockAddons.getInstance().getUpdater().checkForUpdate();
        }
    }

    public static void readTexturedHeads() {
        try (InputStream inputStream = DataUtils.class.getResourceAsStream("/texturedHeads.json");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);){
            ItemUtils.setTexturedHeads((Object2ObjectOpenHashMap<String, TexturedHead>)((Object2ObjectOpenHashMap)GSON.fromJson((Reader)inputStreamReader, new TypeToken<Object2ObjectOpenHashMap<String, TexturedHead>>(){}.getType())));
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
    }

    public static void readLocalFileData() {
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        path = "/data.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    main.setOnlineData(GSON.fromJson((Reader)inputStreamReader, OnlineData.class));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        DataUtils.loadLocalizedStrings(false);
        try {
            inputStream = DataUtils.class.getClassLoader().getResourceAsStream("lang/en_US.json");
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    Translations.setDefaultLangJson(GSON.fromJson((Reader)inputStreamReader, JsonObject.class));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/containers.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    ItemUtils.setContainers((Object2ObjectOpenHashMap<String, ContainerData>)((Object2ObjectOpenHashMap)GSON.fromJson((Reader)inputStreamReader, new TypeToken<Object2ObjectOpenHashMap<String, ContainerData>>(){}.getType())));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/compactorItems.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    Object2ObjectOpenHashMap compactorItems = (Object2ObjectOpenHashMap)GSON.fromJson((Reader)inputStreamReader, new TypeToken<Object2ObjectOpenHashMap<String, CompactorItem>>(){}.getType());
                    compactorItems.forEach((skyblockId, compactorItem) -> ItemUtils.setItemStackSkyblockID(compactorItem.getItemStack(), skyblockId));
                    ItemUtils.setCompactorItems((Object2ObjectOpenHashMap<String, CompactorItem>)compactorItems);
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/seaCreatures.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    SeaCreatureManager.getInstance().setSeaCreatures((Map)GSON.fromJson((Reader)inputStreamReader, new TypeToken<Map<String, SeaCreature>>(){}.getType()));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/enchants.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    EnchantManager.setEnchants((EnchantmentsData)GSON.fromJson((Reader)inputStreamReader, new TypeToken<EnchantmentsData>(){}.getType()));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/cooldowns.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    Object2IntOpenHashMap cooldowns = new Object2IntOpenHashMap();
                    cooldowns.putAll((Map)GSON.fromJson((Reader)inputStreamReader, new TypeToken<HashMap<String, Integer>>(){}.getType()));
                    CooldownManager.setItemCooldowns((Object2IntOpenHashMap<String>)cooldowns);
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/skillXp.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    SkillXpManager.initialize(GSON.fromJson((Reader)inputStreamReader, SkillXpManager.JsonInput.class));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/petItems.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    PetManager.setPetItems((Map)GSON.fromJson((Reader)inputStreamReader, new TypeToken<HashMap<String, PetItem>>(){}.getType()));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/locations.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    HashMap result = (HashMap)GSON.fromJson((Reader)inputStreamReader, new TypeToken<HashMap<String, LocationData>>(){}.getType());
                    for (Map.Entry entry : result.entrySet()) {
                        for (Island island : Island.values()) {
                            if (!island.getMode().equalsIgnoreCase((String)entry.getKey())) continue;
                            island.setLocationData((LocationData)entry.getValue());
                        }
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        path = "/slayerLocations.json";
        try {
            inputStream = DataUtils.class.getResourceAsStream(path);
            try {
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
                try {
                    LocationUtils.setSlayerLocations((HashMap)GSON.fromJson((Reader)inputStreamReader, new TypeToken<HashMap<String, Set<String>>>(){}.getType()));
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        if (LegacyIdItemMapData.getItemStack("175:4").method_7909() == class_1802.field_17527) {
            LOGGER.info("roses are red and violets are blue");
        }
    }

    private static void fetchFromOnline() {
        for (RemoteFileRequest<?> request : remoteRequests) {
            request.execute(futureRequestExecutionService);
            if (!request.getURL().contains(DataConstants.CDN_BASE_URL)) continue;
            SkyblockAddons.getInstance().getScheduler().scheduleAsyncTask(scheduledTask -> {
                if (request.isDone() && failedUris.contains(request.getURL())) {
                    request.setFallbackCDN();
                    request.execute(futureRequestExecutionService);
                    if (!fallbackCDNUsed) {
                        if (class_310.method_1551().field_1724 != null) {
                            Utils.sendMessage(Translations.getMessage("messages.fallbackCdnUsed", new Object[0]));
                        } else {
                            LOGGER.warn(Translations.getMessage("messages.fallbackCdnUsed", new Object[0]));
                        }
                        fallbackCDNUsed = true;
                    }
                    scheduledTask.cancel();
                }
            }, 0, 2);
        }
    }

    public static void loadOnlineData(RemoteFileRequest<?> request) {
        request.execute(futureRequestExecutionService);
    }

    public static void loadLocalizedStrings(boolean loadOnlineStrings) {
        Language currentLanguage = (Language)Feature.LANGUAGE.getValue();
        DataUtils.loadLocalizedStrings(currentLanguage, loadOnlineStrings);
    }

    public static void loadLocalizedStrings(Language language, boolean loadOnlineStrings) {
        path = "lang/" + language.getPath() + ".json";
        try (InputStream inputStream = DataUtils.class.getClassLoader().getResourceAsStream(path);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);){
            Translations.setLanguageJson(GSON.fromJson((Reader)inputStreamReader, JsonObject.class));
            Feature.LANGUAGE.setValue(language);
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(path, ex);
        }
        if (USE_ONLINE_DATA && loadOnlineStrings && language != Language.ENGLISH) {
            HttpRequestFutureTask futureTask;
            if (localizedStringsRequest != null && !(futureTask = localizedStringsRequest.getFutureTask()).isDone()) {
                futureTask.cancel(false);
            }
            localizedStringsRequest = new LocalizationsRequest(language);
            localizedStringsRequest.execute(futureRequestExecutionService);
        }
    }

    public static void onSkyblockJoined() {
        if (!failureMessageShown && !failedRequests.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder("Failed Requests:\n");
            for (Map.Entry<String, Throwable> failedRequest : failedRequests.entrySet()) {
                errorMessageBuilder.append(failedRequest.getKey()).append("\n");
                errorMessageBuilder.append(failedRequest.getValue().toString()).append("\n");
            }
            class_5250 failureMessageComponent = class_2561.method_43470((String)Translations.getMessage("messages.fileFetchFailed", String.valueOf(ColorCode.AQUA) + SkyblockAddons.METADATA.getName() + String.valueOf(ColorCode.RED), failedRequests.size()));
            class_5250 buttonRowComponent = class_2561.method_43470((String)("[" + Translations.getMessage("messages.copy", new Object[0]) + "]")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(String.valueOf(ColorCode.WHITE) + String.format("/sba internal copy %s", errorMessageBuilder))));
            buttonRowComponent.method_27693("  ");
            buttonRowComponent.method_10852((class_2561)class_2561.method_43470((String)("[" + Translations.getMessage("messages.retry", new Object[0]) + "]")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(String.valueOf(ColorCode.WHITE) + "/sba reloadRes"))));
            failureMessageComponent.method_27693("\n").method_10852((class_2561)buttonRowComponent);
            Utils.sendMessage((class_2561)failureMessageComponent, false);
            failureMessageShown = true;
            failedRequests.clear();
        }
    }

    static String getFileNameFromUrlString(String url) {
        int fileNameIndex;
        int queryParamIndex = url.indexOf(63, fileNameIndex = url.lastIndexOf(47) + 1);
        return url.substring(fileNameIndex, queryParamIndex > fileNameIndex ? queryParamIndex : url.length());
    }

    public static void registerNewRemoteRequests() {
        remoteRequests.clear();
        failedUris.clear();
        fallbackCDNUsed = false;
        failureMessageShown = false;
        remoteRequests.add(new OnlineDataRequest());
        remoteRequests.add(new ContainersRequest());
        remoteRequests.add(new CompactorItemsRequest());
        remoteRequests.add(new SeaCreaturesRequest());
        remoteRequests.add(new EnchantmentsRequest());
        remoteRequests.add(new CooldownsRequest());
        remoteRequests.add(new SkillXpRequest());
        remoteRequests.add(new PetItemsRequest());
        remoteRequests.add(new LocationsRequest());
        remoteRequests.add(new SlayerLocationsRequest());
    }

    public static void handleLocalFileReadException(String filePath, Throwable exception) {
        if (ClientEvents.ClientInitialization.AFTER_INITIALIZE.isTrue()) {
            throw new DataLoadingException(filePath, exception);
        }
        class_128 crashReport = class_128.method_560((Throwable)exception, (String)"[SkyblockAddons] Loading data file at %s".formatted(filePath));
        throw new class_148(crashReport);
    }

    static void handleOnlineFileLoadException(String urlString, Throwable exception, boolean essential) {
        String fileName = DataUtils.getFileNameFromUrlString(urlString);
        failedRequests.put(urlString, exception);
        if (exception instanceof IllegalArgumentException) {
            LOGGER.error(exception.getMessage());
            return;
        }
        if (essential) {
            if (ClientEvents.ClientInitialization.AFTER_INITIALIZE.isTrue()) {
                throw new DataLoadingException(urlString, exception);
            }
            class_128 crashReport = class_128.method_560((Throwable)exception, (String)String.format("Loading online data file at %s", fileName));
            throw new class_148(crashReport);
        }
        LOGGER.error("Failed to load \"{}\" from the server. The local copy will be used instead.", (Object)fileName);
        if (exception != null) {
            LOGGER.error(exception.getMessage());
        }
    }

    @Generated
    public static FutureRequestExecutionMetrics getExecutionServiceMetrics() {
        return executionServiceMetrics;
    }

    static {
        localizedStringsRequest = null;
        connectionManager.setMaxTotal(5);
        connectionManager.setDefaultMaxPerRoute(5);
        DataUtils.registerNewRemoteRequests();
    }
}

