/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.gson;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.FeatureData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.utils.EnumRegistry;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;

public class FeatureDataAdapter<T>
implements JsonDeserializer<FeatureData<T>>,
JsonSerializer<FeatureData<T>> {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final Float DEFAULT_SCALE = Float.valueOf(1.0f);
    private static final int DEFAULT_COLOR = ColorCode.RED.getColor();

    @Override
    public FeatureData<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject settingsJson;
        TreeMap<FeatureSetting, Object> settings;
        JsonObject jsonObject = json.getAsJsonObject();
        FeatureData featureData = new FeatureData(null);
        if (!jsonObject.has("value")) {
            throw new JsonParseException("FeatureData value cannot be null!");
        }
        featureData.setValue(this.deserializedValue(jsonObject.get("value"), context));
        if (jsonObject.has("anchorPoint")) {
            featureData.setAnchorPoint((EnumUtils.AnchorPoint)context.deserialize(jsonObject.get("anchorPoint"), (Type)((Object)EnumUtils.AnchorPoint.class)));
        }
        if (jsonObject.has("coords")) {
            JsonArray coords = jsonObject.get("coords").getAsJsonArray();
            featureData.setCoords(new Pair<Float, Float>(Float.valueOf(coords.get(0).getAsFloat()), Float.valueOf(coords.get(1).getAsFloat())));
        }
        if (jsonObject.has("barSizes")) {
            JsonArray barSizes = jsonObject.get("barSizes").getAsJsonArray();
            featureData.setBarSizes(new Pair<Float, Float>(Float.valueOf(barSizes.get(0).getAsFloat()), Float.valueOf(barSizes.get(1).getAsFloat())));
        }
        if (jsonObject.has("guiScale")) {
            featureData.setGuiScale(jsonObject.get("guiScale").getAsFloat());
        }
        if (jsonObject.has("color")) {
            featureData.setColor(jsonObject.get("color").getAsInt());
        }
        if (jsonObject.has("chroma")) {
            featureData.setChroma(jsonObject.get("chroma").getAsBoolean());
        }
        if (jsonObject.has("settings") && !(settings = this.deserializeSettings(settingsJson = jsonObject.getAsJsonObject("settings"))).isEmpty()) {
            featureData.setSettings(settings);
        }
        return featureData;
    }

    @Override
    public JsonElement serialize(FeatureData<T> src, Type typeOfSrc, JsonSerializationContext context) {
        TreeMap<FeatureSetting, Object> settings;
        JsonObject jsonObject = new JsonObject();
        T value = src.getValue();
        if (src.getValue() == null) {
            throw new JsonParseException("FeatureData value cannot be null!");
        }
        this.serializeValue(value, jsonObject, context);
        if (src.getAnchorPoint() != null) {
            jsonObject.add("anchorPoint", context.serialize(src.getAnchorPoint()));
        }
        if (src.getCoords() != null) {
            JsonArray coords = new JsonArray();
            coords.add(new JsonPrimitive(src.getCoords().getLeft()));
            coords.add(new JsonPrimitive(src.getCoords().getRight()));
            jsonObject.add("coords", coords);
        }
        if (!DEFAULT_SCALE.equals(src.getBarSizes().getLeft()) || !DEFAULT_SCALE.equals(src.getBarSizes().getRight())) {
            JsonArray barSizes = new JsonArray();
            barSizes.add(new JsonPrimitive(src.getBarSizes().getLeft()));
            barSizes.add(new JsonPrimitive(src.getBarSizes().getRight()));
            jsonObject.add("barSizes", barSizes);
        }
        if (src.getGuiScale() != DEFAULT_SCALE.floatValue()) {
            jsonObject.addProperty("guiScale", Float.valueOf(src.getGuiScale()));
        }
        if (src.getColor() != DEFAULT_COLOR || src.getGuiData() != null && src.getGuiData().getDefaultColor() != null) {
            jsonObject.addProperty("color", src.getColor());
        }
        if (src.isChroma()) {
            jsonObject.addProperty("chroma", true);
        }
        if ((settings = src.getSettings()) != null && !settings.isEmpty()) {
            JsonObject settingsJson = new JsonObject();
            settings.forEach((featureSetting, settingValue) -> this.serializeValue(featureSetting.name(), settingValue, settingsJson, context));
            jsonObject.add("settings", settingsJson);
        }
        return jsonObject;
    }

    private void serializeValue(Object value, JsonObject jsonObject, JsonSerializationContext context) {
        this.serializeValue("value", value, jsonObject, context);
    }

    private void serializeValue(String propertyName, Object value, JsonObject jsonObject, JsonSerializationContext context) {
        if (value instanceof Boolean) {
            jsonObject.addProperty(propertyName, (boolean)((Boolean)value));
        } else if (value instanceof Number) {
            jsonObject.addProperty(propertyName, (Number)value);
        } else if (value instanceof RegistrableEnum) {
            jsonObject.add(propertyName, context.serialize(value));
        } else if (value instanceof String) {
            jsonObject.addProperty(propertyName, (String)value);
        } else {
            throw new JsonParseException("Invalid FeatureData value type: " + String.valueOf(value.getClass()));
        }
    }

    private Object deserializedValue(JsonElement value, JsonDeserializationContext context) {
        JsonPrimitive primitive = value.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return value.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return value.getAsNumber();
        }
        if (primitive.isString()) {
            Class<? extends Enum> classType = EnumRegistry.getEnumClass(value.getAsString());
            if (classType != null) {
                return context.deserialize(value, classType);
            }
            return value.getAsString();
        }
        throw new JsonParseException("Invalid FeatureData value type: " + primitive.getAsString());
    }

    private TreeMap<FeatureSetting, Object> deserializeSettings(JsonObject settingsJson) {
        TreeMap<FeatureSetting, Object> settings = new TreeMap<FeatureSetting, Object>();
        for (Map.Entry<String, JsonElement> entry : settingsJson.entrySet()) {
            FeatureSetting featureSetting;
            try {
                featureSetting = FeatureSetting.valueOf(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Invalid FeatureSetting: {}", (Object)entry.getKey());
                continue;
            }
            JsonElement entryValue = entry.getValue();
            if (!entryValue.isJsonPrimitive()) continue;
            JsonPrimitive primitive = entryValue.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                settings.put(featureSetting, primitive.getAsBoolean());
                continue;
            }
            if (primitive.isNumber()) {
                settings.put(featureSetting, primitive.getAsNumber());
                continue;
            }
            if (!primitive.isString()) continue;
            try {
                RegistrableEnum enumKey = EnumRegistry.getEnumValue(entry.getKey(), primitive.getAsString());
                settings.put(featureSetting, enumKey);
            }
            catch (IllegalArgumentException e) {
                settings.put(featureSetting, primitive.getAsString());
            }
        }
        return settings;
    }
}

