/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.config;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockEquipment;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.features.FetchurManager;
import com.fix3dll.skyblockaddons.features.backpacks.CompressedStorage;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonTrackerData;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTrackerData;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import org.apache.logging.log4j.Logger;

public class PersistentValuesManager {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final ReentrantLock SAVE_LOCK = new ReentrantLock();
    private final File configFile;
    private final File persistentValuesFile;
    private PersistentValues persistentValues = new PersistentValues();

    public PersistentValuesManager(File mainConfigDir) {
        this.configFile = mainConfigDir;
        this.persistentValuesFile = new File(mainConfigDir.getAbsolutePath(), "/skyblockaddons/persistentValues.json");
    }

    public void loadValues() {
        if (this.persistentValuesFile.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(this.persistentValuesFile.toPath(), StandardCharsets.UTF_8);){
                this.persistentValues = SkyblockAddons.getGson().fromJson((Reader)reader, PersistentValues.class);
                if (this.persistentValues == null) {
                    this.persistentValues = new PersistentValues();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error loading persistent values!", (Throwable)ex);
                this.backupValues();
            }
        } else {
            this.saveValues();
        }
        FetchurManager.getInstance().postPersistentConfigLoad(this.persistentValues.lastTimeFetchur);
        SkyblockEquipment.loadEquipments(SkyblockEquipment.Type.MAIN);
    }

    public void saveValues() {
        SkyblockAddons.runAsync(() -> {
            boolean isDevMode;
            block12: {
                if (!SAVE_LOCK.tryLock()) {
                    return;
                }
                isDevMode = Feature.DEVELOPER_MODE.isEnabled();
                if (isDevMode) {
                    LOGGER.info("Saving persistent values...");
                }
                try {
                    File tempFile = File.createTempFile(this.persistentValuesFile.getName(), ".tmp", this.persistentValuesFile.getParentFile());
                    try (BufferedWriter writer = Files.newBufferedWriter(tempFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        SkyblockAddons.getGson().toJson((Object)this.persistentValues, (Appendable)writer);
                    }
                    Files.move(tempFile.toPath(), this.persistentValuesFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception ex) {
                    LOGGER.error("Error saving persistent values!", (Throwable)ex);
                    if (class_310.method_1551().field_1724 == null) break block12;
                    Utils.sendErrorMessage("Error saving persistent values! Check log for more detail.");
                }
            }
            if (isDevMode) {
                LOGGER.info("Persistent values saved!");
            }
            SAVE_LOCK.unlock();
        });
    }

    public void backupValues() {
        if (!this.persistentValuesFile.exists()) {
            LOGGER.warn("persistentValues.json file for backup is not exist!");
            return;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm");
            String formattedDate = ZonedDateTime.now().format(formatter);
            String backupFileName = "persistentValues.json." + formattedDate + ".backup";
            File backupFile = new File(this.configFile, "/skyblockaddons/backup/" + backupFileName);
            Files.createDirectories(backupFile.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(this.persistentValuesFile.toPath(), backupFile.toPath(), new CopyOption[0]);
            LOGGER.info("Persistent values backed up successfully: {}", (Object)backupFile.getPath());
        }
        catch (IOException e) {
            LOGGER.error("Failed to backup persistent values file!", (Throwable)e);
        }
    }

    public void addEyeResetKills() {
        ++this.persistentValues.summoningEyeCount;
        this.persistentValues.totalKills += this.persistentValues.kills;
        this.persistentValues.kills = -1;
        this.saveValues();
    }

    public void resetZealotCounter() {
        this.persistentValues.summoningEyeCount = 0;
        this.persistentValues.totalKills = 0;
        this.persistentValues.kills = 0;
        this.saveValues();
    }

    public void addOresMined() {
        ++this.persistentValues.oresMined;
        SkyblockAddons.getInstance().getPlayerListener().setSavePersistentFlag(true);
    }

    public void addKills() {
        ++this.persistentValues.kills;
        this.saveValues();
    }

    public void addSeaCreaturesKilled(int spawned) {
        this.persistentValues.seaCreaturesKilled += spawned;
        this.saveValues();
    }

    public void setLastTimeFetchur(long lastTimeFetchur) {
        this.persistentValues.lastTimeFetchur = lastTimeFetchur;
        this.saveValues();
    }

    public Set<Integer> getLockedSlots() {
        String profile = SkyblockAddons.getInstance().getUtils().getProfileName();
        if (!this.persistentValues.profileLockedSlots.containsKey(profile)) {
            this.persistentValues.profileLockedSlots.put(profile, new HashSet());
        }
        return this.persistentValues.profileLockedSlots.get(profile);
    }

    public CompressedStorage getCompressedEquipments(String levelKey) {
        if (class_3544.method_15438((String)levelKey)) {
            return null;
        }
        return this.persistentValues.equipmentCache.getOrDefault(levelKey, null);
    }

    @Generated
    public void setPersistentValues(PersistentValues persistentValues) {
        this.persistentValues = persistentValues;
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Generated
    public File getPersistentValuesFile() {
        return this.persistentValuesFile;
    }

    @Generated
    public PersistentValues getPersistentValues() {
        return this.persistentValues;
    }

    public static class PersistentValues {
        private int kills = 0;
        private int totalKills = 0;
        private int summoningEyeCount = 0;
        private SlayerTrackerData slayerTracker = new SlayerTrackerData();
        private DragonTrackerData dragonTracker = new DragonTrackerData();
        private final Map<String, CompressedStorage> storageCache = new HashMap<String, CompressedStorage>();
        private final Map<String, Set<Integer>> profileLockedSlots = new HashMap<String, Set<Integer>>();
        private final Map<String, CompressedStorage> equipmentCache = new HashMap<String, CompressedStorage>();
        private int oresMined = 0;
        private int seaCreaturesKilled = 0;
        private long lastTimeFetchur = 0L;

        @Generated
        public int getKills() {
            return this.kills;
        }

        @Generated
        public int getTotalKills() {
            return this.totalKills;
        }

        @Generated
        public int getSummoningEyeCount() {
            return this.summoningEyeCount;
        }

        @Generated
        public SlayerTrackerData getSlayerTracker() {
            return this.slayerTracker;
        }

        @Generated
        public DragonTrackerData getDragonTracker() {
            return this.dragonTracker;
        }

        @Generated
        public Map<String, CompressedStorage> getStorageCache() {
            return this.storageCache;
        }

        @Generated
        public Map<String, Set<Integer>> getProfileLockedSlots() {
            return this.profileLockedSlots;
        }

        @Generated
        public Map<String, CompressedStorage> getEquipmentCache() {
            return this.equipmentCache;
        }

        @Generated
        public int getOresMined() {
            return this.oresMined;
        }

        @Generated
        public int getSeaCreaturesKilled() {
            return this.seaCreaturesKilled;
        }

        @Generated
        public long getLastTimeFetchur() {
            return this.lastTimeFetchur;
        }

        @Generated
        public void setKills(int kills) {
            this.kills = kills;
        }

        @Generated
        public void setTotalKills(int totalKills) {
            this.totalKills = totalKills;
        }

        @Generated
        public void setSummoningEyeCount(int summoningEyeCount) {
            this.summoningEyeCount = summoningEyeCount;
        }

        @Generated
        public void setSlayerTracker(SlayerTrackerData slayerTracker) {
            this.slayerTracker = slayerTracker;
        }

        @Generated
        public void setDragonTracker(DragonTrackerData dragonTracker) {
            this.dragonTracker = dragonTracker;
        }

        @Generated
        public void setOresMined(int oresMined) {
            this.oresMined = oresMined;
        }

        @Generated
        public void setSeaCreaturesKilled(int seaCreaturesKilled) {
            this.seaCreaturesKilled = seaCreaturesKilled;
        }

        @Generated
        public void setLastTimeFetchur(long lastTimeFetchur) {
            this.lastTimeFetchur = lastTimeFetchur;
        }
    }
}

