/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.regex.Matcher;
import lombok.Generated;

public class SkyblockDate {
    private final SkyblockMonth month;
    private final int day;
    private final int hour;
    private final int minute;
    private final String period;

    public static SkyblockDate parse(Matcher dateMatcher) {
        if (dateMatcher == null) {
            return null;
        }
        int day = Integer.parseInt(dateMatcher.group("day"));
        String month = dateMatcher.group("month");
        return new SkyblockDate(SkyblockMonth.fromName(month), day);
    }

    public static SkyblockDate parse(Matcher dateMatcher, Matcher timeMatcher) {
        if (dateMatcher == null || timeMatcher == null) {
            return null;
        }
        int day = Integer.parseInt(dateMatcher.group("day"));
        int hour = Integer.parseInt(timeMatcher.group("hour"));
        int minute = Integer.parseInt(timeMatcher.group("minute"));
        String month = dateMatcher.group("month");
        String period = timeMatcher.group("period");
        return new SkyblockDate(SkyblockMonth.fromName(month), day, hour, minute, period);
    }

    public SkyblockDate(SkyblockMonth month, int day) {
        this.month = month;
        this.day = day;
        this.hour = -1;
        this.minute = -1;
        this.period = "";
    }

    public SkyblockDate(SkyblockMonth month, int day, int hour, int minute, String period) {
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.period = period;
    }

    public String toString() {
        String monthName = this.month != null ? this.month.scoreboardString : null;
        if (this.hour == -1 || this.minute == -1) {
            return String.format("%s %s", monthName, this.day + TextUtils.getOrdinalSuffix(this.day));
        }
        return String.format("%s %s, %d:%s%s", monthName, this.day + TextUtils.getOrdinalSuffix(this.day), this.hour, this.minute == 0 ? "00" : Integer.valueOf(this.minute), this.period);
    }

    @Generated
    public SkyblockMonth getMonth() {
        return this.month;
    }

    @Generated
    public int getDay() {
        return this.day;
    }

    @Generated
    public int getHour() {
        return this.hour;
    }

    @Generated
    public int getMinute() {
        return this.minute;
    }

    @Generated
    public String getPeriod() {
        return this.period;
    }

    public static enum SkyblockMonth {
        EARLY_WINTER("Early Winter"),
        WINTER("Winter"),
        LATE_WINTER("Late Winter"),
        EARLY_SPRING("Early Spring"),
        SPRING("Spring"),
        LATE_SPRING("Late Spring"),
        EARLY_SUMMER("Early Summer"),
        SUMMER("Summer"),
        LATE_SUMMER("Late Summer"),
        EARLY_AUTUMN("Early Autumn"),
        AUTUMN("Autumn"),
        LATE_AUTUMN("Late Autumn");

        final String scoreboardString;

        private SkyblockMonth(String scoreboardString) {
            this.scoreboardString = scoreboardString;
        }

        public static SkyblockMonth fromName(String scoreboardName) {
            for (SkyblockMonth skyblockMonth : SkyblockMonth.values()) {
                if (!skyblockMonth.scoreboardString.equals(scoreboardName)) continue;
                return skyblockMonth;
            }
            return null;
        }
    }
}

