/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.backpacks.CompressedStorage;
import com.fix3dll.skyblockaddons.features.backpacks.ContainerPreviewManager;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;

public enum SkyblockEquipment {
    NECKLACE(String.valueOf(ColorCode.GRAY) + "Empty Equipment Slot", String.valueOf(ColorCode.DARK_GRAY) + "> Necklace"),
    CLOAK(String.valueOf(ColorCode.GRAY) + "Empty Equipment Slot", String.valueOf(ColorCode.DARK_GRAY) + "> Cloak"),
    BELT(String.valueOf(ColorCode.GRAY) + "Empty Equipment Slot", String.valueOf(ColorCode.DARK_GRAY) + "> Belt"),
    GLOVES_BRACELET(String.valueOf(ColorCode.GRAY) + "Empty Equipment Slot", String.valueOf(ColorCode.DARK_GRAY) + "> Gloves", String.valueOf(ColorCode.DARK_GRAY) + "> Bracelet"),
    PET(String.valueOf(ColorCode.GRAY) + "Empty Pet Slot");

    private static final SkyblockAddons main;
    private static final class_310 MC;
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE;
    private static final class_1799 NULL;
    private static Type currentType;
    private class_1799 itemStack;
    private final class_1799 emptyStack = class_1802.field_8240.method_7854();
    private boolean isHovered = false;

    private SkyblockEquipment(String ... defaultName) {
        List<class_2561> loreList = SkyblockEquipment.createListsForItemLore(defaultName);
        if (!loreList.isEmpty()) {
            this.emptyStack.method_57379(class_9334.field_49631, (Object)loreList.getFirst());
            loreList.removeFirst();
        }
        this.emptyStack.method_57379(class_9334.field_49632, (Object)new class_9290(loreList));
        this.itemStack = this.emptyStack;
    }

    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack == null || itemStack.method_7960() ? this.emptyStack : itemStack;
    }

    public void render(class_332 graphics, int mouseX, int mouseY, int leftPos, int topPos) {
        if (this == PET && Feature.EQUIPMENTS_IN_INVENTORY.isDisabled(FeatureSetting.PET_PANEL)) {
            return;
        }
        if (this.itemStack == null) {
            this.itemStack = NULL;
        }
        int x = -15;
        int y = 8 + this.ordinal() * 18 + (this == PET ? 4 : 0);
        int seed = x + y * 176;
        class_327 font = SkyblockEquipment.MC.field_1772;
        int translatedMouseX = mouseX - leftPos;
        int translatedMouseY = mouseY - topPos;
        this.isHovered = translatedMouseX >= x - 1 && translatedMouseX < x + 16 + 1 && translatedMouseY >= y - 1 && translatedMouseY < y + 16 + 1;
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)leftPos, (float)topPos);
        graphics.method_51428(this.itemStack, x, y, seed);
        graphics.method_51431(font, this.itemStack, x, y);
        if (this.isHovered) {
            graphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, x - 4, y - 4, 24, 24);
        }
        poseStack.popMatrix();
        if (this.isHovered) {
            graphics.method_71048();
            graphics.method_51446(font, this.itemStack, mouseX, mouseY);
        }
    }

    public void onClick(int button) {
        class_746 player = SkyblockEquipment.MC.field_1724;
        if (player == null || !this.isHovered || button != 0) {
            return;
        }
        if (this == PET && Feature.EQUIPMENTS_IN_INVENTORY.isEnabled(FeatureSetting.PET_PANEL)) {
            if (main.getUtils().isOnRift()) {
                player.field_3944.method_45729("/sbmenu");
            } else {
                player.field_3944.method_45729("/petsmenu");
            }
        } else {
            player.field_3944.method_45729("/equipment");
        }
    }

    public boolean isEmpty() {
        return class_1799.method_7973((class_1799)this.itemStack, (class_1799)this.emptyStack) || class_1799.method_7984((class_1799)this.itemStack, (class_1799)NULL);
    }

    public static boolean equipmentsInInventory() {
        return main.getUtils().isOnSkyblock() && Feature.EQUIPMENTS_IN_INVENTORY.isEnabled();
    }

    public static void loadEquipments(Type equipmentType) {
        if (equipmentType == null || currentType == equipmentType) {
            return;
        }
        currentType = equipmentType;
        CompressedStorage compressedStorage = main.getPersistentValuesManager().getCompressedEquipments(currentType.getLevelKey());
        if (compressedStorage != null) {
            List<class_1799> list = ContainerPreviewManager.decompressItems(compressedStorage.getStorage());
            if (list != null) {
                SkyblockEquipment[] equipments = SkyblockEquipment.values();
                int listSize = list.size();
                for (int i = 0; i < equipments.length; ++i) {
                    if (i < listSize) {
                        equipments[i].setItemStack(list.get(i));
                        continue;
                    }
                    equipments[i].itemStack = equipments[i].getEmptyStack();
                }
            } else {
                for (SkyblockEquipment equipment : SkyblockEquipment.values()) {
                    equipment.itemStack = equipment.emptyStack;
                }
            }
        } else {
            for (SkyblockEquipment equipment : SkyblockEquipment.values()) {
                equipment.itemStack = equipment.emptyStack;
            }
        }
    }

    public static void saveEquipments() {
        class_1799[] list = (class_1799[])Arrays.stream(SkyblockEquipment.values()).map(SkyblockEquipment::getItemStack).toArray(class_1799[]::new);
        main.getPersistentValuesManager().getPersistentValues().getEquipmentCache().put(main.getUtils().isOnRift() ? Type.RIFT.getLevelKey() : Type.MAIN.getLevelKey(), new CompressedStorage(ItemUtils.getCompressedNBT(list).method_10521()));
        main.getPersistentValuesManager().saveValues();
    }

    private static List<class_2561> createListsForItemLore(String ... strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("\"strings\" cannot be null or empty!");
        }
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        for (String string : strings) {
            list.add((class_2561)class_2561.method_43470((String)string));
        }
        return list;
    }

    @Generated
    public class_1799 getItemStack() {
        return this.itemStack;
    }

    @Generated
    public class_1799 getEmptyStack() {
        return this.emptyStack;
    }

    static {
        main = SkyblockAddons.getInstance();
        MC = class_310.method_1551();
        SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
        NULL = class_1802.field_8077.method_7854();
        NULL.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"ERROR").method_54663(ColorCode.RED.getColor()));
        NULL.method_57379(class_9334.field_49632, (Object)new class_9290(Collections.singletonList(class_2561.method_43470((String)"You have to update equipments and pets from '/petsmenu' and '/equipment'!").method_54663(ColorCode.GRAY.getColor()))));
    }

    public static enum Type {
        MAIN("main"),
        RIFT("rift");

        public final String levelKey;

        @Generated
        private Type(String levelKey) {
            this.levelKey = levelKey;
        }

        @Generated
        public String getLevelKey() {
            return this.levelKey;
        }
    }
}

