/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.scheduler;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_10209;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import org.apache.logging.log4j.Logger;

public class Scheduler {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private final ObjectArrayList<ScheduledTask> queuedTasks;
    private final ObjectArrayList<ScheduledTask> pendingTasks;
    private final Object anchor = new Object();
    private volatile long totalTicks = 0L;

    public Scheduler() {
        this.queuedTasks = new ObjectArrayList();
        this.pendingTasks = new ObjectArrayList();
        ClientTickEvents.START_CLIENT_TICK.register(this::ticker);
    }

    public synchronized long getTotalTicks() {
        return this.totalTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ticker(class_310 mc) {
        class_3695 profilerFiller = class_10209.method_64146();
        profilerFiller.method_15396("SkyblockAddonsScheduler");
        Object object = this.anchor;
        synchronized (object) {
            ++this.totalTicks;
        }
        if (mc != null) {
            if (!this.pendingTasks.isEmpty()) {
                this.pendingTasks.removeIf(ScheduledTask::isCanceled);
            }
            if (!this.queuedTasks.isEmpty()) {
                this.queuedTasks.removeIf(ScheduledTask::isCanceled);
            }
            this.pendingTasks.addAll(this.queuedTasks);
            this.queuedTasks.clear();
            try {
                for (ScheduledTask scheduledTask : this.pendingTasks) {
                    if (this.getTotalTicks() < scheduledTask.getStartTick() + (long)scheduledTask.getDelay()) continue;
                    scheduledTask.start();
                    if (scheduledTask.isRepeating()) {
                        if (scheduledTask.isCanceled()) continue;
                        scheduledTask.updateDelay(scheduledTask.getPeriod(), true);
                        continue;
                    }
                    scheduledTask.cancel();
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Scheduler ticking error: ", ex);
            }
        }
        profilerFiller.method_15407();
    }

    public synchronized void cancel(int id) {
        this.pendingTasks.forEach(scheduledTask -> {
            if (scheduledTask.getId() == id) {
                scheduledTask.cancel();
            }
        });
    }

    public ScheduledTask scheduleAsyncTask(Consumer<ScheduledTask> task, int delay) {
        return this.scheduleAsyncTask(task, delay, 0);
    }

    public ScheduledTask scheduleAsyncTask(Consumer<ScheduledTask> task, int delay, int period) {
        return this.scheduleTask(task, delay, period, false, true);
    }

    public ScheduledTask scheduleTask(Consumer<ScheduledTask> task, int delay) {
        return this.scheduleTask(task, delay, 0);
    }

    public ScheduledTask scheduleTask(Consumer<ScheduledTask> task, int delay, int period) {
        return this.scheduleTask(task, delay, period, false, false);
    }

    public ScheduledTask scheduleTask(Consumer<ScheduledTask> task, int delay, int period, boolean queued, boolean async) {
        ScheduledTask scheduledTask = new ScheduledTask(task, delay, period, async);
        if (queued) {
            this.queuedTasks.add((Object)scheduledTask);
        } else {
            this.pendingTasks.add((Object)scheduledTask);
        }
        return scheduledTask;
    }
}

