/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.updater;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.updater.CustomUpdateSource;
import com.fix3dll.skyblockaddons.libautoupdate.CurrentVersion;
import com.fix3dll.skyblockaddons.libautoupdate.PotentialUpdate;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateContext;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateData;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateTarget;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.OnlineData;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Updater {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>[0-9])\\.(?<minor>[0-9])\\.(?<patch>[0-9]).*");
    private static final UpdateContext AUTO_UPDATE_CONTEXT = new UpdateContext(new CustomUpdateSource(), UpdateTarget.deleteAndSaveInTheSameFolder(SkyblockAddons.class), CurrentVersion.ofTag(SkyblockAddons.METADATA.getVersion().toString()), "skyblockaddons");
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private SemanticVersion target = null;
    private String messageToRender;
    private String downloadLink;
    private String changelogLink;
    private String note = "";
    private boolean hasUpdate = false;
    private boolean isPatch = false;
    private boolean sentUpdateMessage = false;
    private PotentialUpdate cachedPotentialUpdate = null;
    private boolean updateLaunched = false;

    public Updater() {
        UpdateUtils.patchConnection(urlConnection -> urlConnection.setRequestProperty("User-Agent", Utils.USER_AGENT));
        AUTO_UPDATE_CONTEXT.cleanup();
    }

    public boolean hasSentUpdateMessage() {
        return this.sentUpdateMessage;
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public void checkForUpdate() {
        SemanticVersion current;
        LOGGER.info("Checking to see if an update is available...");
        OnlineData.UpdateInfo updateInfo = main.getOnlineData().getUpdateInfo();
        this.sentUpdateMessage = false;
        main.getRenderListener().setUpdateMessageDisplayed(false);
        if (updateInfo == null) {
            LOGGER.error("Update check failed: Update info is null!");
            return;
        }
        SemanticVersion latestRelease = null;
        SemanticVersion latestBeta = null;
        try {
            current = SemanticVersion.parse((String)SkyblockAddons.METADATA.getVersion().toString());
        }
        catch (VersionParsingException e) {
            LOGGER.error("Version parsing error: {}", (Object)e.getMessage());
            return;
        }
        boolean isCurrentBeta = this.isBetaVersion((Version)current);
        boolean latestReleaseExists = updateInfo.getLatestRelease() != null;
        boolean latestBetaExists = updateInfo.getLatestBeta() != null;
        int releaseDiff = 0;
        int betaDiff = 0;
        if (latestReleaseExists) {
            latestRelease = updateInfo.getLatestRelease();
            releaseDiff = latestRelease.compareTo(current);
        } else {
            if (!isCurrentBeta) {
                LOGGER.error("Update check failed: Current version is a release version and key `latestRelease` is null or empty.");
                return;
            }
            LOGGER.warn("Key `latestRelease` is null or empty, skipping!");
        }
        if (isCurrentBeta) {
            if (latestBetaExists) {
                latestBeta = updateInfo.getLatestBeta();
                betaDiff = latestBeta.compareTo(current);
            } else {
                if (latestRelease == null) {
                    LOGGER.error("Update check failed: Keys `latestRelease` and `latestBeta` are null or empty.");
                    return;
                }
                LOGGER.warn("Key `latestBeta` is null or empty, skipping!");
            }
        }
        Status status = null;
        if (!isCurrentBeta) {
            if (releaseDiff == 0) {
                status = Status.UP_TO_DATE;
            } else if (releaseDiff < 0) {
                status = Status.AHEAD;
            } else {
                status = Status.OUTDATED;
                this.target = latestRelease;
            }
        } else {
            String currentVersionString = current.toString();
            if (latestReleaseExists) {
                try {
                    SemanticVersion currentWithoutPrerelease = SemanticVersion.parse((String)currentVersionString.substring(0, currentVersionString.indexOf(45)));
                    if (releaseDiff > 0 || latestRelease.compareTo(currentWithoutPrerelease) == 0) {
                        status = Status.OUTDATED;
                        this.target = latestRelease;
                    } else if (!latestBetaExists && releaseDiff < 0) {
                        status = Status.AHEAD;
                    } else if (releaseDiff == 0) {
                        LOGGER.warn("The current beta version ({}) matches the latest release version. There is probably something wrong with the online data.", (Object)currentVersionString);
                        status = Status.UP_TO_DATE;
                    }
                }
                catch (VersionParsingException e) {
                    LOGGER.error("Semantic version parsing error: ", (Throwable)e);
                }
            }
            if (status == null) {
                if (betaDiff == 0) {
                    status = Status.UP_TO_DATE;
                } else if (betaDiff < 0) {
                    status = Status.AHEAD;
                } else {
                    status = Status.BETA_OUTDATED;
                    this.target = latestBeta;
                }
            }
        }
        if (status == Status.OUTDATED || status == Status.BETA_OUTDATED) {
            Object autoUpdate = Feature.AUTO_UPDATE.getValue();
            if (autoUpdate == EnumUtils.AutoUpdateMode.STABLE || autoUpdate == EnumUtils.AutoUpdateMode.LATEST) {
                EnumUtils.AutoUpdateMode updateStream = (EnumUtils.AutoUpdateMode)autoUpdate;
                AUTO_UPDATE_CONTEXT.checkUpdate(updateStream.name()).whenComplete((potentialUpdate, throwable) -> {
                    if (potentialUpdate.getUpdate() == null) {
                        Utils.sendMessageOrElseLog("The automatic update check could not be completed because the Online Data was not fetched from the CDN.", LOGGER, true);
                    } else if (throwable != null) {
                        Utils.sendMessageOrElseLog("Auto update check failed!", LOGGER, true);
                        LOGGER.catching(throwable);
                    } else if (potentialUpdate.isUpdateAvailable()) {
                        this.cachedPotentialUpdate = potentialUpdate;
                        int versionNumber = Optional.of(this.cachedPotentialUpdate.getUpdate()).map(UpdateData::getVersionNumber).map(JsonElement::getAsInt).orElse(0);
                        if (versionNumber != 0) {
                            this.note = "";
                            updateInfo.getUpdateNotes().headMap(versionNumber, true).forEach((key, value) -> {
                                int buildNumber = Integer.parseInt(SkyblockAddons.BUILD_NUMBER.split("\\.")[0]);
                                if (class_3544.method_15438((String)value) || buildNumber >= key) {
                                    return;
                                }
                                this.note = this.note + "\u2022 " + value + "\n";
                            });
                        }
                    }
                });
            }
            this.hasUpdate = true;
            LOGGER.info("Found an update: {}", (Object)this.target);
            if (status == Status.OUTDATED) {
                this.downloadLink = updateInfo.getReleaseDownload();
                this.changelogLink = updateInfo.getReleaseChangelog();
            } else {
                this.downloadLink = updateInfo.getBetaDownload();
                this.changelogLink = updateInfo.getBetaChangelog();
            }
            boolean bl = this.isPatch = current.getVersionComponent(0) == this.target.getVersionComponent(0) && current.getVersionComponent(1) == this.target.getVersionComponent(1) && !isCurrentBeta;
            this.messageToRender = this.isPatch ? Translations.getMessage("messages.updateChecker.notificationBox.patchAvailable", this.target) : (status == Status.BETA_OUTDATED ? Translations.getMessage("messages.updateChecker.notificationBox.betaAvailable", this.target) : Translations.getMessage("messages.updateChecker.notificationBox.majorAvailable", this.target));
        } else if (status == Status.AHEAD) {
            if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
                LOGGER.warn("The current version is newer than the latest version. Please tell an SBA developer to update the online data.");
            } else {
                LOGGER.error("The current version is newer than the latest version. You're doing something wrong.");
                LOGGER.error("Current: {}", (Object)current);
                LOGGER.error("Latest: {}", (Object)latestRelease);
                LOGGER.error("Latest Beta: {}", (Object)latestBeta);
                LOGGER.error("Release Diff: {}", (Object)releaseDiff);
                LOGGER.error("Beta Diff: {}", (Object)betaDiff);
            }
        } else {
            LOGGER.info("Up to date!");
        }
    }

    public void sendUpdateMessage() {
        if (this.sentUpdateMessage) {
            return;
        }
        String targetVersion = this.target.toString();
        Utils.sendMessage((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m----------------\u00a77[ \u00a7b\u00a7lSkyblockAddons \u00a77]\u00a77\u00a7m----------------"), false);
        class_5250 newUpdate = class_2561.method_43470((String)String.format("\u00a7b%s\n", Translations.getMessage("messages.updateChecker.newUpdateAvailable", targetVersion)));
        if (!this.note.isEmpty()) {
            class_5250 versionNote = class_2561.method_43470((String)("\n" + String.valueOf(ColorCode.RED) + this.note));
            newUpdate.method_10852((class_2561)versionNote);
        }
        Utils.sendMessage((class_2561)newUpdate, false);
        class_5250 autoDownloadButton = class_2561.method_43470((String)String.format("\u00a7a\u00a7l[%s]", Translations.getMessage("messages.updateChecker.autoDownloadButton", new Object[0])));
        Object autoUpdateValue = Feature.AUTO_UPDATE.getValue();
        if (autoUpdateValue == EnumUtils.AutoUpdateMode.STABLE || autoUpdateValue == EnumUtils.AutoUpdateMode.LATEST) {
            EnumUtils.AutoUpdateMode autoUpdateMode = (EnumUtils.AutoUpdateMode)autoUpdateValue;
            UpdateData currentUpdateData = main.getOnlineData().getUpdateData(autoUpdateMode.name());
            if (this.cachedPotentialUpdate == null) {
                autoDownloadButton = class_2561.method_43470((String)String.format("\u00a78\u00a7m[%s]\u00a7r", Translations.getMessage("messages.updateChecker.autoDownloadButton", new Object[0]))).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.updateChecker.autoUpdateTargetNotFound", new Object[0]))))));
                autoDownloadButton.method_27693(" ");
            } else if (currentUpdateData != null && !class_3544.method_15438((String)currentUpdateData.getVersionName()) && !currentUpdateData.getVersionName().contains(targetVersion)) {
                autoDownloadButton = class_2561.method_43470((String)String.format("\u00a78\u00a7m[%s]\u00a7r", Translations.getMessage("messages.updateChecker.autoDownloadButton", new Object[0]))).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.updateChecker.autoUpdateTargetIsNotUpToDate", new Object[0]))))));
                autoDownloadButton.method_27693(" ");
            } else {
                String targetVersionName = this.cachedPotentialUpdate.getUpdate() == null ? null : this.cachedPotentialUpdate.getUpdate().getVersionName();
                String mcVersionXYZ = class_155.method_16673().comp_4025().split("-")[0];
                if (!class_3544.method_15438((String)targetVersionName) && !targetVersionName.contains(mcVersionXYZ)) {
                    autoDownloadButton = class_2561.method_43470((String)String.format("\u00a78\u00a7m[%s]\u00a7r", Translations.getMessage("messages.updateChecker.autoDownloadButton", new Object[0]))).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.updateChecker.targetIsNotForCurrentMinecraft", mcVersionXYZ))))));
                    autoDownloadButton.method_27693(" ");
                } else if (Feature.FULL_AUTO_UPDATE.isEnabled()) {
                    if (!this.updateLaunched) {
                        Utils.sendMessage(String.valueOf(ColorCode.YELLOW) + Translations.getMessage("messages.updateChecker.autoDownloadStarted", new Object[0]) + "\n", false);
                        this.launchAutoUpdate(this.cachedPotentialUpdate);
                    }
                    autoDownloadButton = class_2561.method_43470((String)"");
                } else {
                    autoDownloadButton.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/sba internal launchAutoUpdate")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.updateChecker.autoDownloadButtonHover", targetVersion))))));
                    autoDownloadButton.method_27693(" ");
                }
            }
        } else {
            autoDownloadButton = class_2561.method_43470((String)"");
        }
        class_5250 downloadButton = class_2561.method_43470((String)String.format("\u00a7b[%s]", Translations.getMessage("messages.updateChecker.downloadButton", new Object[0])));
        if (!class_3544.method_15438((String)this.downloadLink)) {
            downloadButton.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(this.downloadLink))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.clickToOpenLink", new Object[0]))))));
        } else {
            downloadButton.method_27694(style -> style.method_36140(Boolean.valueOf(true)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.updateChecker.noDownloadAvailable", new Object[0]))))));
        }
        autoDownloadButton.method_10852((class_2561)downloadButton).method_27693(" ");
        class_5250 openModsFolderButton = class_2561.method_43470((String)String.format("\u00a7e[%s]", Translations.getMessage("messages.updateChecker.openModFolderButton", new Object[0]))).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/sba folder")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.clickToOpenFolder", new Object[0]))))));
        autoDownloadButton.method_10852((class_2561)openModsFolderButton).method_27693(" ");
        if (!class_3544.method_15438((String)this.changelogLink)) {
            class_5250 changelogButton = class_2561.method_43470((String)String.format(" \u00a79[%s]", Translations.getMessage("messages.updateChecker.changelogButton", new Object[0]))).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(this.changelogLink))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a77" + Translations.getMessage("messages.clickToOpenLink", new Object[0]))))));
            autoDownloadButton.method_10852((class_2561)changelogButton).method_27693(" ");
        }
        Utils.sendMessage((class_2561)autoDownloadButton, false);
        Utils.sendMessage((class_2561)class_2561.method_43470((String)"\u00a77\u00a7m--------------------------------------------------"), false);
        this.sentUpdateMessage = true;
    }

    private boolean isBetaVersion(Version version) {
        String versionString = version.toString();
        return versionString.contains("a") || versionString.contains("b");
    }

    public void launchAutoUpdate() {
        if (this.cachedPotentialUpdate != null && !this.updateLaunched) {
            Utils.sendMessage(String.valueOf(ColorCode.YELLOW) + Translations.getMessage("messages.updateChecker.autoDownloadStarted", new Object[0]));
            this.launchAutoUpdate(this.cachedPotentialUpdate);
        } else {
            LOGGER.warn("cachedPotentialUpdate: {}, updateLaunched: {}", (Object)this.cachedPotentialUpdate, (Object)this.updateLaunched);
        }
    }

    public void launchAutoUpdate(@NotNull PotentialUpdate potentialUpdate) {
        this.updateLaunched = true;
        potentialUpdate.launchUpdate().whenComplete((ignored, throwableUpdate) -> {
            if (throwableUpdate != null) {
                Utils.sendMessageOrElseLog("\u00a7cAuto update failed! See the log for more details.", LOGGER, true);
                LOGGER.catching(throwableUpdate);
            } else {
                Utils.sendMessageOrElseLog("\u00a7aThe update has been downloaded successfully. It will be installed after the reboot.", LOGGER, false);
                this.cachedPotentialUpdate = null;
            }
            this.updateLaunched = false;
        });
    }

    @Generated
    public String getMessageToRender() {
        return this.messageToRender;
    }

    private static enum Status {
        UP_TO_DATE,
        OUTDATED,
        AHEAD,
        BETA_OUTDATED;

    }
}

