/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1439;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

public class EndstoneProtectorManager {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final class_2338 ORIGIN = new class_2338(-689, 5, -273);
    private static boolean canDetectSkull = false;
    private static Stage minibossStage = null;
    private static int zealotCount = 0;
    private static long lastWaveStart = -1L;

    public static void checkGolemStatus() {
        class_638 level = EndstoneProtectorManager.MC.field_1687;
        if (level == null || !LocationUtils.isOn(Island.THE_END) || Feature.ENDSTONE_PROTECTOR_DISPLAY.isDisabled()) {
            canDetectSkull = false;
            return;
        }
        class_2818 chunk = level.method_2935().method_21730(ORIGIN.method_10263() >> 4, ORIGIN.method_10260() >> 4);
        if (chunk == null) {
            canDetectSkull = false;
            return;
        }
        Stage newStage = Stage.detectStage();
        for (class_1297 entity : level.method_18112()) {
            if (!(entity instanceof class_1439)) continue;
            newStage = Stage.GOLEM_ALIVE;
            break;
        }
        canDetectSkull = true;
        if (minibossStage != newStage) {
            int timeTaken = (int)(System.currentTimeMillis() - lastWaveStart);
            int totalSeconds = timeTaken / 1000;
            int minutes = totalSeconds / 60;
            int seconds = totalSeconds % 60;
            String previousStage = minibossStage == null ? "null" : minibossStage.name();
            String zealotsKilled = minibossStage == null ? "N/A" : String.valueOf(zealotCount);
            LOGGER.info("Endstone protector stage updated from {} to {}. Your zealot kill count was {}. This took {}m {}s.", (Object)previousStage, (Object)newStage.name(), (Object)zealotsKilled, (Object)minutes, (Object)seconds);
            if (minibossStage == Stage.GOLEM_ALIVE && newStage == Stage.NO_HEAD) {
                zealotCount = 0;
            }
            minibossStage = newStage;
            lastWaveStart = System.currentTimeMillis();
        }
    }

    public static void onKill() {
        ++zealotCount;
    }

    public static void reset() {
        minibossStage = null;
        zealotCount = 0;
        canDetectSkull = false;
    }

    @Generated
    public static boolean isCanDetectSkull() {
        return canDetectSkull;
    }

    @Generated
    public static Stage getMinibossStage() {
        return minibossStage;
    }

    @Generated
    public static int getZealotCount() {
        return zealotCount;
    }

    public static enum Stage {
        NO_HEAD(-1),
        STAGE_1(0),
        STAGE_2(1),
        STAGE_3(2),
        STAGE_4(3),
        STAGE_5(4),
        GOLEM_ALIVE(-1);

        private final int blocksUp;
        private static Stage lastStage;
        private static class_2338 lastPos;
        private static final ExecutorService EXECUTOR;

        private Stage(int blocksUp) {
            this.blocksUp = blocksUp;
        }

        public static Stage detectStage() {
            EXECUTOR.submit(() -> {
                try {
                    class_638 level = class_310.method_1551().field_1687;
                    if (level == null) {
                        return;
                    }
                    if (lastStage != null && lastPos != null && level.method_8320(lastPos).method_27852(class_2246.field_10432)) {
                        return;
                    }
                    for (Stage stage : Stage.values()) {
                        if (stage.blocksUp == -1) continue;
                        for (int x = -749; x < -602; ++x) {
                            for (int z = -353; z < -202; ++z) {
                                class_2338 blockPos = new class_2338(x, 5 + stage.blocksUp, z);
                                if (!level.method_8320(blockPos).method_27852(class_2246.field_10432)) continue;
                                lastStage = stage;
                                lastPos = blockPos;
                                return;
                            }
                        }
                    }
                    lastStage = NO_HEAD;
                    lastPos = null;
                }
                catch (Throwable ex) {
                    LOGGER.catching(ex);
                }
            });
            return lastStage;
        }

        static {
            lastStage = null;
            lastPos = null;
            EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(SkyblockAddons.METADATA.getName() + " - Endstone Protector #%d").build());
        }
    }
}

