/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class ItemDropChecker {
    private static final long DROP_CONFIRMATION_TIMEOUT = 3000L;
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static class_1799 itemOfLastDropAttempt;
    private static long timeOfLastDropAttempt;
    private static int attemptsRequiredToConfirm;

    public static boolean canDropItem(class_1799 item) {
        return ItemDropChecker.canDropItem(item, false);
    }

    public static boolean canDropItem(class_1735 slot) {
        if (slot != null && slot.method_7681()) {
            return ItemDropChecker.canDropItem(slot.method_7677());
        }
        return true;
    }

    public static boolean canDropItem(class_1799 item, boolean itemIsInHotbar) {
        return ItemDropChecker.canDropItem(item, itemIsInHotbar, true);
    }

    public static boolean canDropItem(class_1799 item, boolean itemIsInHotbar, boolean playAlert) {
        if (main.getUtils().isOnSkyblock()) {
            String itemID = ItemUtils.getSkyblockItemID(item);
            SkyblockRarity itemRarity = ItemUtils.getRarity(item);
            if (itemID == null) {
                return true;
            }
            if (itemRarity == null) {
                return true;
            }
            List<String> blacklist = main.getOnlineData().getDropSettings().getDontDropTheseItems();
            List<String> whitelist = main.getOnlineData().getDropSettings().getAllowDroppingTheseItems();
            if (itemIsInHotbar) {
                if (itemRarity.compareTo(main.getOnlineData().getDropSettings().getMinimumHotbarRarity()) < 0 && !blacklist.contains(itemID)) {
                    return true;
                }
                if (whitelist.contains(itemID)) {
                    return true;
                }
                if (playAlert) {
                    ItemDropChecker.playAlert();
                }
                return false;
            }
            if (itemRarity.compareTo(main.getOnlineData().getDropSettings().getMinimumInventoryRarity()) < 0 && !blacklist.contains(itemID)) {
                return true;
            }
            if (whitelist.contains(itemID)) {
                return true;
            }
            return ItemDropChecker.dropConfirmed(item, 3, playAlert);
        }
        if (Feature.DROP_CONFIRMATION.isEnabled(FeatureSetting.DROP_CONFIRMATION_IN_OTHER_GAMES)) {
            return ItemDropChecker.dropConfirmed(item, 2, playAlert);
        }
        return true;
    }

    public static boolean dropConfirmed(class_1799 item, int numberOfActions, boolean playAlert) {
        if (item == null) {
            throw new NullPointerException("Item cannot be null!");
        }
        if (numberOfActions < 2) {
            throw new IllegalArgumentException("At least two attempts are required.");
        }
        if (itemOfLastDropAttempt == null) {
            itemOfLastDropAttempt = item;
            timeOfLastDropAttempt = class_156.method_658();
            attemptsRequiredToConfirm = numberOfActions - 1;
            ItemDropChecker.onDropConfirmationFail();
            return false;
        }
        if (class_156.method_658() - timeOfLastDropAttempt > 3000L || !class_1799.method_7973((class_1799)item, (class_1799)itemOfLastDropAttempt)) {
            ItemDropChecker.resetDropConfirmation();
            return ItemDropChecker.dropConfirmed(item, numberOfActions, playAlert);
        }
        if (attemptsRequiredToConfirm >= 1) {
            ItemDropChecker.onDropConfirmationFail();
            return false;
        }
        ItemDropChecker.resetDropConfirmation();
        return true;
    }

    public static void onDropConfirmationFail() {
        ColorCode colorCode = Feature.DROP_CONFIRMATION.getRestrictedColor();
        if (attemptsRequiredToConfirm >= 2) {
            String multipleAttemptsRequiredMessage = Translations.getMessage("messages.clickMoreTimes", Integer.toString(attemptsRequiredToConfirm));
            Utils.sendMessage(String.valueOf(colorCode) + multipleAttemptsRequiredMessage);
        } else {
            String oneMoreAttemptRequiredMessage = Translations.getMessage("messages.clickOneMoreTime", new Object[0]);
            Utils.sendMessage(String.valueOf(colorCode) + oneMoreAttemptRequiredMessage);
        }
        ItemDropChecker.playAlert();
        --attemptsRequiredToConfirm;
    }

    public static void playAlert() {
        main.getUtils().playLoudSound((class_3414)class_3417.field_14624.comp_349(), 0.5);
    }

    public static void resetDropConfirmation() {
        itemOfLastDropAttempt = null;
        timeOfLastDropAttempt = 0L;
        attemptsRequiredToConfirm = 0;
    }
}

