/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.PetInfo;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.features.backpacks.CompressedStorage;
import com.fix3dll.skyblockaddons.features.backpacks.ContainerPreviewManager;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.PetItem;
import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class PetManager {
    private static final Pattern PET_LEVEL_PATTERN = Pattern.compile("(\u00a77\\[Lvl )(?<level>\\d+)(] )(\u00a78\\[\u00a7.)?(?<cosmeticLevel>\\d+)?(.*)");
    private static final Pattern FAVORITE_PATTERN = Pattern.compile("(?i)(\u00a7r)?\u00a7e\u2b50 ");
    private static final PetManager instance = new PetManager();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static Map<String, PetItem> petItems;

    public void checkCurrentPet(class_310 mc) {
        class_437 class_4372;
        if (!main.getUtils().isOnSkyblock()) {
            return;
        }
        boolean petsUpdated = false;
        if (main.getInventoryUtils().getInventoryType() == InventoryType.PETS && (class_4372 = mc.field_1755) instanceof class_476) {
            class_476 containerScreen = (class_476)class_4372;
            class_2371 inventory = ((class_1707)containerScreen.method_17577()).method_7602();
            if (inventory.size() < 54) {
                return;
            }
            int pageNum = main.getInventoryUtils().getInventoryPageNum();
            for (int i = 10; i < inventory.size() - 10; ++i) {
                Pet pet;
                class_1799 item = (class_1799)inventory.get(i);
                if (item == class_1799.field_8037 || item.method_65130() == null || (pet = this.getPetFromItemStack(item)) == null) continue;
                int sbaPetIndex = i + 45 * (pageNum == 0 ? 0 : pageNum - 1);
                Pet oldPet = main.getPetCacheManager().getPet(sbaPetIndex);
                if (oldPet != null && oldPet.getItemStack() != null && oldPet.displayName.equals(pet.displayName) && oldPet.petInfo.equals(pet.petInfo)) continue;
                main.getPetCacheManager().putPet(sbaPetIndex, pet);
                petsUpdated = true;
            }
        }
        if (petsUpdated) {
            main.getPetCacheManager().saveValues();
        }
    }

    public void findCurrentPetFromAutopet(String levelString, String rarityColor, String petName) {
        int level = Integer.parseInt(levelString);
        ColorCode color = ColorCode.getByChar(rarityColor.charAt(0));
        SkyblockRarity rarity = SkyblockRarity.getByColorCode(color);
        for (Pet pet : main.getPetCacheManager().getPetCache().getPetMap().values()) {
            if (!TextUtils.stripPetName(pet.displayName).equals(petName) || pet.petLevel != level || pet.petInfo.getPetRarity() != rarity) continue;
            main.getPetCacheManager().setCurrentPet(pet);
        }
    }

    public void updateAndSetCurrentLevelledPet(int newLevel, String rarityColor, String petName) {
        ColorCode color = ColorCode.getByChar(rarityColor.charAt(0));
        SkyblockRarity rarity = SkyblockRarity.getByColorCode(color);
        Pet currentPet = main.getPetCacheManager().getCurrentPet();
        for (Map.Entry petEntry : main.getPetCacheManager().getPetCache().getPetMap().int2ObjectEntrySet()) {
            Matcher m;
            int index = (Integer)petEntry.getKey();
            Pet pet = (Pet)petEntry.getValue();
            if (!TextUtils.stripPetName(pet.displayName).equals(petName) || pet.petInfo.getPetRarity() != rarity || !(m = PET_LEVEL_PATTERN.matcher(pet.displayName)).matches()) continue;
            boolean isCurrentPet = currentPet != null && currentPet.petInfo.getUniqueId() == pet.petInfo.getUniqueId();
            String cosmeticLevelGroup = m.group("cosmeticLevel");
            if (pet.petLevel >= newLevel) continue;
            if (cosmeticLevelGroup != null) {
                int cosmeticLevel = newLevel - pet.petLevel;
                pet.displayName = m.group(1) + m.group(2) + m.group(3) + m.group(4) + cosmeticLevel + m.group(6);
            } else {
                pet.petLevel = newLevel;
                pet.displayName = m.group(1) + newLevel + m.group(3) + m.group(6);
            }
            main.getPetCacheManager().putPet(index, pet);
            main.getPetCacheManager().saveValues();
            if (!isCurrentPet) continue;
            main.getPetCacheManager().setCurrentPet(pet);
        }
    }

    public void updatePetItem(String rarityColor, String petItem) {
        String petItemId = this.getPetIdFromDisplayName("\u00a7" + rarityColor + petItem);
        if (petItemId == null) {
            return;
        }
        Pet currentPet = main.getPetCacheManager().getCurrentPet();
        for (Map.Entry petEntry : main.getPetCacheManager().getPetCache().getPetMap().int2ObjectEntrySet()) {
            int index = (Integer)petEntry.getKey();
            Pet pet = (Pet)petEntry.getValue();
            if (pet.petInfo.getUniqueId() != currentPet.petInfo.getUniqueId()) continue;
            pet.petInfo.setHeldItemId(petItemId);
            main.getPetCacheManager().putPet(index, pet);
            main.getPetCacheManager().setCurrentPet(pet);
        }
    }

    public Pet getPetFromItemStack(class_1799 itemStack) {
        if (itemStack.method_65130() == null) {
            return null;
        }
        String displayName = FAVORITE_PATTERN.matcher(TextUtils.getFormattedText(itemStack.method_65130(), true)).replaceAll("");
        int petLevel = TextUtils.getPetLevelFromDisplayName(displayName);
        if (petLevel == -1) {
            return null;
        }
        PetInfo petInfo = ItemUtils.getPetInfo(itemStack);
        if (petInfo != null) {
            Pet oldPet = main.getPetCacheManager().getCurrentPet();
            Pet newPet = new Pet(itemStack, displayName, petLevel, petInfo);
            if (!(!petInfo.isActive() || oldPet != null && oldPet.getItemStack() != null && oldPet.displayName.equals(displayName) && oldPet.petInfo.equals(petInfo))) {
                main.getPetCacheManager().setCurrentPet(newPet);
            }
            return newPet;
        }
        return null;
    }

    public class_1799 getPetItemFromId(String petItemId) {
        PetItem petItem = petItems.get(petItemId);
        if (petItem != null) {
            return petItem.getItemStack();
        }
        return new class_1799((class_1935)class_2246.field_10340.method_8389());
    }

    public String getPetItemDisplayNameFromId(String petItemId) {
        PetItem petItem = petItems.get(petItemId);
        if (petItem != null) {
            return petItem.getDisplayName();
        }
        return "\u00a7cNot Found!";
    }

    public SkyblockRarity getPetItemRarityFromId(String petItemId) {
        PetItem petItem = petItems.get(petItemId);
        if (petItem != null) {
            return petItem.getRarity();
        }
        return SkyblockRarity.ADMIN;
    }

    public String getPetIdFromDisplayName(String petItemDisplayName) {
        for (Map.Entry<String, PetItem> petItem : petItems.entrySet()) {
            if (!petItem.getValue().getDisplayName().equals(petItemDisplayName)) continue;
            return petItem.getKey();
        }
        return null;
    }

    @Generated
    public static PetManager getInstance() {
        return instance;
    }

    @Generated
    public static void setPetItems(Map<String, PetItem> petItems) {
        PetManager.petItems = petItems;
    }

    public static class Pet {
        private String displayName;
        private int petLevel;
        private PetInfo petInfo;
        private CompressedStorage compressedStorage = new CompressedStorage();
        @Expose(serialize=false, deserialize=false)
        private class_1799 itemStack;

        public Pet(class_1799 stack, String displayName, int petLevel, PetInfo petInfo) {
            this.displayName = displayName;
            this.petLevel = petLevel;
            this.petInfo = petInfo;
            this.compressedStorage.setStorage(ItemUtils.getCompressedNBT(new class_1799[]{stack}).method_10521());
            this.itemStack = stack;
        }

        public class_1799 getItemStack() {
            List<class_1799> list;
            if (this.itemStack == null && this.compressedStorage != null && !(list = ContainerPreviewManager.decompressItems(this.compressedStorage.getStorage())).isEmpty()) {
                this.itemStack = list.getFirst();
            }
            return this.itemStack;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public int getPetLevel() {
            return this.petLevel;
        }

        @Generated
        public PetInfo getPetInfo() {
            return this.petInfo;
        }

        @Generated
        public CompressedStorage getCompressedStorage() {
            return this.compressedStorage;
        }
    }
}

