/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.cooldowns;

import com.fix3dll.skyblockaddons.features.cooldowns.CooldownEntry;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_3544;

public class CooldownManager {
    private static Object2IntOpenHashMap<String> itemCooldowns = new Object2IntOpenHashMap();
    private static final Pattern ITEM_COOLDOWN_PATTERN = Pattern.compile("Cooldown: ([0-9]+)s");
    private static final Pattern ALTERNATE_COOLDOWN_PATTERN = Pattern.compile("([0-9]+) Second Cooldown");
    private static final Object2ObjectOpenHashMap<String, CooldownEntry> cooldowns = new Object2ObjectOpenHashMap();

    private static CooldownEntry get(class_1799 item) {
        return CooldownManager.get(ItemUtils.getSkyblockItemID(item));
    }

    private static CooldownEntry get(String itemId) {
        return (CooldownEntry)cooldowns.getOrDefault((Object)itemId, (Object)CooldownEntry.NULL_ENTRY);
    }

    public static int getItemCooldown(class_1799 item) {
        return itemCooldowns.getOrDefault((Object)ItemUtils.getSkyblockItemID(item), 0);
    }

    public static int getItemCooldown(String itemId) {
        return itemCooldowns.getOrDefault((Object)itemId, 0);
    }

    public static void put(class_1799 item) {
        String itemId = ItemUtils.getSkyblockItemID(item);
        CooldownManager.put(itemId);
    }

    public static void put(String itemId) {
        if (class_3544.method_15438((String)itemId)) {
            return;
        }
        int cooldown = itemCooldowns.getOrDefault((Object)itemId, 0);
        if (cooldown > 0) {
            CooldownManager.put(itemId, (long)cooldown);
        }
    }

    public static void put(class_1799 item, long cooldown) {
        String itemId = ItemUtils.getSkyblockItemID(item);
        if (itemId != null && cooldown > 0L) {
            CooldownManager.put(itemId, cooldown);
        }
    }

    public static void put(String itemId, long cooldown) {
        if (cooldown < 0L) {
            throw new IllegalArgumentException("Cooldown must be positive and not 0");
        }
        if (!cooldowns.containsKey((Object)itemId) || !((CooldownEntry)cooldowns.get((Object)itemId)).isOnCooldown()) {
            CooldownEntry cooldownEntry = new CooldownEntry(cooldown);
            cooldowns.put((Object)itemId, (Object)cooldownEntry);
        }
    }

    public static void remove(String itemId) {
        cooldowns.put((Object)itemId, (Object)CooldownEntry.NULL_ENTRY);
    }

    public static boolean isOnCooldown(class_1799 item) {
        return CooldownManager.get(item).isOnCooldown();
    }

    public static boolean isOnCooldown(String itemId) {
        return CooldownManager.get(itemId).isOnCooldown();
    }

    public static long getRemainingCooldown(class_1799 item) {
        return CooldownManager.get(item).getRemainingCooldown();
    }

    public static long getRemainingCooldown(String itemId) {
        return CooldownManager.get(itemId).getRemainingCooldown();
    }

    public static double getRemainingCooldownPercent(class_1799 item) {
        return CooldownManager.get(item).getRemainingCooldownPercent();
    }

    public static double getRemainingCooldownPercent(String itemId) {
        return CooldownManager.get(itemId).getRemainingCooldownPercent();
    }

    private static int getLoreCooldown(class_1799 itemStack) {
        for (String loreLine : ItemUtils.getItemLore(itemStack)) {
            String strippedLoreLine = TextUtils.stripColor(loreLine);
            Matcher matcher = ITEM_COOLDOWN_PATTERN.matcher(strippedLoreLine);
            if (matcher.matches()) {
                try {
                    return Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            matcher = ALTERNATE_COOLDOWN_PATTERN.matcher(strippedLoreLine);
            if (!matcher.matches()) continue;
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    @Generated
    public static void setItemCooldowns(Object2IntOpenHashMap<String> itemCooldowns) {
        CooldownManager.itemCooldowns = itemCooldowns;
    }
}

