/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.deployable;

import com.fix3dll.skyblockaddons.features.deployable.Deployable;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_310;

public class DeployableManager {
    private static final DeployableManager instance = new DeployableManager();
    private static final Pattern POWER_ORB_PATTERN = Pattern.compile("[A-Za-z ]* (?<seconds>[0-9]*)s");
    public static class_1531 DUMMY_ARMOR_STAND = new class_1531(class_1299.field_6131, (class_1937)class_310.method_1551().field_1687);
    public static DeployableEntry DUMMY_DEPLOYABLE_ENTRY;
    private final Map<Deployable, DeployableEntry> deployableEntryMap = new HashMap<Deployable, DeployableEntry>();

    private void put(Deployable deployable, int seconds, UUID uuid) {
        this.deployableEntryMap.put(deployable, new DeployableEntry(deployable, seconds, uuid));
    }

    public DeployableEntry getActiveDeployable() {
        Optional max = this.deployableEntryMap.entrySet().stream().filter(deployableEntryEntry -> ((DeployableEntry)deployableEntryEntry.getValue()).timestamp + 100L > System.currentTimeMillis()).max(Map.Entry.comparingByKey());
        return max.map(Map.Entry::getValue).orElse(null);
    }

    public void detectDeployables(class_1531 entityArmorStand) {
        if (entityArmorStand.method_5797() != null) {
            Matcher matcher;
            class_310 mc = class_310.method_1551();
            if (entityArmorStand.method_5797() == null) {
                return;
            }
            String customNameTag = entityArmorStand.method_5797().getString();
            Deployable orb = Deployable.getByDisplayName(customNameTag);
            if (orb != null && orb.isInRadius(entityArmorStand.method_5858((class_1297)mc.field_1724)) && (matcher = POWER_ORB_PATTERN.matcher(customNameTag)).matches()) {
                int seconds;
                try {
                    seconds = Integer.parseInt(matcher.group("seconds"));
                }
                catch (NumberFormatException ex) {
                    return;
                }
                if (mc.field_1687 == null) {
                    return;
                }
                List surroundingArmorStands = mc.field_1687.method_8390(class_1531.class, new class_238(entityArmorStand.method_23317() - 0.1, entityArmorStand.method_23318() - 1.0, entityArmorStand.method_23321() - 0.1, entityArmorStand.method_23317() + 0.1, entityArmorStand.method_23318() + 1.0, entityArmorStand.method_23321() + 0.1), armorStandEntity -> armorStandEntity.method_6118(class_1304.field_6169) != class_1799.field_8037);
                if (!surroundingArmorStands.isEmpty()) {
                    class_1531 orbArmorStand = (class_1531)surroundingArmorStands.getFirst();
                    this.put(orb, seconds, orbArmorStand == null ? null : orbArmorStand.method_5667());
                }
            }
        } else if (entityArmorStand.method_5767()) {
            class_1799 headItem = entityArmorStand.method_6118(class_1304.field_6169);
            if (headItem == class_1799.field_8037) {
                return;
            }
            String skullTexture = ItemUtils.getSkullTexture(headItem);
            String decodedTextureUrl = TextUtils.decodeSkinTexture(skullTexture, true);
            if (decodedTextureUrl == null) {
                return;
            }
            Deployable flare = Deployable.getByTextureId(decodedTextureUrl);
            if (flare != null && flare.isInRadius(entityArmorStand.method_5858((class_1297)class_310.method_1551().field_1724))) {
                int seconds = 180;
                this.put(flare, seconds -= entityArmorStand.field_6012 * 50 / 1000, entityArmorStand.method_5667());
            }
        }
    }

    @Generated
    public static DeployableManager getInstance() {
        return instance;
    }

    static {
        DUMMY_ARMOR_STAND.method_5673(class_1304.field_6169, ItemUtils.getTexturedHead("SOS_FLARE"));
        DUMMY_ARMOR_STAND.method_5648(true);
        DUMMY_DEPLOYABLE_ENTRY = new DeployableEntry(Deployable.SOS_FLARE, 90, DUMMY_ARMOR_STAND.method_5667());
    }

    public static class DeployableEntry {
        private final Deployable deployable;
        private final int seconds;
        private final long timestamp = System.currentTimeMillis();
        private final UUID uuid;

        @Generated
        public Deployable getDeployable() {
            return this.deployable;
        }

        @Generated
        public int getSeconds() {
            return this.seconds;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @Generated
        public DeployableEntry(Deployable deployable, int seconds, UUID uuid) {
            this.deployable = deployable;
            this.seconds = seconds;
            this.uuid = uuid;
        }
    }
}

