/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.discordrpc;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockDate;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.discordipc.IPCClient;
import com.fix3dll.skyblockaddons.discordipc.IPCListener;
import com.fix3dll.skyblockaddons.discordipc.entities.ActivityType;
import com.fix3dll.skyblockaddons.discordipc.entities.DiscordBuild;
import com.fix3dll.skyblockaddons.discordipc.entities.Packet;
import com.fix3dll.skyblockaddons.discordipc.entities.RichPresence;
import com.fix3dll.skyblockaddons.discordipc.entities.User;
import com.fix3dll.skyblockaddons.features.discordrpc.DiscordStatus;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import lombok.Generated;
import org.apache.logging.log4j.Logger;

public class DiscordRPCManager
implements IPCListener {
    private FeatureSetting currentStatus;
    private static final long APPLICATION_ID = 653443797182578707L;
    private static final long UPDATE_PERIOD = 4200L;
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private IPCClient client;
    private DiscordStatus detailsLine;
    private DiscordStatus stateLine;
    private long startTimestamp;
    private Timer updateTimer;
    private boolean connected;

    public void start() {
        SkyblockAddons.runAsync(() -> {
            try {
                LOGGER.info("Starting Discord RPC...");
                if (this.isActive()) {
                    return;
                }
                this.stateLine = (DiscordStatus)Feature.DISCORD_RPC.get(FeatureSetting.DISCORD_RP_STATE);
                this.detailsLine = (DiscordStatus)Feature.DISCORD_RPC.get(FeatureSetting.DISCORD_RP_DETAILS);
                this.startTimestamp = System.currentTimeMillis();
                this.client = new IPCClient(653443797182578707L);
                this.client.setListener(this);
                try {
                    this.client.connect(new DiscordBuild[0]);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to connect to Discord RPC!", (Throwable)ex);
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Discord RPC has thrown an unexpected error while trying to start...", ex);
            }
        });
    }

    public void stop() {
        SkyblockAddons.runAsync(() -> {
            if (this.isActive()) {
                this.connected = false;
                this.client.close();
            }
        });
    }

    public boolean isActive() {
        return this.client != null && this.connected;
    }

    public void updatePresence() {
        String location = SkyblockAddons.getInstance().getUtils().getLocation();
        SkyblockDate skyblockDate = SkyblockAddons.getInstance().getUtils().getCurrentDate();
        String skyblockDateString = skyblockDate != null ? skyblockDate.toString() : "";
        String largeImageDescription = String.format("%s - %s", skyblockDateString, location);
        String smallImageDescription = String.format("Using SkyblockAddons v%s", SkyblockAddons.METADATA.getVersion());
        RichPresence presence = new RichPresence.Builder().setState(this.stateLine.getDisplayString(FeatureSetting.DISCORD_RP_CUSTOM_STATE)).setDetails(this.detailsLine.getDisplayString(FeatureSetting.DISCORD_RP_CUSTOM_DETAILS)).setStartTimestamp(this.startTimestamp).setLargeImage(location.toLowerCase(Locale.ENGLISH).replaceAll(" ", "-"), largeImageDescription).setSmallImage("skyblockicon", smallImageDescription).setActivityType(ActivityType.Playing).build();
        this.client.sendRichPresence(presence);
    }

    public void setStateLine(DiscordStatus status) {
        this.stateLine = status;
        if (this.isActive()) {
            this.updatePresence();
        }
    }

    public void setDetailsLine(DiscordStatus status) {
        this.detailsLine = status;
        if (this.isActive()) {
            this.updatePresence();
        }
    }

    private void cancelTimer() {
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
            this.updateTimer = null;
        }
    }

    @Override
    public void onReady(IPCClient client) {
        LOGGER.info("Discord RPC started.");
        this.connected = true;
        this.updateTimer = new Timer();
        this.updateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DiscordRPCManager.this.updatePresence();
            }
        }, 0L, 4200L);
    }

    @Override
    public void onClose(IPCClient client, JsonObject json) {
        LOGGER.info("Discord RPC closed.");
        this.client = null;
        this.connected = false;
        this.cancelTimer();
    }

    @Override
    public void onDisconnect(IPCClient client, Throwable t) {
        LOGGER.warn("Discord RPC disconnected.");
        this.client = null;
        this.connected = false;
        this.cancelTimer();
    }

    @Override
    public void onPacketSent(IPCClient client, Packet packet) {
    }

    @Override
    public void onPacketReceived(IPCClient client, Packet packet) {
    }

    @Override
    public void onActivityJoin(IPCClient client, String secret) {
    }

    @Override
    public void onActivitySpectate(IPCClient client, String secret) {
    }

    @Override
    public void onActivityJoinRequest(IPCClient client, String secret, User user) {
    }

    @Generated
    public FeatureSetting getCurrentStatus() {
        return this.currentStatus;
    }

    @Generated
    public void setCurrentStatus(FeatureSetting currentStatus) {
        this.currentStatus = currentStatus;
    }
}

