/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.discordrpc;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.PlayerStat;
import com.fix3dll.skyblockaddons.core.SkyblockDate;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public enum DiscordStatus implements ButtonCycling.SelectItem,
RegistrableEnum
{
    NONE("discordStatus.titleNone", "discordStatus.descriptionNone", () -> null),
    LOCATION("discordStatus.titleLocation", "discordStatus.descriptionLocation", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        String location = main.getUtils().getLocation();
        Island map = main.getUtils().getMap();
        String prefix = main.getUtils().isOnRift() ? "\u0444 " : "\u23e3 ";
        switch (map) {
            case PRIVATE_ISLAND: {
                if (main.getUtils().isGuest()) {
                    return "Visiting " + location.trim();
                }
                return "\u23e3 Private Island";
            }
            case GARDEN: {
                if (main.getUtils().isGuest()) {
                    return "Visiting The Garden";
                }
                String display = prefix + location;
                String plotName = main.getUtils().getPlotName();
                if (!plotName.isEmpty()) {
                    display = display + " - " + plotName;
                }
                return display;
            }
        }
        return prefix + location;
    }),
    PURSE("discordStatus.titlePurse", "discordStatus.descriptionPurse", () -> {
        double coins = SkyblockAddons.getInstance().getUtils().getPurse();
        return TextUtils.formatNumber(coins) + " Coin" + (coins == 1.0 ? "" : "s");
    }),
    BITS("discordStatus.titleBits", "discordStatus.descriptionBits", () -> {
        double bits = SkyblockAddons.getInstance().getUtils().getBits();
        return TextUtils.formatNumber(bits) + " Bit" + (bits == 1.0 ? "" : "s");
    }),
    MOTES("discordStatus.titleMotes", "discordStatus.descriptionMotes", () -> {
        double motes = SkyblockAddons.getInstance().getUtils().getMotes();
        return TextUtils.formatNumber(motes) + " Mote" + (motes == 1.0 ? "" : "s");
    }),
    STATS("discordStatus.titleStats", "discordStatus.descriptionStats", () -> {
        String health = TextUtils.formatNumber(Float.valueOf(PlayerStat.HEALTH.getValue()));
        String defense = TextUtils.formatNumber(Float.valueOf(PlayerStat.DEFENCE.getValue()));
        String mana = TextUtils.formatNumber(Float.valueOf(PlayerStat.MANA.getValue()));
        return String.format("%s\u2764 %s\u2748 %s\u270e", health, defense, mana);
    }),
    ZEALOTS("discordStatus.titleZealots", "discordStatus.descriptionZealots", () -> String.format("%d Zealots killed", SkyblockAddons.getInstance().getPersistentValuesManager().getPersistentValues().getKills())),
    ITEM("discordStatus.titleItem", "discordStatus.descriptionItem", () -> {
        class_2561 itemName;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_6047() != class_1799.field_8037 && (itemName = player.method_6047().method_65130()) != null) {
            return String.format("Holding %s", itemName.getString());
        }
        return "No item in hand";
    }),
    TIME("discordStatus.titleTime", "discordStatus.descriptionTime", () -> {
        SkyblockDate date = SkyblockAddons.getInstance().getUtils().getCurrentDate();
        return date != null ? date.toString() : "";
    }),
    PROFILE("discordStatus.titleProfile", "discordStatus.descriptionProfile", () -> {
        String profile = SkyblockAddons.getInstance().getUtils().getProfileName();
        return String.format("Profile: %s", profile == null ? "None" : profile);
    }),
    CUSTOM("discordStatus.titleCustom", "discordStatus.descriptionCustom", () -> {
        FeatureSetting currentStatus = SkyblockAddons.getInstance().getDiscordRPCManager().getCurrentStatus();
        if (currentStatus == null) {
            return "!!";
        }
        String text = Feature.DISCORD_RPC.getAsString(currentStatus);
        return text.substring(0, Math.min(text.length(), 100));
    }),
    AUTO_STATUS("discordStatus.titleAuto", "discordStatus.descriptionAuto", () -> {
        SkyblockAddons main = SkyblockAddons.getInstance();
        EnumUtils.SlayerQuest slayerQuest = main.getUtils().getSlayerQuest();
        if (slayerQuest != null && LocationUtils.isOnSlayerLocation(slayerQuest)) {
            return (main.getUtils().isSlayerBossAlive() ? "Slaying a " : "Doing a ") + slayerQuest.getScoreboardName() + " " + main.getUtils().getSlayerQuestLevel() + " boss.";
        }
        if (LocationUtils.isOnZealotSpawnLocation()) {
            return DiscordStatus.ZEALOTS.displayMessageSupplier.get();
        }
        if (main.getUtils().isOnRift()) {
            return DiscordStatus.valueOf((String)"MOTES").displayMessageSupplier.get();
        }
        Feature feature = Feature.DISCORD_RPC;
        if ("AUTO_STATUS".equals(feature.getAsEnum(FeatureSetting.DISCORD_RP_AUTO_MODE).name())) {
            feature.set(FeatureSetting.DISCORD_RP_AUTO_MODE, NONE);
        }
        DiscordStatus mode = (DiscordStatus)feature.getAsEnum(FeatureSetting.DISCORD_RP_AUTO_MODE);
        return mode.displayMessageSupplier.get();
    });

    private final String title;
    private final String description;
    private final Supplier<String> displayMessageSupplier;

    private DiscordStatus(String titleTranslationKey, String descriptionTranslationKey, Supplier<String> displayMessageSupplier) {
        this.title = titleTranslationKey;
        this.description = descriptionTranslationKey;
        this.displayMessageSupplier = displayMessageSupplier;
    }

    public String getDisplayString(FeatureSetting currentStatus) {
        SkyblockAddons.getInstance().getDiscordRPCManager().setCurrentStatus(currentStatus);
        return this.displayMessageSupplier.get();
    }

    @Override
    public String getDisplayName() {
        return Translations.getMessage(this.title, new Object[0]);
    }

    @Override
    public String getDescription() {
        return Translations.getMessage(this.description, new Object[0]);
    }
}

