/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.dungeonmap;

import com.fix3dll.skyblockaddons.features.dungeonmap.DungeonMapManager;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_21;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_9428;

public class MapMarker {
    private class_9428 decorationType;
    private float x;
    private float y;
    private float rotation;
    private String playerName;
    private String mapMarkerName;
    private boolean wearingHat;

    public MapMarker(@NonNull class_1657 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.playerName = player.method_7334().name();
        this.wearingHat = player.method_74091(class_1664.field_7563);
        this.decorationType = player == class_310.method_1551().field_1724 ? (class_9428)class_21.field_95.comp_349() : (class_9428)class_21.field_83.comp_349();
        this.updateXZRot(player);
    }

    public MapMarker(class_9428 decorationType, float x, float y, float rotation) {
        this.decorationType = decorationType;
        this.x = x;
        this.y = y;
        this.rotation = rotation;
    }

    public class_1657 getPlayer() {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            for (class_742 player : world.method_18456()) {
                if (!player.method_7334().name().equals(this.playerName)) continue;
                return player;
            }
        }
        return null;
    }

    public void updateXZRot(@NonNull class_1657 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.x = DungeonMapManager.toMapCoordinate(player.method_23317(), DungeonMapManager.getMarkerOffsetX());
        this.y = DungeonMapManager.toMapCoordinate(player.method_23321(), DungeonMapManager.getMarkerOffsetZ());
        this.rotation = class_3532.method_15393((float)player.method_36454()) / 360.0f * 16.0f;
    }

    @Generated
    public class_9428 getDecorationType() {
        return this.decorationType;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getRotation() {
        return this.rotation;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public String getMapMarkerName() {
        return this.mapMarkerName;
    }

    @Generated
    public boolean isWearingHat() {
        return this.wearingHat;
    }

    @Generated
    public void setDecorationType(class_9428 decorationType) {
        this.decorationType = decorationType;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    @Generated
    public void setWearingHat(boolean wearingHat) {
        this.wearingHat = wearingHat;
    }

    @Generated
    public String toString() {
        return "MapMarker(decorationType=" + String.valueOf(this.getDecorationType()) + ", x=" + this.getX() + ", y=" + this.getY() + ", rotation=" + this.getRotation() + ", playerName=" + this.getPlayerName() + ", mapMarkerName=" + this.getMapMarkerName() + ", wearingHat=" + this.isWearingHat() + ")";
    }

    @Generated
    public void setMapMarkerName(String mapMarkerName) {
        this.mapMarkerName = mapMarkerName;
    }
}

