/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.dungeons;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.EssenceType;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.events.RenderEntityOutlineEvent;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonClass;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonMilestone;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonPlayer;
import com.fix3dll.skyblockaddons.features.healingcircle.HealingCircle;
import com.fix3dll.skyblockaddons.features.tablist.TabStringType;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.ParseException;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class DungeonManager {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final Pattern PATTERN_MILESTONE = Pattern.compile("^.+?(Healer|Tank|Mage|Archer|Berserk) Milestone .+?([\u2776-\u277f]).+?\u00a7r\u00a7.([\\d,]+)");
    private static final Pattern PATTERN_COLLECTED_ESSENCES = Pattern.compile("\u00a7.+?(\\d+) (Wither|Spider|Undead|Dragon|Gold|Diamond|Ice|Crimson) Essence");
    private static final Pattern PATTERN_BONUS_ESSENCE = Pattern.compile("^\u00a7.+?[^You] .+?found a .+?(Wither|Spider|Undead|Dragon|Gold|Diamond|Ice|Crimson) Essence.+?");
    private static final Pattern PATTERN_SALVAGE_ESSENCES = Pattern.compile("\\+(?<essenceNum>[0-9]+) (?<essenceType>Wither|Spider|Undead|Dragon|Gold|Diamond|Ice|Crimson) Essence!");
    private static final Pattern PATTERN_SECRETS = Pattern.compile("\u00a77([0-9]+)/([0-9]+) Secrets");
    private static final Pattern PATTERN_PLAYER_LINE = Pattern.compile("\u00a7.\\[(?<classLetter>.)] (?<name>[\\w\u00a7]+) \u00a7(?<healthColor>.)(?:\u00a7l)?(?<health>[\\w,\u00a7]+)(?:[\u00a7c\u2764]{0,3})?");
    private static final Pattern PATTERN_PLAYER_LIST_INFO_DEATHS = Pattern.compile("Team Deaths: (?<deaths>\\d+)");
    private static final Pattern PATTERN_STRIP_FORMAT = Pattern.compile("\u00a7.?");
    private static final class_2960 CRITICAL = SkyblockAddons.resourceLocation("critical.png");
    private static final int CRITICAL_ICON_SIZE = 25;
    private String lastServerId;
    private DungeonMilestone dungeonMilestone;
    private final EnumMap<EssenceType, Integer> collectedEssences = new EnumMap(EssenceType.class);
    private final EnumMap<EssenceType, Integer> salvagedEssences = new EnumMap(EssenceType.class);
    private final Object2ObjectOpenHashMap<String, DungeonPlayer> teammates = new Object2ObjectOpenHashMap();
    private int secrets = -1;
    private int maxSecrets;
    private EssenceType lastEssenceType;
    private int lastEssenceAmount;
    private int lastEssenceRepeat;
    private int deaths;
    private int alternateDeaths;
    private int playerListInfoDeaths;
    private Pair<DungeonClass, Integer> thePlayerClass = null;
    private static final Function<class_1297, Integer> OUTLINE_COLOR = e -> {
        if (e instanceof class_745) {
            class_745 remotePlayer = (class_745)e;
            if (main.getUtils().isInDungeon()) {
                String profileName = remotePlayer.method_7334().name();
                DungeonPlayer teammate = SkyblockAddons.getInstance().getDungeonManager().getDungeonPlayerByName(profileName);
                if (teammate != null) {
                    if (Feature.SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY.isEnabled(FeatureSetting.CLASS_COLORED_TEAMMATE)) {
                        return teammate.getDungeonClass().getColor();
                    }
                    if (teammate.isCritical()) {
                        return ColorCode.RED.getColor();
                    }
                    if (teammate.isLow()) {
                        return ColorCode.YELLOW.getColor();
                    }
                }
                return null;
            }
        }
        return null;
    };

    public DungeonManager() {
        RenderEntityOutlineEvent.EVENT.register(this::onRenderEntityOutlines);
    }

    public void reset() {
        this.dungeonMilestone = null;
        this.collectedEssences.clear();
        this.teammates.clear();
        this.thePlayerClass = null;
        this.deaths = 0;
        this.alternateDeaths = 0;
        this.playerListInfoDeaths = 0;
        HealingCircle.setRadius(0.0f);
    }

    public DungeonPlayer getDungeonPlayerByName(String name) {
        return (DungeonPlayer)this.teammates.get((Object)name);
    }

    public DungeonMilestone parseMilestone(String message) {
        Matcher matcher = PATTERN_MILESTONE.matcher(message);
        if (!matcher.lookingAt()) {
            return null;
        }
        DungeonClass dungeonClass = DungeonClass.fromDisplayName(matcher.group(1));
        return new DungeonMilestone(dungeonClass, matcher.group(2), matcher.group(3));
    }

    public void addEssence(String message) {
        Matcher matcher = PATTERN_COLLECTED_ESSENCES.matcher(message);
        while (matcher.find()) {
            int amount = Integer.parseInt(matcher.group(1));
            EssenceType essenceType = EssenceType.fromName(matcher.group(2));
            if (this.lastEssenceType != null && this.lastEssenceAmount == amount && this.lastEssenceType == essenceType) {
                ++this.lastEssenceRepeat;
                if (this.lastEssenceRepeat != 3) continue;
                this.lastEssenceType = null;
                continue;
            }
            this.lastEssenceType = essenceType;
            this.lastEssenceAmount = amount;
            this.lastEssenceRepeat = 1;
            if (essenceType == null) continue;
            this.collectedEssences.put(essenceType, this.collectedEssences.getOrDefault((Object)essenceType, 0) + amount);
        }
    }

    public void addBonusEssence(String message) {
        Matcher matcher = PATTERN_BONUS_ESSENCE.matcher(message);
        if (matcher.matches()) {
            EssenceType essenceType = EssenceType.fromName(matcher.group(1));
            this.collectedEssences.put(essenceType, this.collectedEssences.getOrDefault((Object)essenceType, 0) + 1);
        }
    }

    public void addSecrets(String message) {
        Matcher matcher = PATTERN_SECRETS.matcher(message);
        if (!matcher.find()) {
            this.secrets = -1;
            this.maxSecrets = 0;
            return;
        }
        this.secrets = Integer.parseInt(matcher.group(1));
        this.maxSecrets = Integer.parseInt(matcher.group(2));
        SkyblockAddons.getInstance().getPlayerListener().getActionBarParser().getStringsToRemove().add(matcher.group());
    }

    public void addSalvagedEssences(String message) {
        Matcher matcher = PATTERN_SALVAGE_ESSENCES.matcher(message);
        while (matcher.find()) {
            EssenceType essenceType = EssenceType.fromName(matcher.group("essenceType"));
            int amount = Integer.parseInt(matcher.group("essenceNum"));
            this.salvagedEssences.put(essenceType, this.salvagedEssences.getOrDefault((Object)essenceType, 0) + amount);
        }
    }

    public void setSalvagedEssences(EssenceType type, String number) {
        int amount = 0;
        try {
            amount = TextUtils.NUMBER_FORMAT.parse(number).intValue();
        }
        catch (ParseException ex) {
            LOGGER.error("Failed to parse " + type.getNiceName() + " essence amount: ", (Throwable)ex);
        }
        this.salvagedEssences.put(type, amount);
    }

    public void updateDungeonPlayer(String scoreboardLine) {
        Matcher matcher = PATTERN_PLAYER_LINE.matcher(scoreboardLine);
        if (matcher.find()) {
            int health;
            String name = TextUtils.stripColor(matcher.group("name"));
            class_746 playerEntity = DungeonManager.MC.field_1724;
            if (playerEntity == null || name.equals(playerEntity.method_7334().name())) {
                return;
            }
            DungeonClass dungeonClass = DungeonClass.fromFirstLetter(matcher.group("classLetter").charAt(0));
            ColorCode healthColor = ColorCode.getByChar(matcher.group("healthColor").charAt(0));
            String healthText = PATTERN_STRIP_FORMAT.matcher(matcher.group("health")).replaceAll("");
            if (healthText.equals("DEAD")) {
                health = 0;
            } else {
                try {
                    health = TextUtils.NUMBER_FORMAT.parse(healthText).intValue();
                }
                catch (ParseException ex) {
                    LOGGER.error("Failed to parse playerEntity " + name + " health: " + healthText, (Throwable)ex);
                    return;
                }
            }
            for (DungeonPlayer player : this.teammates.values()) {
                if (!player.getName().startsWith(name)) continue;
                player.setHealthColor(healthColor);
                if (player.getHealth() > 0 && health == 0) {
                    this.addAlternateDeath();
                }
                player.setHealth(health);
                return;
            }
            class_634 networkHandler = MC.method_1562();
            if (networkHandler == null) {
                return;
            }
            for (class_640 playerListEntry : networkHandler.method_2880()) {
                String profileName = playerListEntry.method_2966().name();
                if (!profileName.startsWith(name)) continue;
                this.teammates.put((Object)profileName, (Object)new DungeonPlayer(profileName, dungeonClass, healthColor, health, playerListEntry.method_2966().id()));
            }
        }
    }

    public int getDeathCount() {
        if (this.isPlayerListInfoEnabled()) {
            return this.playerListInfoDeaths;
        }
        return Math.max(this.deaths, this.alternateDeaths);
    }

    public void addDeath() {
        ++this.deaths;
    }

    public void addAlternateDeath() {
        ++this.alternateDeaths;
    }

    public void updateDeathsFromPlayerListInfo() {
        String deathDisplayString;
        Matcher deathDisplayMatcher;
        class_634 networkHandler = MC.method_1562();
        if (networkHandler == null) {
            return;
        }
        class_640 deathDisplayPlayerInfo = networkHandler.method_2874("!B-f");
        if (deathDisplayPlayerInfo != null && deathDisplayPlayerInfo.method_2971() != null && (deathDisplayMatcher = PATTERN_PLAYER_LIST_INFO_DEATHS.matcher(deathDisplayString = deathDisplayPlayerInfo.method_2971().getString())).matches()) {
            this.playerListInfoDeaths = Integer.parseInt(deathDisplayMatcher.group("deaths"));
        }
    }

    public boolean isPlayerListInfoEnabled() {
        class_634 networkHandler = MC.method_1562();
        if (networkHandler == null) {
            return false;
        }
        List networkPlayerInfoList = networkHandler.method_2880().stream().limit(10L).toList();
        for (class_640 networkPlayerInfo : networkPlayerInfoList) {
            String username = networkPlayerInfo.method_2966().name();
            if (!username.startsWith("!")) continue;
            return true;
        }
        return false;
    }

    public boolean onRenderNameTag(class_10055 state, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        class_243 vec3 = state.field_53338;
        class_2561 nameTag = state.field_53337;
        if (nameTag == null || vec3 == null || DungeonManager.MC.field_1724 == null || TabStringType.usernameFromLine(nameTag.getString()).equals(DungeonManager.MC.field_1724.method_7334().name())) {
            return false;
        }
        boolean nameOverlayEnabled = Feature.SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY.isEnabled();
        boolean criticalOverlayEnabled = Feature.SHOW_CRITICAL_DUNGEONS_TEAMMATES.isEnabled();
        class_638 level = DungeonManager.MC.field_1687;
        if (level != null && main.getUtils().isOnSkyblock() && main.getUtils().isInDungeon() && (criticalOverlayEnabled || nameOverlayEnabled)) {
            class_1297 cameraEntity = MC.method_1560();
            class_742 player = null;
            DungeonPlayer dungeonPlayer = null;
            for (DungeonPlayer teammate : this.teammates.values()) {
                class_742 playerEntity;
                class_1297 class_12972;
                if (!TabStringType.usernameFromLine(nameTag.getString()).equals(teammate.getName()) || !((class_12972 = level.method_66347(teammate.getEntityId())) instanceof class_742)) continue;
                player = playerEntity = (class_742)class_12972;
                dungeonPlayer = teammate;
                break;
            }
            if (cameraEntity != null && cameraEntity != player && dungeonPlayer != null) {
                boolean canceled = false;
                float distanceScale = Math.max(1.0f, (float)cameraEntity.method_73189().method_1022(player.method_73189()) / 5.0f);
                poseStack.method_22903();
                poseStack.method_22905(distanceScale, distanceScale, distanceScale);
                poseStack.method_22904(0.0, -vec3.field_1351 + (double)(1.8f / distanceScale), 0.0);
                if (criticalOverlayEnabled && !dungeonPlayer.isGhost() && (dungeonPlayer.isCritical() || dungeonPlayer.isLow())) {
                    poseStack.method_22903();
                    poseStack.method_46416(0.0f, 1.23625f, 0.0f);
                    poseStack.method_22904(vec3.field_1352, vec3.field_1351 + 0.5, vec3.field_1350);
                    poseStack.method_22907((Quaternionfc)cameraRenderState.field_63081);
                    poseStack.method_22905(0.025f, -0.025f, 0.025f);
                    submitNodeCollector.method_73483(poseStack, class_1921.method_65216((class_2960)CRITICAL), (pose, vertexConsumer) -> DrawUtils.blitAbsolute(pose, vertexConsumer, -12.5f, 0.0f, 0.0f, 0.0f, 25.0f, 25.0f, 25.0f, 25.0f, -1));
                    poseStack.method_22909();
                    String text = dungeonPlayer.isLow() ? String.valueOf(ColorCode.YELLOW) + "LOW" : (dungeonPlayer.isCritical() ? String.valueOf(ColorCode.RED) + "CRITICAL" : null);
                    if (text != null) {
                        poseStack.method_22903();
                        poseStack.method_46416(0.0f, 0.5175f, 0.0f);
                        submitNodeCollector.method_73482(poseStack, vec3, 0, (class_2561)class_2561.method_43470((String)text), true, 0xF000F0, state.field_53332, cameraRenderState);
                        poseStack.method_22909();
                    }
                    canceled = true;
                }
                if (!dungeonPlayer.isGhost() && dungeonPlayer.getDungeonClass() != null && nameOverlayEnabled) {
                    class_5250 playerName = class_2561.method_43470((String)dungeonPlayer.getName());
                    int classColor = dungeonPlayer.getDungeonClass().getColor();
                    if (classColor == ColorCode.CHROMA.getColor()) {
                        if (Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.FADE) {
                            playerName.method_27694(style -> style.method_27703(DrawUtils.CHROMA_TEXT_COLOR));
                        } else {
                            playerName.method_54663(ManualChromaManager.getChromaColor(0.0f, 0.0f, 255));
                        }
                    } else {
                        playerName.method_54663(classColor);
                    }
                    String dungeonClass = String.valueOf(ColorCode.YELLOW) + "[" + dungeonPlayer.getDungeonClass().getFirstLetter() + "] ";
                    class_5250 playerNameTag = class_2561.method_43470((String)dungeonClass).method_10852((class_2561)playerName);
                    poseStack.method_22903();
                    String health = dungeonPlayer.getHealth() + " " + String.valueOf(ColorCode.RED) + "\u2764";
                    submitNodeCollector.method_73482(poseStack, vec3, 0, (class_2561)class_2561.method_43470((String)health), true, 0xF000F0, state.field_53332, cameraRenderState);
                    poseStack.method_46416(0.0f, 0.25875f, 0.0f);
                    submitNodeCollector.method_73482(poseStack, vec3, 0, (class_2561)playerNameTag, true, 0xF000F0, state.field_53332, cameraRenderState);
                    poseStack.method_22909();
                    canceled = true;
                }
                poseStack.method_22909();
                return canceled;
            }
        }
        return false;
    }

    private void onRenderEntityOutlines(RenderEntityOutlineEvent e) {
        if (e.getType() == RenderEntityOutlineEvent.Type.XRAY) {
            e.queueEntitiesToOutline(OUTLINE_COLOR);
        }
    }

    @Generated
    public String getLastServerId() {
        return this.lastServerId;
    }

    @Generated
    public void setLastServerId(String lastServerId) {
        this.lastServerId = lastServerId;
    }

    @Generated
    public DungeonMilestone getDungeonMilestone() {
        return this.dungeonMilestone;
    }

    @Generated
    public void setDungeonMilestone(DungeonMilestone dungeonMilestone) {
        this.dungeonMilestone = dungeonMilestone;
    }

    @Generated
    public EnumMap<EssenceType, Integer> getCollectedEssences() {
        return this.collectedEssences;
    }

    @Generated
    public EnumMap<EssenceType, Integer> getSalvagedEssences() {
        return this.salvagedEssences;
    }

    @Generated
    public Object2ObjectOpenHashMap<String, DungeonPlayer> getTeammates() {
        return this.teammates;
    }

    @Generated
    public int getSecrets() {
        return this.secrets;
    }

    @Generated
    public void setSecrets(int secrets) {
        this.secrets = secrets;
    }

    @Generated
    public int getMaxSecrets() {
        return this.maxSecrets;
    }

    @Generated
    public void setMaxSecrets(int maxSecrets) {
        this.maxSecrets = maxSecrets;
    }

    @Generated
    public int getDeaths() {
        return this.deaths;
    }

    @Generated
    public int getAlternateDeaths() {
        return this.alternateDeaths;
    }

    @Generated
    public int getPlayerListInfoDeaths() {
        return this.playerListInfoDeaths;
    }

    @Generated
    public Pair<DungeonClass, Integer> getThePlayerClass() {
        return this.thePlayerClass;
    }

    @Generated
    public void setThePlayerClass(Pair<DungeonClass, Integer> thePlayerClass) {
        this.thePlayerClass = thePlayerClass;
    }
}

