/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.fishing;

import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.mixin.extensions.WakeParticleExtension;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1536;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_738;
import net.minecraft.class_9848;

public class FishParticleManager {
    private static final class_310 MC = class_310.method_1551();
    private static final double DIST_EXPECTED = 0.1;
    private static final double DIST_VARIATION = 0.005;
    private static final double ANGLE_EXPECTED = 12.0;
    private static final int TIME_VARIATION = 4;
    private static final double MAX_DISTANCE = 8.0;
    private static final int MIN_TRAIL_LENGTH = 4;
    private static final int MAX_PARTICLE_AGE = 100;
    private static final int MAX_ACTIVE_PARTICLES = 64;
    private static final Map<Long, ParticleNode> particleMap = new Long2ObjectLinkedOpenHashMap();
    private static final Deque<ParticleNode> recentParticles = new ArrayDeque<ParticleNode>();
    private static final Set<ParticleNode> trailHeads = new HashSet<ParticleNode>();
    private static final Map<ParticleNode, List<ParticleNode>> graph = new HashMap<ParticleNode, List<ParticleNode>>();
    private static final Map<ParticleNode, Integer> maxPathCache = new Object2IntOpenHashMap();

    public static void onFishWakeSpawn(class_1536 hook, class_738 fishWakeParticle) {
        long zBits;
        class_638 level = FishParticleManager.MC.field_1687;
        if (level == null) {
            return;
        }
        if (hook == null || hook.field_6012 == 0) {
            FishParticleManager.clearParticleCache();
            return;
        }
        double xCoord = fishWakeParticle.field_3874;
        double zCoord = fishWakeParticle.field_3871;
        double distToHook = Math.sqrt((xCoord - hook.method_23317()) * (xCoord - hook.method_23317()) + (zCoord - hook.method_23321()) * (zCoord - hook.method_23321()));
        if (distToHook > 8.0) {
            return;
        }
        long xBits = Double.doubleToLongBits(xCoord);
        long hash = 31L * (713L + xBits) + (zBits = Double.doubleToLongBits(zCoord));
        ParticleNode existingNode = particleMap.get(hash);
        if (existingNode != null) {
            existingNode.particles.add(fishWakeParticle);
            return;
        }
        long currentTime = level.method_8510();
        FishParticleManager.cleanOldParticles(currentTime);
        double angle = class_3532.method_15349((double)(xCoord - hook.method_23317()), (double)(zCoord - hook.method_23321())) * 180.0 / Math.PI;
        ParticleNode newNode = new ParticleNode(xCoord, zCoord, distToHook, angle, currentTime, Collections.singletonList(fishWakeParticle), hash);
        ArrayList<ParticleNode> parents = new ArrayList<ParticleNode>();
        for (ParticleNode candidate : recentParticles) {
            if (newNode.isCompatibleWith(candidate, currentTime)) {
                parents.add(candidate);
            }
            if (!candidate.isCompatibleWith(newNode, currentTime)) continue;
            graph.computeIfAbsent(candidate, k -> new ArrayList()).add(newNode);
        }
        particleMap.put(hash, newNode);
        recentParticles.addFirst(newNode);
        graph.put(newNode, parents);
        FishParticleManager.calculateTrails();
        FishParticleManager.updateOverlay();
    }

    private static void cleanOldParticles(long currentTime) {
        ParticleNode oldest;
        HashSet<ParticleNode> nodesToEvict = new HashSet<ParticleNode>();
        while (!recentParticles.isEmpty()) {
            oldest = recentParticles.peekLast();
            if (currentTime - oldest.spawnTime <= 100L) break;
            recentParticles.removeLast();
            nodesToEvict.add(oldest);
        }
        while (recentParticles.size() > 64) {
            oldest = recentParticles.removeLast();
            nodesToEvict.add(oldest);
        }
        if (nodesToEvict.isEmpty()) {
            return;
        }
        for (ParticleNode nodeToEvict : nodesToEvict) {
            particleMap.remove(nodeToEvict.hash);
            graph.remove(nodeToEvict);
            trailHeads.remove(nodeToEvict);
            maxPathCache.remove(nodeToEvict);
        }
    }

    private static void calculateTrails() {
        maxPathCache.clear();
        trailHeads.clear();
        HashSet<ParticleNode> processedNodes = new HashSet<ParticleNode>();
        for (ParticleNode node : recentParticles) {
            int pathLen = FishParticleManager.getMaxPathLengthDfs(node, processedNodes, Sets.newIdentityHashSet());
            if (pathLen < 4) continue;
            trailHeads.add(node);
        }
    }

    private static int getMaxPathLengthDfs(ParticleNode node, Set<ParticleNode> processedNodes, Set<ParticleNode> visiting) {
        if (!visiting.add(node)) {
            return 0;
        }
        Integer cachedLength = maxPathCache.get(node);
        if (cachedLength != null) {
            visiting.remove(node);
            return cachedLength;
        }
        processedNodes.add(node);
        List<ParticleNode> parents = graph.get(node);
        int maxParentLength = 0;
        if (parents != null && !parents.isEmpty()) {
            for (ParticleNode parent : parents) {
                int parentLen;
                if (!particleMap.containsKey(parent.hash) || (parentLen = FishParticleManager.getMaxPathLengthDfs(parent, processedNodes, visiting)) <= maxParentLength) continue;
                maxParentLength = parentLen;
            }
        }
        visiting.remove(node);
        int myLength = 1 + maxParentLength;
        maxPathCache.put(node, myLength);
        return myLength;
    }

    private static void updateOverlay() {
        if (trailHeads.isEmpty()) {
            return;
        }
        int color = Feature.COLORED_FISHING_PARTICLES.getColor();
        float rCol = class_9848.method_65101((int)color);
        float gCol = class_9848.method_65102((int)color);
        float bCol = class_9848.method_65103((int)color);
        boolean biggerWake = Feature.COLORED_FISHING_PARTICLES.isEnabled(FeatureSetting.BIGGER_WAKE);
        for (ParticleNode head : trailHeads) {
            for (class_738 particle : head.particles) {
                ((WakeParticleExtension)particle).sba$setBlankSprite(true);
                if (biggerWake) {
                    particle.method_3087(1.1f);
                }
                particle.method_74305(rCol, gCol, bCol);
            }
        }
    }

    public static void clearParticleCache() {
        particleMap.clear();
        recentParticles.clear();
        trailHeads.clear();
        graph.clear();
        maxPathCache.clear();
    }

    private static class ParticleNode {
        final double x;
        final double z;
        final double distance;
        final double angle;
        final long spawnTime;
        final List<class_738> particles;
        final long hash;

        ParticleNode(double x, double z, double dist, double angle, long time, List<class_738> particles, long hash) {
            this.x = x;
            this.z = z;
            this.distance = dist;
            this.angle = angle;
            this.spawnTime = time;
            this.particles = new ArrayList<class_738>(particles);
            this.hash = hash;
        }

        boolean isCompatibleWith(ParticleNode other, long currentTime) {
            long timeDiff = this.spawnTime - other.spawnTime;
            if (timeDiff <= 0L || timeDiff > 4L) {
                return false;
            }
            if (currentTime - other.spawnTime > 100L) {
                return false;
            }
            double anglDiff = Math.abs(this.angle - other.angle) % 360.0;
            double d = anglDiff > 180.0 ? 360.0 - anglDiff : anglDiff;
            if (d >= 12.0) {
                return false;
            }
            double distDiff1 = Math.abs(other.distance - this.distance - 0.1);
            double distDiff2 = Math.abs(other.distance - this.distance - 0.2);
            return distDiff1 < 0.005 || distDiff2 < 0.005;
        }

        public int hashCode() {
            return Long.hashCode(this.hash);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hash == ((ParticleNode)obj).hash;
        }
    }
}

