/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.buttons;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.gui.buttons.SkyblockAddonsButton;
import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9848;

public class ButtonStepper
extends SkyblockAddonsButton {
    private static final float WIDTH_LIMIT = 90.0f;
    public static final int SPACER = 5;
    private final Consumer<Modifier> callback;
    private boolean hitMaximum = false;

    public ButtonStepper(double x, double y, int width, int height, String displayString, Consumer<Modifier> callback) {
        super((int)x, (int)y, width, height, (class_2561)class_2561.method_43470((String)displayString));
        if (callback == null) {
            throw new IllegalArgumentException("ButtonStepper's callback cannot be null!");
        }
        this.callback = callback;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int boxColor;
        this.field_22762 = this.method_25405(mouseX, mouseY);
        for (Modifier modifier : Modifier.values()) {
            int boxAlpha;
            int fontColor;
            boolean isHovered;
            this.hitMaximum = this.hitMaximum(modifier, mouseX, mouseY);
            boolean bl = isHovered = modifier == Modifier.SUBTRACT ? this.isOverSubtractButton(mouseX, mouseY) : this.isOverAddButton(mouseX, mouseY);
            if (isHovered && !this.hitMaximum) {
                fontColor = class_9848.method_61317((float)1.0f);
                boxAlpha = 170;
            } else {
                fontColor = class_9848.method_61324((int)255, (int)255, (int)255, (int)160);
                boxAlpha = 100;
            }
            if (this.hitMaximum) {
                boxColor = ColorCode.GRAY.getColor(boxAlpha);
                fontColor = class_9848.method_61324((int)255, (int)255, (int)255, (int)160);
            } else {
                boxColor = modifier == Modifier.SUBTRACT ? ColorCode.RED.getColor(boxAlpha) : ColorCode.GREEN.getColor(boxAlpha);
            }
            int startX = modifier == Modifier.SUBTRACT ? this.method_46426() : this.method_46426() + this.field_22758 - this.field_22759;
            this.drawButtonBoxAndText(graphics, modifier.message, startX, this.method_46427(), this.field_22759, this.field_22759, boxColor, 1.0f, fontColor);
        }
        boxColor = main.getUtils().getDefaultColor(100.0f);
        int stringWidth = ButtonStepper.MC.field_1772.method_27525((class_5348)this.method_25369());
        int textBoxWidth = this.field_22758 - 2 * (5 + this.field_22759);
        float scale = (float)stringWidth > 90.0f ? 1.0f / ((float)stringWidth / 90.0f) : 1.0f;
        this.drawButtonBoxAndText(graphics, this.method_25369(), this.method_46426() + this.field_22759 + 5, this.method_46427(), textBoxWidth, this.field_22759, boxColor, scale, ColorCode.WHITE.getColor());
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (event.method_74245() == 0) {
            if (this.isOverSubtractButton(event.comp_4798(), event.comp_4799())) {
                this.callback.accept(Modifier.SUBTRACT);
                if (!this.hitMaximum(Modifier.SUBTRACT, event.comp_4798(), event.comp_4799())) {
                    this.method_25354(MC.method_1483());
                }
                return true;
            }
            if (this.isOverAddButton(event.comp_4798(), event.comp_4799())) {
                this.callback.accept(Modifier.ADD);
                if (!this.hitMaximum(Modifier.ADD, event.comp_4798(), event.comp_4799())) {
                    this.method_25354(MC.method_1483());
                }
                return true;
            }
        }
        return false;
    }

    private boolean hitMaximum(Modifier modifier, double mouseX, double mouseY) {
        int warningSeconds = Feature.WARNING_TIME.numberValue().intValue();
        return switch (modifier.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.isOverSubtractButton(mouseX, mouseY) && warningSeconds == 1) {
                    yield true;
                }
                yield false;
            }
            case 1 -> this.isOverAddButton(mouseX, mouseY) && warningSeconds == 99;
        };
    }

    private boolean isOverSubtractButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22759) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    private boolean isOverAddButton(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + this.field_22758 - this.field_22759) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    public static enum Modifier {
        SUBTRACT("-"),
        ADD("+");

        private final class_2561 message;

        private Modifier(String message) {
            this.message = class_2561.method_43470((String)message);
        }
    }
}

