/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.enchants.EnchantLayout;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonArrow;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonText;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonOpenColorMenu;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonSettingToggle;
import com.fix3dll.skyblockaddons.gui.screens.SettingsGui;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class EnchantmentSettingsGui
extends SettingsGui {
    private static final EnumSet<FeatureSetting> ENCHANT_COLORING = EnumSet.of(FeatureSetting.HIGHLIGHT_ENCHANTMENTS, new FeatureSetting[]{FeatureSetting.PERFECT_ENCHANT_COLOR, FeatureSetting.GREAT_ENCHANT_COLOR, FeatureSetting.GOOD_ENCHANT_COLOR, FeatureSetting.POOR_ENCHANT_COLOR, FeatureSetting.COMMA_ENCHANT_COLOR});
    private static final EnumSet<FeatureSetting> ORGANIZATION = EnumSet.of(FeatureSetting.ENCHANT_LAYOUT, FeatureSetting.HIDE_ENCHANTMENT_LORE, FeatureSetting.HIDE_GREY_ENCHANTS);
    private int maxPage = 1;

    public EnchantmentSettingsGui(int page, int lastPage, EnumUtils.GuiTab lastTab) {
        super(Feature.ENCHANTMENT_LORE_PARSING, page, lastPage, lastTab, EnumUtils.GUIType.MAIN);
        if (this.feature.hasSettings()) {
            for (FeatureSetting setting : this.feature.getFeatureData().getSettings().keySet()) {
                if (ENCHANT_COLORING.contains((Object)setting) || ORGANIZATION.contains((Object)setting)) continue;
                this.maxPage = 2;
                break;
            }
        } else {
            throw new IllegalStateException("Unexpected feature on EnchantmentSettingsGui: " + String.valueOf((Object)this.feature));
        }
    }

    @Override
    public void method_25426() {
        this.row = 1.0f;
        this.column = 1;
        this.method_37067();
        for (FeatureSetting setting : this.feature.getFeatureData().getSettings().keySet()) {
            switch (this.page) {
                case 0: {
                    if (!ORGANIZATION.contains((Object)setting)) break;
                    this.addButton(setting);
                    break;
                }
                case 1: {
                    if (!ENCHANT_COLORING.contains((Object)setting)) break;
                    this.addButton(setting);
                    break;
                }
                case 2: {
                    if (ENCHANT_COLORING.contains((Object)setting) || ORGANIZATION.contains((Object)setting)) break;
                    this.addButton(setting);
                }
            }
        }
        this.row += 0.4f;
        this.addScrollIgnoredButton(new ButtonArrow((double)this.field_22789 / 2.0 - 15.0 - 150.0, this.field_22790 - 70, ButtonArrow.ArrowType.LEFT, this.page == 0));
        this.addScrollIgnoredButton(new ButtonArrow((double)this.field_22789 / 2.0 - 15.0 + 150.0, this.field_22790 - 70, ButtonArrow.ArrowType.RIGHT, this.page == this.maxPage));
        this.addSocials(this::addScrollIgnoredButton);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void addButton(FeatureSetting setting) {
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 100;
        int x = halfWidth - boxWidth / 2;
        double y = this.getRowHeightSetting(this.row);
        switch (setting) {
            case COLOR: {
                this.method_37063((class_364)new ButtonOpenColorMenu((double)x, y, 100, 20, Translations.getMessage("settings.changeColor", new Object[0]), this.feature));
                break;
            }
            case PERFECT_ENCHANT_COLOR: 
            case GREAT_ENCHANT_COLOR: 
            case GOOD_ENCHANT_COLOR: 
            case POOR_ENCHANT_COLOR: 
            case COMMA_ENCHANT_COLOR: {
                this.method_37063((class_364)new ButtonOpenColorMenu((double)x, y, 100, 20, setting.getMessage(new String[0]), setting));
                break;
            }
            case ENCHANT_LAYOUT: {
                boxWidth = 140;
                x = halfWidth - boxWidth / 2;
                EnchantLayout currentStatus = (EnchantLayout)this.feature.getAsEnum(FeatureSetting.ENCHANT_LAYOUT);
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, Translations.getMessage("enchantLayout.title", new Object[0]), true, -1));
                this.method_37063((class_364)new ButtonCycling(x, (int)y, boxWidth, 20, Arrays.asList(EnchantLayout.values()), currentStatus.ordinal(), index -> {
                    EnchantLayout enchantLayout = EnchantLayout.values()[index];
                    this.feature.set(setting, enchantLayout);
                    this.reInit = true;
                }));
                this.row += 0.4f;
                break;
            }
            default: {
                boxWidth = 31;
                x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, setting.getMessage(new String[0]), setting));
            }
        }
        this.row += 1.0f;
    }
}

