/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockDate;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCustomToggle;
import com.fix3dll.skyblockaddons.gui.buttons.IslandButton;
import com.fix3dll.skyblockaddons.gui.buttons.IslandMarkerButton;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.time.Month;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import org.joml.Matrix3x2fStack;

public class IslandWarpGui
extends SkyblockAddonsScreen {
    private static Marker doubleWarpMarker;
    private static final class_1041 WINDOW;
    private static int TOTAL_WIDTH;
    private static int TOTAL_HEIGHT;
    public static float SHIFT_LEFT;
    public static float SHIFT_TOP;
    private Marker selectedMarker;
    public static float ISLAND_SCALE;
    public static float IMAGE_SCALED_DOWN_FACTOR;

    public IslandWarpGui() {
        super((class_2561)class_2561.method_43473());
    }

    public void method_25426() {
        super.method_25426();
        for (Island island : Island.values()) {
            if (island == Island.JERRYS_WORKSHOP && main.getUtils().getCurrentDate().getMonth() != SkyblockDate.SkyblockMonth.LATE_WINTER && SkyblockAddons.getHypixelZonedDateTime().getMonth() != Month.DECEMBER) continue;
            this.method_37063((class_364)new IslandButton(island));
        }
        int screenWidth = MC.method_22683().method_4489();
        int screenHeight = MC.method_22683().method_4506();
        ISLAND_SCALE = 6.481481E-4f * (float)screenHeight;
        float totalWidth = (float)TOTAL_WIDTH * ISLAND_SCALE;
        float totalHeight = (float)TOTAL_HEIGHT * ISLAND_SCALE;
        SHIFT_LEFT = ((float)screenWidth / 2.0f - totalWidth / 2.0f) / ISLAND_SCALE;
        SHIFT_TOP = ((float)screenHeight / 2.0f - totalHeight / 2.0f) / ISLAND_SCALE;
        int x = Math.round((float)screenWidth / ISLAND_SCALE - SHIFT_LEFT - 475.0f);
        int y = Math.round((float)screenHeight / ISLAND_SCALE - SHIFT_TOP);
        this.method_37063((class_364)new ButtonCustomToggle((double)x, (double)(y - 30 - 120), 50, Feature.FANCY_WARP_MENU::isEnabled, () -> Feature.FANCY_WARP_MENU.setEnabled(Feature.FANCY_WARP_MENU.isDisabled())));
        this.method_37063((class_364)new ButtonCustomToggle((double)x, (double)(y - 30 - 60), 50, () -> Feature.FANCY_WARP_MENU.isEnabled(FeatureSetting.DOUBLE_WARP), () -> Feature.FANCY_WARP_MENU.set(FeatureSetting.DOUBLE_WARP, Feature.FANCY_WARP_MENU.isDisabled(FeatureSetting.DOUBLE_WARP))));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_71048();
        this.drawGradientBackground(graphics, Math.round(85.0f), Math.round(127.5f));
        graphics.method_25300(IslandWarpGui.MC.field_1772, Translations.getMessage("warpMenu.click", new Object[0]), WINDOW.method_4486() / 2, 10, -1);
        graphics.method_25300(IslandWarpGui.MC.field_1772, Translations.getMessage("warpMenu.mustUnlock", new Object[0]), WINDOW.method_4486() / 2, 20, -1);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        ISLAND_SCALE = 6.481481E-4f * (float)WINDOW.method_4506();
        poseStack.scale(1.0f / (float)WINDOW.method_4495());
        poseStack.scale(ISLAND_SCALE);
        float totalWidth = (float)TOTAL_WIDTH * ISLAND_SCALE;
        float totalHeight = (float)TOTAL_HEIGHT * ISLAND_SCALE;
        SHIFT_LEFT = ((float)WINDOW.method_4489() / 2.0f - totalWidth / 2.0f) / ISLAND_SCALE;
        SHIFT_TOP = ((float)WINDOW.method_4506() / 2.0f - totalHeight / 2.0f) / ISLAND_SCALE;
        poseStack.translate(SHIFT_LEFT, SHIFT_TOP);
        IslandButton lastHoveredButton = null;
        for (class_4068 button : this.field_33816) {
            if (!(button instanceof IslandButton)) continue;
            IslandButton islandButton = (IslandButton)button;
            islandButton.drawButton(graphics, mouseX, mouseY, false);
            if (!islandButton.isHovering()) continue;
            if (lastHoveredButton != null) {
                lastHoveredButton.setDisableHover(true);
            }
            lastHoveredButton = islandButton;
        }
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTick);
        }
        int x = Math.round((float)WINDOW.method_4489() / ISLAND_SCALE - SHIFT_LEFT - 500.0f);
        int y = Math.round((float)WINDOW.method_4506() / ISLAND_SCALE - SHIFT_TOP);
        poseStack.pushMatrix();
        float textScale = 3.0f;
        poseStack.scale(textScale);
        graphics.method_25303(IslandWarpGui.MC.field_1772, Feature.FANCY_WARP_MENU.getMessage(new String[0]), (int)((float)x / textScale + 50.0f), (int)((float)(y - 30 - 120) / textScale + 5.0f), -1);
        graphics.method_25303(IslandWarpGui.MC.field_1772, FeatureSetting.DOUBLE_WARP.getMessage(new String[0]), (int)((float)x / textScale + 50.0f), (int)((float)(y - 30 - 60) / textScale + 5.0f), -1);
        poseStack.popMatrix();
        poseStack.popMatrix();
        this.detectClosestMarker(mouseX, mouseY);
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (event.method_74245() == 0 && this.selectedMarker != null) {
            MC.method_1507(null);
            if (Feature.FANCY_WARP_MENU.isEnabled(FeatureSetting.DOUBLE_WARP)) {
                doubleWarpMarker = this.selectedMarker;
                main.getScheduler().scheduleTask(scheduledTask -> {
                    if (doubleWarpMarker != null) {
                        doubleWarpMarker = null;
                    }
                }, 20);
            }
            if (this.selectedMarker != null && IslandWarpGui.MC.field_1724 != null) {
                IslandWarpGui.MC.field_1724.field_3944.method_45729("/warp " + this.selectedMarker.getWarpName());
            }
        }
        Pair<Integer, Integer> scaledMouseLocations = IslandWarpGui.getScaledMouseLocation((int)event.comp_4798(), (int)event.comp_4799());
        class_11909 mouseButtonEvent = new class_11909((double)scaledMouseLocations.getLeft().intValue(), (double)scaledMouseLocations.getRight().intValue(), event.comp_4800());
        for (class_364 guiEventListener : this.method_25396()) {
            if (!guiEventListener.method_25405((double)scaledMouseLocations.getLeft().intValue(), (double)scaledMouseLocations.getRight().intValue())) continue;
            if (guiEventListener.method_25402(mouseButtonEvent, isDoubleClick)) {
                this.method_25395(guiEventListener);
                if (event.method_74245() == 0) {
                    this.method_25398(true);
                }
            }
            return true;
        }
        return false;
    }

    public void detectClosestMarker(int mouseX, int mouseY) {
        Pair<Integer, Integer> scaledMouseLocations = IslandWarpGui.getScaledMouseLocation(mouseX, mouseY);
        Marker hoveredMarker = null;
        double markerDistance = 91.0;
        for (class_4068 button : this.field_33816) {
            if (!(button instanceof IslandButton)) continue;
            IslandButton islandButton = (IslandButton)button;
            for (IslandMarkerButton marker : islandButton.getMarkerButtons()) {
                double distance = marker.getDistance(scaledMouseLocations.getLeft().intValue(), scaledMouseLocations.getRight().intValue());
                if (distance == -1.0 || !(distance < markerDistance)) continue;
                hoveredMarker = marker.getMarker();
                markerDistance = distance;
            }
        }
        this.selectedMarker = hoveredMarker;
    }

    public static Pair<Integer, Integer> getScaledMouseLocation(int mouseX, int mouseY) {
        double minecraftScale = MC.method_22683().method_4495();
        float islandGuiScale = ISLAND_SCALE;
        mouseX = (int)((double)mouseX * minecraftScale);
        mouseY = (int)((double)mouseY * minecraftScale);
        mouseX = (int)((float)mouseX / islandGuiScale);
        mouseY = (int)((float)mouseY / islandGuiScale);
        mouseX = (int)((float)mouseX - SHIFT_LEFT);
        mouseY = (int)((float)mouseY - SHIFT_TOP);
        return new Pair<Integer, Integer>(mouseX, mouseY);
    }

    @Generated
    public static Marker getDoubleWarpMarker() {
        return doubleWarpMarker;
    }

    @Generated
    public static void setDoubleWarpMarker(Marker doubleWarpMarker) {
        IslandWarpGui.doubleWarpMarker = doubleWarpMarker;
    }

    static {
        WINDOW = MC.method_22683();
        IMAGE_SCALED_DOWN_FACTOR = 0.75f;
    }

    public static enum Island {
        THE_END("The End", 240, 30),
        CRIMSON_ISLE("Crimson Isle", 835, 45),
        THE_PARK("The Park", 80, 440),
        SPIDERS_DEN("Spider's Den", 500, 470),
        DEEP_CAVERNS("Deep Caverns", 1400, 250),
        GOLD_MINE("Gold Mine", 1130, 525),
        MUSHROOM_DESERT("Mushroom Desert", 1470, 525),
        THE_BARN("The Barn", 1100, 860),
        HUB("Hub", 300, 820),
        PRIVATE_ISLAND("Private Island", 275, 1172),
        THE_GARDEN("The Garden", 50, 1050),
        DUNGEON_HUB("Dungeon Hub", 1500, 1100),
        JERRYS_WORKSHOP("Jerry's Workshop", 1280, 1150),
        THE_RIFT("The Rift", 1720, 1050),
        BACKWATER_BAYOU("Backwater Bayou", 960, 1275),
        GALATEA("Galatea", -200, 240);

        private final String label;
        private final int x;
        private final int y;
        private int w;
        private int h;
        private final class_2960 resourceLocation;
        private class_1011 nativeImage;

        private Island(String label, int x, int y) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.resourceLocation = SkyblockAddons.resourceLocation("islands/" + this.name().toLowerCase(Locale.US).replace("_", "") + ".png");
            Optional resource = class_310.method_1551().method_1478().method_14486(this.resourceLocation);
            if (resource.isPresent()) {
                try {
                    this.nativeImage = class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482());
                    this.w = this.nativeImage.method_4307();
                    this.h = this.nativeImage.method_4323();
                    if (label.equals("The End")) {
                        IMAGE_SCALED_DOWN_FACTOR = (float)this.w / 573.0f;
                    }
                }
                catch (IOException e) {
                    SkyblockAddons.getLogger().catching((Throwable)e);
                }
            }
            this.w = (int)((float)this.w / IMAGE_SCALED_DOWN_FACTOR);
            this.h = (int)((float)this.h / IMAGE_SCALED_DOWN_FACTOR);
            if (this.y + this.h > TOTAL_HEIGHT) {
                TOTAL_HEIGHT = this.y + this.h;
            }
            if (this.x + this.w > TOTAL_WIDTH) {
                TOTAL_WIDTH = this.x + this.w;
            }
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public int getX() {
            return this.x;
        }

        @Generated
        public int getY() {
            return this.y;
        }

        @Generated
        public int getW() {
            return this.w;
        }

        @Generated
        public int getH() {
            return this.h;
        }

        @Generated
        public class_2960 getResourceLocation() {
            return this.resourceLocation;
        }

        @Generated
        public class_1011 getNativeImage() {
            return this.nativeImage;
        }
    }

    public static enum Marker {
        PRIVATE_ISLAND("home", Translations.getMessage("warpMenu.home", new Object[0]), Island.PRIVATE_ISLAND, 72, 90),
        THE_GARDEN("garden", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.THE_GARDEN, 160, 70),
        JERRYS_WORKSHOP("workshop", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.JERRYS_WORKSHOP, 35, 90),
        THE_RIFT("rift", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.THE_RIFT, 35, 90),
        BACKWATER_BAYOU("backwater", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.BACKWATER_BAYOU, 60, 150),
        HUB("hub", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.HUB, 610, 210),
        ELIZABETH("elizabeth", "Elizabeth", Island.HUB, 660, 150),
        CASTLE("castle", "Castle", Island.HUB, 130, 80),
        DARK_AUCTION("da", "Sirius Shack", Island.HUB, 385, 415),
        CRYPT("crypt", "Crypts", Island.HUB, 580, 100),
        WIZARD_TOWER("wizard", "Wizard Tower", Island.HUB, 490, 260),
        MUSEUM("museum", "Museum", Island.HUB, 310, 200),
        TRADE_CENTER("stonks", "Trade Center", Island.HUB, 530, 175),
        CARNIVAL("carnival", "Carnival", Island.HUB, 480, 100),
        SPIDERS_DEN("spider", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.SPIDERS_DEN, 345, 240),
        SPIDERS_DEN_NEST("nest", "Top of Nest", Island.SPIDERS_DEN, 450, 30),
        ARACHNES_SANCTUARY("arachne", "Arachne's Sanctuary", Island.SPIDERS_DEN, 240, 135),
        THE_PARK("park", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.THE_PARK, 263, 308),
        HOWLING_CAVE("howl", "Howling Cave", Island.THE_PARK, 254, 202),
        THE_PARK_JUNGLE("jungle", "Jungle", Island.THE_PARK, 194, 82),
        GALATEA("galatea", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.GALATEA, 160, 260),
        MURKWATER_LOCH("murkwater", "Murkwater Loch", Island.GALATEA, 220, 140),
        THE_END("end", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.THE_END, 440, 291),
        DRAGONS_NEST("drag", "Dragon's Nest", Island.THE_END, 260, 248),
        VOID_SEPULTURE("void", "Void Sepulture", Island.THE_END, 370, 227),
        CRIMSON_ISLE("nether", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.CRIMSON_ISLE, 70, 280),
        FORGOTTEN_SKULL("kuudra", "Forgotten Skull", Island.CRIMSON_ISLE, 460, 90),
        THE_WASTELAND("wasteland", "The Wasteland", Island.CRIMSON_ISLE, 330, 160),
        DRAGONTAIL("dragontail", "Dragontail", Island.CRIMSON_ISLE, 140, 150),
        SCARLETON("scarleton", "Scarleton", Island.CRIMSON_ISLE, 400, 220),
        SMOLDERING_TOMB("smold", "Smoldering Tomb", Island.CRIMSON_ISLE, 350, 70),
        THE_BARN("barn", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.THE_BARN, 140, 150),
        MUSHROOM_DESERT("desert", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.MUSHROOM_DESERT, 210, 295),
        TRAPPER("trapper", "Trapper's Hut", Island.MUSHROOM_DESERT, 300, 200),
        GOLD_MINE("gold", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.GOLD_MINE, 86, 259),
        DEEP_CAVERNS("deep", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.DEEP_CAVERNS, 97, 213),
        DWARVEN_MINES("mines", "Dwarven Mines", Island.DEEP_CAVERNS, 280, 205),
        DWARVEN_FORGE("forge", "Forge", Island.DEEP_CAVERNS, 280, 280),
        DWARVEN_BASE_CAMP("base", "Dwarven Base Camp", Island.DEEP_CAVERNS, 240, 330),
        CRYSTAL_HOLLOWS("crystals", "Crystal Hollows", Island.DEEP_CAVERNS, 190, 360),
        CRYSTAL_NUCLEUS("nucleus", "Crystal Nucleus", Island.DEEP_CAVERNS, 140, 390),
        DUNGEON_HUB_ISLAND("dungeon_hub", Translations.getMessage("warpMenu.spawn", new Object[0]), Island.DUNGEON_HUB, 35, 80);

        private final String warpName;
        private final String label;
        private final Island island;
        private final boolean advanced;
        private final int x;
        private final int y;

        private Marker(String warpName, String label, Island island, int x, int y) {
            this(warpName, label, island, false, x, y);
        }

        private Marker(String warpName, String label, Island island, boolean advanced, int x, int y) {
            this.warpName = warpName;
            this.label = label;
            this.island = island;
            this.x = x;
            this.y = y;
            this.advanced = advanced;
        }

        @Generated
        public String getWarpName() {
            return this.warpName;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public Island getIsland() {
            return this.island;
        }

        @Generated
        public boolean isAdvanced() {
            return this.advanced;
        }

        @Generated
        public int getX() {
            return this.x;
        }

        @Generated
        public int getY() {
            return this.y;
        }
    }
}

