/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Language;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.discordrpc.DiscordStatus;
import com.fix3dll.skyblockaddons.features.dungeonmap.DungeonMapManager;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonArrow;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonInputFieldWrapper;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonLanguage;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonSlider;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonText;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonOpenColorMenu;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonSettingToggle;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_9848;

public class SettingsGui
extends SkyblockAddonsScreen {
    final ObjectArrayList<class_4068> scrollIgnoredButtons = new ObjectArrayList();
    final Feature feature;
    final int lastPage;
    final EnumUtils.GuiTab lastTab;
    final EnumUtils.GUIType lastGUI;
    int page;
    float row = 1.0f;
    int column = 1;
    int displayCount;
    boolean closingGui;
    boolean reInit = false;
    double scrollValue;
    int maxScrollValue;
    double scrollY;

    public SettingsGui(Feature feature, int page, int lastPage, EnumUtils.GuiTab lastTab, EnumUtils.GUIType lastGUI) {
        super((class_2561)class_2561.method_43473());
        this.feature = feature;
        this.page = page;
        this.lastPage = lastPage;
        this.lastTab = lastTab;
        this.lastGUI = lastGUI;
    }

    public void method_25426() {
        super.method_25426();
        this.scrollValue = 0.0;
        this.maxScrollValue = MC.method_22683().method_4507() / 2;
        this.row = 1.0f;
        this.column = 1;
        this.method_37067();
        if (this.feature == Feature.LANGUAGE) {
            Language currentLanguage = (Language)this.feature.getFeatureData().getValue();
            this.displayCount = this.findDisplayCount();
            int skip = (this.page - 1) * this.displayCount;
            boolean max = this.page == 1;
            this.addScrollIgnoredButton(new ButtonArrow(this.field_22789 / 2 - 15 - 50, this.field_22790 - 70, ButtonArrow.ArrowType.LEFT, max));
            max = Language.values().length - skip - this.displayCount <= 0;
            this.addScrollIgnoredButton(new ButtonArrow(this.field_22789 / 2 - 15 + 50, this.field_22790 - 70, ButtonArrow.ArrowType.RIGHT, max));
            for (Language language : Language.values()) {
                if (skip == 0) {
                    if (language == Language.ENGLISH) continue;
                    if (language == Language.CHINESE_TRADITIONAL) {
                        this.addLanguageButton(Language.ENGLISH);
                    }
                    this.addLanguageButton(language);
                    continue;
                }
                --skip;
            }
            this.feature.setValue(currentLanguage);
            DataUtils.loadLocalizedStrings(false);
        } else {
            if (this.feature.hasSettings()) {
                for (Map.Entry<FeatureSetting, Object> entry : this.feature.getFeatureData().getSettings().entrySet()) {
                    this.addButton(entry.getKey(), entry.getValue());
                }
            }
            this.addUniversalButton();
        }
        this.addSocials(this::addScrollIgnoredButton);
    }

    private int findDisplayCount() {
        int maxX = MC.method_22683().method_4502() - 70 - 25;
        int displayCount = 0;
        for (int row = 1; row < 99; ++row) {
            if (this.getRowHeight(row) < (double)maxX) {
                displayCount += 3;
                continue;
            }
            return displayCount;
        }
        return displayCount;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        double scroll;
        if (this.reInit) {
            this.reInit = false;
            this.method_25426();
        }
        if (Math.abs(this.scrollValue + (scroll = this.getMouseScrollY() * 16.0)) <= (double)this.maxScrollValue) {
            this.scrollValue += scroll;
        } else {
            scroll = 0.0;
        }
        float alphaMultiplier = this.calculateAlphaMultiplier();
        int alpha = (int)(255.0f * alphaMultiplier);
        this.drawGradientBackground(graphics, alpha);
        if (alpha < 4) {
            alpha = 4;
        }
        int defaultBlue = ColorUtils.getDefaultBlue(alpha * 2);
        this.drawDefaultTitleText(graphics, mouseX, mouseY, partialTick, this, alpha * 2);
        boolean scissorEnabled = false;
        if (this.feature != Feature.LANGUAGE) {
            int halfWidth = this.field_22789 / 2;
            int boxWidth = 140;
            int x = halfWidth - 90 - boxWidth;
            int width = halfWidth + 90 + boxWidth;
            float numberOfRow = this.row - 1.0f;
            int height = (int)(this.getRowHeightSetting(numberOfRow) - 70.0);
            int y = (int)this.getRowHeight(1.0);
            this.maxScrollValue = height - 35;
            DrawUtils.drawRoundedRect(graphics, x, y, width -= x, height, 4, class_9848.method_61324((int)230, (int)28, (int)29, (int)41));
            graphics.method_44379(x, y, x + width, y + height);
            scissorEnabled = true;
            SettingsGui.drawScaledString(graphics, this, Translations.getMessage("settings.settings", new Object[0]), (int)(110.0 + this.scrollValue), defaultBlue, 1.5f, 0);
            double finalScroll = scroll;
            this.field_33816.forEach(guiButton -> {
                class_339 abstractWidget = (class_339)guiButton;
                if (!this.scrollIgnoredButtons.contains(guiButton)) {
                    abstractWidget.method_46419(abstractWidget.method_46427() + (int)finalScroll);
                }
            });
        }
        this.drawSettingsScreen(graphics, mouseX, mouseY, partialTick);
        if (scissorEnabled) {
            graphics.method_44380();
        }
        this.scrollIgnoredButtons.forEach(renderable -> renderable.method_25394(graphics, mouseX, mouseY, partialTick));
    }

    protected void method_37067() {
        this.scrollIgnoredButtons.clear();
        super.method_37067();
    }

    private void addLanguageButton(Language language) {
        if (this.displayCount == 0) {
            return;
        }
        String text = this.feature.getMessage(new String[0]);
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 140;
        int x = 0;
        if (this.column == 1) {
            x = halfWidth - 90 - boxWidth;
        } else if (this.column == 2) {
            x = halfWidth - boxWidth / 2;
        } else if (this.column == 3) {
            x = halfWidth + 90;
        }
        double y = this.getRowHeight(this.row);
        this.method_37063((class_364)new ButtonLanguage(x, y, text, language));
        ++this.column;
        if (this.column > 3) {
            this.column = 1;
            this.row += 1.0f;
        }
        --this.displayCount;
    }

    private void addButton(FeatureSetting setting, Object settingValue) {
        int halfWidth = this.field_22789 / 2;
        double y = this.getRowHeightSetting(this.row);
        switch (setting) {
            case DISCORD_RP_AUTO_MODE: 
            case DISCORD_RP_CUSTOM_DETAILS: 
            case DISCORD_RP_CUSTOM_STATE: {
                return;
            }
            case DISCORD_RP_DETAILS: 
            case DISCORD_RP_STATE: {
                int boxWidth = 140;
                int x = halfWidth - boxWidth / 2;
                DiscordStatus currentStatus = (DiscordStatus)settingValue;
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, setting.getMessage(new String[0]), true, -1));
                this.method_37063((class_364)new ButtonCycling(x, (int)y, boxWidth, 20, Arrays.asList(DiscordStatus.values()), currentStatus.ordinal(), index -> {
                    DiscordStatus selectedStatus = DiscordStatus.values()[index];
                    if (setting == FeatureSetting.DISCORD_RP_STATE) {
                        main.getDiscordRPCManager().setStateLine(selectedStatus);
                    } else {
                        main.getDiscordRPCManager().setDetailsLine(selectedStatus);
                    }
                    this.feature.set(setting, selectedStatus);
                    this.reInit = true;
                }));
                if (currentStatus == DiscordStatus.AUTO_STATUS) {
                    this.row += 1.0f;
                    this.row += 0.4f;
                    x = halfWidth - boxWidth / 2;
                    y = this.getRowHeightSetting(this.row);
                    this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, Translations.getMessage("messages.fallbackStatus", new Object[0]), true, -1));
                    currentStatus = (DiscordStatus)this.feature.get(FeatureSetting.DISCORD_RP_AUTO_MODE);
                    this.method_37063((class_364)new ButtonCycling(x, (int)y, boxWidth, 20, Arrays.asList(DiscordStatus.values()), currentStatus.ordinal(), index -> {
                        DiscordStatus selectedStatus = DiscordStatus.values()[index];
                        this.feature.set(FeatureSetting.DISCORD_RP_AUTO_MODE, selectedStatus);
                        this.reInit = true;
                    }));
                }
                if (currentStatus == DiscordStatus.CUSTOM) {
                    this.row += 1.0f;
                    boxWidth = 200;
                    x = halfWidth - boxWidth / 2;
                    y = this.getRowHeightSetting(this.row);
                    FeatureSetting customLine = setting == FeatureSetting.DISCORD_RP_DETAILS ? FeatureSetting.DISCORD_RP_CUSTOM_DETAILS : FeatureSetting.DISCORD_RP_CUSTOM_STATE;
                    this.method_37063((class_364)new ButtonInputFieldWrapper(x, (int)y, 200, 20, Feature.DISCORD_RPC.getAsString(customLine), null, 100, false, updatedValue -> Feature.DISCORD_RPC.set(customLine, updatedValue)));
                }
                this.row += 0.4f;
                break;
            }
            case EXPAND_DEPLOYABLE_STATUS: {
                if (this.feature.get(FeatureSetting.DEPLOYABLE_DISPLAY_STYLE) != EnumUtils.DeployableDisplayStyle.DETAILED) {
                    return;
                }
                int boxWidth = 31;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, Translations.getMessage("settings.expandDeployableStatus", new Object[0]), setting));
                break;
            }
            case DEPLOYABLE_DISPLAY_STYLE: {
                int boxWidth = 140;
                int x = halfWidth - boxWidth / 2;
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, setting.getMessage(new String[0]), true, -1));
                this.method_37063((class_364)new ButtonCycling(x, (int)y, 140, 20, Arrays.asList(EnumUtils.DeployableDisplayStyle.values()), this.feature.getAsEnum(setting).ordinal(), index -> {
                    EnumUtils.DeployableDisplayStyle style = EnumUtils.DeployableDisplayStyle.values()[index];
                    this.feature.set(setting, style);
                    this.reInit = true;
                }));
                this.row += 0.1f;
                break;
            }
            case BACKPACK_STYLE: {
                int boxWidth = 140;
                int x = halfWidth - boxWidth / 2;
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, Translations.getMessage("settings.backpackStyle", new Object[0]), true, -1));
                this.method_37063((class_364)new ButtonCycling(x, (int)y, 140, 20, Arrays.asList(EnumUtils.BackpackStyle.values()), this.feature.getAsEnum(setting).ordinal(), index -> this.feature.set(setting, EnumUtils.BackpackStyle.values()[index])));
                this.row += 0.1f;
                break;
            }
            case DUNGEON_MAP_ZOOM: {
                int boxWidth = 100;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSlider(x, y, 100, 20, DungeonMapManager.getMapZoom(), 0.5f, 5.0f, 0.05f, DungeonMapManager::setMapZoom).setPrefix("Map Zoom: "));
                this.row += 0.1f;
                break;
            }
            case HEALING_CIRCLE_OPACITY: {
                int boxWidth = 150;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSlider(x, y, boxWidth, 20, this.feature.getAsNumber(setting).floatValue(), 0.0f, 1.0f, 0.01f, updatedValue -> this.feature.set(setting, updatedValue)).setPrefix("Healing Circle Opacity: "));
                this.row += 0.1f;
                break;
            }
            case PET_ITEM_STYLE: {
                int boxWidth = 140;
                int x = halfWidth - boxWidth / 2;
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y - 10, setting.getMessage(new String[0]), true, -1));
                this.method_37063((class_364)new ButtonCycling(x, (int)y, 140, 20, Arrays.asList(EnumUtils.PetItemStyle.values()), this.feature.getAsEnum(FeatureSetting.PET_ITEM_STYLE).ordinal(), index -> this.feature.set(setting, EnumUtils.PetItemStyle.values()[index])));
                this.row += 0.1f;
                break;
            }
            case TREVOR_SHOW_QUEST_COOLDOWN: {
                int boxWidth = 31;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, setting.getMessage(new String[0]), setting));
                this.row += 0.1f;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y + 15, Translations.getMessage("settings.trevorTheTrapper.showQuestCooldownDescription", new Object[0]), true, ColorCode.GRAY.getColor()));
                this.row += 0.4f;
                break;
            }
            case TREVOR_HIGHLIGHT_TRACKED_ENTITY: {
                int boxWidth = 31;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, setting.getMessage(new String[0]), setting));
                this.row += 0.1f;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y + 15, Translations.getMessage("messages.entityOutlinesRequirement", new Object[0]), true, ColorCode.GRAY.getColor()));
                this.row += 0.4f;
                break;
            }
            case CLASS_COLORED_TEAMMATE: {
                int boxWidth = 31;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, setting.getMessage(new String[0]), setting));
                this.row += 0.1f;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonText(halfWidth, (int)y + 15, Translations.getMessage("messages.classColoredTeammateRequirement", new Object[0]), true, ColorCode.GRAY.getColor()));
                if (!this.feature.isDisabled(setting)) break;
                this.row += 0.4f;
                break;
            }
            case HEALER_COLOR: 
            case MAGE_COLOR: 
            case BERSERK_COLOR: 
            case ARCHER_COLOR: 
            case TANK_COLOR: {
                if (this.feature.isDisabled(FeatureSetting.CLASS_COLORED_TEAMMATE)) {
                    return;
                }
                int boxWidth = 100;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonOpenColorMenu((double)x, y, 100, 20, setting.getMessage(new String[0]), setting));
                if (setting != FeatureSetting.TANK_COLOR) break;
                this.row += 0.4f;
                break;
            }
            default: {
                if (setting.isUniversal()) {
                    return;
                }
                int boxWidth = 31;
                int x = halfWidth - boxWidth / 2;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonSettingToggle((double)x, y, setting.getMessage(new String[0]), setting));
            }
        }
        this.row += 1.0f;
    }

    private void addUniversalButton() {
        if (this.feature.isGuiFeature()) {
            double y;
            double x;
            int halfWidth = this.field_22789 / 2;
            if (this.feature.couldBeXAllignment()) {
                x = (double)halfWidth - 15.5;
                y = this.getRowHeightSetting(this.row);
                FeatureSetting xAllignment = FeatureSetting.X_ALLIGNMENT;
                xAllignment.setUniversalFeature(this.feature);
                this.method_37063((class_364)new ButtonSettingToggle(x, y, xAllignment.getMessage(new String[0]), xAllignment));
                this.row += 1.0f;
            }
            if (this.feature.getFeatureGuiData().getDefaultColor() != null) {
                x = halfWidth - 50;
                y = this.getRowHeightSetting(this.row);
                this.method_37063((class_364)new ButtonOpenColorMenu(x, y - 10.0, 100, 20, Translations.getMessage("settings.changeColor", new Object[0]), this.feature));
                this.row += 1.0f;
            }
        }
    }

    protected double getRowHeight(double row) {
        return 95.0 + (row -= 1.0) * 30.0;
    }

    protected double getRowHeightSetting(double row) {
        return 140.0 + (row -= 1.0) * 35.0;
    }

    protected void addScrollIgnoredButton(class_339 button) {
        this.scrollIgnoredButtons.add((Object)button);
        this.method_37063((class_364)button);
    }

    protected void drawSettingsScreen(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.firstDraw) {
            this.sortButtonList();
            this.firstDraw = false;
        }
        this.method_25420(graphics, mouseX, mouseY, partialTick);
        for (class_4068 renderable : this.field_33816) {
            if (this.scrollIgnoredButtons.contains((Object)renderable)) continue;
            renderable.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    private double getMouseScrollY() {
        double result = this.scrollY;
        this.scrollY = 0.0;
        return result;
    }

    private void updateButtonInputFields(class_11909 event, boolean isDoubleClick) {
        for (class_364 guiEventListener : this.method_25396()) {
            ButtonInputFieldWrapper bif;
            if (!(guiEventListener instanceof ButtonInputFieldWrapper) || !(bif = (ButtonInputFieldWrapper)guiEventListener).method_25402(event, isDoubleClick)) continue;
            bif.method_25354(MC.method_1483());
        }
    }

    public void method_25432() {
        if (!this.closingGui) {
            this.closingGui = true;
            main.getRenderListener().setGuiToOpen(this.lastGUI, this.lastPage, this.lastTab);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollY = scrollY;
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        boolean consumed = super.method_25402(event, isDoubleClick);
        this.updateButtonInputFields(event, isDoubleClick);
        return consumed;
    }

    @Generated
    public Feature getFeature() {
        return this.feature;
    }

    @Generated
    public int getLastPage() {
        return this.lastPage;
    }

    @Generated
    public EnumUtils.GuiTab getLastTab() {
        return this.lastTab;
    }

    @Generated
    public EnumUtils.GUIType getLastGUI() {
        return this.lastGUI;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public void setClosingGui(boolean closingGui) {
        this.closingGui = closingGui;
    }

    @Generated
    public void setReInit(boolean reInit) {
        this.reInit = reInit;
    }
}

