/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.libautoupdate;

import com.fix3dll.skyblockaddons.libautoupdate.UpdateData;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateSource;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateUtils;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.NonNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@NonNull
public class MavenSource
implements UpdateSource {
    String repoUrl;
    String module;
    String artifact;
    String classifier;
    String extension;

    protected URI getMavenBaseUrl() {
        URI uri = URI.create(this.repoUrl);
        for (String modulePart : UpdateUtils.stringSplitIterator(this.module, ".")) {
            uri = uri.resolve(UpdateUtils.urlEncode(modulePart));
        }
        uri = uri.resolve(UpdateUtils.urlEncode(this.artifact));
        return uri;
    }

    protected URI getMavenMetadataUrl() {
        return this.getMavenBaseUrl().resolve("maven-metadata.xml");
    }

    protected String getFileName(String version) {
        return String.format("%s-%s%s%s.%s", this.artifact, version, this.classifier.isEmpty() ? "" : "-", this.classifier, this.extension);
    }

    protected URI getMavenArtifactUrl(String version) {
        return this.getMavenBaseUrl().resolve(UpdateUtils.urlEncode(version)).resolve(UpdateUtils.urlEncode(this.getFileName(version)));
    }

    @Override
    public CompletableFuture<UpdateData> checkUpdate(String updateStream) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream is = UpdateUtils.openUrlConnection(this.getMavenMetadataUrl().toURL());){
                Document document = db.parse(new InputSource(is));
                Element metadata = document.getDocumentElement();
                Element versioning = (Element)metadata.getElementsByTagName("versioning").item(0);
                Element latest = (Element)versioning.getElementsByTagName("latest").item(0);
                Element release = (Element)versioning.getElementsByTagName("release").item(0);
                if (release != null && ("full".equals(updateStream) || latest == null)) {
                    latest = release;
                }
                String latestVersion = latest.getTextContent();
                UpdateData updateData = new UpdateData(latestVersion, new JsonPrimitive(latestVersion), null, this.getMavenArtifactUrl(latestVersion).toString());
                return updateData;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public MavenSource(String repoUrl, String module, String artifact, String classifier, String extension) {
        this.repoUrl = repoUrl;
        this.module = module;
        this.artifact = artifact;
        this.classifier = classifier;
        this.extension = extension;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getModule() {
        return this.module;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSource)) {
            return false;
        }
        MavenSource other = (MavenSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$repoUrl = this.getRepoUrl();
        String other$repoUrl = other.getRepoUrl();
        if (this$repoUrl == null ? other$repoUrl != null : !this$repoUrl.equals(other$repoUrl)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !this$extension.equals(other$extension));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repoUrl = this.getRepoUrl();
        result = result * 59 + ($repoUrl == null ? 43 : $repoUrl.hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        return result;
    }
}

