/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.libautoupdate;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;

public class UpdateUtils {
    static final Gson gson = new Gson();
    private static Consumer<URLConnection> connectionPatcher = null;

    private UpdateUtils() {
    }

    public static File getJarFileContainingClass(Class<?> clazz) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (location == null) {
            return null;
        }
        String path = location.toString();
        if ((path = path.split("!", 2)[0]).startsWith("jar:")) {
            path = path.substring(4);
        }
        try {
            return new File(new URI(path));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void connect(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    public static String sha256sum(InputStream stream) throws IOException {
        try {
            int r;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] buf = new byte[4096];
            while ((r = stream.read(buf)) != -1) {
                digest.update(buf, 0, r);
            }
            return String.format("%64s", new BigInteger(1, digest.digest()).toString(16)).replace(' ', '0').toLowerCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream openUrlConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (connectionPatcher != null) {
            connectionPatcher.accept(conn);
        }
        return conn.getInputStream();
    }

    public static void deleteDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void patchConnection(Consumer<URLConnection> connectionPatcher) {
        UpdateUtils.connectionPatcher = connectionPatcher;
    }

    public static <T> CompletableFuture<T> httpGet(String url, Gson gson, Type clazz) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream is = UpdateUtils.openUrlConnection(new URL(url));){
                Object t = gson.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), clazz);
                return t;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public static Iterable<String> stringSplitIterator(final String subject, final String splitOn) {
        return () -> new Iterator<String>(){
            int endIndex;
            int startIndex;
            {
                this.endIndex = -splitOn.length();
                this.startIndex = -1;
            }

            @Override
            public boolean hasNext() {
                if (this.startIndex >= 0) {
                    return true;
                }
                if (this.endIndex >= subject.length()) {
                    return false;
                }
                int searchIndex = this.endIndex + splitOn.length();
                if (searchIndex >= subject.length()) {
                    return false;
                }
                this.startIndex = searchIndex;
                int nextNeedle = subject.indexOf(splitOn, searchIndex);
                if (nextNeedle < 0) {
                    this.endIndex = subject.length();
                    return true;
                }
                this.endIndex = nextNeedle;
                return true;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String match = subject.substring(this.startIndex, this.endIndex);
                this.startIndex = -1;
                return match;
            }
        };
    }

    public static String lastStringSegment(String subject, String needle) {
        int i = subject.lastIndexOf(needle);
        if (i < 0) {
            return null;
        }
        return subject.substring(i + needle.length());
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("StandardCharsets.UTF_8 should always be available", e);
        }
    }

    public static String urlRoundtrip(String urlEncoded) {
        return UpdateUtils.urlEncode(UpdateUtils.urlDecode(urlEncoded));
    }

    public static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            return "null";
        }
        if (fileName.isEmpty()) {
            return "empty";
        }
        if (fileName.equals("..")) {
            return "%2E%2E";
        }
        if (fileName.equals(".")) {
            return "%2E";
        }
        fileName = fileName.replace("/", "%2F");
        Path path = Paths.get(fileName = fileName.replace("\\", "%5C"), new String[0]);
        if (path.getNameCount() != 1) {
            throw new RuntimeException("Could not sanitize file name " + fileName + " into a single name");
        }
        return path.getFileName().toString();
    }

    public static File getContainedFile(File directory, String filename) throws IOException {
        File file = new File(directory, filename).getCanonicalFile();
        if (!directory.getCanonicalFile().equals(file.getParentFile())) {
            throw new IllegalArgumentException("Tried to create a file named '" + filename + "' in directory '" + directory + "', but leaked out to '" + file + "'.");
        }
        return file;
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("StandardCharsets.UTF_8 should always be available", e);
        }
    }
}

