/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.listeners;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.config.PersistentValuesManager;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.ItemType;
import com.fix3dll.skyblockaddons.core.PlayerStat;
import com.fix3dll.skyblockaddons.core.SkillType;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.SkyblockOre;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.npc.NPCUtils;
import com.fix3dll.skyblockaddons.core.seacreatures.SeaCreatureManager;
import com.fix3dll.skyblockaddons.events.ClientEvents;
import com.fix3dll.skyblockaddons.events.SkyblockEvents;
import com.fix3dll.skyblockaddons.features.BaitManager;
import com.fix3dll.skyblockaddons.features.EndstoneProtectorManager;
import com.fix3dll.skyblockaddons.features.FetchurManager;
import com.fix3dll.skyblockaddons.features.JerryPresent;
import com.fix3dll.skyblockaddons.features.PetManager;
import com.fix3dll.skyblockaddons.features.cooldowns.CooldownManager;
import com.fix3dll.skyblockaddons.features.deployable.DeployableManager;
import com.fix3dll.skyblockaddons.features.dragontracker.DragonTracker;
import com.fix3dll.skyblockaddons.features.dungeonmap.DungeonMapManager;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonMilestone;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonPlayer;
import com.fix3dll.skyblockaddons.features.enchants.EnchantManager;
import com.fix3dll.skyblockaddons.features.fishing.FishParticleManager;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTracker;
import com.fix3dll.skyblockaddons.features.tablist.TabListParser;
import com.fix3dll.skyblockaddons.gui.screens.IslandWarpGui;
import com.fix3dll.skyblockaddons.utils.ActionBarParser;
import com.fix3dll.skyblockaddons.utils.DevUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.InventoryUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.RomanNumeralParser;
import com.fix3dll.skyblockaddons.utils.ScoreboardManager;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.fix3dll.skyblockaddons.utils.data.requests.MayorRequest;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3544;
import net.minecraft.class_355;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class PlayerListener {
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private final ActionBarParser actionBarParser = new ActionBarParser();
    private static final Pattern NO_ARROWS_LEFT_PATTERN = Pattern.compile("\u00a7c\u00a7lQUIVER! \u00a7r\u00a7cYou have run out of \u00a7r(?<type>\u00a7.*)\u00a7r\u00a7c!\u00a7r");
    private static final Pattern ONLY_HAVE_ARROWS_LEFT_PATTERN = Pattern.compile("\u00a7c\u00a7lQUIVER! \u00a7r\u00a7cYou only have (?<arrows>[0-9]+) \u00a7r(?<type>\u00a7.*) \u00a7r\u00a7cleft!\u00a7r");
    private static final Pattern ABILITY_CHAT_PATTERN = Pattern.compile("\u00a7aUsed \u00a7r\u00a76[A-Za-z ]+\u00a7r\u00a7a! \u00a7r\u00a7b\\([0-9]+ Mana\\)\u00a7r");
    private static final Pattern PROFILE_CHAT_PATTERN = Pattern.compile("You are playing on profile: ([A-Za-z]+).*");
    private static final Pattern SWITCH_PROFILE_CHAT_PATTERN = Pattern.compile("Your profile was changed to: ([A-Za-z]+).*");
    private static final Pattern MINION_CANT_REACH_PATTERN = Pattern.compile("\u00a7cI can't reach any (?<mobName>\\w+?)(s?)$");
    private static final Pattern DRAGON_KILLED_PATTERN = Pattern.compile(" *[A-Z]* DRAGON DOWN!");
    private static final Pattern DRAGON_SPAWNED_PATTERN = Pattern.compile("\u262c The (?<dragonType>[A-Za-z ]+) Dragon has spawned!");
    private static final Pattern SLAYER_COMPLETED_PATTERN = Pattern.compile(" {3}\u00bb Talk to Maddox to claim your (?<slayerType>[A-Za-z]+) Slayer XP!");
    private static final Pattern SLAYER_COMPLETED_PATTERN_AUTO1 = Pattern.compile(" *(?<slayerType>[A-Za-z]+) Slayer LVL \\d+ - (?:Next LVL in [\\d,]+ XP!|LVL MAXED OUT!)");
    private static final Pattern SLAYER_COMPLETED_PATTERN_AUTO2 = Pattern.compile(" *SLAYER QUEST STARTED!");
    private static final Pattern DEATH_MESSAGE_PATTERN = Pattern.compile(" \u2620 (?<username>\\w+) (?<causeOfDeath>.+)\\.");
    private static final Pattern REVIVE_MESSAGE_PATTERN = Pattern.compile(" \u2763 (?<revivedPlayer>\\w+) was revived(?: by (?<reviver>\\w+))*!");
    private static final Pattern NEXT_TIER_PET_PROGRESS = Pattern.compile("Next tier: (?<total>[0-9,]+)/.*");
    private static final Pattern MAXED_TIER_PET_PROGRESS = Pattern.compile(".*: (?<total>[0-9,]+)");
    private static final Pattern SPIRIT_SCEPTRE_MESSAGE_PATTERN = Pattern.compile("Your (?:Implosion|Spirit Sceptre|Molten Wave) hit (?<hitEnemies>[0-9]+) enem(?:y|ies) for (?<dealtDamage>[0-9]{1,3}(?:,[0-9]{3})*(?:\\.[0-9]+)*) damage\\.");
    private static final Pattern PROFILE_TYPE_SYMBOL = Pattern.compile("(?i)\u00a7[0-9A-FK-ORZ][\u2672\u24b7]");
    private static final Pattern NETHER_FACTION_SYMBOL = Pattern.compile("(?i)\u00a7[0-9A-FK-ORZ][\u2692\u127e]");
    private static final Pattern AUTOPET_PATTERN = Pattern.compile("\u00a7cAutopet \u00a7eequipped your \u00a77\\[Lvl (?<level>\\d+)](?: \u00a78\\[\u00a76\\d+\u00a78\u00a7.\u2726\u00a78])? \u00a7(?<rarityColor>.)(?<name>.*)\u00a7e! \u00a7a\u00a7lVIEW RULE\u00a7r");
    private static final Pattern PET_LEVELED_UP_PATTERN = Pattern.compile("\u00a7aYour \u00a7r\u00a7(?<rarityColor>.)(?<name>.*?)(?<cosmetic>\u00a7r\u00a7. \u2726)? \u00a7r\u00a7aleveled up to level \u00a7r(?:\u00a7.)*(?<newLevel>\\d+)\u00a7r\u00a7a!\u00a7r");
    private static final Pattern PET_ITEM_PATTERN = Pattern.compile("\u00a7aYour pet is now holding \u00a7r\u00a7(?<rarityColor>.)(?<petItem>.*)\u00a7r\u00a7a.\u00a7r");
    private static final ObjectOpenHashSet<String> SOUP_RANDOM_MESSAGES = ObjectOpenHashSet.of((Object[])new String[]{"I feel like I can fly!", "What was in that soup?", "Hmm\u2026 tasty!", "Hmm... tasty!", "You can now fly for 2 minutes.", "Your flight has been extended for 2 extra minutes.", "You can now fly for 200 minutes.", "Your flight has been extended for 200 extra minutes."});
    private static final Set<class_2960> BONZO_STAFF_SOUNDS = Set.of(class_3417.field_14917.comp_3319(), class_3417.field_15090.comp_3319(), class_3417.field_14800.comp_3319(), class_3417.field_14882.comp_3319(), class_3417.field_14566.comp_3319(), class_3417.field_15130.comp_3319());
    private static final ObjectOpenHashSet<RatSound> RAT_SOUNDS = ObjectOpenHashSet.of((Object)new RatSound(class_3417.field_15009.comp_3319(), 1.0f, 1.1904762f), (Object)new RatSound(class_3417.field_14685.comp_3319(), 0.15f, 1.0f));
    private long lastWorldJoin = -1L;
    private long lastBal = -1L;
    private int lastBalEntityId = -1;
    private long lastBroodmother = -1L;
    private int timerTick = 1;
    private long lastMinionSound = -1L;
    private long lastSkyblockServerJoinAttempt = 0L;
    private long lastDeath = 0L;
    private long lastRevive = 0L;
    private long lastMaddoxLevelTime;
    private String lastMaddoxSlayerType;
    private long rainmakerTimeEnd = -1L;
    private final Set<UUID> countedEndermen = new HashSet<UUID>();
    private final TreeMap<Long, Set<class_243>> recentlyKilledZealots = new TreeMap();
    private int spiritSceptreHitEnemies = 0;
    private float spiritSceptreDealtDamage = 0.0f;
    private final TreeMap<Long, class_243> explosiveBowExplosions = new TreeMap();
    private final LinkedHashMap<String, String> namesWithSymbols = new LinkedHashMap<String, String>(81){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 80;
        }
    };
    private long fireFreezeTimer = 0L;
    private boolean doubleHook = false;
    private String cachedChatRunCommand;
    private boolean savePersistentFlag = false;
    public static final class_2960 SBA_FIRST_PHASE = SkyblockAddons.resourceLocation("first");
    public static final class_2960 SBA_LAST_PHASE = SkyblockAddons.resourceLocation("last");
    private boolean previousAllowFlyingState = false;

    public PlayerListener() {
        ClientTickEvents.START_CLIENT_TICK.register(this::onTickStart);
        ClientEvents.ENTITY_JOIN_WORLD.register(this::onEntityJoinWorld);
        ClientEvents.HANDLE_KEYBINDS.register(this::handleKeybinds);
        ClientEvents.LIVING_ENTITY_TICK.register(this::onEntityTick);
        ClientEvents.PLAY_SOUND.register(this::onPlaySound);
        ClientReceiveMessageEvents.GAME_CANCELED.register(this::onChatReceived);
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::onChatReceived);
        ClientReceiveMessageEvents.MODIFY_GAME.register(this::onChatModify);
        UseItemCallback.EVENT.register(this::onRightClickBlock);
        ItemTooltipCallback.EVENT.addPhaseOrdering(SBA_FIRST_PHASE, Event.DEFAULT_PHASE);
        ItemTooltipCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, SBA_LAST_PHASE);
        ItemTooltipCallback.EVENT.register(SBA_FIRST_PHASE, this::onGetComponentFirst);
        ItemTooltipCallback.EVENT.register(SBA_LAST_PHASE, this::onGetComponentLast);
        SkyblockEvents.DUNGEON_PLAYER_DEATH.register(this::onDungeonPlayerDeath);
        SkyblockEvents.DUNGEON_PLAYER_REVIVE.register(this::onDungeonPlayerRevive);
        SkyblockEvents.BLOCK_BREAK.register(this::onBlockBreak);
    }

    private void onEntityJoinWorld(class_1297 entity, CallbackInfo callbackInfo) {
        if (PlayerListener.MC.field_1724 != null && entity == PlayerListener.MC.field_1724) {
            this.lastWorldJoin = class_156.method_658();
            this.timerTick = 1;
            main.getInventoryUtils().resetPreviousInventory();
            this.countedEndermen.clear();
            EndstoneProtectorManager.reset();
            IslandWarpGui.Marker doubleWarpMarker = IslandWarpGui.getDoubleWarpMarker();
            if (doubleWarpMarker != null) {
                IslandWarpGui.setDoubleWarpMarker(null);
                PlayerListener.MC.field_1724.field_3944.method_45729("/warp " + doubleWarpMarker.getWarpName());
            }
            NPCUtils.getNpcLocations().clear();
            JerryPresent.getJerryPresents().clear();
            FishParticleManager.clearParticleCache();
            main.getRenderListener().setMaxRiftHealth(0.0f);
            PlayerStat.MAX_RIFT_HEALTH.setValue(0.0f);
        }
    }

    private class_2561 onChatModify(class_2561 component, boolean actionBar) {
        if (!main.getUtils().isOnHypixel()) {
            return component;
        }
        String formattedText = TextUtils.getFormattedText(component);
        String unformattedText = component.getString();
        String strippedText = TextUtils.stripColor(component.getString());
        if (actionBar) {
            Iterator itr = this.actionBarParser.getStringsToRemove().iterator();
            String message = unformattedText;
            while (itr.hasNext()) {
                message = message.replaceAll(" *" + Pattern.quote((String)itr.next()), "");
            }
            message = message.trim();
            return class_2561.method_43470((String)message);
        }
        if (formattedText.equals("\u00a7aA special \u00a7r\u00a75Zealot \u00a7r\u00a7ahas spawned nearby!\u00a7r")) {
            if (Feature.SPECIAL_ZEALOT_ALERT.isEnabled()) {
                main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                main.getRenderListener().setTitleFeature(Feature.SUMMONING_EYE_ALERT);
                main.getRenderListener().setTitleFeature(Feature.SPECIAL_ZEALOT_ALERT);
            }
            if (Feature.ZEALOT_COUNTER.isEnabled()) {
                component = class_2561.method_43470((String)(formattedText + String.valueOf(ColorCode.GRAY) + " (" + main.getPersistentValuesManager().getPersistentValues().getKills() + ")"));
            }
            main.getPersistentValuesManager().addEyeResetKills();
        } else if (Feature.PLAYER_SYMBOLS_IN_CHAT.isEnabled() && unformattedText.contains(":")) {
            component = this.playerSymbolsDisplay(component);
        }
        return component;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onChatReceived(class_2561 component, boolean actionBar) {
        String mayorName;
        class_2568 hoverEvent;
        Object revivedPlayerName;
        if (!main.getUtils().isOnHypixel() || component == null) {
            return true;
        }
        String formattedText = TextUtils.getFormattedText(component);
        String unformattedText = component.getString();
        String strippedText = TextUtils.stripColor(component.getString());
        if (formattedText.startsWith("\u00a77Sending to server ")) {
            this.lastSkyblockServerJoinAttempt = class_156.method_658();
            DragonTracker.getInstance().reset();
            return true;
        }
        if (Feature.OUTBID_ALERT_SOUND.isEnabled() && formattedText.matches("\u00a76\\[Auction] \u00a7..*\u00a7eoutbid you .*") && (Feature.OUTBID_ALERT_SOUND.isEnabled(FeatureSetting.OUTBID_ALERT_SOUND_IN_OTHER_GAMES) || main.getUtils().isOnSkyblock())) {
            main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
        }
        if (actionBar) {
            String restMessage;
            if (Feature.DEVELOPER_MODE.isEnabled() && DevUtils.isLoggingActionBarMessages()) {
                LOGGER.info("[ACTION BAR] {}", (Object)unformattedText);
            }
            if ((restMessage = this.actionBarParser.parseActionBar(component.getString())).trim().isEmpty()) {
                return true;
            }
            if (main.getUtils().isInDungeon()) {
                if (Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.isEnabled()) {
                    main.getDungeonManager().addEssence(restMessage);
                }
                if (Feature.DUNGEONS_SECRETS_DISPLAY.isEnabled()) {
                    main.getDungeonManager().addSecrets(restMessage);
                }
            }
        } else {
            Matcher matcher;
            if (this.cachedChatRunCommand == null && formattedText.contains("\u00a72\u00a7l[PICK UP]")) {
                this.setChatRunCommandFromComponent(component);
            } else if (formattedText.contains("\u00a7a\u00a7l[YES]") || formattedText.contains("\u00a7a[Yes]")) {
                this.setChatRunCommandFromComponent(component);
            }
            if (main.getRenderListener().isPredictMana() && unformattedText.startsWith("Used ") && unformattedText.endsWith("Mana)")) {
                int manaLost = Integer.parseInt(unformattedText.split(Pattern.quote("! ("))[1].split(Pattern.quote(" Mana)"))[0]);
                PlayerStat.MANA.setValue(PlayerStat.MANA.getValue() - (float)manaLost);
            } else {
                matcher = AUTOPET_PATTERN.matcher(formattedText);
                if (matcher.find()) {
                    PetManager.getInstance().findCurrentPetFromAutopet(matcher.group("level"), matcher.group("rarityColor"), matcher.group("name"));
                } else {
                    matcher = PET_LEVELED_UP_PATTERN.matcher(formattedText);
                    if (matcher.find()) {
                        int newLevel = Integer.parseInt(matcher.group("newLevel"));
                        Object petName = matcher.group("name");
                        String petCosmetic = matcher.group("cosmetic");
                        if (!class_3544.method_15438((String)petCosmetic) && newLevel <= 200) {
                            petName = (String)petName + petCosmetic.replace("\u00a7r", "");
                        }
                        PetManager.getInstance().updateAndSetCurrentLevelledPet(newLevel, matcher.group("rarityColor"), (String)petName);
                    } else {
                        matcher = PET_ITEM_PATTERN.matcher(formattedText);
                        if (matcher.find()) {
                            PetManager.getInstance().updatePetItem(matcher.group("rarityColor"), matcher.group("petItem"));
                        } else {
                            matcher = DEATH_MESSAGE_PATTERN.matcher(unformattedText);
                            if (matcher.matches() && PlayerListener.MC.field_1687 != null) {
                                String causeOfDeath = matcher.group("causeOfDeath");
                                if (!causeOfDeath.equals("reconnected")) {
                                    String username = matcher.group("username");
                                    class_746 deadPlayer = null;
                                    if (username.equals("You")) {
                                        deadPlayer = PlayerListener.MC.field_1724;
                                    } else {
                                        for (class_742 player : PlayerListener.MC.field_1687.method_18456()) {
                                            if (!player.method_5477().getString().equals(username)) continue;
                                            deadPlayer = player;
                                            break;
                                        }
                                    }
                                    if (deadPlayer == null) return true;
                                    ((SkyblockEvents.SkyblockPlayerDeath)SkyblockEvents.DUNGEON_PLAYER_DEATH.invoker()).onDungeonPlayerDeath((class_742)deadPlayer, username, causeOfDeath);
                                    return true;
                                }
                            } else if (Feature.SUMMONING_EYE_ALERT.isEnabled() && formattedText.equals("\u00a76\u00a7lRARE DROP! \u00a7r\u00a75Summoning Eye\u00a7r")) {
                                main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                                main.getRenderListener().setTitleFeature(Feature.SUMMONING_EYE_ALERT);
                            } else if (SeaCreatureManager.getInstance().getAllSeaCreatureSpawnMessages().contains(unformattedText)) {
                                int spawned;
                                int n = spawned = unformattedText.contains("Magma Slug") || unformattedText.contains("Bayou Sludge") || unformattedText.contains("Liltads") ? 4 : 1;
                                if (this.doubleHook) {
                                    spawned *= 2;
                                    this.doubleHook = false;
                                }
                                main.getPersistentValuesManager().addSeaCreaturesKilled(spawned);
                                if (Feature.LEGENDARY_SEA_CREATURE_WARNING.isEnabled() && SeaCreatureManager.getInstance().getLegendarySeaCreatureSpawnMessages().contains(unformattedText)) {
                                    main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                                    main.getRenderListener().setTitleFeature(Feature.LEGENDARY_SEA_CREATURE_WARNING);
                                }
                            } else if (formattedText.startsWith("\u00a7eIt's a \u00a7r\u00a7aDouble Hook\u00a7r\u00a7e!")) {
                                this.doubleHook = true;
                            } else {
                                if (Feature.DISABLE_MAGICAL_SOUP_MESSAGES.isEnabled() && SOUP_RANDOM_MESSAGES.contains((Object)unformattedText)) {
                                    return false;
                                }
                                if (Feature.DISABLE_TELEPORT_PAD_MESSAGES.isEnabled() && (formattedText.startsWith("\u00a7aWarped from ") || formattedText.equals("\u00a7cThis Teleport Pad does not have a destination set!\u00a7r"))) {
                                    return false;
                                }
                                if (Feature.DISABLE_MORT_MESSAGES.isEnabled() && strippedText.startsWith("[NPC] Mort:")) {
                                    return false;
                                }
                                if (strippedText.startsWith("[BOSS] ")) {
                                    if (Feature.FIRE_FREEZE_TIMER.isEnabled() && strippedText.equals("[BOSS] The Professor: Oh? You found my Guardians' one weakness?")) {
                                        this.fireFreezeTimer = System.currentTimeMillis() + 5000L;
                                    }
                                    if (Feature.DISABLE_BOSS_MESSAGES.isEnabled()) {
                                        return false;
                                    }
                                } else if (Feature.SPIRIT_SCEPTRE_DISPLAY.isEnabled() && strippedText.startsWith("Your Implosion hit") || strippedText.startsWith("Your Spirit Sceptre hit") || strippedText.startsWith("Your Molten Wave hit")) {
                                    matcher = SPIRIT_SCEPTRE_MESSAGE_PATTERN.matcher(unformattedText);
                                    if (matcher.find()) {
                                        this.spiritSceptreHitEnemies = Integer.parseInt(matcher.group("hitEnemies"));
                                        this.spiritSceptreDealtDamage = Float.parseFloat(matcher.group("dealtDamage").replace(",", ""));
                                        if (Feature.SPIRIT_SCEPTRE_DISPLAY.isEnabled(FeatureSetting.DISABLE_SPIRIT_SCEPTRE_MESSAGES)) {
                                            return false;
                                        }
                                    }
                                } else if (SlayerTracker.getInstance().isTrackerEnabled() && (matcher = SLAYER_COMPLETED_PATTERN.matcher(unformattedText)).matches()) {
                                    SlayerTracker.getInstance().completedSlayer(matcher.group("slayerType"));
                                } else if (SlayerTracker.getInstance().isTrackerEnabled() && (matcher = SLAYER_COMPLETED_PATTERN_AUTO1.matcher(strippedText)).matches()) {
                                    this.lastMaddoxLevelTime = System.currentTimeMillis();
                                    this.lastMaddoxSlayerType = matcher.group("slayerType");
                                } else if (SLAYER_COMPLETED_PATTERN_AUTO2.matcher(strippedText).matches() && System.currentTimeMillis() - this.lastMaddoxLevelTime < 100L) {
                                    SlayerTracker.getInstance().completedSlayer(this.lastMaddoxSlayerType);
                                } else if (Feature.DRAGON_STATS_TRACKER.isEnabled() && strippedText.startsWith("\u262c You placed a Summoning Eye!")) {
                                    DragonTracker.getInstance().addEye();
                                } else if (Feature.DRAGON_STATS_TRACKER.isEnabled() && strippedText.equals("You recovered a Summoning Eye!")) {
                                    DragonTracker.getInstance().removeEye();
                                } else if (Feature.DRAGON_STATS_TRACKER.isEnabled() && (matcher = DRAGON_SPAWNED_PATTERN.matcher(strippedText)).matches()) {
                                    DragonTracker.getInstance().dragonSpawned(matcher.group("dragonType"));
                                } else if (Feature.DRAGON_STATS_TRACKER.isEnabled() && DRAGON_KILLED_PATTERN.matcher(strippedText).matches()) {
                                    DragonTracker.getInstance().dragonKilled();
                                } else if (Feature.BIRCH_PARK_RAINMAKER_TIMER.isEnabled() && formattedText.startsWith("\u00a7eYou added a minute of rain!")) {
                                    this.rainmakerTimeEnd = this.rainmakerTimeEnd == -1L || this.rainmakerTimeEnd < System.currentTimeMillis() ? System.currentTimeMillis() + 60000L : (this.rainmakerTimeEnd += 60000L);
                                } else if (Feature.FETCHUR_TODAY.isEnabled() && formattedText.startsWith("\u00a7e[NPC] Fetchur\u00a7f:")) {
                                    FetchurManager fetchur = FetchurManager.getInstance();
                                    if (unformattedText.contains(fetchur.getFetchurTaskCompletedPhrase())) {
                                        fetchur.saveLastTimeFetched();
                                    } else if (!fetchur.hasFetchedToday() && unformattedText.contains(fetchur.getFetchurAlreadyDidTaskPhrase())) {
                                        fetchur.saveLastTimeFetched();
                                    }
                                } else if (Feature.SHOW_ITEM_COOLDOWNS.isEnabled() && unformattedText.equals("You laid an egg!")) {
                                    CooldownManager.put("CHICKEN_HEAD");
                                }
                            }
                        }
                    }
                }
            }
            if (Feature.NO_ARROWS_LEFT_ALERT.isEnabled()) {
                if (NO_ARROWS_LEFT_PATTERN.matcher(formattedText).matches()) {
                    main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                    main.getRenderListener().setSubtitleFeature(Feature.NO_ARROWS_LEFT_ALERT);
                    main.getRenderListener().setArrowsLeft(-1);
                    return false;
                }
                matcher = ONLY_HAVE_ARROWS_LEFT_PATTERN.matcher(formattedText);
                if (matcher.matches()) {
                    int arrowsLeft = Integer.parseInt(matcher.group("arrows"));
                    main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                    main.getRenderListener().setSubtitleFeature(Feature.NO_ARROWS_LEFT_ALERT);
                    main.getRenderListener().setArrowsLeft(arrowsLeft);
                    main.getRenderListener().setArrowsType(matcher.group("type"));
                    return false;
                }
            }
            if (main.getInventoryUtils().getInventoryType() == InventoryType.SALVAGING && Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.isEnabled(FeatureSetting.SHOW_SALVAGE_ESSENCES_COUNTER)) {
                main.getDungeonManager().addSalvagedEssences(unformattedText);
            }
            if (main.getUtils().isInDungeon()) {
                DungeonMilestone dungeonMilestone;
                Matcher reviveMessageMatcher = REVIVE_MESSAGE_PATTERN.matcher(unformattedText);
                if (reviveMessageMatcher.matches() && PlayerListener.MC.field_1687 != null) {
                    List players = PlayerListener.MC.field_1687.method_18456();
                    revivedPlayerName = reviveMessageMatcher.group("revivedPlayer");
                    String reviverName = reviveMessageMatcher.group("reviver");
                    class_742 revivedPlayer = null;
                    class_742 revivingPlayer = null;
                    for (class_742 player : players) {
                        if (revivedPlayer != null && revivingPlayer != null) break;
                        if (player.method_5477().getString().equals(revivedPlayerName)) {
                            revivedPlayer = player;
                            this.lastRevive = class_156.method_658();
                        }
                        if (reviverName == null || !player.method_5477().getString().equals(reviverName)) continue;
                        revivingPlayer = player;
                    }
                    ((SkyblockEvents.SkyblockPlayerRevive)SkyblockEvents.DUNGEON_PLAYER_REVIVE.invoker()).onDungeonPlayerRevive(revivedPlayer, revivingPlayer);
                }
                if (Feature.SHOW_DUNGEON_MILESTONE.isEnabled() && (dungeonMilestone = main.getDungeonManager().parseMilestone(formattedText)) != null) {
                    main.getDungeonManager().setDungeonMilestone(dungeonMilestone);
                }
                if (Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.isEnabled()) {
                    main.getDungeonManager().addBonusEssence(formattedText);
                }
            }
            if (ABILITY_CHAT_PATTERN.matcher(formattedText).matches() && PlayerListener.MC.field_1724 != null) {
                CooldownManager.put(PlayerListener.MC.field_1724.method_6047());
            } else {
                matcher = PROFILE_CHAT_PATTERN.matcher(strippedText);
                if (matcher.matches()) {
                    String profile = matcher.group(1);
                    main.getUtils().setProfileName(profile);
                } else {
                    matcher = SWITCH_PROFILE_CHAT_PATTERN.matcher(strippedText);
                    if (matcher.matches()) {
                        String profile = matcher.group(1);
                        main.getUtils().setProfileName(profile);
                    }
                }
            }
        }
        if (!unformattedText.contains("\u00a7eis elected Mayor for the year, \u00a76gg\u00a7e!") || main.getUtils().isAlpha() || !((hoverEvent = component.method_10866().method_10969()) instanceof class_2568.class_10613)) return true;
        class_2568.class_10613 class_106132 = (class_2568.class_10613)hoverEvent;
        try {
            class_2561 value = revivedPlayerName = class_106132.comp_3510();
            String[] lines = TextUtils.getFormattedText(value).split("\n");
            mayorName = lines[0].substring(lines[0].lastIndexOf(" ") + 1);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        DataUtils.loadOnlineData(new MayorRequest(mayorName));
        main.getUtils().setMayor(mayorName);
        LOGGER.info("Mayor changed to {}", (Object)mayorName);
        return true;
    }

    private void onTickStart(class_310 mc) {
        ++this.timerTick;
        ScoreboardManager.tick();
        if (mc.field_1687 == null) {
            main.getRenderListener().setGui();
        }
        if (this.actionBarParser.getHealthUpdate() != null && System.currentTimeMillis() - this.actionBarParser.getLastHealthUpdate() > 3000L) {
            this.actionBarParser.setHealthUpdate(null);
        }
        this.updateHealthAttributes(mc);
        PetManager.getInstance().checkCurrentPet(mc);
        this.flyingCheck();
        if (this.timerTick == 20) {
            float maxMana;
            float mana;
            if (main.getRenderListener().isPredictMana() && (mana = PlayerStat.MANA.getValue()) < (maxMana = PlayerStat.MAX_MANA.getValue())) {
                DeployableManager.DeployableEntry activeDeployable = DeployableManager.getInstance().getActiveDeployable();
                float predictedRegenMana = maxMana / 50.0f;
                if (activeDeployable != null) {
                    predictedRegenMana += (float)((double)maxMana * activeDeployable.getDeployable().getManaRegen() / 50.0);
                }
                PlayerStat.MANA.setValue(Math.min(mana + predictedRegenMana, maxMana));
            }
            if (Feature.DUNGEON_DEATH_COUNTER.isEnabled() && main.getUtils().isInDungeon() && main.getDungeonManager().isPlayerListInfoEnabled()) {
                main.getDungeonManager().updateDeathsFromPlayerListInfo();
            }
            if (this.savePersistentFlag) {
                main.getPersistentValuesManager().saveValues();
                this.savePersistentFlag = false;
            }
        } else if (this.timerTick % 5 == 0) {
            class_746 player = mc.field_1724;
            if (player != null) {
                EndstoneProtectorManager.checkGolemStatus();
                TabListParser.parse();
                main.getUtils().parseSidebar();
                main.getInventoryUtils().checkIfInventoryIsFull(mc, player);
                if (main.getUtils().isOnSkyblock()) {
                    main.getInventoryUtils().checkIfWearingSkeletonHelmet(player);
                    main.getInventoryUtils().checkIfUsingArrowPoison(player);
                    main.getInventoryUtils().checkIfWearingSlayerArmor(player);
                    main.getInventoryUtils().checkIfThunderBottle(player);
                    if (Feature.FETCHUR_TODAY.isEnabled()) {
                        FetchurManager.getInstance().recalculateFetchurItem();
                    }
                    this.checkPetMilestones(mc);
                }
                if (mc.field_1755 == null && main.getPlayerListener().didntRecentlyJoinWorld() && (!main.getUtils().isInDungeon() || class_156.method_658() - this.lastDeath > 1000L && class_156.method_658() - this.lastRevive > 1000L)) {
                    main.getInventoryUtils().calculateInventoryDifference((class_2371<class_1799>)player.method_31548().method_67533());
                }
                if (Feature.BAIT_LIST.isEnabled() && this.isHoldingRod()) {
                    BaitManager.getInstance().refreshBaits(player);
                }
            }
            main.getInventoryUtils().cleanUpPickupLog();
        } else if (this.timerTick > 20) {
            this.timerTick = 1;
        }
    }

    private void onEntityTick(class_1309 livingEntity) {
        if (!main.getUtils().isOnSkyblock()) {
            return;
        }
        if (Feature.BROOD_MOTHER_ALERT.isEnabled() && LocationUtils.isOn(Island.SPIDERS_DEN) && livingEntity.method_16914() && livingEntity.method_23318() > 165.0 && livingEntity.method_5477().getString().contains("Broodmother")) {
            if (this.lastBroodmother == -1L || System.currentTimeMillis() - this.lastBroodmother > 15000L) {
                this.lastBroodmother = System.currentTimeMillis();
                main.getRenderListener().setTitleFeature(Feature.BROOD_MOTHER_ALERT);
            }
            if (livingEntity.field_6012 < 13 && livingEntity.field_6012 % 3 == 0) {
                Utils.playSound(class_3417.field_14627, 0.5);
            }
        }
        if (Feature.BAL_BOSS_ALERT.isEnabled() && LocationUtils.isOn(Island.CRYSTAL_HOLLOWS) && PlayerListener.MC.field_1687 != null) {
            if (this.lastBal == -1L || System.currentTimeMillis() - this.lastBal > 60000L) {
                for (class_1297 cubes : PlayerListener.MC.field_1687.method_18112()) {
                    class_1589 magmaCube;
                    if (!(cubes instanceof class_1589) || (magmaCube = (class_1589)cubes).method_7152() <= 10 || this.lastBalEntityId == magmaCube.method_5628()) continue;
                    this.lastBal = System.currentTimeMillis();
                    this.lastBalEntityId = magmaCube.method_5628();
                    main.getRenderListener().setTitleFeature(Feature.BAL_BOSS_ALERT);
                    break;
                }
            }
            if (main.getRenderListener().getTitleFeature() == Feature.BAL_BOSS_ALERT && this.timerTick % 4 == 0) {
                Utils.playSound(class_3417.field_14627, 0.5);
            }
        }
        if (livingEntity.field_6012 < 20) {
            if (Feature.HIDE_OTHER_PLAYERS_PRESENTS.isEnabled()) {
                JerryPresent.detectJerryPresent((class_1297)livingEntity);
            }
            if (livingEntity instanceof class_745 && !main.getUtils().isGuest() && !LocationUtils.isOn(Island.DUNGEON)) {
                float health = livingEntity.method_6032();
                if (NPCUtils.getNpcLocations().containsKey(livingEntity.method_5628())) {
                    if (health != 20.0f) {
                        NPCUtils.getNpcLocations().remove(livingEntity.method_5628());
                        return;
                    }
                } else if (NPCUtils.isNPC((class_1297)livingEntity)) {
                    NPCUtils.getNpcLocations().put(livingEntity.method_5628(), (Object)livingEntity.method_73189());
                    return;
                }
            }
        }
        if (livingEntity instanceof class_1531) {
            class_1531 armorStand = (class_1531)livingEntity;
            DeployableManager.getInstance().detectDeployables(armorStand);
            if (livingEntity.method_16914() && LocationUtils.isOn(Island.PRIVATE_ISLAND) && !main.getUtils().isGuest()) {
                long now;
                Matcher matcher;
                int cooldown = Feature.WARNING_TIME.numberValue().intValue() * 1000 + 10000;
                String nameTag = TextUtils.getFormattedText(livingEntity.method_5797());
                if (Feature.MINION_FULL_WARNING.isEnabled() && nameTag.equals("\u00a7cMy storage is full! :(")) {
                    long now2 = System.currentTimeMillis();
                    if (now2 - this.lastMinionSound > (long)cooldown) {
                        this.lastMinionSound = now2;
                        main.getUtils().playLoudSound(class_3417.field_15197, 1.0);
                        main.getRenderListener().setSubtitleFeature(Feature.MINION_FULL_WARNING);
                    }
                } else if (Feature.MINION_STOP_WARNING.isEnabled() && (matcher = MINION_CANT_REACH_PATTERN.matcher(nameTag)).matches() && (now = System.currentTimeMillis()) - this.lastMinionSound > (long)cooldown) {
                    this.lastMinionSound = now;
                    main.getUtils().playLoudSound(class_3417.field_14627, 1.0);
                    String mobName = matcher.group("mobName");
                    main.getRenderListener().setCannotReachMobName(mobName);
                    main.getRenderListener().setSubtitleFeature(Feature.MINION_STOP_WARNING);
                }
            }
        }
    }

    private void onGetComponentFirst(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> components) {
        if (components.isEmpty() || !main.getUtils().isOnSkyblock()) {
            return;
        }
        int insertAt = components.size() - 1;
        if (tooltipFlag.method_8035()) {
            insertAt -= 2;
            if (itemStack.method_7986()) {
                --insertAt;
            }
        }
        insertAt = Math.max(0, insertAt);
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        if (extraAttributes != null) {
            if (Feature.SHOW_BASE_STAT_BOOST_PERCENTAGE.isEnabled() && extraAttributes.method_10545("baseStatBoostPercentage")) {
                int baseStatBoost = extraAttributes.method_68083("baseStatBoostPercentage", 0);
                ColorCode colorCode = Feature.SHOW_BASE_STAT_BOOST_PERCENTAGE.getRestrictedColor();
                if (Feature.SHOW_BASE_STAT_BOOST_PERCENTAGE.isEnabled(FeatureSetting.BASE_STAT_COLOR_BY_RARITY)) {
                    int rarityIndex = baseStatBoost / 10;
                    if (rarityIndex < 0) {
                        rarityIndex = 0;
                    }
                    if (rarityIndex >= SkyblockRarity.values().length) {
                        rarityIndex = SkyblockRarity.values().length - 1;
                    }
                    colorCode = SkyblockRarity.values()[rarityIndex].getColorCode();
                }
                components.add(insertAt++, (class_2561)class_2561.method_43470((String)("\u00a77Base Stat Boost: " + String.valueOf(colorCode) + "+" + baseStatBoost + "%")));
            }
            if (Feature.SHOW_STACKING_ENCHANT_PROGRESS.isEnabled()) {
                insertAt = EnchantManager.insertStackingEnchantProgress(components, extraAttributes, insertAt);
            }
            if (Feature.SHOW_SWORD_KILLS.isEnabled() && extraAttributes.method_10545("sword_kills")) {
                ColorCode colorCode = Feature.SHOW_SWORD_KILLS.getRestrictedColor();
                int swordKills = extraAttributes.method_68083("sword_kills", 0);
                components.add(insertAt++, (class_2561)class_2561.method_43470((String)("\u00a77Sword Kills: " + String.valueOf(colorCode) + swordKills)));
            }
            if (Feature.SHOW_ITEM_DUNGEON_FLOOR.isEnabled() && extraAttributes.method_10545("item_tier")) {
                int floor = extraAttributes.method_68083("item_tier", 0);
                ColorCode colorCode = Feature.SHOW_ITEM_DUNGEON_FLOOR.getRestrictedColor();
                components.add(insertAt, (class_2561)class_2561.method_43470((String)("\u00a77Obtained on Floor: " + String.valueOf(colorCode) + String.valueOf(floor == 0 ? "Entrance" : Integer.valueOf(floor)))));
            }
        }
    }

    private void onGetComponentLast(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> components) {
        int i;
        if (components.isEmpty() || !main.getUtils().isOnSkyblock()) {
            return;
        }
        if (Feature.ENCHANTMENT_LORE_PARSING.isEnabled()) {
            EnchantManager.parseEnchants(components, itemStack);
        }
        if (Feature.REPLACE_ROMAN_NUMERALS_WITH_NUMBERS.isEnabled()) {
            int startIndex;
            for (i = startIndex = (replaceItemName = Feature.REPLACE_ROMAN_NUMERALS_WITH_NUMBERS.isEnabled(FeatureSetting.DONT_REPLACE_ROMAN_NUMERALS_IN_ITEM_NAME)) ? 1 : 0; i < components.size(); ++i) {
                String line = components.get(i).getString();
                boolean legacy = line.contains("\u00a7");
                if (!legacy) {
                    line = TextUtils.getFormattedText(components.get(i));
                }
                String parsedFormattedText = RomanNumeralParser.replaceNumeralsWithIntegers(line);
                if (legacy) {
                    components.set(i, (class_2561)EnchantManager.CREATE_STYLED_COMPONENT.apply(parsedFormattedText));
                    continue;
                }
                components.set(i, (class_2561)class_2561.method_43470((String)parsedFormattedText));
            }
        }
        if (Feature.SHOW_SKYBLOCK_ITEM_ID.isEnabled() || Feature.DEVELOPER_MODE.isEnabled()) {
            String itemId = ItemUtils.getSkyblockItemID(itemStack);
            class_5250 tooltipLine = class_2561.method_43470((String)(String.valueOf(ColorCode.DARK_GRAY) + "skyblock:" + itemId));
            if (itemId != null) {
                if (tooltipFlag.method_8035()) {
                    i = components.size();
                    while (i-- > 0) {
                        if (!TextUtils.getFormattedText(components.get(i)).startsWith(String.valueOf(ColorCode.DARK_GRAY) + "minecraft:")) continue;
                        components.add(i + 1, (class_2561)tooltipLine);
                        break;
                    }
                } else {
                    components.add((class_2561)tooltipLine);
                }
            }
        }
    }

    private void handleKeybinds() {
        while (SkyblockKeyBinding.OPEN_SETTINGS.consumeClick()) {
            main.getUtils().setFadingIn(true);
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.MAIN, 1, EnumUtils.GuiTab.MAIN);
        }
        while (SkyblockKeyBinding.OPEN_EDIT_GUI.consumeClick()) {
            main.getUtils().setFadingIn(false);
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.EDIT_LOCATIONS, 0, null);
        }
        while (SkyblockKeyBinding.ANSWER_ABIPHONE_OR_OPTION.consumeClick()) {
            if (this.cachedChatRunCommand == null || PlayerListener.MC.field_1724 == null || !PlayerListener.MC.field_1724.field_3944.method_48106()) continue;
            PlayerListener.MC.field_1724.field_3944.method_45729(this.cachedChatRunCommand);
        }
        while (SkyblockKeyBinding.DEVELOPER_COPY_NBT.consumeClick()) {
            if (!Feature.DEVELOPER_MODE.isEnabled()) continue;
            DevUtils.copyData();
        }
        if (Feature.DUNGEONS_MAP_DISPLAY.isEnabled(FeatureSetting.CHANGE_DUNGEON_MAP_ZOOM_WITH_KEYBOARD) && main.getUtils().isInDungeon()) {
            while (SkyblockKeyBinding.DECREASE_DUNGEON_MAP_ZOOM.consumeClick()) {
                DungeonMapManager.decreaseZoomByStep();
            }
            while (SkyblockKeyBinding.INCREASE_DUNGEON_MAP_ZOOM.consumeClick()) {
                DungeonMapManager.increaseZoomByStep();
            }
        }
    }

    public void onPlaySound(class_1113 soundInstance, CallbackInfoReturnable<class_1140.class_11518> cir) {
        String skyblockId;
        boolean isRatSound;
        if (!main.getUtils().isOnSkyblock() || soundInstance.method_4787()) {
            return;
        }
        if (Feature.STOP_RAT_SOUNDS.isEnabled() && soundInstance.method_4774() == class_3419.field_15254 && (isRatSound = RAT_SOUNDS.stream().anyMatch(ratSound -> soundInstance.method_4775().equals((Object)ratSound.location()) && soundInstance.method_4782() == ratSound.pitch() && soundInstance.method_4781() == ratSound.volume())) && (Feature.STOP_RAT_SOUNDS.isDisabled(FeatureSetting.STOP_ONLY_RAT_SQUEAK) || soundInstance.method_4775().equals((Object)class_3417.field_15009.comp_3319()))) {
            cir.cancel();
            return;
        }
        class_746 player = PlayerListener.MC.field_1724;
        if (Feature.BACKPACK_OPENING_SOUND.isEnabled() && System.currentTimeMillis() - main.getScreenListener().getLastBackpackOpenMs() < 500L && soundInstance.method_4775().equals((Object)class_3417.field_14982.comp_3319()) && player != null && (double)Math.round(soundInstance.method_4784()) == player.method_73189().method_10216() && (double)Math.round(soundInstance.method_4779()) == player.method_73189().method_10214() && (double)Math.round(soundInstance.method_4778()) == player.method_73189().method_10215()) {
            cir.cancel();
            return;
        }
        if (Feature.STOP_BONZO_STAFF_SOUNDS.isEnabled() && BONZO_STAFF_SOUNDS.contains(soundInstance.method_4775()) && PlayerListener.MC.field_1724 != null && (skyblockId = ItemUtils.getSkyblockItemID(PlayerListener.MC.field_1724.method_6047())) != null && skyblockId.endsWith("BONZO_STAFF")) {
            cir.cancel();
            return;
        }
    }

    private void onDungeonPlayerDeath(class_742 player, String username, String cause) {
        class_746 localPlayer = PlayerListener.MC.field_1724;
        if (localPlayer == null) {
            return;
        }
        if (Feature.PREVENT_MOVEMENT_ON_DEATH.isEnabled() && player == localPlayer) {
            class_304.method_1437();
        }
        if (Feature.ITEM_PICKUP_LOG.isEnabled() && player == localPlayer && main.getUtils().isInDungeon()) {
            this.lastDeath = class_156.method_658();
            main.getInventoryUtils().resetPreviousInventory();
        }
        if (Feature.DUNGEON_DEATH_COUNTER.isEnabled() && main.getUtils().isInDungeon()) {
            DungeonPlayer dungeonPlayer = main.getDungeonManager().getDungeonPlayerByName(username);
            if (dungeonPlayer != null) {
                if (cause.contains("disconnected") && dungeonPlayer.isGhost()) {
                    return;
                }
                main.getDungeonManager().addDeath();
            } else if (player == localPlayer) {
                if (cause.contains("disconnected") && localPlayer.method_31549().field_7478) {
                    return;
                }
                main.getDungeonManager().addDeath();
            } else {
                LOGGER.warn("Could not record death for {}. This dungeon player isn't in the registry.", (Object)username);
            }
        }
    }

    private void onDungeonPlayerRevive(class_742 revivedPlayer, class_742 revivingPlayer) {
        if (revivedPlayer == PlayerListener.MC.field_1724) {
            this.lastRevive = class_156.method_658();
        }
        if (Feature.ITEM_PICKUP_LOG.isEnabled()) {
            main.getInventoryUtils().resetPreviousInventory();
        }
    }

    private void onBlockBreak(class_2338 blockPos, long l) {
        if (PlayerListener.MC.field_1687 == null || PlayerListener.MC.field_1724 == null) {
            return;
        }
        class_2680 blockState = PlayerListener.MC.field_1687.method_8320(blockPos);
        SkyblockOre minedOre = SkyblockOre.getByStateOrNull(blockState);
        if (minedOre != null) {
            switch (minedOre.getBlockType()) {
                case ORE: 
                case DWARVEN_METAL: 
                case GEMSTONE: {
                    main.getPersistentValuesManager().addOresMined();
                }
            }
            if (DevUtils.isLoggingSkyBlockOre()) {
                Utils.sendMessage("\u00a7eMined ore: \u00a7f" + minedOre.name());
            }
        }
        if (Feature.SHOW_ITEM_COOLDOWNS.isEnabled()) {
            String itemId = ItemUtils.getSkyblockItemID(PlayerListener.MC.field_1724.method_6047());
            if (itemId == null) {
                return;
            }
            if ((itemId.equals("JUNGLE_AXE") || itemId.equals("TREECAPITATOR_AXE")) && blockState.method_26164(class_3481.field_15475)) {
                long cooldownTime = CooldownManager.getItemCooldown(itemId);
                PetManager.Pet pet = main.getPetCacheManager().getCurrentPet();
                if (pet != null && pet.getPetInfo().getPetRarity() == SkyblockRarity.LEGENDARY && pet.getPetInfo().getPetSkyblockId().equalsIgnoreCase("monkey")) {
                    cooldownTime -= (long)((int)(2000.0 * (0.005 * (double)pet.getPetLevel())));
                }
                CooldownManager.put(itemId, Math.max(cooldownTime, 400L));
            }
        }
    }

    private class_1269 onRightClickBlock(class_1657 player, class_1937 world, class_1268 hand) {
        String itemId;
        if (player.method_6047().method_7909() == class_1802.field_8378 && Feature.SHOW_ITEM_COOLDOWNS.isEnabled() && (itemId = ItemUtils.getSkyblockItemID(player.method_6047())) != null && itemId.equals("GRAPPLING_HOOK") && player.field_7513 != null) {
            boolean wearingFullBatPerson = InventoryUtils.isWearingFullSet(player, InventoryUtils.BAT_PERSON_SET_IDS);
            int cooldownTime = wearingFullBatPerson ? 0 : CooldownManager.getItemCooldown(itemId);
            CooldownManager.put(itemId, (long)cooldownTime);
        }
        return class_1269.field_5811;
    }

    public boolean aboutToJoinSkyblockServer() {
        return class_156.method_658() - this.lastSkyblockServerJoinAttempt < 6000L;
    }

    public boolean didntRecentlyJoinWorld() {
        return class_156.method_658() - this.lastWorldJoin > 3000L;
    }

    public int getMaxTickers() {
        return this.actionBarParser.getMaxTickers();
    }

    public int getTickers() {
        return this.actionBarParser.getTickers();
    }

    public void updateLastSecondHealth() {
        float health = PlayerStat.HEALTH.getValue();
        if (Feature.HEALTH_UPDATES.isEnabled() && this.actionBarParser.getLastSecondHealth() != health) {
            this.actionBarParser.setHealthUpdate(Float.valueOf(health - this.actionBarParser.getLastSecondHealth()));
            this.actionBarParser.setLastHealthUpdate(System.currentTimeMillis());
        }
        this.actionBarParser.setLastSecondHealth(health);
    }

    public boolean shouldResetMouse() {
        return System.currentTimeMillis() - main.getScreenListener().getLastContainerCloseMs() > 150L;
    }

    public boolean isHoldingRod() {
        class_746 player = PlayerListener.MC.field_1724;
        if (player != null) {
            class_1799 item = player.method_6047();
            if (item == class_1799.field_8037 || item.method_7909() != class_1802.field_8378) {
                return false;
            }
            return ItemUtils.getItemType(item) == ItemType.FISHING_ROD;
        }
        return false;
    }

    public boolean isHoldingMiningTool() {
        ItemType type;
        class_1799 item;
        class_746 player = PlayerListener.MC.field_1724;
        if (player != null && (item = player.method_6047()) != class_1799.field_8037 && (type = ItemUtils.getItemType(item)) != null) {
            return switch (type) {
                case ItemType.PICKAXE, ItemType.GAUNTLET, ItemType.DRILL -> true;
                default -> false;
            };
        }
        return false;
    }

    public boolean isHoldingFireFreeze() {
        class_1799 item;
        class_746 player = PlayerListener.MC.field_1724;
        if (player != null && (item = player.method_6047()) != class_1799.field_8037 && item.method_65130() != null) {
            String itemName = item.method_65130().getString();
            return itemName.contains("Fire Freeze Staff");
        }
        return false;
    }

    private class_2561 playerSymbolsDisplay(class_2561 root) {
        class_746 localPlayer = PlayerListener.MC.field_1724;
        if (localPlayer == null) {
            return root;
        }
        String username = TextUtils.stripColor(root.getString().split(":")[0]);
        if (username.contains(">")) {
            username = username.substring(username.indexOf(62) + 1).trim();
        }
        if (!TextUtils.isUsername(username) && !username.equals("**MINECRAFTUSERNAME**")) {
            return root;
        }
        String finalUsername = TextUtils.stripUsername(username);
        Collection networkPlayerInfos = localPlayer.field_3944.method_45732();
        Optional<class_640> result = networkPlayerInfos.stream().filter(pi -> {
            String profileName = pi.method_2966().name();
            return profileName != null && profileName.equals(finalUsername);
        }).findAny();
        if (result.isPresent()) {
            class_355 tabList = class_310.method_1551().field_1705.method_1750();
            this.namesWithSymbols.put(username, TextUtils.getFormattedText(tabList.method_1918(result.get())).trim());
        }
        if (this.namesWithSymbols.containsKey(username)) {
            Matcher m;
            String usernameWithSymbols = this.namesWithSymbols.get(username);
            Object suffix = " ";
            if (Feature.PLAYER_SYMBOLS_IN_CHAT.isEnabled(FeatureSetting.SHOW_PROFILE_TYPE) && (m = PROFILE_TYPE_SYMBOL.matcher(usernameWithSymbols)).find()) {
                suffix = (String)suffix + m.group(0);
            }
            if (Feature.PLAYER_SYMBOLS_IN_CHAT.isEnabled(FeatureSetting.SHOW_NETHER_FACTION) && (m = NETHER_FACTION_SYMBOL.matcher(usernameWithSymbols)).find()) {
                suffix = (String)suffix + m.group(0);
            }
            if (!((String)suffix).isBlank()) {
                String formattedRoot = TextUtils.getFormattedText(root).replace(finalUsername, finalUsername + (String)suffix);
                class_5250 modifiedRoot = class_2561.method_43470((String)formattedRoot);
                class_2583 rootStyle = root.method_10866().method_10969() != null ? root.method_10866() : ((class_2561)root.method_10855().getFirst()).method_10866();
                return modifiedRoot.method_27694(style -> style.method_10958(rootStyle.method_10970()).method_10949(rootStyle.method_10969()));
            }
        }
        return root;
    }

    private void updateHealthAttributes(class_310 MC) {
        class_746 p = MC.field_1724;
        if (p != null) {
            if (main.getUtils().isOnRift()) {
                if (Feature.HEALTH_BAR.isEnabled() || Feature.HEALTH_TEXT.isEnabled()) {
                    PlayerStat.MAX_RIFT_HEALTH.setValue(p.method_6063());
                    PlayerStat.HEALTH.setValue(p.method_6032());
                }
            } else if (Feature.HEALTH_BAR.isEnabled(FeatureSetting.HEALTH_PREDICTION)) {
                float newHealth = PlayerStat.HEALTH.getValue() > PlayerStat.MAX_HEALTH.getValue() ? PlayerStat.HEALTH.getValue() : (float)Math.round(PlayerStat.MAX_HEALTH.getValue() * (p.method_6032() / p.method_6063()));
                PlayerStat.HEALTH.setValue(newHealth);
            }
        }
    }

    private void checkPetMilestones(class_310 mc) {
        if (main.getInventoryUtils().getInventoryType() == InventoryType.SKILL_TYPE_MENU) {
            SkillType skill = SkillType.getFromString(main.getInventoryUtils().getInventorySubtype());
            class_437 class_4372 = mc.field_1755;
            if (class_4372 instanceof class_476) {
                class_476 containerScreen = (class_476)class_4372;
                if (skill == SkillType.MINING || skill == SkillType.FISHING) {
                    class_1707 container = (class_1707)containerScreen.method_17577();
                    class_2371 itemList = container.method_7602();
                    class_1799 milestoneItem = (class_1799)itemList.get(51);
                    if (milestoneItem == class_1799.field_8037) {
                        return;
                    }
                    List<String> lore = ItemUtils.getItemLore(milestoneItem);
                    if (lore.isEmpty()) {
                        return;
                    }
                    String milestoneProgress = TextUtils.stripColor(lore.getLast());
                    Matcher m = NEXT_TIER_PET_PROGRESS.matcher(milestoneProgress);
                    int total = -1;
                    if (m.matches()) {
                        total = Integer.parseInt(m.group("total").replaceAll(",", ""));
                    } else {
                        m = MAXED_TIER_PET_PROGRESS.matcher(milestoneProgress);
                        if (m.matches()) {
                            total = Integer.parseInt(m.group("total").replaceAll(",", ""));
                        }
                    }
                    if (total > 0) {
                        int original;
                        PersistentValuesManager.PersistentValues persistentValues = main.getPersistentValuesManager().getPersistentValues();
                        if (skill == SkillType.FISHING) {
                            original = persistentValues.getSeaCreaturesKilled();
                            main.getPersistentValuesManager().getPersistentValues().setSeaCreaturesKilled(total);
                        } else {
                            original = persistentValues.getOresMined();
                            main.getPersistentValuesManager().getPersistentValues().setOresMined(total);
                        }
                        if (original != total) {
                            main.getPersistentValuesManager().saveValues();
                        }
                    }
                }
            }
        }
    }

    private void setChatRunCommandFromComponent(class_2561 component) {
        for (class_2561 sibling : component.method_10855()) {
            class_2558 clickEvent;
            class_2583 style = sibling.method_10866();
            if (style == class_2583.field_24360 || !((clickEvent = style.method_10970()) instanceof class_2558.class_10609)) continue;
            class_2558.class_10609 class_106092 = (class_2558.class_10609)clickEvent;
            try {
                String string;
                String command;
                this.cachedChatRunCommand = command = (string = class_106092.comp_3506());
                main.getScheduler().scheduleTask(scheduledTask -> {
                    this.cachedChatRunCommand = null;
                }, 200);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return;
        }
    }

    private void flyingCheck() {
        class_746 thePlayer = PlayerListener.MC.field_1724;
        if (thePlayer != null && LocationUtils.isOn(Island.KUUDRA)) {
            if (this.previousAllowFlyingState != thePlayer.method_31549().field_7478 && Feature.ITEM_PICKUP_LOG.isEnabled()) {
                main.getInventoryUtils().resetPreviousInventory();
            }
            this.previousAllowFlyingState = thePlayer.method_31549().field_7478;
        }
    }

    @Generated
    public ActionBarParser getActionBarParser() {
        return this.actionBarParser;
    }

    @Generated
    public long getRainmakerTimeEnd() {
        return this.rainmakerTimeEnd;
    }

    @Generated
    public Set<UUID> getCountedEndermen() {
        return this.countedEndermen;
    }

    @Generated
    public TreeMap<Long, Set<class_243>> getRecentlyKilledZealots() {
        return this.recentlyKilledZealots;
    }

    @Generated
    public int getSpiritSceptreHitEnemies() {
        return this.spiritSceptreHitEnemies;
    }

    @Generated
    public float getSpiritSceptreDealtDamage() {
        return this.spiritSceptreDealtDamage;
    }

    @Generated
    public TreeMap<Long, class_243> getExplosiveBowExplosions() {
        return this.explosiveBowExplosions;
    }

    @Generated
    public long getFireFreezeTimer() {
        return this.fireFreezeTimer;
    }

    @Generated
    public void setFireFreezeTimer(long fireFreezeTimer) {
        this.fireFreezeTimer = fireFreezeTimer;
    }

    @Generated
    public void setSavePersistentFlag(boolean savePersistentFlag) {
        this.savePersistentFlag = savePersistentFlag;
    }

    private record RatSound(class_2960 location, float volume, float pitch) {
    }
}

