/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerBoss;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_2960;

public class EnumUtils {

    public static enum SlayerQuest {
        REVENANT_HORROR("Revenant Horror", SlayerBoss.REVENANT),
        TARANTULA_BROODFATHER("Tarantula Broodfather", SlayerBoss.TARANTULA),
        SVEN_PACKMASTER("Sven Packmaster", SlayerBoss.SVEN),
        VOIDGLOOM_SERAPH("Voidgloom Seraph", SlayerBoss.VOIDGLOOM),
        INFERNO_DEMONLORD("Inferno Demonlord", SlayerBoss.INFERNO),
        RIFTSTALKER_BLOODFIEND("Riftstalker Bloodfiend", SlayerBoss.RIFTSTALKER);

        private final String scoreboardName;
        private final SlayerBoss boss;

        public static SlayerQuest fromName(String scoreboardName) {
            for (SlayerQuest slayerQuest : SlayerQuest.values()) {
                if (!slayerQuest.scoreboardName.equals(scoreboardName)) continue;
                return slayerQuest;
            }
            return null;
        }

        @Generated
        public String getScoreboardName() {
            return this.scoreboardName;
        }

        @Generated
        public SlayerBoss getBoss() {
            return this.boss;
        }

        @Generated
        private SlayerQuest(String scoreboardName, SlayerBoss boss) {
            this.scoreboardName = scoreboardName;
            this.boss = boss;
        }
    }

    public static enum GUIType {
        MAIN,
        EDIT_LOCATIONS,
        SETTINGS,
        WARP;

    }

    public static enum Social {
        GITHUB("github", "https://github.com/Fix3dll/SkyblockAddons"),
        MODRINTH("modrinth", "https://modrinth.com/project/F35D4vTL"),
        BUYMEACOFFEE("buymeacoffee", "https://www.buymeacoffee.com/fix3dll");

        private final class_2960 resourceLocation;
        private URI url;

        private Social(String resourcePath, String url) {
            this.resourceLocation = SkyblockAddons.resourceLocation("gui/" + resourcePath + ".png");
            try {
                this.url = new URI(url);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }

        @Generated
        public class_2960 getResourceLocation() {
            return this.resourceLocation;
        }

        @Generated
        public URI getUrl() {
            return this.url;
        }
    }

    public static enum DrawType {
        SKELETON_BAR,
        BAR,
        TEXT,
        PICKUP_LOG,
        DEFENCE_ICON,
        SLAYER_ARMOR_PROGRESS,
        DEPLOYABLE_DISPLAY,
        TICKER,
        BAIT_LIST_DISPLAY,
        DUNGEONS_MAP,
        SLAYER_TRACKERS,
        DRAGON_STATS_TRACKER,
        PROXIMITY_INDICATOR,
        PET_DISPLAY;

    }

    public static enum FeatureCredit {
        ORCHID_ALLOY("orchidalloy", "github.com/orchidalloy", Feature.SUMMONING_EYE_ALERT, Feature.ENCHANTMENT_LORE_PARSING),
        HIGH_CRIT("HighCrit", "github.com/HighCrit", Feature.PREVENT_MOVEMENT_ON_DEATH),
        MOULBERRY("Moulberry", "github.com/Moulberry", Feature.DONT_RESET_CURSOR_INVENTORY),
        TOMOCRAFTER("tomocrafter", "github.com/tomocrafter", Feature.SLAYER_ARMOR_PROGRESS, Feature.NO_ARROWS_LEFT_ALERT, Feature.BOSS_APPROACH_ALERT),
        DAPIGGUY("DaPigGuy", "github.com/DaPigGuy", Feature.MINION_DISABLE_LOCATION_WARNING),
        KEAGEL("Keagel", "github.com/Keagel", Feature.DISABLE_MAGICAL_SOUP_MESSAGES),
        SUPERHIZE("SuperHiZe", "github.com/superhize", Feature.SPECIAL_ZEALOT_ALERT),
        DIDI_SKYWALKER("DidiSkywalker", "twitter.com/didiskywalker", Feature.ITEM_PICKUP_LOG, Feature.HEALTH_UPDATES, Feature.REPLACE_ROMAN_NUMERALS_WITH_NUMBERS),
        P0KE("P0ke", "p0ke.dev", Feature.ZEALOT_COUNTER),
        DJTHEREDSTONER("DJtheRedstoner", "github.com/DJtheRedstoner", Feature.LEGENDARY_SEA_CREATURE_WARNING, Feature.HIDE_SVEN_PUP_NAMETAGS),
        CHARZARD("Charzard4261", "github.com/Charzard4261", Feature.DISABLE_TELEPORT_PAD_MESSAGES, Feature.BAIT_LIST, Feature.SHOW_BASE_STAT_BOOST_PERCENTAGE, Feature.SHOW_ITEM_DUNGEON_FLOOR, Feature.SHOW_BASE_STAT_BOOST_PERCENTAGE, Feature.REVENANT_SLAYER_TRACKER, Feature.TARANTULA_SLAYER_TRACKER, Feature.SVEN_SLAYER_TRACKER, Feature.DRAGON_STATS_TRACKER, Feature.SHOW_STACKING_ENCHANT_PROGRESS, Feature.STOP_BONZO_STAFF_SOUNDS, Feature.DISABLE_MORT_MESSAGES, Feature.DISABLE_BOSS_MESSAGES),
        IHDEVELOPER("iHDeveloper", "github.com/iHDeveloper", Feature.SHOW_DUNGEON_MILESTONE, Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY, Feature.SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY, Feature.DUNGEONS_SECRETS_DISPLAY, Feature.SHOW_SWORD_KILLS),
        TIRELESS_TRAVELER("TirelessTraveler", "github.com/ILikePlayingGames", Feature.DUNGEON_DEATH_COUNTER),
        KAASBROODJU("kaasbroodju", "github.com/kaasbroodju", Feature.SKILL_PROGRESS_BAR),
        PHOUBE("Phoube", "github.com/Phoube", Feature.HIDE_OTHER_PLAYERS_PRESENTS, Feature.SHOW_EXPERIMENTATION_TABLE_TOOLTIPS, Feature.DRILL_FUEL_BAR, Feature.DRILL_FUEL_TEXT),
        PEDRO9558("Pedro9558", "github.com/Pedro9558", Feature.TREVOR_THE_TRAPPER_FEATURES, Feature.FETCHUR_TODAY, Feature.STOP_RAT_SOUNDS),
        ROBOTHANZO("RobotHanzo", "robothanzo.dev", Feature.HIDE_SPAWN_POINT_PLAYERS),
        IRONM00N("IRONM00N", "github.com/IRONM00N", Feature.FARM_EVENT_TIMER),
        SKYCATMINEPOKIE("skycatminepokie", "github.com/skycatminepokie", Feature.OUTBID_ALERT_SOUND),
        TIMOLOB("TimoLob", "github.com/TimoLob", Feature.BROOD_MOTHER_ALERT),
        NOPOTHEGAMER("NopoTheGamer", "twitch.tv/nopothegamer", Feature.BAL_BOSS_ALERT),
        CATFACE("CatFace", "github.com/CattoFace", Feature.PLAYER_SYMBOLS_IN_CHAT),
        HANNIBAL2("Hannibal2", "github.com/hannibal00212", Feature.CRIMSON_ARMOR_ABILITY_STACKS, Feature.HIDE_TRUE_DEFENSE),
        JASON54("jason54jg", "github.com/jason54jg", Feature.INFERNO_SLAYER_TRACKER),
        GLACIALVITALITY("GlacialVitality", "github.com/glacialvitality", Feature.RIFTSTALKER_SLAYER_TRACKER),
        FIX3DLL("Fix3dll", "github.com/Fix3dll", Feature.FIRE_FREEZE_TIMER, Feature.HIDE_HAUNTED_SKULLS, Feature.THUNDER_BOTTLE_DISPLAY, Feature.PET_DISPLAY, Feature.PRESSURE_BAR, Feature.PRESSURE_TEXT, Feature.HIDE_EFFECTS_HUD, Feature.EQUIPMENTS_IN_INVENTORY, Feature.COLORED_FISHING_PARTICLES);

        private final Set<Feature> features;
        private final String author;
        private final String url;

        private FeatureCredit(String author, String url, Feature ... features) {
            this.features = EnumSet.of(features[0], features);
            this.author = author;
            this.url = url;
        }

        public static FeatureCredit fromFeature(Feature feature) {
            for (FeatureCredit credit : FeatureCredit.values()) {
                if (!credit.features.contains((Object)feature)) continue;
                return credit;
            }
            return null;
        }

        public String getAuthor() {
            return "Contrib. " + this.author;
        }

        public String getUrl() {
            return "https://" + this.url;
        }
    }

    public static enum AutoUpdateMode implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        UPDATE_OFF("settings.autoUpdate.disabled.title", "settings.autoUpdate.disabled.description"),
        STABLE("settings.autoUpdate.stable.title", "settings.autoUpdate.stable.description"),
        LATEST("settings.autoUpdate.latest.title", "settings.autoUpdate.latest.description");

        private final String TRANSLATION_KEY;
        private final String DESCRIPTION_KEY;

        private AutoUpdateMode(String translationKey, String descriptionKey) {
            this.TRANSLATION_KEY = translationKey;
            this.DESCRIPTION_KEY = descriptionKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            if (this.DESCRIPTION_KEY != null) {
                return Translations.getMessage(this.DESCRIPTION_KEY, new Object[0]);
            }
            return null;
        }
    }

    public static enum ChromaMode implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        ALL_SAME_COLOR("settings.chromaModes.allTheSame"),
        FADE("settings.chromaModes.fade");

        private final String TRANSLATION_KEY;

        private ChromaMode(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static enum PetItemStyle implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        NONE("settings.none"),
        DISPLAY_NAME("settings.petItemStyles.displayName"),
        SHOW_ITEM("settings.petItemStyles.showItem");

        private final String TRANSLATION_KEY;

        private PetItemStyle(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static enum GuiTab {
        MAIN,
        GENERAL_SETTINGS;

    }

    public static enum TextStyle implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        STYLE_ONE("settings.textStyles.one"),
        STYLE_TWO("settings.textStyles.two");

        private final String TRANSLATION_KEY;

        private TextStyle(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        public String getMessage() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static enum DeployableDisplayStyle implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        DETAILED("settings.deployableStyle.detailed"),
        COMPACT("settings.deployableStyle.compact");

        private final String TRANSLATION_KEY;

        private DeployableDisplayStyle(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static enum BackpackStyle implements ButtonCycling.SelectItem,
    RegistrableEnum
    {
        GUI("settings.backpackStyles.regular"),
        BOX("settings.backpackStyles.compact");

        private final String TRANSLATION_KEY;

        private BackpackStyle(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static enum ButtonType {
        TOGGLE,
        SOLID,
        CHROMA_SLIDER,
        CYCLING,
        STEPPER;

    }

    public static enum AnchorPoint implements RegistrableEnum
    {
        TOP_LEFT(0),
        TOP_RIGHT(1),
        BOTTOM_LEFT(2),
        BOTTOM_RIGHT(3),
        BOTTOM_MIDDLE(4),
        TOP_MIDDLE(5);

        private final int id;

        private AnchorPoint(int id) {
            this.id = id;
        }

        public static AnchorPoint fromId(int id) {
            for (AnchorPoint feature : AnchorPoint.values()) {
                if (feature.getId() != id) continue;
                return feature;
            }
            return null;
        }

        public int getX(int maxX) {
            return switch (this.ordinal()) {
                case 1, 3 -> maxX;
                case 4, 5 -> maxX / 2;
                default -> 0;
            };
        }

        public int getY(int maxY) {
            return switch (this.ordinal()) {
                case 2, 3, 4 -> maxY;
                default -> 0;
            };
        }

        public boolean isOnTop() {
            return this == TOP_LEFT || this == TOP_RIGHT || this == TOP_MIDDLE;
        }

        public boolean isOnBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_RIGHT || this == BOTTOM_MIDDLE;
        }

        public boolean isOnLeft() {
            return this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        public boolean isOnRight() {
            return this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }

        public boolean isOnMiddle() {
            return this == TOP_MIDDLE || this == BOTTOM_MIDDLE;
        }

        @Generated
        public int getId() {
            return this.id;
        }
    }
}

