/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7225;
import net.minecraft.class_8824;

public class TextUtils {
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NUMBER_FORMAT_NO_GROUPING = NumberFormat.getInstance(Locale.US);
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORZ]");
    private static final Pattern STRIP_ICONS_PATTERN = Pattern.compile("\\[\u270c]|[\u2672\u24b7\u2692\u127e]+");
    private static final Pattern STRIP_PREFIX_PATTERN = Pattern.compile("\\[\\d+]");
    private static final Pattern STRIP_PET_DISPLAY_NAME = Pattern.compile("]\\s(?:\u00a7.)*([\\w- ]+(?:\u00a7. \u2726)?)");
    private static final Pattern REPEATED_COLOR_PATTERN = Pattern.compile("(?i)(\u00a7[0-9A-FK-ORZ])+");
    private static final Pattern NUMBERS_SLASHES = Pattern.compile("[^0-9 /]");
    private static final Pattern SCOREBOARD_CHARACTERS = Pattern.compile("[^a-z A-Z:0-9_/'.!\u00a7\\[\\]\u2764]");
    private static final Pattern FLOAT_CHARACTERS = Pattern.compile("[^.0-9\\-]");
    private static final Pattern INTEGER_CHARACTERS = Pattern.compile("[^0-9]");
    private static final Pattern TRIM_WHITESPACE_RESETS = Pattern.compile("^(?:\\s|\u00a7r)*|(?:\\s|\u00a7r)*$");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^(?:\\[.+?] )?(?<username>\\w+)(?: \\[.+?])?$");
    private static final Pattern RESET_CODE_PATTERN = Pattern.compile("(?i)\u00a7R");
    private static final Pattern MAGNITUDE_PATTERN = Pattern.compile("(\\d[\\d,.]*\\d*)+([kKmMbBtT])");
    private static final Pattern TEXTURE_URL_PATTERN = Pattern.compile("\"url\"\\s?:\\s?\".+/(?<textureId>\\w+)\"");
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();
    private static boolean isInstanceLoaded;
    private static final Gson GSON;

    public static String formatNumber(Number number) {
        if (!isInstanceLoaded || Feature.NUMBER_SEPARATORS.isEnabled()) {
            return NUMBER_FORMAT.format(number);
        }
        return NUMBER_FORMAT_NO_GROUPING.format(number);
    }

    public static String stripColor(String input) {
        return STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static String stripIcons(String input) {
        return STRIP_ICONS_PATTERN.matcher(input).replaceAll("");
    }

    public static String stripUsername(String input) {
        Matcher usernameMatcher = USERNAME_PATTERN.matcher(input);
        if (usernameMatcher.matches()) {
            return usernameMatcher.group("username");
        }
        return input;
    }

    public static String stripPrefix(String input) {
        return STRIP_PREFIX_PATTERN.matcher(input).replaceAll("");
    }

    public static boolean isUsername(String input) {
        return USERNAME_PATTERN.matcher(input).matches();
    }

    public static boolean isZeroLength(String input) {
        return input.isEmpty() || REPEATED_COLOR_PATTERN.matcher(input).matches();
    }

    public static String keepScoreboardCharacters(String text) {
        return SCOREBOARD_CHARACTERS.matcher(text).replaceAll("");
    }

    public static String keepFloatCharactersOnly(String text) {
        return FLOAT_CHARACTERS.matcher(text).replaceAll("");
    }

    public static String keepIntegerCharactersOnly(String text) {
        return INTEGER_CHARACTERS.matcher(text).replaceAll("");
    }

    public static String getNumbersOnly(String text) {
        return NUMBERS_SLASHES.matcher(text).replaceAll("");
    }

    public static String convertMagnitudes(String text) throws ParseException {
        Matcher matcher = MAGNITUDE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String magnitude;
            double parsedDouble = NUMBER_FORMAT.parse(matcher.group(1)).doubleValue();
            switch (magnitude = matcher.group(2).toLowerCase(Locale.ROOT)) {
                case "k": {
                    parsedDouble *= 1000.0;
                    break;
                }
                case "m": {
                    parsedDouble *= 1000000.0;
                    break;
                }
                case "b": {
                    parsedDouble *= 1.0E9;
                    break;
                }
                case "t": {
                    parsedDouble *= 1.0E12;
                }
            }
            matcher.appendReplacement(sb, TextUtils.formatNumber(parsedDouble));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String removeDuplicateSpaces(String text) {
        return text.replaceAll("\\s+", " ");
    }

    public static String reverseText(String originalText) {
        StringBuilder newString = new StringBuilder();
        String[] parts = originalText.split(" ");
        for (int i = parts.length; i > 0; --i) {
            String textPart = parts[i - 1];
            boolean foundCharacter = false;
            for (char letter : textPart.toCharArray()) {
                if (letter <= '\u00bf') continue;
                foundCharacter = true;
                newString.append((CharSequence)new StringBuilder(textPart).reverse());
                break;
            }
            newString.append(" ");
            if (!foundCharacter) {
                newString.insert(0, textPart);
            }
            newString.insert(0, " ");
        }
        return TextUtils.removeDuplicateSpaces(newString.toString().trim());
    }

    public static String getOrdinalSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return "th";
        }
        return switch (n % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
    }

    public static String encodeSkinTextureURL(String textureURL) {
        JsonObject skin = new JsonObject();
        skin.addProperty("url", "https://textures.minecraft.net/texture/" + textureURL);
        JsonObject textures = new JsonObject();
        textures.add("SKIN", skin);
        JsonObject root = new JsonObject();
        root.add("textures", textures);
        return Base64.getEncoder().encodeToString(SkyblockAddons.getGson().toJson(root).getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeSkinTexture(String base64, boolean justTextureUrl) {
        if (base64 == null) {
            return null;
        }
        String decodedString = new String(Base64.getDecoder().decode(base64.contains("=") ? base64.substring(0, base64.indexOf(61)) : base64), StandardCharsets.UTF_8);
        if (justTextureUrl) {
            Matcher matcher = TEXTURE_URL_PATTERN.matcher(decodedString);
            if (matcher.find()) {
                return matcher.group("textureId");
            }
            return null;
        }
        return decodedString;
    }

    public static String abbreviate(Number number) {
        long longValue = number.longValue();
        if (longValue < 0L) {
            return "-" + TextUtils.abbreviate(-longValue);
        }
        if (longValue < 1000L) {
            return Long.toString(longValue);
        }
        Map.Entry<Long, String> entry = SUFFIXES.floorEntry(longValue);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = longValue / (divideBy / 10L);
        boolean hasDecimal = truncated % 10L != 0L;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String trimWhitespaceAndResets(String input) {
        return TRIM_WHITESPACE_RESETS.matcher(input).replaceAll("");
    }

    public static String stripResets(String input) {
        return RESET_CODE_PATTERN.matcher(input).replaceAll("");
    }

    public static String capitalizeFully(String inputString) {
        return TextUtils.capitalizeFully(inputString, ' ');
    }

    public static String capitalizeFully(String inputString, char separator) {
        StringBuilder titleCase = new StringBuilder(inputString.length());
        boolean nextTitleCase = true;
        for (char c : inputString.toCharArray()) {
            if (c == separator) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    public static String getFormattedString(String formatted, String unformattedSubstring) {
        if (unformattedSubstring.isEmpty()) {
            return "";
        }
        String styles = "kKlLmMnNoO";
        StringBuilder preEnchantFormat = new StringBuilder();
        StringBuilder formattedEnchant = new StringBuilder();
        int i = -2;
        int len = formatted.length();
        int unformattedEnchantIdx = 0;
        int k = 0;
        while (true) {
            if ((i = formatted.indexOf(167, i + 2)) == -1) {
                while (k < len) {
                    if (formatted.charAt(k) == unformattedSubstring.charAt(unformattedEnchantIdx)) {
                        formattedEnchant.append(formatted.charAt(k));
                        if (++unformattedEnchantIdx == unformattedSubstring.length()) {
                            return preEnchantFormat.append((CharSequence)formattedEnchant).toString();
                        }
                    } else {
                        unformattedEnchantIdx = 0;
                        preEnchantFormat = new StringBuilder(TextUtils.mergeFormats(preEnchantFormat.toString(), formattedEnchant.toString()));
                        formattedEnchant = new StringBuilder();
                    }
                    ++k;
                }
                return null;
            }
            while (k < i) {
                if (formatted.charAt(k) == unformattedSubstring.charAt(unformattedEnchantIdx)) {
                    formattedEnchant.append(formatted.charAt(k));
                    if (++unformattedEnchantIdx == unformattedSubstring.length()) {
                        return preEnchantFormat.append((CharSequence)formattedEnchant).toString();
                    }
                } else {
                    unformattedEnchantIdx = 0;
                    preEnchantFormat = new StringBuilder(TextUtils.mergeFormats(preEnchantFormat.toString(), formattedEnchant.toString()));
                    formattedEnchant = new StringBuilder();
                }
                ++k;
            }
            if (i + 1 >= len) continue;
            char formatChar = formatted.charAt(i + 1);
            if (unformattedEnchantIdx == 0) {
                if (styles.indexOf(formatChar) == -1) {
                    preEnchantFormat = new StringBuilder();
                }
                preEnchantFormat.append("\u00a7").append(formatChar);
            } else {
                formattedEnchant.append("\u00a7").append(formatChar);
            }
            k = i + 2;
        }
    }

    private static String mergeFormats(String firstFormat, String secondFormat) {
        if (secondFormat == null || secondFormat.isEmpty()) {
            return firstFormat;
        }
        String styles = "kKlLmMnNoO";
        StringBuilder builder = new StringBuilder(firstFormat);
        int i = -2;
        while ((i = secondFormat.indexOf(167, i + 2)) != -1) {
            if (i + 1 >= secondFormat.length()) continue;
            char c = secondFormat.charAt(i + 1);
            if (styles.indexOf(c) == -1) {
                builder = new StringBuilder();
            }
            builder.append("\u00a7").append(c);
        }
        return builder.toString();
    }

    public static void transformAllChatComponents(class_2561 chatComponent, Consumer<class_2561> action) {
        action.accept(chatComponent);
        for (class_2561 sibling : chatComponent.method_10855()) {
            TextUtils.transformAllChatComponents(sibling, action);
        }
    }

    public static boolean transformAnyChatComponent(class_2561 chatComponent, Predicate<class_2561> action) {
        if (action.test(chatComponent)) {
            return true;
        }
        for (class_2561 sibling : chatComponent.method_10855()) {
            if (!TextUtils.transformAnyChatComponent(sibling, action)) continue;
            return true;
        }
        return false;
    }

    public static String getBackpackIDFromLore(String lore) {
        return TextUtils.stripColor(lore).replace("\u2726", "").trim().toUpperCase().replaceAll(" ", "_");
    }

    public static int getPetLevelFromDisplayName(String displayName) {
        int endIndex;
        int startIndex = displayName.indexOf("[Lvl ");
        if (startIndex != -1 && (endIndex = displayName.indexOf("]", startIndex += 5)) != -1) {
            return Integer.parseInt(displayName.substring(startIndex, endIndex));
        }
        return -1;
    }

    public static String stripPetName(String displayName) {
        Matcher matcher = STRIP_PET_DISPLAY_NAME.matcher(displayName);
        return matcher.find() ? matcher.group(1) : displayName;
    }

    public static class_5250 componentFromJson(JsonElement customName) {
        return TextUtils.componentFromJson(customName, (class_7225.class_7874)Utils.registryAccess());
    }

    public static class_5250 componentFromJson(JsonElement customName, class_7225.class_7874 provider) {
        return (class_5250)class_8824.field_46597.parse((DynamicOps)provider.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)customName).getOrThrow(JsonParseException::new);
    }

    public static String componentToJson(class_2561 component) {
        return TextUtils.componentToJson(component, (class_7225.class_7874)Utils.registryAccess());
    }

    public static String componentToJson(class_2561 component, class_7225.class_7874 provider) {
        return GSON.toJson((JsonElement)class_8824.field_46597.encodeStart((DynamicOps)provider.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)component).getOrThrow(JsonParseException::new));
    }

    public static String roundForString(float value, int decimalPlaces) {
        return String.format("%." + decimalPlaces + "f", Float.valueOf(value));
    }

    public static String getFormattedText(class_2561 text) {
        return TextUtils.getFormattedText(text, false);
    }

    public static String getFormattedText(@NonNull class_2561 root, final boolean sideBar) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        final StringBuilder out = new StringBuilder();
        final class_2583 rootStyle = root.method_10866();
        class_5348.class_5246<Void> consumer = new class_5348.class_5246<Void>(){
            private boolean firstChunk = true;

            public Optional<Void> accept(class_2583 style, String string) {
                String formattingCode = TextUtils.formattingCode(style, rootStyle);
                if (this.firstChunk && sideBar && "\u00a7f".equals(formattingCode)) {
                    formattingCode = "";
                }
                this.firstChunk = false;
                out.append(formattingCode).append(string);
                if (!sideBar) {
                    out.append(class_124.field_1070);
                }
                return Optional.empty();
            }
        };
        root.method_27658((class_5348.class_5246)consumer, class_2583.field_24360);
        return out.toString();
    }

    private static String formattingCode(class_2583 style, class_2583 rootStyle) {
        StringBuilder sb = new StringBuilder();
        if (style == class_2583.field_24360) {
            sb.append(rootStyle != class_2583.field_24360 ? TextUtils.formattingCode(rootStyle, class_2583.field_24360) : "");
        } else {
            if (style.method_10973() != null) {
                class_5251 textColor = style.method_10973();
                String colorName = textColor.field_24365;
                if (colorName != null && colorName.equals(DrawUtils.CHROMA_TEXT_COLOR.field_24365)) {
                    sb.append(ColorCode.CHROMA);
                } else {
                    ColorCode color = ColorCode.getByARGB(0xFF000000 | textColor.method_27716() & 0xFFFFFF);
                    if (color != null) {
                        sb.append(color);
                    }
                }
            }
            if (style.method_10984()) {
                sb.append(class_124.field_1067);
            }
            if (style.method_10966()) {
                sb.append(class_124.field_1056);
            }
            if (style.method_10965()) {
                sb.append(class_124.field_1073);
            }
            if (style.method_10986()) {
                sb.append(class_124.field_1055);
            }
            if (style.method_10987()) {
                sb.append(class_124.field_1051);
            }
        }
        return sb.toString();
    }

    @Generated
    public static void setInstanceLoaded(boolean isInstanceLoaded) {
        TextUtils.isInstanceLoaded = isInstanceLoaded;
    }

    static {
        SUFFIXES.put(1000L, "k");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "B");
        SUFFIXES.put(1000000000000L, "T");
        NUMBER_FORMAT.setMaximumFractionDigits(2);
        NUMBER_FORMAT_NO_GROUPING.setMaximumFractionDigits(2);
        NUMBER_FORMAT_NO_GROUPING.setGroupingUsed(false);
        isInstanceLoaded = false;
        GSON = new GsonBuilder().disableHtmlEscaping().create();
    }
}

