/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class JSONResponseHandler<T>
implements ResponseHandler<T> {
    private static final Gson gson = SkyblockAddons.getGson();
    private final Type type;

    public JSONResponseHandler(Type type) {
        this.type = type;
    }

    public T handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status == 200) {
            if (entity != null) {
                return gson.fromJson(EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8), this.type);
            }
            return null;
        }
        EntityUtils.consume((HttpEntity)entity);
        throw new HttpResponseException(status, "Unexpected response status: " + status);
    }
}

