/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data;

import com.fix3dll.skyblockaddons.utils.data.DataConstants;
import com.fix3dll.skyblockaddons.utils.data.DataFetchCallback;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;

public class RemoteFileRequest<T> {
    protected static final String NO_DATA_RECEIVED_ERROR = "No data received for get request to \"%s\"";
    private String REQUEST_URL;
    private final ResponseHandler<T> RESPONSE_HANDLER;
    private final FutureCallback<T> FETCH_CALLBACK;
    private final boolean ESSENTIAL;
    private HttpRequestFutureTask<T> futureTask;

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, DataFetchCallback<T> dataFetchCallback) {
        this(requestPath, responseHandler, dataFetchCallback, false);
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, DataFetchCallback<T> dataFetchCallback, boolean essential) {
        this(requestPath, responseHandler, dataFetchCallback, essential, false);
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
    }

    public RemoteFileRequest(@NonNull String requestPath, @NonNull ResponseHandler<T> responseHandler, DataFetchCallback<T> dataFetchCallback, boolean essential, boolean usingCustomUrl) {
        if (requestPath == null) {
            throw new NullPointerException("requestPath is marked non-null but is null");
        }
        if (responseHandler == null) {
            throw new NullPointerException("responseHandler is marked non-null but is null");
        }
        this.REQUEST_URL = usingCustomUrl ? requestPath : DataConstants.CDN_BASE_URL + requestPath;
        this.RESPONSE_HANDLER = responseHandler;
        this.FETCH_CALLBACK = dataFetchCallback;
        this.ESSENTIAL = essential;
        this.futureTask = null;
    }

    public void execute(@NonNull FutureRequestExecutionService executionService) {
        if (executionService == null) {
            throw new NullPointerException("executionService is marked non-null but is null");
        }
        this.futureTask = executionService.execute((HttpUriRequest)new HttpGet(this.REQUEST_URL), null, this.RESPONSE_HANDLER, this.FETCH_CALLBACK);
    }

    public String getURL() {
        return this.REQUEST_URL;
    }

    public void setFallbackCDN() {
        this.REQUEST_URL = this.REQUEST_URL.replace(DataConstants.CDN_BASE_URL, DataConstants.FALLBACK_CDN_BASE_URL);
    }

    public boolean isEssential() {
        return this.ESSENTIAL;
    }

    protected boolean isDone() {
        return this.futureTask.isDone();
    }

    protected static String getCDNBaseURL() {
        return DataConstants.CDN_BASE_URL;
    }

    @Generated
    public HttpRequestFutureTask<T> getFutureTask() {
        return this.futureTask;
    }
}

