/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.skyblockdata;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Generated;

public class ContainerData {
    @SerializedName(value="type")
    private ContainerType type;
    @SerializedName(value="size")
    private int size;
    @SerializedName(value="compressedItemStacksTag")
    private String compressedItemStacksTag;
    @SerializedName(value="itemStackDataTags")
    private List<String> itemStackDataTags;
    @SerializedName(value="colorTag")
    private String colorTag;
    @SerializedName(value="dimensions")
    private int[] dimensions = new int[]{6, 9};

    public boolean isBackpack() {
        return this.type == ContainerType.BACKPACK;
    }

    public boolean isCakeBag() {
        return this.type == ContainerType.NEW_YEARS_CAKE;
    }

    public boolean isPersonalCompactor() {
        return this.type == ContainerType.PERSONAL_COMPACTOR;
    }

    public boolean isPersonalDeletor() {
        return this.type == ContainerType.PERSONAL_DELETOR;
    }

    public boolean isBuildersWand() {
        return this.type == ContainerType.BUILDERS_WAND;
    }

    public boolean isBuildersRuler() {
        return this.type == ContainerType.BUILDERS_RULER;
    }

    public boolean isBasketOfSeeds() {
        return this.type == ContainerType.BASKET_OF_SEEDS;
    }

    public boolean isNetherWartPouch() {
        return this.type == ContainerType.NETHER_WART_POUCH;
    }

    public int getSize() {
        return Math.min(this.size, 54);
    }

    public int getNumRows() {
        return this.dimensions.length == 2 ? Math.min(this.dimensions[0], 6) : 6;
    }

    public int getNumCols() {
        return this.dimensions.length == 2 ? Math.min(this.dimensions[1], 9) : 9;
    }

    @Generated
    public ContainerType getType() {
        return this.type;
    }

    @Generated
    public String getCompressedItemStacksTag() {
        return this.compressedItemStacksTag;
    }

    @Generated
    public List<String> getItemStackDataTags() {
        return this.itemStackDataTags;
    }

    @Generated
    public String getColorTag() {
        return this.colorTag;
    }

    @Generated
    public int[] getDimensions() {
        return this.dimensions;
    }

    public static enum ContainerType {
        BACKPACK,
        NEW_YEARS_CAKE,
        PERSONAL_COMPACTOR,
        PERSONAL_DELETOR,
        BUILDERS_WAND,
        BUILDERS_RULER,
        BASKET_OF_SEEDS,
        NETHER_WART_POUCH;

    }
}

