/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.skyblockdata;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import lombok.Generated;

public class EnchantmentsData {
    @SerializedName(value="NORMAL")
    private HashMap<String, Enchant.Normal> normal = new HashMap();
    @SerializedName(value="ULTIMATE")
    private HashMap<String, Enchant.Ultimate> ultimate = new HashMap();
    @SerializedName(value="STACKING")
    private HashMap<String, Enchant.Stacking> stacking = new HashMap();

    public Enchant getFromLore(String loreName) {
        Enchant enchant = this.normal.get(loreName = loreName.toLowerCase(Locale.US));
        if (enchant == null) {
            enchant = this.ultimate.get(loreName);
        }
        if (enchant == null) {
            enchant = this.stacking.get(loreName);
        }
        if (enchant == null) {
            enchant = new Enchant.Dummy(loreName);
        }
        return enchant;
    }

    public Enchant getFromNbtKey(String nbtKey) {
        if (nbtKey.startsWith("ultimate_")) {
            for (Enchant.Ultimate enchant : this.ultimate.values()) {
                if (!enchant.nbtName.equals(nbtKey)) continue;
                return enchant;
            }
        } else {
            String constantTitle = nbtKey.replaceAll("_", " ");
            if (this.normal.containsKey(constantTitle)) {
                return this.normal.get(constantTitle);
            }
            if (this.stacking.containsKey(constantTitle)) {
                return this.stacking.get(constantTitle);
            }
        }
        return null;
    }

    @Generated
    public HashMap<String, Enchant.Normal> getNormal() {
        return this.normal;
    }

    @Generated
    public HashMap<String, Enchant.Ultimate> getUltimate() {
        return this.ultimate;
    }

    @Generated
    public HashMap<String, Enchant.Stacking> getStacking() {
        return this.stacking;
    }

    public static class Enchant
    implements Comparable<Enchant> {
        String nbtName;
        String loreName;
        int goodLevel;
        int maxLevel;

        public boolean isNormal() {
            return this instanceof Normal;
        }

        public boolean isUltimate() {
            return this instanceof Ultimate;
        }

        public boolean isStacking() {
            return this instanceof Stacking;
        }

        public String getFormattedName(int level) {
            return this.getFormat(level) + this.loreName;
        }

        public String getUnformattedName() {
            return this.loreName;
        }

        public String getFormat(int level) {
            Feature feature = Feature.ENCHANTMENT_LORE_PARSING;
            if (level >= this.maxLevel) {
                return feature.getAsEnum(FeatureSetting.PERFECT_ENCHANT_COLOR).toString();
            }
            if (level > this.goodLevel) {
                return feature.getAsEnum(FeatureSetting.GREAT_ENCHANT_COLOR).toString();
            }
            if (level == this.goodLevel) {
                return feature.getAsEnum(FeatureSetting.GOOD_ENCHANT_COLOR).toString();
            }
            return feature.getAsEnum(FeatureSetting.POOR_ENCHANT_COLOR).toString();
        }

        @Override
        public int compareTo(Enchant o) {
            if (this.isUltimate() == o.isUltimate()) {
                if (this.isStacking() == o.isStacking()) {
                    return this.loreName.compareTo(o.loreName);
                }
                return this.isStacking() ? -1 : 1;
            }
            return this.isUltimate() ? -1 : 1;
        }

        @Generated
        public String getNbtName() {
            return this.nbtName;
        }

        @Generated
        public String getLoreName() {
            return this.loreName;
        }

        @Generated
        public int getGoodLevel() {
            return this.goodLevel;
        }

        @Generated
        public int getMaxLevel() {
            return this.maxLevel;
        }

        public static class Normal
        extends Enchant {
        }

        public static class Ultimate
        extends Enchant {
            @Override
            public String getFormat(int level) {
                return "\u00a7d\u00a7l";
            }
        }

        public static class Stacking
        extends Enchant {
            String nbtNum;
            String statLabel;
            TreeSet<Long> stackLevel;

            @Generated
            public String getNbtNum() {
                return this.nbtNum;
            }

            @Generated
            public String getStatLabel() {
                return this.statLabel;
            }

            @Generated
            public TreeSet<Long> getStackLevel() {
                return this.stackLevel;
            }
        }

        public static class Dummy
        extends Enchant {
            public Dummy(String name) {
                this.loreName = name;
                this.nbtName = name.toLowerCase(Locale.US).replaceAll(" ", "_");
            }

            @Override
            public String getFormat(int level) {
                return ColorCode.DARK_RED.toString();
            }
        }
    }
}

