/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.skyblockdata;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockMayor;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_3544;
import org.apache.logging.log4j.Logger;

public class MayorJerryData {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final long ONE_MINUTE = 60000L;
    private static final Pattern DATE_PATTERN = Pattern.compile("Next set of perks in (?:(?<hours>\\d+)h)?(?: ?(?<minutes>\\d+)m)?(?: ?(?<seconds>\\d+)s)?!");
    private Long nextSwitch = 0L;
    private SkyblockMayor mayor = null;

    public boolean hasMayorAndActive() {
        return this.mayor != null && this.nextSwitch >= System.currentTimeMillis();
    }

    public void parseMayorJerryPerkpocalypse(class_1799 mayorItem) {
        if (mayorItem == null) {
            return;
        }
        List<String> loreList = ItemUtils.getItemLore(mayorItem);
        boolean perkpocalypsePerksFound = false;
        boolean perksStartFlag = false;
        for (String line : loreList) {
            String resetStripped;
            String stripped = TextUtils.stripColor(line);
            if (!perksStartFlag && stripped.isEmpty()) continue;
            if (!perkpocalypsePerksFound && stripped.contains("Perkpocalypse Perks:")) {
                perkpocalypsePerksFound = true;
            } else if (!perkpocalypsePerksFound) continue;
            if (line.contains("\u00a7m")) {
                perksStartFlag = !perksStartFlag;
            } else if (perksStartFlag && !(resetStripped = TextUtils.stripResets(line)).startsWith("\u00a77")) {
                this.mayor = SkyblockMayor.getByPerkName(stripped);
                if (this.mayor != null) continue;
            }
            if (perksStartFlag) continue;
            this.parseNextSwitch(stripped);
        }
        if (Feature.DEVELOPER_MODE.isEnabled()) {
            LOGGER.info((Object)this);
        }
    }

    private void parseNextSwitch(String strippedLine) {
        Matcher matcher = DATE_PATTERN.matcher(strippedLine);
        if (!matcher.matches()) {
            return;
        }
        try {
            String seconds;
            String minutes;
            int delayMs = 0;
            String hours = matcher.group("hours");
            if (!class_3544.method_15438((String)hours)) {
                delayMs += Integer.parseInt(hours) * 60 * 60 * 1000;
            }
            if (!class_3544.method_15438((String)(minutes = matcher.group("minutes")))) {
                delayMs += Integer.parseInt(minutes) * 60 * 1000;
            }
            if (!class_3544.method_15438((String)(seconds = matcher.group("seconds")))) {
                delayMs += Integer.parseInt(seconds) * 1000;
            }
            this.nextSwitch = (System.currentTimeMillis() + (long)delayMs + 60000L - 1L) / 60000L * 60000L;
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    @Generated
    public Long getNextSwitch() {
        return this.nextSwitch;
    }

    @Generated
    public SkyblockMayor getMayor() {
        return this.mayor;
    }

    @Generated
    public void setNextSwitch(Long nextSwitch) {
        this.nextSwitch = nextSwitch;
    }

    @Generated
    public void setMayor(SkyblockMayor mayor) {
        this.mayor = mayor;
    }

    @Generated
    public String toString() {
        return "MayorJerryData(nextSwitch=" + this.getNextSwitch() + ", mayor=" + String.valueOf((Object)this.getMayor()) + ")";
    }
}

