/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.gson;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.config.ConfigValuesManager;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ConfigValuesAdapter
implements JsonDeserializer<ConfigValuesManager.ConfigValues> {
    private static final Logger LOGGER = SkyblockAddons.getLogger();

    @Override
    public ConfigValuesManager.ConfigValues deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        try {
            jsonObject = json.getAsJsonObject();
        }
        catch (JsonParseException | IllegalStateException e) {
            SkyblockAddons.getInstance().getConfigValuesManager().backupConfig(true);
            LOGGER.error("configurations.json is corrupted! It will be restored to default settings.", (Throwable)e);
            return null;
        }
        ConfigValuesManager.ConfigValues configValues = new ConfigValuesManager.ConfigValues();
        if (jsonObject.has("configVersion")) {
            try {
                configValues.setConfigVersion(jsonObject.get("configVersion").getAsInt());
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing 'configVersion':", (Throwable)e);
                configValues.setConfigVersion(Integer.MIN_VALUE);
            }
        }
        if (jsonObject.has("lastFeatureId")) {
            try {
                configValues.setLastFeatureId(jsonObject.get("lastFeatureId").getAsInt());
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing 'lastFeatureId':", (Throwable)e);
                configValues.setLastFeatureId(Integer.MIN_VALUE);
            }
        }
        if (jsonObject.has("features")) {
            JsonObject featuresObject;
            try {
                featuresObject = jsonObject.getAsJsonObject("features");
            }
            catch (Exception e) {
                featuresObject = new JsonObject();
                SkyblockAddons.getInstance().getConfigValuesManager().backupConfig(true);
                LOGGER.error("Error while parsing 'features'! It will be restored to defaults. Error:", (Throwable)e);
            }
            EnumMap features = new EnumMap(Feature.class);
            for (Map.Entry<String, JsonElement> entry : featuresObject.entrySet()) {
                try {
                    features.put(Feature.valueOf(entry.getKey()), (FeatureData)context.deserialize(entry.getValue(), (Type)((Object)FeatureData.class)));
                }
                catch (IllegalArgumentException ignored) {
                    try {
                        FeatureSetting newSetting = FeatureSetting.valueOf(entry.getKey());
                        Feature relatedFeature = newSetting.getRelatedFeature();
                        if (relatedFeature == null) continue;
                        FeatureData legacyFeatureData = (FeatureData)context.deserialize(entry.getValue(), (Type)((Object)FeatureData.class));
                        FeatureData<?> parentFeatureData = features.get((Object)relatedFeature);
                        if (parentFeatureData == null) {
                            LOGGER.error("Failed to convert deprecated Feature '{}' to FeatureSetting. Parent Feature has no existing FeatureData!", (Object)entry.getKey());
                            continue;
                        }
                        parentFeatureData.setSetting(newSetting, legacyFeatureData.getValue());
                        LOGGER.info("Legacy Feature '{}' converted to FeatureSetting", (Object)newSetting);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Could not parse feature {}. If it is a deprecated feature, ignore it.", (Object)entry.getKey(), (Object)ex);
                    }
                }
                catch (JsonParseException ex) {
                    LOGGER.error("Could not parse feature {}. FeatureData will be replaced with defaults.", (Object)entry.getKey(), (Object)ex);
                    features.put(Feature.valueOf(entry.getKey()), null);
                }
            }
            configValues.setFeatures(features);
        }
        return configValues;
    }
}

