/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighthomes;

import com.knightgost.knighthomes.CombatManager;
import com.knightgost.knighthomes.HomeCommand;
import com.knightgost.knighthomes.HomeManager;
import com.knightgost.knighthomes.MessageUtils;
import com.knightgost.knighthomes.TeleportUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HomeGUI
implements Listener {
    public static Map<UUID, Integer> deletingHomeSlot = new HashMap<UUID, Integer>();
    public static final Map<UUID, BukkitTask> activeDeleteTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    public static final Map<UUID, Integer> activeDeleteSlots = new ConcurrentHashMap<UUID, Integer>();
    private final HomeManager homeManager;
    private final JavaPlugin plugin;

    public HomeGUI(JavaPlugin plugin) {
        this.plugin = plugin;
        this.homeManager = new HomeManager(plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static int getMaxHomesAllowed(Player player) {
        int i = 5;
        while (i >= 1) {
            if (player.hasPermission("knighthomes.home.limit." + i)) {
                return i;
            }
            --i;
        }
        return 1;
    }

    public void openHomeGui(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)45, (Component)Component.text((String)"\u00a76\u00a7lKnightHomes"));
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        headMeta.setOwningPlayer((OfflinePlayer)player);
        headMeta.displayName(MessageUtils.getColoredIconMessage(this.plugin, "player", "&e" + player.getName()));
        int ownedHomes = 0;
        int maxHomes = HomeGUI.getMaxHomesAllowed(player);
        int i = 0;
        while (i < maxHomes) {
            if (HomeManager.loadHome(player.getUniqueId(), i) != null) {
                ++ownedHomes;
            }
            ++i;
        }
        headMeta.lore(List.of(MessageUtils.getColoredIconMessage(this.plugin, "homes_owned", "\u00a7a\u029c\u1d0f\u1d0d\u1d07\ua731 \u1d0f\u1d21\u0274\u1d07\u1d05: \u00a7b" + ownedHomes + "/" + maxHomes)));
        head.setItemMeta((ItemMeta)headMeta);
        gui.setItem(4, head);
        int[] homeSlots = new int[]{20, 21, 22, 23, 24};
        int deleteSlot = 29;
        int i2 = 0;
        while (i2 < 5) {
            boolean slotUnlocked;
            Location home = HomeManager.loadHome(player.getUniqueId(), i2);
            boolean bl = slotUnlocked = i2 < maxHomes;
            ItemStack bed = new ItemStack(home != null ? Material.LIME_BED : (slotUnlocked ? Material.GRAY_BED : Material.RED_BED));
            ItemMeta bedMeta = bed.getItemMeta();
            bedMeta.displayName(home != null ? MessageUtils.getColoredIconMessage(this.plugin, "home_slot", "\u00a7a\u029c\u1d0f\u1d0d\u1d07 " + (i2 + 1)) : (slotUnlocked ? MessageUtils.getColoredIconMessage(this.plugin, "empty_slot", "\u00a77\u1d07\u1d0d\u1d18\u1d1b\u028f \ua731\u029f\u1d0f\u1d1b " + (i2 + 1)) : MessageUtils.getColoredIconMessage(this.plugin, "locked_slot", "\u00a7c\u029f\u1d0f\u1d04\u1d0b\u1d07\u1d05 \ua731\u029f\u1d0f\u1d1b")));
            bedMeta.lore(List.of(Component.text((String)(home != null ? "\u00a77Left-click to \u00a7ateleport" : (slotUnlocked ? "\u00a77No home set." : "\u00a7cMax homes reached."))), Component.text((String)("\u00a78Slot: \u00a7f#" + (i2 + 1)))));
            bed.setItemMeta(bedMeta);
            gui.setItem(homeSlots[i2], bed);
            ItemStack dye = new ItemStack(home != null ? Material.RED_DYE : (slotUnlocked ? Material.GRAY_DYE : Material.REDSTONE));
            ItemMeta dyeMeta = dye.getItemMeta();
            dyeMeta.displayName(home != null ? MessageUtils.getColoredIconMessage(this.plugin, "delete_home", "\u00a7c\u1d05\u1d07\u029f\u1d07\u1d1b\u1d07 \u029c\u1d0f\u1d0d\u1d07 " + (i2 + 1)) : (slotUnlocked ? MessageUtils.getColoredIconMessage(this.plugin, "set_home", "\u00a77\ua731\u1d07\u1d1b \u029c\u1d0f\u1d0d\u1d07 " + (i2 + 1)) : MessageUtils.getColoredIconMessage(this.plugin, "locked_slot", "\u00a7c\ua731\u029f\u1d0f\u1d1b \u029f\u1d0f\u1d04\u1d0b\u1d07\u1d05")));
            dyeMeta.lore(List.of(Component.text((String)(home != null ? "\u00a77Right-click to \u00a7cdelete home" : (slotUnlocked ? "\u00a77Right-click to \u00a7aset home here" : "\u00a7cYou can\u2019t set more homes.")))));
            dye.setItemMeta(dyeMeta);
            gui.setItem(deleteSlot++, dye);
            ++i2;
        }
        player.openInventory(gui);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        List lore;
        ItemMeta meta;
        ItemStack clicked;
        Location home;
        int homeSlot;
        void player;
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player2 = (Player)clicker;
        String rawTitle = Component.text((String)"\u00a76\u00a7lKnightHomes").toString();
        if (!event.getView().title().toString().equals(rawTitle)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getSlot();
        ClickType click = event.getClick();
        UUID uuid = player.getUniqueId();
        if (slot >= 20 && slot <= 24) {
            homeSlot = slot - 20;
            home = HomeManager.loadHome(uuid, homeSlot);
            if (click.isLeftClick() && home != null) {
                player.closeInventory();
                if (CombatManager.isInCombat(player.getUniqueId())) {
                    player.sendMessage(MessageUtils.getColoredIconMessage(this.plugin, "combat_teleport_blocked", "\u00a7cYou cannot teleport while in combat!"));
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_HURT, 1.0f, 1.0f);
                    return;
                }
                Component component = MessageUtils.getColoredIconMessage(this.plugin, "home_teleport_success", "\u00a7aTeleported to your Home " + (homeSlot + 1) + ".");
                String message = LegacyComponentSerializer.legacySection().serialize(component);
                TeleportUtils.teleportWithCountdown((Player)player, home, message, this.plugin);
            }
        }
        if (slot >= 29 && slot <= 33 && click.isRightClick() && (clicked = event.getCurrentItem()) != null && clicked.hasItemMeta() && (meta = clicked.getItemMeta()) != null && meta.hasLore() && (lore = meta.lore()) != null && !lore.isEmpty() && ((Component)lore.get(0)).equals(Component.text((String)"\u00a77Click again to \u00a76\u00a7lCONFIRM"))) {
            int homeSlot2 = slot - 29;
            HomeManager.deleteHome(uuid, homeSlot2);
            player.sendMessage(MessageUtils.getColoredIconMessage(this.plugin, "home_deleted", "\u00a7cDeleted Home " + (homeSlot2 + 1) + "."));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            player.closeInventory();
            activeDeleteTasks.remove(uuid);
            activeDeleteSlots.remove(uuid);
            return;
        }
        if (slot >= 29 && slot <= 33 && click.isRightClick()) {
            int maxHomes;
            homeSlot = slot - 29;
            home = HomeManager.loadHome(uuid, homeSlot);
            if (home != null) {
                if (activeDeleteTasks.containsKey(uuid)) {
                    Location prevHome;
                    activeDeleteTasks.get(uuid).cancel();
                    Integer prevSlot = activeDeleteSlots.get(uuid);
                    if (prevSlot != null && player.getOpenInventory().getTopInventory().equals(event.getInventory()) && (prevHome = HomeManager.loadHome(uuid, prevSlot - 29)) != null) {
                        ItemStack resetDye = new ItemStack(Material.RED_DYE);
                        ItemMeta resetMeta = resetDye.getItemMeta();
                        resetMeta.displayName(MessageUtils.getColoredIconMessage(this.plugin, "delete_home", "\u00a7c\u1d05\u1d07\u029f\u1d07\u1d1b\u1d07 \u029c\u1d0f\u1d0d\u1d07 " + (prevSlot - 28)));
                        resetMeta.lore(List.of(Component.text((String)"\u00a77Right-click to \u00a7cdelete home")));
                        resetDye.setItemMeta(resetMeta);
                        event.getInventory().setItem(prevSlot.intValue(), resetDye);
                    }
                }
                BukkitTask task = new BukkitRunnable((Player)player, event, homeSlot, slot){
                    int secondsLeft = 5;
                    private final /* synthetic */ Player val$player;
                    private final /* synthetic */ InventoryClickEvent val$event;
                    private final /* synthetic */ int val$homeSlot;
                    private final /* synthetic */ int val$slot;
                    {
                        this.val$player = player;
                        this.val$event = inventoryClickEvent;
                        this.val$homeSlot = n;
                        this.val$slot = n2;
                    }

                    public void run() {
                        if (!this.val$player.isOnline() || !this.val$player.getOpenInventory().getTopInventory().equals(this.val$event.getInventory())) {
                            this.cancel();
                            return;
                        }
                        Inventory topInv = this.val$player.getOpenInventory().getTopInventory();
                        ItemStack dye = new ItemStack(Material.RED_DYE);
                        ItemMeta meta = dye.getItemMeta();
                        if (this.secondsLeft == 0) {
                            meta.displayName(MessageUtils.getColoredIconMessage(HomeGUI.this.plugin, "delete_home", "\u00a7c\u1d05\u1d07\u029f\u1d07\u1d1b\u1d07 \u029c\u1d0f\u1d0d\u1d07 " + (this.val$homeSlot + 1)));
                            meta.lore(List.of(Component.text((String)"\u00a77Click again to \u00a76\u00a7lCONFIRM")));
                            dye.setItemMeta(meta);
                            topInv.setItem(this.val$slot, dye);
                            this.cancel();
                            return;
                        }
                        meta.displayName(MessageUtils.getColoredIconMessage(HomeGUI.this.plugin, "delete_home", "\u00a7c\u1d05\u1d07\u029f\u1d07\u1d1b\u1d07 \u029c\u1d0f\u1d0d\u1d07 " + (this.val$homeSlot + 1)));
                        meta.lore(List.of(Component.text((String)("\u00a77Confirming in \u00a7f" + this.secondsLeft + "s"))));
                        dye.setItemMeta(meta);
                        topInv.setItem(this.val$slot, dye);
                        --this.secondsLeft;
                        this.val$player.playSound(this.val$player.getLocation(), Sound.BLOCK_STONE_PRESSURE_PLATE_CLICK_ON, 1.0f, 1.0f);
                    }
                }.runTaskTimer((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), 0L, 20L);
                activeDeleteTasks.put(uuid, task);
                activeDeleteSlots.put(uuid, slot);
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() != Material.GRAY_DYE) {
                player.sendMessage("\u00a7cYou can\u2019t set a home in a locked slot.");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                return;
            }
            int currentHomes = HomeManager.countHomes(uuid);
            if (currentHomes >= (maxHomes = HomeGUI.getMaxHomesAllowed((Player)player))) {
                player.sendMessage("\u00a7cYou have reached the maximum number of homes.");
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                return;
            }
            this.homeManager.saveHome(uuid, homeSlot, player.getLocation());
            player.sendMessage(MessageUtils.getColoredIconMessage(this.plugin, "set_home_confirmed", "\u00a7aSet Home at Slot " + (homeSlot + 1) + "."));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
            player.closeInventory();
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        void player;
        HumanEntity human = event.getPlayer();
        if (!(human instanceof Player)) {
            return;
        }
        Player player2 = (Player)human;
        String rawTitle = Component.text((String)"Homes (Max 5)").toString();
        if (!event.getView().title().toString().equals(rawTitle)) {
            return;
        }
        HomeCommand.deletingHomeSlot.remove(player.getUniqueId());
    }

    public ItemStack buildHomeItem(int slot, UUID uuid) {
        Location home = HomeManager.loadHome(uuid, slot);
        if (home == null) {
            return null;
        }
        ItemStack item = new ItemStack(Material.GREEN_BED);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)("\u00a7aHome " + (slot + 1))));
            meta.lore(List.of(Component.text((String)"\u00a77Click to teleport"), Component.text((String)"\u00a7eRight-click to delete")));
            item.setItemMeta(meta);
        }
        return item;
    }
}

