/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighthomes;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class HomeManager {
    private static File homesFolder;

    public HomeManager(JavaPlugin plugin) {
        homesFolder = new File(plugin.getDataFolder(), "homes");
        if (!homesFolder.exists()) {
            homesFolder.mkdirs();
        }
    }

    public void saveHome(UUID uuid, int slot, Location location) {
        File file = new File(homesFolder, uuid.toString() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String path = "homes." + slot;
        config.set(path + ".world", (Object)location.getWorld().getName());
        config.set(path + ".x", (Object)location.getX());
        config.set(path + ".y", (Object)location.getY());
        config.set(path + ".z", (Object)location.getZ());
        config.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        config.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Location loadHome(UUID uuid, int slot) {
        String path;
        File file = new File(homesFolder, uuid.toString() + ".yml");
        if (!file.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!config.contains((path = "homes." + slot) + ".world")) {
            return null;
        }
        World world = Bukkit.getWorld((String)config.getString(path + ".world"));
        if (world == null) {
            return null;
        }
        double x = config.getDouble(path + ".x");
        double y = config.getDouble(path + ".y");
        double z = config.getDouble(path + ".z");
        float yaw = (float)config.getDouble(path + ".yaw");
        float pitch = (float)config.getDouble(path + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static void deleteHome(UUID uuid, int slot) {
        File file = new File(homesFolder, uuid.toString() + ".yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("homes." + slot, null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int countHomes(UUID uuid) {
        int count = 0;
        int i = 0;
        while (i < 5) {
            if (HomeManager.loadHome(uuid, i) != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

