/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighthomes;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageUtils {
    public static void sendColoredMessage(JavaPlugin plugin, Player player, String key, String message) {
        player.sendMessage(MessageUtils.getColoredIconMessage(plugin, key, message));
    }

    public static Component getColoredIconMessage(JavaPlugin plugin, String key, String message) {
        FileConfiguration config = plugin.getConfig();
        String icon = config.getString("icons." + key, "");
        String colorCode = config.getString("colors." + key, "&f");
        NamedTextColor iconColor = MessageUtils.parseColorCode(colorCode);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)(icon + " "), (TextColor)iconColor).decoration(TextDecoration.ITALIC, false))).append(MessageUtils.colorAmpersands(message))).decoration(TextDecoration.ITALIC, false)).build();
    }

    private static NamedTextColor parseColorCode(String code) {
        if (code != null && code.length() == 2 && code.charAt(0) == '&') {
            return switch (Character.toLowerCase(code.charAt(1))) {
                case '0' -> NamedTextColor.BLACK;
                case '1' -> NamedTextColor.DARK_BLUE;
                case '2' -> NamedTextColor.DARK_GREEN;
                case '3' -> NamedTextColor.DARK_AQUA;
                case '4' -> NamedTextColor.DARK_RED;
                case '5' -> NamedTextColor.DARK_PURPLE;
                case '6' -> NamedTextColor.GOLD;
                case '7' -> NamedTextColor.GRAY;
                case '8' -> NamedTextColor.DARK_GRAY;
                case '9' -> NamedTextColor.BLUE;
                case 'a' -> NamedTextColor.GREEN;
                case 'b' -> NamedTextColor.AQUA;
                case 'c' -> NamedTextColor.RED;
                case 'd' -> NamedTextColor.LIGHT_PURPLE;
                case 'e' -> NamedTextColor.YELLOW;
                case 'f' -> NamedTextColor.WHITE;
                default -> NamedTextColor.WHITE;
            };
        }
        return NamedTextColor.WHITE;
    }

    private static Component colorAmpersands(String message) {
        TextComponent component = Component.empty();
        char[] chars = message.toCharArray();
        NamedTextColor currentColor = NamedTextColor.WHITE;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '&' && i + 1 < chars.length) {
                if (buffer.length() > 0) {
                    component = component.append((Component)Component.text((String)buffer.toString(), (TextColor)currentColor));
                    buffer.setLength(0);
                }
                char colorChar = Character.toLowerCase(chars[i + 1]);
                currentColor = MessageUtils.parseColorCode("&" + colorChar);
                ++i;
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            component = component.append((Component)Component.text((String)buffer.toString(), (TextColor)currentColor));
        }
        return component;
    }
}

