/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighthomes;

import com.knightgost.knighthomes.MessageUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportUtils
implements Listener {
    private static final Set<UUID> teleportingPlayers = new HashSet<UUID>();

    public static void teleportWithCountdown(final Player player, final Location location, final String successMessage, final JavaPlugin plugin) {
        final UUID uuid = player.getUniqueId();
        teleportingPlayers.add(uuid);
        final Location startLocation = player.getLocation().clone();
        new BukkitRunnable(){
            int countdown = 5;

            public void run() {
                if (!teleportingPlayers.contains(uuid)) {
                    player.sendMessage(MessageUtils.getColoredIconMessage(plugin, "teleport_cancelled", "&cTeleport cancelled because you moved."));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                    this.cancel();
                    return;
                }
                Location current = player.getLocation();
                if (TeleportUtils.hasMoved(startLocation, current)) {
                    teleportingPlayers.remove(uuid);
                    player.sendMessage(MessageUtils.getColoredIconMessage(plugin, "teleport_cancelled", "&cTeleport cancelled because you moved."));
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                    this.cancel();
                    return;
                }
                if (this.countdown > 0) {
                    player.sendActionBar(MessageUtils.getColoredIconMessage(plugin, "teleporting", "\u00a77(Do not move) \u00a7eTeleporting in " + this.countdown + "..."));
                    --this.countdown;
                } else {
                    teleportingPlayers.remove(uuid);
                    player.teleport(location);
                    player.sendMessage(successMessage);
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    private static boolean hasMoved(Location from, Location to) {
        return from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ();
    }
}

