/*
 * Decompiled with CFR 0.152.
 */
package com.knightgost.knighthomes;

import com.knightgost.knighthomes.KnightHomes;
import com.knightgost.knighthomes.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatManager {
    private static final Map<UUID, Long> combatTimestamps = new HashMap<UUID, Long>();
    private static final Map<UUID, BukkitRunnable> combatTimers = new HashMap<UUID, BukkitRunnable>();
    private static final long COMBAT_DURATION = 10000L;

    public static void tagCombat(final Player player) {
        final UUID uuid = player.getUniqueId();
        boolean alreadyInCombat = CombatManager.isInCombat(uuid);
        combatTimestamps.put(uuid, System.currentTimeMillis());
        if (combatTimers.containsKey(uuid)) {
            combatTimers.get(uuid).cancel();
        }
        BukkitRunnable timer = new BukkitRunnable(){

            public void run() {
                combatTimestamps.remove(uuid);
                combatTimers.remove(uuid);
                player.sendMessage(MessageUtils.getColoredIconMessage(KnightHomes.getInstance(), "out_of_combat", "\u00a7aYou are no longer in combat."));
            }
        };
        timer.runTaskLater((Plugin)KnightHomes.getInstance(), 200L);
        combatTimers.put(uuid, timer);
        if (!alreadyInCombat) {
            player.sendMessage(MessageUtils.getColoredIconMessage(KnightHomes.getInstance(), "in_combat", "\u00a7cYou are now in combat!"));
        }
    }

    public static boolean isInCombat(UUID uuid) {
        Long lastTagged = combatTimestamps.get(uuid);
        return lastTagged != null && System.currentTimeMillis() - lastTagged < 10000L;
    }

    public static void untag(Player player) {
        UUID uuid = player.getUniqueId();
        BukkitRunnable task = combatTimers.remove(uuid);
        if (task != null) {
            task.cancel();
        }
        combatTimestamps.remove(uuid);
    }
}

