/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.objects.IslandAdvancements;

public class AdvancementsManager {
    private final Boxed addon;
    private final Database<IslandAdvancements> handler;
    private final Map<String, IslandAdvancements> cache = new HashMap<String, IslandAdvancements>();
    private final YamlConfiguration advConfig;
    private int unknownAdvChange;
    private int unknownRecipeChange;

    public AdvancementsManager(Boxed addon) {
        this.addon = addon;
        this.handler = new Database((Addon)addon, IslandAdvancements.class);
        addon.saveResource("advancements.yml", false);
        this.advConfig = new YamlConfiguration();
        File advFile = new File(addon.getDataFolder(), "advancements.yml");
        if (!advFile.exists()) {
            addon.logError("advancements.yml cannot be found!");
        } else {
            try {
                this.advConfig.load(advFile);
                this.unknownAdvChange = this.advConfig.getInt("settings.unknown-advancement-increase", 0);
                this.unknownRecipeChange = this.advConfig.getInt("settings.unknown-recipe-increase", 0);
            }
            catch (IOException | InvalidConfigurationException e) {
                addon.logError("advancements.yml cannot be found! " + e.getLocalizedMessage());
            }
        }
    }

    public @NonNull IslandAdvancements getIsland(Island island) {
        return this.cache.computeIfAbsent(island.getUniqueId(), this::getFromDb);
    }

    private @NonNull IslandAdvancements getFromDb(String k) {
        if (!this.handler.objectExists(k)) {
            return new IslandAdvancements(k);
        }
        @Nullable IslandAdvancements ia = (IslandAdvancements)this.handler.loadObject(k);
        return ia == null ? new IslandAdvancements(k) : ia;
    }

    protected CompletableFuture<Boolean> saveIsland(Island island) {
        return this.cache.containsKey(island.getUniqueId()) ? this.handler.saveObjectAsync((Object)this.cache.get(island.getUniqueId())) : CompletableFuture.completedFuture(true);
    }

    protected void save() {
        this.cache.values().forEach(arg_0 -> this.handler.saveObjectAsync(arg_0));
    }

    protected void removeFromCache(Island island) {
        this.cache.remove(island.getUniqueId());
    }

    public boolean addAdvancement(Island island, String advancement) {
        if (this.hasAdvancement(island, advancement)) {
            return false;
        }
        this.getIsland(island).getAdvancements().add(advancement);
        this.saveIsland(island);
        return true;
    }

    public void removeAdvancement(Island island, String advancement) {
        this.getIsland(island).getAdvancements().remove(advancement);
        this.saveIsland(island);
    }

    public boolean hasAdvancement(Island island, String advancement) {
        return this.getIsland(island).getAdvancements().contains(advancement);
    }

    public int checkIslandSize(Island island) {
        int shouldSize = this.getIsland(island).getAdvancements().stream().mapToInt(this::getScore).sum() + 1;
        if (shouldSize < 1) {
            return 0;
        }
        int diff = shouldSize - island.getProtectionRange();
        if (diff != 0) {
            this.setProtectionSize(island, shouldSize, null);
        }
        return diff;
    }

    public int addAdvancement(Player p, Advancement advancement) {
        if (!this.addon.inWorld(p.getWorld())) {
            return 0;
        }
        int score = this.getScore(advancement);
        if (score == 0) {
            return 0;
        }
        Island island = this.addon.getIslands().getIsland(this.addon.getOverWorld(), p.getUniqueId());
        if (island != null && island.getRank(p.getUniqueId()) >= 500 && this.addAdvancement(island, advancement.getKey().toString())) {
            int oldSize = island.getProtectionRange();
            int newSize = Math.max(1, oldSize + score);
            this.setProtectionSize(island, newSize, p.getUniqueId());
            return score;
        }
        return 0;
    }

    private void setProtectionSize(@NonNull Island island, int newSize, @Nullable UUID uuid) {
        island.setProtectionRange(newSize);
        IslandEvent.builder().island(island).location(island.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(uuid).admin(true).protectionRange(newSize, island.getProtectionRange()).build();
    }

    public int getScore(String key) {
        Advancement a = Bukkit.getAdvancement((NamespacedKey)NamespacedKey.fromString((String)key));
        return a == null ? 0 : this.getScore(a);
    }

    public int getScore(Advancement a) {
        String adv = "advancements." + a.getKey().getKey();
        if (adv.endsWith("/root")) {
            return this.advConfig.getInt("settings.default-root-increase");
        }
        if (adv.contains("recipes")) {
            return this.unknownRecipeChange;
        }
        if (this.advConfig.getBoolean("settings.automatic-scoring")) {
            if (!a.getKey().getKey().contains("recipes") && a.getDisplay() != null) {
                float x = a.getDisplay().getX();
                float y = a.getDisplay().getY();
                return (int)Math.round(Math.sqrt(x * x + y * y));
            }
            return 0;
        }
        if (this.advConfig.contains(adv)) {
            return this.advConfig.getInt(adv, this.unknownAdvChange);
        }
        return this.unknownAdvChange;
    }
}

