/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.DefaultAdminCommand;
import world.bentobox.bentobox.api.commands.island.DefaultPlayerCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.WorldManagementHook;
import world.bentobox.boxed.AdvancementsManager;
import world.bentobox.boxed.PlaceholdersManager;
import world.bentobox.boxed.Settings;
import world.bentobox.boxed.commands.AdminPlaceStructureCommand;
import world.bentobox.boxed.generators.biomes.BoxedBiomeGenerator;
import world.bentobox.boxed.generators.biomes.NetherSeedBiomeGenerator;
import world.bentobox.boxed.generators.biomes.SeedBiomeGenerator;
import world.bentobox.boxed.generators.chunks.AbstractBoxedChunkGenerator;
import world.bentobox.boxed.generators.chunks.BoxedChunkGenerator;
import world.bentobox.boxed.generators.chunks.BoxedSeedChunkGenerator;
import world.bentobox.boxed.listeners.AdvancementListener;
import world.bentobox.boxed.listeners.EnderPearlListener;
import world.bentobox.boxed.listeners.NewAreaListener;

public class Boxed
extends GameModeAddon {
    public static final Flag MOVE_BOX = new Flag.Builder("MOVE_BOX", Material.COMPOSTER).mode(Flag.Mode.BASIC).type(Flag.Type.PROTECTION).defaultRank(1000).build();
    public static final Flag ALLOW_MOVE_BOX = new Flag.Builder("ALLOW_MOVE_BOX", Material.COMPOSTER).mode(Flag.Mode.BASIC).type(Flag.Type.WORLD_SETTING).defaultSetting(true).build();
    private static final String SEED = "seed";
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    private Settings settings;
    private AbstractBoxedChunkGenerator worldGen;
    private BoxedSeedChunkGenerator seedGen;
    private AbstractBoxedChunkGenerator netherGen;
    private BoxedSeedChunkGenerator netherSeedGen;
    private final Config<Settings> configObject = new Config((Addon)this, Settings.class);
    private AdvancementsManager advManager;
    private World seedWorld;
    private final Map<World, ChunkGenerator> generatorMap = new HashMap<World, ChunkGenerator>();
    private final Map<String, ChunkGenerator> generatorMaps = new HashMap<String, ChunkGenerator>();
    private BiomeProvider boxedBiomeProvider;

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
        this.playerCommand = new DefaultPlayerCommand(this, this){};
        this.adminCommand = new DefaultAdminCommand(this, this){

            public void setup() {
                super.setup();
                new AdminPlaceStructureCommand((CompositeCommand)this);
            }
        };
    }

    private boolean loadSettings() {
        this.settings = (Settings)this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("Boxed settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return false;
        }
        this.worldGen = new BoxedChunkGenerator(this);
        this.generatorMaps.put(this.settings.getWorldName(), this.worldGen);
        this.seedGen = new BoxedSeedChunkGenerator(this, World.Environment.NORMAL, new SeedBiomeGenerator(this));
        this.generatorMaps.put(this.settings.getWorldName() + "/seed", this.seedGen);
        this.netherGen = new BoxedChunkGenerator(this);
        this.generatorMaps.put(this.settings.getWorldName() + NETHER, this.netherGen);
        this.netherSeedGen = new BoxedSeedChunkGenerator(this, World.Environment.NETHER, new NetherSeedBiomeGenerator(this));
        this.generatorMaps.put(this.settings.getWorldName() + "/seed_nether", this.netherSeedGen);
        return true;
    }

    public void onEnable() {
        if (this.getPlugin().getAddonsManager().getAddonByName("Border").isEmpty()) {
            this.logWarning("Boxed normally requires the Border addon.");
        }
        if (this.getPlugin().getAddonsManager().getAddonByName("InvSwitcher").isEmpty()) {
            this.logWarning("Boxed normally requires the InvSwitcher addon for per-world Advancements.");
        }
        this.advManager = new AdvancementsManager(this);
        MOVE_BOX.setGameModes(Collections.singleton(this));
        ALLOW_MOVE_BOX.setGameModes(Collections.singleton(this));
        this.getPlugin().getFlagsManager().registerFlag((Addon)this, ALLOW_MOVE_BOX);
        if (ALLOW_MOVE_BOX.isSetForWorld(this.getOverWorld())) {
            this.getPlugin().getFlagsManager().registerFlag((Addon)this, MOVE_BOX);
        } else {
            this.getPlugin().getFlagsManager().unregister(MOVE_BOX);
        }
        this.registerListener(new AdvancementListener(this));
        this.registerListener(new EnderPearlListener(this));
        this.registerListener(new NewAreaListener(this));
        PlaceholdersManager phManager = new PlaceholdersManager(this);
        this.getPlugin().getPlaceholdersManager().registerPlaceholder((Addon)this, "visited_island_advancements", phManager::getCountByLocation);
        this.getPlugin().getPlaceholdersManager().registerPlaceholder((Addon)this, "island_advancements", phManager::getCount);
    }

    public void onDisable() {
        this.getAdvManager().save();
    }

    public void onReload() {
        if (this.loadSettings()) {
            this.log("Reloaded Boxed settings");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        this.createOverWorld(worldName);
        if (this.settings.isNetherGenerate()) {
            this.createNether(worldName);
        }
    }

    private void createNether(String worldName) {
        this.log("Creating Boxed Seed Nether world ...");
        World seedWorldNether = WorldCreator.name((String)(worldName + "/seed_nether")).generator((ChunkGenerator)this.netherSeedGen).environment(World.Environment.NETHER).seed(this.getSettings().getSeed()).createWorld();
        seedWorldNether.setDifficulty(Difficulty.EASY);
        seedWorldNether.setSpawnLocation(this.settings.getNetherSeedX(), 64, this.settings.getNetherSeedZ());
        this.generatorMap.put(seedWorldNether, this.netherSeedGen);
        this.getPlugin().getIWM().addWorld(seedWorldNether, (GameModeAddon)this);
        this.copyChunks(seedWorldNether, this.netherGen);
        if (this.getServer().getWorld(worldName + NETHER) == null) {
            this.log("Creating Boxed's Nether...");
        }
        this.netherWorld = this.getWorld(worldName, World.Environment.NETHER);
    }

    private void createOverWorld(String worldName) {
        this.log("Creating Boxed Seed world ...");
        this.seedWorld = WorldCreator.name((String)(worldName + "/seed")).generator((ChunkGenerator)this.seedGen).environment(World.Environment.NORMAL).seed(this.getSettings().getSeed()).createWorld();
        this.seedWorld.setDifficulty(Difficulty.EASY);
        this.seedWorld.setSpawnLocation(this.settings.getSeedX(), 64, this.settings.getSeedZ());
        this.generatorMap.put(this.seedWorld, this.seedGen);
        this.getPlugin().getIWM().addWorld(this.seedWorld, (GameModeAddon)this);
        this.copyChunks(this.seedWorld, this.worldGen);
        if (this.getServer().getWorld(worldName) == null) {
            this.log("Creating Boxed world ...");
        }
        this.islandWorld = this.getWorld(worldName, World.Environment.NORMAL);
    }

    private void registerToWorldManagementPlugins(@NonNull World world) {
        if (this.getPlugin().getHooks() != null) {
            for (Hook hook : this.getPlugin().getHooks().getHooks()) {
                if (!(hook instanceof WorldManagementHook)) continue;
                WorldManagementHook worldManagementHook = (WorldManagementHook)hook;
                if (Bukkit.isPrimaryThread()) {
                    worldManagementHook.registerWorld(world, true);
                    continue;
                }
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), () -> worldManagementHook.registerWorld(world, true));
            }
        }
    }

    private void copyChunks(World world, AbstractBoxedChunkGenerator gen) {
        int startX = 0;
        int startZ = 0;
        if (world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            startX = this.settings.getSeedX() >> 4;
            startZ = this.settings.getSeedZ() >> 4;
        } else {
            startX = this.settings.getNetherSeedX() >> 4;
            startZ = this.settings.getNetherSeedZ() >> 4;
        }
        int size = (int)((double)this.getSettings().getIslandDistance() / 16.0);
        double percent = (double)size * 4.0 * (double)size;
        int count = 0;
        int last = 0;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                gen.setChunk(x, z, world.getChunkAt(startX + x, startZ + z));
                int p = (int)((double)(++count) / percent * 100.0);
                if (p % 10 != 0 || p == last) continue;
                last = p;
                this.log("Pregenerating seed chunks for " + world.getName() + "'s " + String.valueOf(world.getEnvironment()) + " " + p + "% done");
            }
        }
    }

    public AbstractBoxedChunkGenerator getChunkGenerator(World.Environment env) {
        return env.equals((Object)World.Environment.NORMAL) ? this.worldGen : this.netherGen;
    }

    private World getWorld(String worldName2, World.Environment env) {
        worldName2 = env.equals((Object)World.Environment.NETHER) ? (String)worldName2 + NETHER : worldName2;
        worldName2 = env.equals((Object)World.Environment.THE_END) ? (String)worldName2 + THE_END : worldName2;
        this.boxedBiomeProvider = new BoxedBiomeGenerator(this);
        World w = WorldCreator.name((String)worldName2).generator((ChunkGenerator)this.getChunkGenerator(env)).environment(env).seed(this.seedWorld.getSeed()).createWorld();
        if (w != null) {
            this.setSpawnRates(w);
        }
        this.generatorMap.put(w, this.getChunkGenerator(env));
        return w;
    }

    public BiomeProvider getBoxedBiomeProvider() {
        return this.boxedBiomeProvider;
    }

    private void setSpawnRates(World w) {
        if (this.getSettings().getSpawnLimitMonsters() > 0) {
            w.setSpawnLimit(SpawnCategory.MONSTER, this.getSettings().getSpawnLimitMonsters());
        }
        if (this.getSettings().getSpawnLimitAmbient() > 0) {
            w.setSpawnLimit(SpawnCategory.AMBIENT, this.getSettings().getSpawnLimitAmbient());
        }
        if (this.getSettings().getSpawnLimitAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.ANIMAL, this.getSettings().getSpawnLimitAnimals());
        }
        if (this.getSettings().getSpawnLimitWaterAnimals() > 0) {
            w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, this.getSettings().getSpawnLimitWaterAnimals());
        }
        if (this.getSettings().getTicksPerAnimalSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.ANIMAL, this.getSettings().getTicksPerAnimalSpawns());
        }
        if (this.getSettings().getTicksPerMonsterSpawns() > 0) {
            w.setTicksPerSpawns(SpawnCategory.MONSTER, this.getSettings().getTicksPerMonsterSpawns());
        }
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        for (Map.Entry<String, ChunkGenerator> en : this.generatorMaps.entrySet()) {
            if (!en.getKey().equalsIgnoreCase(worldName)) continue;
            return en.getValue();
        }
        return null;
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.configObject.saveConfigObject((Object)this.settings);
        }
    }

    public void allLoaded() {
        this.saveWorldSettings();
        this.log("Registering Boxed worlds with other plugins (if applicable)...");
        this.generatorMap.keySet().forEach(this::registerToWorldManagementPlugins);
    }

    public AdvancementsManager getAdvManager() {
        return this.advManager;
    }

    public boolean isUsesNewChunkGeneration() {
        return true;
    }
}

