/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.FlagSerializer;
import world.bentobox.bentobox.database.objects.adapters.FlagSerializer2;

@StoreAt(filename="config.yml", path="addons/Boxed")
@ConfigComment(value="Boxed Configuration [version]")
public class Settings
implements WorldSettings {
    @ConfigComment.Line(value={@ConfigComment(value="Player Command. What command users will run to access their area."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="boxed.command.player")
    private String playerCommandAliases = "box bx boxed";
    @ConfigComment.Line(value={@ConfigComment(value="The admin command."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="boxed.command.admin")
    private String adminCommandAliases = "boxedadmin";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for new player command call."), @ConfigComment(value="Sub-command of main player command that will be run on first player command call."), @ConfigComment(value="By default it is sub-command 'create'.")})
    @ConfigEntry(path="boxed.command.new-player-action")
    private String defaultNewPlayerAction = "create";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for player command."), @ConfigComment(value="Sub-command of main player command that will be run on each player command call."), @ConfigComment(value="By default it is sub-command 'go'.")})
    @ConfigEntry(path="boxed.command.default-action")
    private String defaultPlayerAction = "go";
    @ConfigComment.Line(value={@ConfigComment(value="Ignore advancements."), @ConfigComment(value="If this is true, advancements will not change the size of the box.")})
    @ConfigEntry(path="boxed.ignore-advancements")
    private boolean ignoreAdvancements = false;
    @ConfigComment.Line(value={@ConfigComment(value="Announce advancements. We recommend you set the game rule `/gamerule announceAdvancements false`"), @ConfigComment(value="but that blocks all new advancement announcements. This setting tells Boxed to broadcast new advancements.")})
    @ConfigEntry(path="boxed.broadcast-advancements")
    private boolean broadcastAdvancements;
    @ConfigComment.Line(value={@ConfigComment(value="Deny advancements for visitors."), @ConfigComment(value="Visitors cannot get an advancement. Note visitors will still get the reward, e.g., experience")})
    @ConfigEntry(path="boxed.deny-visitor-advancements")
    private boolean denyVisitorAdvancements = true;
    @ConfigComment(value="Friendly name for this world. Used in admin commands. Must be a single word")
    @ConfigEntry(path="world.friendly-name")
    private String friendlyName = "Boxed";
    @ConfigComment.Line(value={@ConfigComment(value="Name of the world - if it does not exist then it will be generated."), @ConfigComment(value="It acts like a prefix for nether and end (e.g. boxed_world, boxed_world_nether, boxed_world_end)")})
    @ConfigEntry(path="world.world-name")
    private String worldName = "boxed_world";
    @ConfigComment(value="World seed.")
    @ConfigEntry(path="world.generator.seed", needsReset=true)
    private long seed = 602103456450L;
    @ConfigComment.Line(value={@ConfigComment(value="World difficulty setting - PEACEFUL, EASY, NORMAL, HARD"), @ConfigComment(value="Other plugins may override this setting")})
    @ConfigEntry(path="world.difficulty")
    private Difficulty difficulty = Difficulty.NORMAL;
    @ConfigComment(value="Allow structures to generate in the seed world")
    @ConfigEntry(path="world.allow-structures")
    private boolean allowStructures;
    @ConfigComment.Line(value={@ConfigComment(value="Spawn limits. These override the limits set in bukkit.yml"), @ConfigComment(value="If set to a negative number, the server defaults will be used")})
    @ConfigEntry(path="world.spawn-limits.monsters")
    private int spawnLimitMonsters = -1;
    @ConfigEntry(path="world.spawn-limits.animals")
    private int spawnLimitAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.water-animals")
    private int spawnLimitWaterAnimals = -1;
    @ConfigEntry(path="world.spawn-limits.ambient")
    private int spawnLimitAmbient = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable animal spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-animal-spawns")
    private int ticksPerAnimalSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Setting to 0 will disable monster spawns, but this is not recommended. Minecraft default is 400."), @ConfigComment(value="A negative value uses the server default")})
    @ConfigEntry(path="world.spawn-limits.ticks-per-monster-spawns")
    private int ticksPerMonsterSpawns = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Radius of player area. (So distance between player starting spots is twice this)"), @ConfigComment(value="MUST BE A FACTOR OF 16. If not, it will be rounded to be one."), @ConfigComment(value="It is the same for every dimension : Overworld, Nether and End.")})
    @ConfigEntry(path="world.area-radius", needsReset=true)
    private int islandDistance = 320;
    @ConfigComment.Line(value={@ConfigComment(value="Starting size of boxed spaces. This is a radius so 1 = a 2x2 area."), @ConfigComment(value="Admins can adjust via the /boxadmin range set <player> <new range> command")})
    @ConfigEntry(path="world.starting-protection-range")
    private int islandProtectionRange = 1;
    @ConfigComment.Line(value={@ConfigComment(value="Start to place players at these coordinates. This is where players will start in the"), @ConfigComment(value="world. This must be a multiple of your area radius, but the plugin will auto"), @ConfigComment(value="calculate the closest location on the grid. Players are placed around this location"), @ConfigComment(value="in a spiral manner."), @ConfigComment(value="If none of this makes sense, leave it at 0,0.")})
    @ConfigEntry(path="world.start-x")
    private int islandStartX = 0;
    @ConfigEntry(path="world.start-z")
    private int islandStartZ = 0;
    @ConfigComment.Line(value={@ConfigComment(value="Maximum number of player areas in the world. Set to -1 or 0 for unlimited."), @ConfigComment(value="If the number of areas is greater than this number, it will stop players from joining the world.")})
    @ConfigEntry(path="world.max-areas")
    private int maxIslands = -1;
    @ConfigComment.Line(value={@ConfigComment(value="The number of concurrent areas a player can have"), @ConfigComment(value="A value of 0 will use the BentoBox config.yml default")})
    @ConfigEntry(path="world.concurrent-area")
    private int concurrentIslands = 0;
    @ConfigComment(value="Disallow team members from having their own area.")
    @ConfigEntry(path="world.disallow-team-member-areas")
    private boolean disallowTeamMemberIslands = true;
    @ConfigComment.Line(value={@ConfigComment(value="Area height"), @ConfigComment(value="It is the y coordinate of the bedrock block in the blueprint.")})
    @ConfigEntry(path="world.area-height")
    private int islandHeight = 8;
    @ConfigComment.Line(value={@ConfigComment(value="The maximum number of players a player can ban at any one time in this game mode."), @ConfigComment(value="The permission boxed.ban.maxlimit.X where X is a number can also be used per player"), @ConfigComment(value="-1 = unlimited")})
    @ConfigEntry(path="world.ban-limit")
    private int banLimit = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Generate Nether - if this is false, the nether world will not be made and access to"), @ConfigComment(value="the nether will not occur. Other plugins may still enable portal usage."), @ConfigComment(value="Note: Some default challenges will not be possible if there is no nether."), @ConfigComment(value="Note that with a standard nether all players arrive at the same portal and entering a"), @ConfigComment(value="portal will return them back to their areas.")})
    @ConfigEntry(path="world.nether.generate")
    private boolean netherGenerate = true;
    @ConfigComment.Line(value={@ConfigComment(value="This option indicates if nether portals should be linked via dimensions."), @ConfigComment(value="Option will simulate vanilla portal mechanics that links portals together"), @ConfigComment(value="or creates a new portal, if there is not a portal in that dimension.")})
    @ConfigEntry(path="world.nether.create-and-link-portals", since="1.0.3")
    private boolean makeNetherPortals = false;
    @ConfigComment.Line(value={@ConfigComment(value="End World - if this is false, the end world will not be made and access to"), @ConfigComment(value="the end will not occur. Other plugins may still enable portal usage.")})
    @ConfigEntry(path="world.end.generate")
    private boolean endGenerate = true;
    @ConfigComment(value="Mob white list - these mobs will NOT be removed when logging in or doing /boxed")
    @ConfigEntry(path="world.remove-mobs-whitelist")
    private Set<EntityType> removeMobsWhitelist = new HashSet<EntityType>();
    @ConfigComment(value="World flags. These are boolean settings for various flags for this world")
    @ConfigEntry(path="world.flags")
    private Map<String, Boolean> worldFlags = new HashMap<String, Boolean>();
    @ConfigComment.Line(value={@ConfigComment(value="These are the default protection settings for new areas."), @ConfigComment(value="The value is the minimum area rank required allowed to do the action"), @ConfigComment(value="Ranks are the following:"), @ConfigComment(value="  VISITOR   = 0"), @ConfigComment(value="  COOP      = 200"), @ConfigComment(value="  TRUSTED   = 400"), @ConfigComment(value="  MEMBER    = 500"), @ConfigComment(value="  SUB-OWNER = 900"), @ConfigComment(value="  OWNER     = 1000")})
    @ConfigEntry(path="world.default-area-flags")
    @Adapter(value=FlagSerializer.class)
    private Map<Flag, Integer> defaultIslandFlags = new HashMap<Flag, Integer>();
    @ConfigComment(value="These are the default settings for new areas")
    @ConfigEntry(path="world.default-area-settings")
    @Adapter(value=FlagSerializer2.class)
    private Map<Flag, Integer> defaultIslandSettings = new HashMap<Flag, Integer>();
    @ConfigComment.Line(value={@ConfigComment(value="These settings/flags are hidden from users"), @ConfigComment(value="Ops can toggle hiding in-game using SHIFT-LEFT-CLICK on flags in settings")})
    @ConfigEntry(path="world.hidden-flags")
    private List<String> hiddenFlags = new ArrayList<String>();
    @ConfigComment(value="Visitor banned commands - Visitors to areas cannot use these commands in this world")
    @ConfigEntry(path="world.visitor-banned-commands")
    private List<String> visitorBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Falling banned commands - players cannot use these commands when falling"), @ConfigComment(value="if the PREVENT_TELEPORT_WHEN_FALLING world setting flag is active")})
    @ConfigEntry(path="world.falling-banned-commands")
    private List<String> fallingBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Default max team size"), @ConfigComment(value="Permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-team-size")
    private int maxTeamSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of coop rank members per area"), @ConfigComment(value="Players can have the boxed.coop.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-coop-size")
    private int maxCoopSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of trusted rank members per area"), @ConfigComment(value="Players can have the boxed.trust.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-trusted-size")
    private int maxTrustSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of homes a player can have. Min = 1"), @ConfigComment(value="Accessed via /is sethome <number> or /is go <number>")})
    @ConfigEntry(path="area.max-homes")
    private int maxHomes = 5;
    @ConfigComment.Line(value={@ConfigComment(value="How many resets a player is allowed (manage with /boxadmin reset add/remove/reset/set command)"), @ConfigComment(value="Value of -1 means unlimited, 0 means hardcore - no resets."), @ConfigComment(value="Example, 2 resets means they get 2 resets or 3 areas lifetime")})
    @ConfigEntry(path="area.reset.reset-limit")
    private int resetLimit = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Kicked or leaving players lose resets"), @ConfigComment(value="Players who leave a team will lose an area reset chance"), @ConfigComment(value="If a player has zero resets left and leaves a team, they cannot make a new"), @ConfigComment(value="area by themselves and can only join a team."), @ConfigComment(value="Leave this true to avoid players exploiting free areas")})
    @ConfigEntry(path="area.reset.leavers-lose-reset")
    private boolean leaversLoseReset = false;
    @ConfigComment.Line(value={@ConfigComment(value="Allow kicked players to keep their inventory."), @ConfigComment(value="Overrides the on-leave inventory reset for kicked players.")})
    @ConfigEntry(path="area.reset.kicked-keep-inventory")
    private boolean kickedKeepInventory = false;
    @ConfigComment.Line(value={@ConfigComment(value="What the addon should reset when the player joins or creates an area"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="area.reset.on-join.money")
    private boolean onJoinResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="area.reset.on-join.inventory")
    private boolean onJoinResetInventory = false;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="area.reset.on-join.health")
    private boolean onJoinResetHealth = true;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="area.reset.on-join.hunger")
    private boolean onJoinResetHunger = true;
    @ConfigComment(value="Reset experience points - if true, the player's experience will be reset.")
    @ConfigEntry(path="area.reset.on-join.exp")
    private boolean onJoinResetXP = false;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="area.reset.on-join.ender-chest")
    private boolean onJoinResetEnderChest = false;
    @ConfigComment(value="Reset advancements.")
    @ConfigEntry(path="area.reset.on-join.reset-advancements")
    private boolean onJoinResetAdvancements = true;
    @ConfigComment(value="Grant these advancements")
    @ConfigEntry(path="area.reset.on-join.grant-advancements")
    private List<String> onJoinGrantAdvancements = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="What the plugin should reset when the player leaves or is kicked from an area"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="area.reset.on-leave.money")
    private boolean onLeaveResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="area.reset.on-leave.inventory")
    private boolean onLeaveResetInventory = false;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="area.reset.on-leave.health")
    private boolean onLeaveResetHealth = false;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="area.reset.on-leave.hunger")
    private boolean onLeaveResetHunger = false;
    @ConfigComment(value="Reset experience - if true, the player's experience will be reset.")
    @ConfigEntry(path="area.reset.on-leave.exp")
    private boolean onLeaveResetXP = false;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="area.reset.on-leave.ender-chest")
    private boolean onLeaveResetEnderChest = false;
    @ConfigComment(value="Reset advancements.")
    @ConfigEntry(path="area.reset.on-leave.reset-advancements")
    private boolean onLeaveResetAdvancements = false;
    @ConfigComment(value="Grant these advancements")
    @ConfigEntry(path="area.reset.on-leave.grant-advancements")
    private List<String> onLeaveGrantAdvancements = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Toggles the automatic area creation upon the player's first login on your server."), @ConfigComment(value="If set to true,"), @ConfigComment(value="   * Upon connecting to your server for the first time, the player will be told that"), @ConfigComment(value="    an area will be created for him."), @ConfigComment(value="  * Make sure you have a Blueprint Bundle called \"default\": this is the one that will"), @ConfigComment(value="    be used to create the area."), @ConfigComment(value="  * An area will be created for the player without needing him to run the create command."), @ConfigComment(value="If set to false, this will disable this feature entirely."), @ConfigComment(value="Warning:"), @ConfigComment(value="  * If you are running multiple gamemodes on your server, and all of them have"), @ConfigComment(value="    this feature enabled, an area in all the gamemodes will be created simultaneously."), @ConfigComment(value="    However, it is impossible to know on which area the player will be teleported to afterwards."), @ConfigComment(value="  * Island creation can be resource-intensive, please consider the options below to help mitigate"), @ConfigComment(value="    the potential issues, especially if you expect a lot of players to connect to your server"), @ConfigComment(value="    in a limited period of time.")})
    @ConfigEntry(path="area.create-area-on-first-login.enable")
    private boolean createIslandOnFirstLoginEnabled;
    @ConfigComment.Line(value={@ConfigComment(value="Time in seconds after the player logged in, before his area gets created."), @ConfigComment(value="If set to 0 or less, the area will be created directly upon the player's login."), @ConfigComment(value="It is recommended to keep this value under a minute's time.")})
    @ConfigEntry(path="area.create-area-on-first-login.delay")
    private int createIslandOnFirstLoginDelay = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether the area creation should be aborted if the player logged off while the"), @ConfigComment(value="delay (see the option above) has not worn off yet."), @ConfigComment(value="If set to true,"), @ConfigComment(value="  * If the player has logged off the server while the delay (see the option above) has not"), @ConfigComment(value="    worn off yet, this will cancel the area creation."), @ConfigComment(value="  * If the player relogs afterward, since he will not be recognized as a new player, no area"), @ConfigComment(value="    would be created for him."), @ConfigComment(value="  * If the area creation started before the player logged off, it will continue."), @ConfigComment(value="If set to false, the player's area will be created even if he went offline in the meantime."), @ConfigComment(value="Note this option has no effect if the delay (see the option above) is set to 0 or less.")})
    @ConfigEntry(path="area.create-area-on-first-login.abort-on-logout")
    private boolean createIslandOnFirstLoginAbortOnLogout = true;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether the player should be teleported automatically to his area when it is created."), @ConfigComment(value="If set to false, the player will be told his area is ready but will have to teleport to his area using the command.")})
    @ConfigEntry(path="area.teleport-player-to-area-when-created")
    private boolean teleportPlayerToIslandUponIslandCreation = true;
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player joins an area or creates one."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * \"[SUDO] bbox version\""), @ConfigComment(value="   * \"boxadmin deaths set [player] 0\"")})
    @ConfigEntry(path="area.commands.on-join")
    private List<String> onJoinCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player leaves an area, resets his area or gets kicked from it."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'boxadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="area.commands.on-leave")
    private List<String> onLeaveCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands that should be executed when the player respawns after death if Flags.ISLAND_RESPAWN is true."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'bsbadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="area.commands.on-respawn", since="1.14.0")
    private List<String> onRespawnCommands = new ArrayList<String>();
    @ConfigComment(value="Allow setting home in the nether.")
    @ConfigEntry(path="area.sethome.nether.allow")
    private boolean allowSetHomeInNether = true;
    @ConfigEntry(path="area.sethome.nether.require-confirmation")
    private boolean requireConfirmationToSetHomeInNether = true;
    @ConfigComment(value="Allow setting home in the end.")
    @ConfigEntry(path="area.sethome.the-end.allow")
    private boolean allowSetHomeInTheEnd = true;
    @ConfigEntry(path="area.sethome.the-end.require-confirmation")
    private boolean requireConfirmationToSetHomeInTheEnd = true;
    @ConfigComment(value="Whether deaths are counted or not.")
    @ConfigEntry(path="area.deaths.counted")
    private boolean deathsCounted = true;
    @ConfigComment(value="Maximum number of deaths to count. The death count can be used by add-ons.")
    @ConfigEntry(path="area.deaths.max")
    private int deathsMax = 10;
    @ConfigComment(value="When a player joins a team, reset their death count")
    @ConfigEntry(path="area.deaths.team-join-reset")
    private boolean teamJoinDeathReset = true;
    @ConfigComment(value="Reset player death count when they start a new area or reset an area")
    @ConfigEntry(path="area.deaths.reset-on-new-area")
    private boolean deathsResetOnNewIsland = true;
    @ConfigComment.Line(value={@ConfigComment(value="Geo restrict mobs."), @ConfigComment(value="Mobs that exit the area space where they were spawned will be removed.")})
    @ConfigEntry(path="protection.geo-limit-settings")
    private List<String> geoLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Blocked mobs."), @ConfigComment(value="List of mobs that should not spawn in Boxed.")})
    @ConfigEntry(path="protection.block-mobs")
    private List<String> mobLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Invincible visitors. List of damages that will not affect visitors."), @ConfigComment(value="Make list blank if visitors should receive all damages")})
    @ConfigEntry(path="protection.invincible-visitors")
    private List<String> ivSettings = new ArrayList<String>();
    @ConfigComment(value="These settings should not be edited")
    @ConfigEntry(path="do-not-edit-these-settings.reset-epoch")
    private long resetEpoch = 0L;

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public int getIslandDistance() {
        if (this.islandDistance % 16 != 0) {
            this.islandDistance -= this.islandDistance % 16;
            BentoBox.getInstance().logWarning("Boxed: Area radius is not a factor of 16. Rounding to " + this.islandDistance);
        }
        return this.islandDistance;
    }

    public int getIslandProtectionRange() {
        return this.islandProtectionRange;
    }

    public int getIslandStartX() {
        return this.islandStartX;
    }

    public int getIslandStartZ() {
        return this.islandStartZ;
    }

    public int getIslandXOffset() {
        return 0;
    }

    public int getIslandZOffset() {
        return 0;
    }

    public int getIslandHeight() {
        return this.islandHeight;
    }

    public boolean isUseOwnGenerator() {
        return false;
    }

    public int getSeaHeight() {
        return 0;
    }

    public int getMaxIslands() {
        return this.maxIslands;
    }

    public GameMode getDefaultGameMode() {
        return GameMode.SURVIVAL;
    }

    public boolean isNetherGenerate() {
        return this.netherGenerate;
    }

    public boolean isNetherIslands() {
        return true;
    }

    public int getNetherSpawnRadius() {
        return 32;
    }

    public boolean isEndGenerate() {
        return this.endGenerate;
    }

    public boolean isEndIslands() {
        return false;
    }

    public boolean isDragonSpawn() {
        return false;
    }

    public Set<EntityType> getRemoveMobsWhitelist() {
        return this.removeMobsWhitelist;
    }

    public Map<String, Boolean> getWorldFlags() {
        return this.worldFlags;
    }

    public Map<Flag, Integer> getDefaultIslandFlags() {
        return this.defaultIslandFlags;
    }

    public Map<Flag, Integer> getDefaultIslandSettings() {
        return this.defaultIslandSettings;
    }

    public List<String> getHiddenFlags() {
        return this.hiddenFlags;
    }

    public List<String> getVisitorBannedCommands() {
        return this.visitorBannedCommands;
    }

    public List<String> getFallingBannedCommands() {
        return this.fallingBannedCommands;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getResetLimit() {
        return this.resetLimit;
    }

    public boolean isLeaversLoseReset() {
        return this.leaversLoseReset;
    }

    public boolean isKickedKeepInventory() {
        return this.kickedKeepInventory;
    }

    public boolean isCreateIslandOnFirstLoginEnabled() {
        return this.createIslandOnFirstLoginEnabled;
    }

    public int getCreateIslandOnFirstLoginDelay() {
        return this.createIslandOnFirstLoginDelay;
    }

    public boolean isCreateIslandOnFirstLoginAbortOnLogout() {
        return this.createIslandOnFirstLoginAbortOnLogout;
    }

    public boolean isOnJoinResetMoney() {
        return this.onJoinResetMoney;
    }

    public boolean isOnJoinResetInventory() {
        return this.onJoinResetInventory;
    }

    public boolean isOnJoinResetEnderChest() {
        return this.onJoinResetEnderChest;
    }

    public boolean isOnLeaveResetMoney() {
        return this.onLeaveResetMoney;
    }

    public boolean isOnLeaveResetInventory() {
        return this.onLeaveResetInventory;
    }

    public boolean isOnLeaveResetEnderChest() {
        return this.onLeaveResetEnderChest;
    }

    public boolean isDeathsCounted() {
        return this.deathsCounted;
    }

    public boolean isAllowSetHomeInNether() {
        return this.allowSetHomeInNether;
    }

    public boolean isAllowSetHomeInTheEnd() {
        return this.allowSetHomeInTheEnd;
    }

    public boolean isRequireConfirmationToSetHomeInNether() {
        return this.requireConfirmationToSetHomeInNether;
    }

    public boolean isRequireConfirmationToSetHomeInTheEnd() {
        return this.requireConfirmationToSetHomeInTheEnd;
    }

    public int getDeathsMax() {
        return this.deathsMax;
    }

    public boolean isTeamJoinDeathReset() {
        return this.teamJoinDeathReset;
    }

    public List<String> getGeoLimitSettings() {
        return this.geoLimitSettings;
    }

    public List<String> getIvSettings() {
        return this.ivSettings;
    }

    public long getResetEpoch() {
        return this.resetEpoch;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void setIslandDistance(int islandDistance) {
        this.islandDistance = islandDistance;
    }

    public void setIslandProtectionRange(int islandProtectionRange) {
        this.islandProtectionRange = islandProtectionRange;
    }

    public void setIslandStartX(int islandStartX) {
        this.islandStartX = islandStartX;
    }

    public void setIslandStartZ(int islandStartZ) {
        this.islandStartZ = islandStartZ;
    }

    public void setMaxIslands(int maxIslands) {
        this.maxIslands = maxIslands;
    }

    public void setNetherGenerate(boolean netherGenerate) {
        this.netherGenerate = netherGenerate;
    }

    public void setEndGenerate(boolean endGenerate) {
        this.endGenerate = endGenerate;
    }

    public void setRemoveMobsWhitelist(Set<EntityType> removeMobsWhitelist) {
        this.removeMobsWhitelist = removeMobsWhitelist;
    }

    public void setWorldFlags(Map<String, Boolean> worldFlags) {
        this.worldFlags = worldFlags;
    }

    public void setDefaultIslandFlags(Map<Flag, Integer> defaultIslandFlags) {
        this.defaultIslandFlags = defaultIslandFlags;
    }

    public void setDefaultIslandSettings(Map<Flag, Integer> defaultIslandSettings) {
        this.defaultIslandSettings = defaultIslandSettings;
    }

    public void setHiddenFlags(List<String> hiddenFlags) {
        this.hiddenFlags = hiddenFlags;
    }

    public void setVisitorBannedCommands(List<String> visitorBannedCommands) {
        this.visitorBannedCommands = visitorBannedCommands;
    }

    public void setFallingBannedCommands(List<String> fallingBannedCommands) {
        this.fallingBannedCommands = fallingBannedCommands;
    }

    public void setMaxTeamSize(int maxTeamSize) {
        this.maxTeamSize = maxTeamSize;
    }

    public void setMaxHomes(int maxHomes) {
        this.maxHomes = maxHomes;
    }

    public void setResetLimit(int resetLimit) {
        this.resetLimit = resetLimit;
    }

    public void setLeaversLoseReset(boolean leaversLoseReset) {
        this.leaversLoseReset = leaversLoseReset;
    }

    public void setKickedKeepInventory(boolean kickedKeepInventory) {
        this.kickedKeepInventory = kickedKeepInventory;
    }

    public void setOnJoinResetMoney(boolean onJoinResetMoney) {
        this.onJoinResetMoney = onJoinResetMoney;
    }

    public void setOnJoinResetInventory(boolean onJoinResetInventory) {
        this.onJoinResetInventory = onJoinResetInventory;
    }

    public void setOnJoinResetEnderChest(boolean onJoinResetEnderChest) {
        this.onJoinResetEnderChest = onJoinResetEnderChest;
    }

    public void setOnLeaveResetMoney(boolean onLeaveResetMoney) {
        this.onLeaveResetMoney = onLeaveResetMoney;
    }

    public void setOnLeaveResetInventory(boolean onLeaveResetInventory) {
        this.onLeaveResetInventory = onLeaveResetInventory;
    }

    public void setOnLeaveResetEnderChest(boolean onLeaveResetEnderChest) {
        this.onLeaveResetEnderChest = onLeaveResetEnderChest;
    }

    public void setCreateIslandOnFirstLoginEnabled(boolean createIslandOnFirstLoginEnabled) {
        this.createIslandOnFirstLoginEnabled = createIslandOnFirstLoginEnabled;
    }

    public void setCreateIslandOnFirstLoginDelay(int createIslandOnFirstLoginDelay) {
        this.createIslandOnFirstLoginDelay = createIslandOnFirstLoginDelay;
    }

    public void setCreateIslandOnFirstLoginAbortOnLogout(boolean createIslandOnFirstLoginAbortOnLogout) {
        this.createIslandOnFirstLoginAbortOnLogout = createIslandOnFirstLoginAbortOnLogout;
    }

    public void setDeathsCounted(boolean deathsCounted) {
        this.deathsCounted = deathsCounted;
    }

    public void setDeathsMax(int deathsMax) {
        this.deathsMax = deathsMax;
    }

    public void setTeamJoinDeathReset(boolean teamJoinDeathReset) {
        this.teamJoinDeathReset = teamJoinDeathReset;
    }

    public void setGeoLimitSettings(List<String> geoLimitSettings) {
        this.geoLimitSettings = geoLimitSettings;
    }

    public void setIvSettings(List<String> ivSettings) {
        this.ivSettings = ivSettings;
    }

    public void setAllowSetHomeInNether(boolean allowSetHomeInNether) {
        this.allowSetHomeInNether = allowSetHomeInNether;
    }

    public void setAllowSetHomeInTheEnd(boolean allowSetHomeInTheEnd) {
        this.allowSetHomeInTheEnd = allowSetHomeInTheEnd;
    }

    public void setRequireConfirmationToSetHomeInNether(boolean requireConfirmationToSetHomeInNether) {
        this.requireConfirmationToSetHomeInNether = requireConfirmationToSetHomeInNether;
    }

    public void setRequireConfirmationToSetHomeInTheEnd(boolean requireConfirmationToSetHomeInTheEnd) {
        this.requireConfirmationToSetHomeInTheEnd = requireConfirmationToSetHomeInTheEnd;
    }

    public void setResetEpoch(long resetEpoch) {
        this.resetEpoch = resetEpoch;
    }

    public String getPermissionPrefix() {
        return "boxed";
    }

    public boolean isWaterUnsafe() {
        return false;
    }

    public int getBanLimit() {
        return this.banLimit;
    }

    public void setBanLimit(int banLimit) {
        this.banLimit = banLimit;
    }

    public String getPlayerCommandAliases() {
        return this.playerCommandAliases;
    }

    public void setPlayerCommandAliases(String playerCommandAliases) {
        this.playerCommandAliases = playerCommandAliases;
    }

    public String getAdminCommandAliases() {
        return this.adminCommandAliases;
    }

    public void setAdminCommandAliases(String adminCommandAliases) {
        this.adminCommandAliases = adminCommandAliases;
    }

    public boolean isDeathsResetOnNewIsland() {
        return this.deathsResetOnNewIsland;
    }

    public void setDeathsResetOnNewIsland(boolean deathsResetOnNew) {
        this.deathsResetOnNewIsland = deathsResetOnNew;
    }

    public List<String> getOnJoinCommands() {
        return this.onJoinCommands;
    }

    public void setOnJoinCommands(List<String> onJoinCommands) {
        this.onJoinCommands = onJoinCommands;
    }

    public List<String> getOnLeaveCommands() {
        return this.onLeaveCommands;
    }

    public void setOnLeaveCommands(List<String> onLeaveCommands) {
        this.onLeaveCommands = onLeaveCommands;
    }

    public List<String> getOnRespawnCommands() {
        return this.onRespawnCommands;
    }

    public void setOnRespawnCommands(List<String> onRespawnCommands) {
        this.onRespawnCommands = onRespawnCommands;
    }

    public boolean isOnJoinResetHealth() {
        return this.onJoinResetHealth;
    }

    public void setOnJoinResetHealth(boolean onJoinResetHealth) {
        this.onJoinResetHealth = onJoinResetHealth;
    }

    public boolean isOnJoinResetHunger() {
        return this.onJoinResetHunger;
    }

    public void setOnJoinResetHunger(boolean onJoinResetHunger) {
        this.onJoinResetHunger = onJoinResetHunger;
    }

    public boolean isOnJoinResetXP() {
        return this.onJoinResetXP;
    }

    public void setOnJoinResetXP(boolean onJoinResetXP) {
        this.onJoinResetXP = onJoinResetXP;
    }

    public boolean isOnLeaveResetHealth() {
        return this.onLeaveResetHealth;
    }

    public void setOnLeaveResetHealth(boolean onLeaveResetHealth) {
        this.onLeaveResetHealth = onLeaveResetHealth;
    }

    public boolean isOnLeaveResetHunger() {
        return this.onLeaveResetHunger;
    }

    public void setOnLeaveResetHunger(boolean onLeaveResetHunger) {
        this.onLeaveResetHunger = onLeaveResetHunger;
    }

    public boolean isOnLeaveResetXP() {
        return this.onLeaveResetXP;
    }

    public void setOnLeaveResetXP(boolean onLeaveResetXP) {
        this.onLeaveResetXP = onLeaveResetXP;
    }

    public boolean isPasteMissingIslands() {
        return false;
    }

    public boolean isTeleportPlayerToIslandUponIslandCreation() {
        return this.teleportPlayerToIslandUponIslandCreation;
    }

    public void setTeleportPlayerToIslandUponIslandCreation(boolean teleportPlayerToIslandUponIslandCreation) {
        this.teleportPlayerToIslandUponIslandCreation = teleportPlayerToIslandUponIslandCreation;
    }

    public int getSpawnLimitMonsters() {
        return this.spawnLimitMonsters;
    }

    public void setSpawnLimitMonsters(int spawnLimitMonsters) {
        this.spawnLimitMonsters = spawnLimitMonsters;
    }

    public int getSpawnLimitAnimals() {
        return this.spawnLimitAnimals;
    }

    public void setSpawnLimitAnimals(int spawnLimitAnimals) {
        this.spawnLimitAnimals = spawnLimitAnimals;
    }

    public int getSpawnLimitWaterAnimals() {
        return this.spawnLimitWaterAnimals;
    }

    public void setSpawnLimitWaterAnimals(int spawnLimitWaterAnimals) {
        this.spawnLimitWaterAnimals = spawnLimitWaterAnimals;
    }

    public int getSpawnLimitAmbient() {
        return this.spawnLimitAmbient;
    }

    public void setSpawnLimitAmbient(int spawnLimitAmbient) {
        this.spawnLimitAmbient = spawnLimitAmbient;
    }

    public int getTicksPerAnimalSpawns() {
        return this.ticksPerAnimalSpawns;
    }

    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    public int getTicksPerMonsterSpawns() {
        return this.ticksPerMonsterSpawns;
    }

    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    public int getMaxCoopSize() {
        return this.maxCoopSize;
    }

    public void setMaxCoopSize(int maxCoopSize) {
        this.maxCoopSize = maxCoopSize;
    }

    public int getMaxTrustSize() {
        return this.maxTrustSize;
    }

    public void setMaxTrustSize(int maxTrustSize) {
        this.maxTrustSize = maxTrustSize;
    }

    public String getDefaultNewPlayerAction() {
        return this.defaultNewPlayerAction;
    }

    public void setDefaultNewPlayerAction(String defaultNewPlayerAction) {
        this.defaultNewPlayerAction = defaultNewPlayerAction;
    }

    public String getDefaultPlayerAction() {
        return this.defaultPlayerAction;
    }

    public void setDefaultPlayerAction(String defaultPlayerAction) {
        this.defaultPlayerAction = defaultPlayerAction;
    }

    public List<String> getMobLimitSettings() {
        return this.mobLimitSettings;
    }

    public void setMobLimitSettings(List<String> mobLimitSettings) {
        this.mobLimitSettings = mobLimitSettings;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean isCheckForBlocks() {
        return false;
    }

    public boolean isOnJoinResetAdvancements() {
        return this.onJoinResetAdvancements;
    }

    public void setOnJoinResetAdvancements(boolean onJoinResetAdvancements) {
        this.onJoinResetAdvancements = onJoinResetAdvancements;
    }

    public List<String> getOnJoinGrantAdvancements() {
        return this.onJoinGrantAdvancements;
    }

    public void setOnJoinGrantAdvancements(List<String> onJoinGrantAdvancements) {
        this.onJoinGrantAdvancements = onJoinGrantAdvancements;
    }

    public List<String> getOnLeaveGrantAdvancements() {
        return this.onLeaveGrantAdvancements;
    }

    public void setOnLeaveGrantAdvancements(List<String> onLeaveGrantAdvancements) {
        this.onLeaveGrantAdvancements = onLeaveGrantAdvancements;
    }

    public boolean isOnLeaveResetAdvancements() {
        return this.onLeaveResetAdvancements;
    }

    public void setOnLeaveResetAdvancements(boolean onLeaveResetAdvancements) {
        this.onLeaveResetAdvancements = onLeaveResetAdvancements;
    }

    public boolean isMakeNetherPortals() {
        return this.makeNetherPortals;
    }

    public void setMakeNetherPortals(boolean makeNetherPortals) {
        this.makeNetherPortals = makeNetherPortals;
    }

    public boolean isBroadcastAdvancements() {
        return this.broadcastAdvancements;
    }

    public void setBroadcastAdvancements(boolean broadcastAdvancements) {
        this.broadcastAdvancements = broadcastAdvancements;
    }

    public boolean isDenyVisitorAdvancements() {
        return this.denyVisitorAdvancements;
    }

    public void setDenyVisitorAdvancements(boolean denyVisitorAdvancements) {
        this.denyVisitorAdvancements = denyVisitorAdvancements;
    }

    public int getSeedX() {
        return 0;
    }

    public int getSeedZ() {
        return 0;
    }

    public int getNetherSeedX() {
        return 0;
    }

    public int getNetherSeedZ() {
        return 0;
    }

    public int getEndSeedX() {
        return 0;
    }

    public int getEndSeedZ() {
        return 0;
    }

    public void setIslandHeight(int islandHeight) {
        this.islandHeight = islandHeight;
    }

    public boolean isIgnoreAdvancements() {
        return this.ignoreAdvancements;
    }

    public void setIgnoreAdvancements(boolean ignoreAdvancements) {
        this.ignoreAdvancements = ignoreAdvancements;
    }

    public int getConcurrentIslands() {
        if (this.concurrentIslands <= 0) {
            return BentoBox.getInstance().getSettings().getIslandNumber();
        }
        return this.concurrentIslands;
    }

    public void setConcurrentIslands(int concurrentIslands) {
        this.concurrentIslands = concurrentIslands;
    }

    public boolean isDisallowTeamMemberIslands() {
        return this.disallowTeamMemberIslands;
    }

    public void setDisallowTeamMemberIslands(boolean disallowTeamMemberIslands) {
        this.disallowTeamMemberIslands = disallowTeamMemberIslands;
    }

    public boolean isAllowStructures() {
        return this.allowStructures;
    }

    public void setAllowStructures(boolean allowStructures) {
        this.allowStructures = allowStructures;
    }
}

