/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.commands;

import com.google.common.base.Enums;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.structure.Structure;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.listeners.NewAreaListener;
import world.bentobox.boxed.objects.ToBePlacedStructures;

public class AdminPlaceStructureCommand
extends CompositeCommand {
    private static final String STRUCTURE_FILE = "structures.yml";
    private static final float INTEGRITY = 1.0f;
    private static final int PALETTE = -1;
    private StructureRotation sr = StructureRotation.NONE;
    private Mirror mirror = Mirror.NONE;
    private boolean noMobs;
    private final Stack<ToBePlacedStructures.StructureRecord> placedStructures = new Stack();

    public AdminPlaceStructureCommand(CompositeCommand parent) {
        super(parent, "place", new String[0]);
    }

    public void setup() {
        this.setPermission("boxed.commands.boxadmin.place");
        this.setOnlyPlayer(false);
        this.setParametersHelp("boxed.commands.boxadmin.place.parameters");
        this.setDescription("boxed.commands.boxadmin.place.description");
    }

    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() == 1 && args.get(0).equalsIgnoreCase("undo")) {
            return true;
        }
        this.sr = StructureRotation.NONE;
        this.mirror = Mirror.NONE;
        if (!((Boxed)this.getAddon()).inWorld(this.getWorld())) {
            user.sendMessage("boxed.commands.boxadmin.place.wrong-world", new String[0]);
            return false;
        }
        if (args.isEmpty() || args.size() == 2 || args.size() == 3 || args.size() > 6) {
            this.showHelp(this, user);
            return false;
        }
        List<String> options = Bukkit.getStructureManager().getStructures().keySet().stream().map(NamespacedKey::getKey).toList();
        if (!options.contains(args.get(0).toLowerCase(Locale.ENGLISH))) {
            user.sendMessage("boxed.commands.boxadmin.place.unknown-structure", new String[0]);
            return false;
        }
        if (args.size() == 1) {
            return true;
        }
        if (!args.get(1).equals("~") && !Util.isInteger((String)args.get(1), (boolean)true) || !args.get(2).equals("~") && !Util.isInteger((String)args.get(2), (boolean)true) || !args.get(3).equals("~") && !Util.isInteger((String)args.get(3), (boolean)true)) {
            user.sendMessage("boxed.commands.boxadmin.place.use-integers", new String[0]);
            return false;
        }
        if (args.size() == 4) {
            return true;
        }
        this.sr = (StructureRotation)Enums.getIfPresent(StructureRotation.class, (String)args.get(4).toUpperCase(Locale.ENGLISH)).orNull();
        if (this.sr == null) {
            user.sendMessage("boxed.commands.boxadmin.place.unknown-rotation", new String[0]);
            Arrays.stream(StructureRotation.values()).map(Enum::name).forEach(arg_0 -> ((User)user).sendRawMessage(arg_0));
            return false;
        }
        if (args.size() == 5) {
            return true;
        }
        this.mirror = (Mirror)Enums.getIfPresent(Mirror.class, (String)args.get(5).toUpperCase(Locale.ENGLISH)).orNull();
        if (this.mirror == null) {
            user.sendMessage("boxed.commands.boxadmin.place.unknown-mirror", new String[0]);
            Arrays.stream(Mirror.values()).map(Enum::name).forEach(arg_0 -> ((User)user).sendRawMessage(arg_0));
            return false;
        }
        if (args.size() == 7) {
            if (args.get(6).toUpperCase(Locale.ENGLISH).equals("NO_MOBS")) {
                this.noMobs = true;
            } else {
                user.sendMessage("boxed.commands.boxadmin.place.unknown", new String[]{"[label]", args.get(6).toUpperCase(Locale.ENGLISH)});
                return false;
            }
        }
        return true;
    }

    public boolean execute(User user, String label, List<String> args) {
        if (args.size() == 1 && args.get(0).equalsIgnoreCase("undo")) {
            return this.undoLastPlacement(user);
        }
        NamespacedKey tag = NamespacedKey.fromString((String)args.get(0).toLowerCase(Locale.ENGLISH));
        Structure s = Bukkit.getStructureManager().loadStructure(tag);
        int x = args.size() == 1 || args.get(1).equals("~") ? user.getLocation().getBlockX() : Integer.parseInt(args.get(1).trim());
        int y = args.size() == 1 || args.get(2).equals("~") ? user.getLocation().getBlockY() : Integer.parseInt(args.get(2).trim());
        int z = args.size() == 1 || args.get(3).equals("~") ? user.getLocation().getBlockZ() : Integer.parseInt(args.get(3).trim());
        Location spot = new Location(user.getWorld(), (double)x, (double)y, (double)z);
        HashMap<Vector, BlockData> removedBlocks = new HashMap<Vector, BlockData>();
        BlockTransformer store = (region, xx, yy, zz, current, state) -> {
            removedBlocks.put(new Vector(xx, yy, zz), region.getBlockData(xx, yy, zz));
            return state.getOriginal();
        };
        s.place(spot, true, this.sr, this.mirror, -1, 1.0f, new Random(), Collections.singleton(store), Collections.emptyList());
        NewAreaListener.removeJigsaw(new ToBePlacedStructures.StructureRecord(tag.getKey(), tag.getKey(), spot, this.sr, this.mirror, this.noMobs, removedBlocks));
        this.placedStructures.push(new ToBePlacedStructures.StructureRecord(tag.getKey(), tag.getKey(), spot, this.sr, this.mirror, this.noMobs, removedBlocks));
        boolean result = this.saveStructure(spot, tag, user, this.sr, this.mirror);
        if (result) {
            user.sendMessage("boxed.commands.boxadmin.place.saved", new String[0]);
        } else {
            user.sendMessage("boxed.commands.boxadmin.place.failed", new String[0]);
        }
        return result;
    }

    private boolean saveStructure(Location spot, NamespacedKey tag, User user, StructureRotation sr2, Mirror mirror2) {
        return this.getAddon().getIslands().getIslandAt(spot).map(i -> {
            int xx = spot.getBlockX() - i.getCenter().getBlockX();
            int zz = spot.getBlockZ() - i.getCenter().getBlockZ();
            File structures = new File(this.getAddon().getDataFolder(), STRUCTURE_FILE);
            YamlConfiguration config = new YamlConfiguration();
            try {
                config.load(structures);
                StringBuilder v = new StringBuilder();
                v.append(tag.getKey()).append(",").append(sr2.name()).append(",").append(mirror2.name());
                if (this.noMobs) {
                    v.append(" NO_MOBS");
                }
                config.set(spot.getWorld().getEnvironment().name().toLowerCase(Locale.ENGLISH) + "." + xx + "," + spot.getBlockY() + "," + zz, (Object)v.toString());
                config.save(structures);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }).orElse(false);
    }

    private boolean undoLastPlacement(User user) {
        if (this.placedStructures.isEmpty()) {
            user.sendMessage("boxed.commands.boxadmin.place.no-undo", new String[0]);
            return false;
        }
        ToBePlacedStructures.StructureRecord lastRecord = this.placedStructures.pop();
        NamespacedKey tag = NamespacedKey.fromString((String)lastRecord.name());
        Structure s = Bukkit.getStructureManager().loadStructure(tag);
        if (s == null) {
            user.sendMessage("boxed.commands.boxadmin.place.undo-failed", new String[0]);
            return false;
        }
        BlockTransformer erase = (region, x, y, z, current, state) -> {
            Vector v = new Vector(x, y, z);
            if (lastRecord.removedBlocks().containsKey(v)) {
                return lastRecord.removedBlocks().get(v).createBlockState();
            }
            BlockState airState = Material.AIR.createBlockData().createBlockState();
            return airState;
        };
        s.place(lastRecord.location(), false, lastRecord.rot(), lastRecord.mirror(), -1, 1.0f, new Random(), Collections.singleton(erase), Collections.emptyList());
        lastRecord.removedBlocks().clear();
        this.removeStructure(lastRecord.location(), tag, user);
        user.sendMessage("boxed.commands.boxadmin.place.undo-success", new String[0]);
        return true;
    }

    private boolean removeStructure(Location spot, NamespacedKey tag, User user) {
        return this.getAddon().getIslands().getIslandAt(spot).map(i -> {
            int xx = spot.getBlockX() - i.getCenter().getBlockX();
            int zz = spot.getBlockZ() - i.getCenter().getBlockZ();
            File structures = new File(this.getAddon().getDataFolder(), STRUCTURE_FILE);
            YamlConfiguration config = new YamlConfiguration();
            try {
                config.load(structures);
                String key = spot.getWorld().getEnvironment().name().toLowerCase(Locale.ENGLISH) + "." + xx + "," + spot.getBlockY() + "," + zz;
                if (config.contains(key)) {
                    config.set(key, null);
                    config.save(structures);
                    return true;
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            return false;
        }).orElse(false);
    }

    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        if (args.size() == 1) {
            return Optional.of(Util.tabLimit(Arrays.asList("undo"), (String)args.get(0)));
        }
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.size() == 2) {
            return Optional.of(Util.tabLimit(Bukkit.getStructureManager().getStructures().keySet().stream().map(NamespacedKey::getKey).toList(), (String)lastArg));
        }
        if (args.size() == 3) {
            return Optional.of(List.of(String.valueOf(user.getLocation().getBlockX()), "~"));
        }
        if (args.size() == 4) {
            return Optional.of(List.of(String.valueOf(user.getLocation().getBlockY()), "~"));
        }
        if (args.size() == 5) {
            return Optional.of(List.of(String.valueOf(user.getLocation().getBlockZ()), "~"));
        }
        if (args.size() == 6) {
            return Optional.of(Arrays.stream(StructureRotation.values()).map(Enum::name).toList());
        }
        if (args.size() == 7) {
            return Optional.of(Arrays.stream(Mirror.values()).map(Enum::name).toList());
        }
        if (args.size() == 8) {
            return Optional.of(List.of("NO_MOBS"));
        }
        return Optional.of(Collections.emptyList());
    }
}

