/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.boxed.generators.biomes;

import java.util.List;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.boxed.Boxed;
import world.bentobox.boxed.generators.chunks.AbstractBoxedChunkGenerator;

public abstract class AbstractCopyBiomeProvider
extends BiomeProvider {
    private final Boxed addon;
    private final Biome defaultBiome;
    protected final int dist;

    protected AbstractCopyBiomeProvider(Boxed boxed, World.Environment env, Biome defaultBiome) {
        this.addon = boxed;
        this.defaultBiome = defaultBiome;
        this.dist = this.addon.getSettings().getIslandDistance();
    }

    public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        chunkX = AbstractBoxedChunkGenerator.repeatCalc(chunkX);
        chunkZ = AbstractBoxedChunkGenerator.repeatCalc(chunkZ);
        @Nullable AbstractBoxedChunkGenerator.ChunkStore c = this.addon.getChunkGenerator(worldInfo.getEnvironment()).getChunk(chunkX, chunkZ);
        if (c != null) {
            int xx = Math.floorMod(x, 16);
            int zz = Math.floorMod(z, 16);
            return c.chunkBiomes().getOrDefault(new Vector(xx, y, zz), this.defaultBiome);
        }
        BentoBox.getInstance().logWarning("Snapshot at " + chunkX + " " + chunkZ + " is not stored");
        return this.defaultBiome;
    }

    public List<Biome> getBiomes(WorldInfo worldInfo) {
        return Registry.BIOME.stream().filter(b -> !b.equals((Object)Biome.CUSTOM)).toList();
    }
}

